/*
	open source :)
	one to one soccer v0.23
	
*/

// define WIN or BSD for sockets
#define WIN
//#define BSD

#include <allegro.h>  // power to the people
#include <stdio.h>
#include <string.h>

#ifdef WIN
	#include <winalleg.h>
	#include <winsock.h>
	#include <winioctl.h>
#endif

#ifdef BSD
	#include <sys/select.h>
	#include <sys/types.h>
	#include <sys/socket.h>
	#include <netinet/in.h>
	#include <unistd.h>
	#include <sys/ioctl.h>
#endif

#define VERSION "one to one soccer v0.23 beta"
#define MAX_SPEED 3
#define MAX_SPEED_WITH_BALL 2.5
#define MAX_BALL_SPEED 8
#define PAD_SIZE 6
#define PAD_SPEED 0.1
#define BALL_SIZE 3
#define FAST 0.1
#define MAX_FRAMESKIP 5

//prototypes
int choices();
int game(int arg);  // returns winner 1 or 2 or 0 if none
void about();
int championship();
void image(char *str);
int shoot(float xball, float yball, float xspeed, float yspeed);
void quitgame();
void xtimer(void);
void encode(char *str, float a, float b, float c, float d);
void decode(char *str, float *a, float *b, float *c, float *d);
int netplay();

//glob vars
BITMAP *temp;

PALETTE pal;
PALETTE op;

int PAD1_COLOR       = 218;
int PAD2_COLOR       = 180;
int BALL_COLOR       = 215;
float FRICTION       = 0.970;
float BALL_FRICTION  = 0.990;
int COURT_COLOR      = 210;
int COURT_BACK_COLOR = 0;
int COURT            = 1;
int GOAL_SIZE        = 100;
int CPU_SPACE        = 2;
int CPU_SPEED        = 2;

int position;

// ip address
char *ip;

// for time countin..
volatile int xtime;
volatile int xtime2;
volatile int xtime3;
volatile int xtime4;
volatile int xtime5;

//main
int main()
{
 	allegro_init();
	
	temp = load_pcx("data//tile.pcx",pal);
	if (!temp) {
	    allegro_message("\nData is missing...\nDownload it again\n\n");
	    quitgame();
	}
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, "");
	install_timer();
	install_keyboard();

#ifdef WIN
	set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 800, 600, 0, 0);
	//set_gfx_mode(GFX_AUTODETECT_WINDOWED, 700, 500, 0, 0);
	
#endif
#ifdef BSD
	set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0);
#endif

	set_display_switch_mode(SWITCH_BACKGROUND);
	text_mode(-1);

	vsync();
	clear_bitmap(screen);
	set_palette(pal);
	textprintf(temp, font, 290, 570, 255, "%s", VERSION);
	stretch_blit(temp,screen,0,0,temp->w,temp->h,0,0,SCREEN_W,SCREEN_H);
	//blit(temp, screen, 0, 0, 1, 1, 800, 600);
	readkey();
	fade_out(2);
	destroy_bitmap(temp);
	temp = create_bitmap(800, 600);
	choices();

	quitgame();
	return 1;

}

END_OF_MAIN()


int choices()
{
	BITMAP *opt;
	BITMAP *options;
	SAMPLE *selec;
	SAMPLE *selec2;
	char court_name[64];
	int o = 1;
	
	options = load_pcx("data//options.pcx",op);
	opt = load_pcx("data//opt.pcx",op);
	selec = load_wav("data//selec.wav");
	selec2 = load_wav("data//selec2.wav");

	vsync();
	clear_bitmap(screen);
	clear_bitmap(temp);
	set_palette(op);

	COURT = 3; // default court map
	strcpy(court_name,"soccer");

	for(;;) {
		if(key[KEY_ESC]) {
			fade_out(10);
			destroy_sample(selec);
			destroy_sample(selec2);			
			destroy_bitmap(options);
			destroy_bitmap(opt);
			quitgame();
		}
		vsync();
		stretch_blit(temp,screen,0,0,temp->w,temp->h,0,0,SCREEN_W,SCREEN_H);
		//blit(temp, screen, 0, 0, 1, 1, 800, 600);
		clear_bitmap(temp);
		stretch_blit(options,temp,0,0,options->w,options->h,0,0,temp->w,temp->h);
		//blit(options, temp, 0, 0, 1, 1, 800, 600);
		rectfill(temp, 697, 180, 733, 195, 36);
		rectfill(temp, 700, 183, 730, 192, PAD1_COLOR);
		rectfill(temp, 697, 220, 733, 235, 36);
		rectfill(temp, 700, 223, 730, 232, PAD2_COLOR);
		rectfill(temp, 697, 263, 733, 278, 36);
		rectfill(temp, 700, 266, 730, 275, BALL_COLOR);
		rectfill(temp, 697, 345, 733, 360, 36);
		rectfill(temp, 700, 348, 730, 357, COURT_COLOR);
		rectfill(temp, 697, 390, 733, 405, 36);
		rectfill(temp, 700, 393, 730, 402, COURT_BACK_COLOR);
		textprintf(temp,font,675,310,215,"  %s",court_name);
		//textprintf(temp,font,683,400,215,"%f",FRICTION);
		textprintf(temp,font,695,445,215,"%0.3f",BALL_FRICTION);
		textprintf(temp,font,688,480,215,"  %d",GOAL_SIZE);
   		if (o == 1) draw_sprite(temp, opt, 120, 40);
   		if (o == 2) draw_sprite(temp, opt, 120, 85);
   		if (o == 3) draw_sprite(temp, opt, 120, 130);
   		if (o == 4) draw_sprite(temp, opt, 120, 175);
   		if (o == 5) draw_sprite(temp, opt, 120, 220);
   		if (o == 6) draw_sprite(temp, opt, 120, 260);
   		if (o == 7) draw_sprite(temp, opt, 120, 305);
   		if (o == 8) draw_sprite(temp, opt, 120, 345);
   		if (o == 9) draw_sprite(temp, opt, 120, 385);
   		if (o == 10) draw_sprite(temp, opt, 120, 430);
   		if (o == 11) draw_sprite(temp, opt, 120, 465);
   		if (o == 12) draw_sprite(temp, opt, 120, 505);
   		if (o == 13) draw_sprite(temp, opt, 120, 545);
		rest(100);
   		if (key[KEY_UP]) {
      		play_sample(selec, 180, 180, 1000, 0);
      		o--;
      		clear_keybuf();
      	}
   		if (key[KEY_DOWN]) {
      		play_sample(selec, 180, 180, 1000, 0);
      		o++;
      		clear_keybuf();
      	}
   		if ((key[KEY_ENTER]) || (key[KEY_ENTER_PAD])) {
      		play_sample(selec2, 180, 180, 1000, 0);
      		if(o == 1 || o == 2 || o == 3) {
				clear_bitmap(screen);
				destroy_sample(selec);
				destroy_sample(selec2);			
				destroy_bitmap(options);
				destroy_bitmap(opt);
				if (o == 1) championship();
				if (o == 2) game(2);
				if (o == 3) netplay();
				options = load_pcx("data//options.pcx",op);
				opt = load_pcx("data//opt.pcx",op);
				selec = load_wav("data//selec.wav");
				selec2 = load_wav("data//selec2.wav");
				clear_bitmap(screen);
				clear_bitmap(temp);
				set_palette(op);		
			}
      		if(o == 12) about();
      		if(o == 13) {
				destroy_sample(selec);
				destroy_sample(selec2);			
				destroy_bitmap(options);
				destroy_bitmap(opt);
				quitgame();
			}          	
      	}
   		if (key[KEY_RIGHT]) {
			if(o == 4) PAD1_COLOR++;
      		if(o == 5) PAD2_COLOR++;
			if(o == 6) BALL_COLOR++;
			if(o == 7) if (COURT < 3) COURT++;
      		if(o == 8) COURT_COLOR++;
      		if(o == 9) COURT_BACK_COLOR++;
      		//if(o == 10) FRICTION += 0.002;
      		if(o == 10) BALL_FRICTION += 0.002;
      		if(o == 11) GOAL_SIZE += 2;
      	}
   		if (key[KEY_LEFT]) {
      		if(o == 4) PAD1_COLOR--;
      		if(o == 5) PAD2_COLOR--;
      		if(o == 6) BALL_COLOR--;
      		if(o == 7) if (COURT > 1) COURT--;
      		if(o == 8) COURT_COLOR--;
      		if(o == 9) COURT_BACK_COLOR--;
      		//if(o == 10) FRICTION -= 0.002;
      		if(o == 10) BALL_FRICTION -= 0.002;
      		if(o == 11) GOAL_SIZE -= 2;
      	}
   		if (GOAL_SIZE < 2) GOAL_SIZE = 2;
   		if (GOAL_SIZE > 600) GOAL_SIZE = 600;
   		if (COURT == 1) strcpy(court_name,"custom");
   		if (COURT == 2) strcpy(court_name,"space");
   		if (COURT == 3) strcpy(court_name,"soccer");
   		if (o < 1) o = 13;
   		if (o > 13) o = 1;
   	}
}

int game(int arg)
{
	BITMAP *skin2;
	BITMAP *skin3;
	BITMAP *toy;

	SAMPLE *fundo;
	SAMPLE *goal;
	SAMPLE *bounce;
	SAMPLE *shot;
	SAMPLE *bip;

	int pushed = 0;
	int posse = 0;
	int player = -1;
	int goals1 = 0;
	int goals2 = 0;
	int last_player = 0;
	float xball = 400, yball = 300;
	float xspeed = 0 , yspeed = 0;

	float x1 = 700;
	float y1 = 300;
	float x1v = 0;
	float y1v = 0;

	float x2 = 100;
	float y2 = 300;
	float x2v = 0;
	float y2v = 0;

	//float t1, t2;

	int frameskip = 0;
	int fps = 0;
	int fps2 = 0;
	int pps = 0;
	int pps2 = 0;
	int lat = 0;
	int lat2 = 0;
	int event = 0;
	int packet = 10;
	int lpacket = 0;

	#ifdef WIN
	    WORD wVersionRequested = MAKEWORD(1,1);
	    WSADATA wsaData;               
	#endif
	

	int sock, sock2;
	struct sockaddr_in server, client;
	char str[255];
	char str2[24];
	int ret;
	int size;
	int flags;

	LOCK_VARIABLE(xtime);
	LOCK_VARIABLE(xtime2);	
	LOCK_VARIABLE(xtime3);
	LOCK_VARIABLE(xtime4);
	LOCK_VARIABLE(xtime5);
	LOCK_FUNCTION(xtimer);
	// install timer (60 times per second)
	install_int_ex(xtimer, BPS_TO_TIMER(60));

	skin2 = load_pcx("data//skin2.pcx",op);
	skin3 = load_pcx("data//skin3.pcx",op);
	toy = load_pcx("data//toy.pcx", op);

	fundo = load_wav("data//fundo.wav");
	goal = load_wav("data//goal.wav");
	bounce = load_wav("data//bounce.wav");
	shot = load_wav("data//shot.wav");
	bip = load_wav("data//bip.wav");

	play_sample(fundo, 180, 180, 1000, 1);     
	clear_bitmap(screen);
	clear_bitmap(temp);
	set_palette(op);

	if (COURT == 2) {
    	PAD1_COLOR       = 218;
    	PAD2_COLOR       = 180;
    	BALL_COLOR       = 132;
    	COURT_COLOR      = 215;
    	COURT_BACK_COLOR = 0;
    }
	if (COURT == 3) {
    	PAD1_COLOR       = 218;
    	PAD2_COLOR       = 5;
    	BALL_COLOR       = 138;
    	COURT_COLOR      = 215;
    	COURT_BACK_COLOR = 0;
    }

	if (arg == 3) {

		clear_keybuf();

		#ifdef WIN
			WSAStartup(wVersionRequested, &wsaData);
		#endif

		sock = socket(PF_INET, SOCK_DGRAM, 0);

        client.sin_family = AF_INET;
        server.sin_family = AF_INET;

		if (position == 1) {
			client.sin_port = htons(6667);
			client.sin_addr.s_addr = INADDR_ANY;

			server.sin_port = htons(6665);
		}
		else {
			client.sin_port = htons(6665);
	        client.sin_addr.s_addr = INADDR_ANY;

	        server.sin_port = htons(6667);
	        server.sin_addr.s_addr = inet_addr(ip);
		}

        size = sizeof(client);
        sock2 = socket(PF_INET, SOCK_DGRAM, 0);
        bind(sock2, (struct sockaddr *)&client, size);

		clear_bitmap(screen);
		if (position == 1) textprintf (screen, font, 160, 208, 215, "waiting for player to connect");
		else textprintf (screen, font, 160, 208, 215, "connecting to %s:6667", ip);

		flags = 1;
		#ifdef WIN
    		ioctlsocket(sock, FIONBIO, (u_long *)&flags);
    		ioctlsocket(sock2, FIONBIO, (u_long *)&flags);
		#endif
		#ifdef BSD
			ioctl(sock, FIONBIO, (char *)&flags);
			ioctl(sock2, FIONBIO, (char *)&flags);
		#endif	
		// server
		if (position == 1) {	
			size = sizeof(client);
			for (;;) {
				ret = recvfrom(sock2, str, sizeof(str) - 1, 0, (struct sockaddr *)&client, &size);
				if (key[KEY_ESC]) return 0;
				if (ret > 0) {
					str[ret] = '\0';
					break;
				}
			}

			rest(1000);
			server.sin_addr.s_addr = client.sin_addr.s_addr;
	        sendto(sock, "ready", 5, 0, (struct sockaddr *)&server, sizeof(server));	
		}
		else { // client

			sendto(sock, "ready", 5, 0, (struct sockaddr *)&server, sizeof(server));

			size = sizeof(client);
			for (;;) {
				ret = recvfrom(sock2, str, sizeof(str) - 1, 0, (struct sockaddr *)&client, &size);
				if (key[KEY_ESC]) return 0;
				if (ret > 0) {
					str[ret] = '\0';
					break;
				}
			}
		}

        //printf("\n str = %s - %d\n", str, position);

		xball = 400, yball = 300, xspeed = 0 , yspeed = 0;
		if (position == 1) {
			x1 = 700, y1 = 300, x1v = 0, y1v = 0;
			x2 = 100, y2 = 300, x2v = 0, y2v = 0;
		}
		if (position == 2) {
			x2 = 700, y2 = 300, x2v = 0, y2v = 0;
			x1 = 100, y1 = 300, x1v = 0, y1v = 0;
		}

	}

	play_sample(bip, 180, 180, 1000, 0);

	xtime = xtime2 = xtime3 = xtime4 = xtime5 = 0;

	for(;;) {             //the game rotine

		// enforce the 60 fps, at least in the calcs
		// by xtime++ each 1/60 second
		for (frameskip = -1; xtime > 0; xtime--) {
		   	frameskip++;

			if (arg == 3) {
				// if we receive no packets for 3 secs...
				if (xtime4 > 3*60) {
			   		stop_sample(fundo);	
					clear(screen);
					destroy_bitmap(skin2);
					destroy_bitmap(skin3);
					destroy_bitmap(toy);
					destroy_sample(fundo);
					destroy_sample(goal);
					destroy_sample(bounce);
					destroy_sample(shot);
					destroy_sample(bip);
					remove_int(xtimer);			
					textprintf(screen,font,180,200,215,"connection lost");
					rest(1000);
					readkey();
					clear_keybuf();
					fade_out(2);
					return -1;
				}
				
				if (packet > 99) packet = 0;

				// send 6 packets per second plus events				
				if ((xtime3 > 10) || (event == 1)) {
					event = 0;
					pps2++;
					memset(str, 0, sizeof(str) - 1);
					memset(str2, 0, sizeof(str2) - 1);
					encode(str, x1, y1, x1v, y1v);
					// if we are the last player that touched the ball
					if ( ((position == 1)&&(last_player == 1)) || ((position == 2)&&(last_player == 1)) ) {
						encode(str2, xball, yball, xspeed, yspeed);
						str[6] = str2[0];
						str[7] = str2[1];
						str[8] = str2[2];
						str[9] = str2[3];
						str[10] = str2[4];
						str[11] = str2[5];
						str[12] = packet++;
						sendto(sock, str, 13, 0, (struct sockaddr *)&server, sizeof(server));
					}
					else {
						str[6] = packet++;
						sendto(sock, str, 7, 0, (struct sockaddr *)&server, sizeof(server));
					}
					if (lat2 == 0) {
						xtime4 = 0;
						lat2 = 1;
					}
					xtime3 = 0;
				}
		
	            memset(str, 0, sizeof(str) - 1);
				memset(str2, 0, sizeof(str2) - 1);

	            ret = recvfrom(sock2, str, sizeof(str) - 1, 0, (struct sockaddr *)&client, &size);
				if (ret > 1) {
					str[ret] = '\0';

					xtime5 = 0;
					if (str[ret-1] < 5) lpacket = 0;
					
					if (str[ret-1] > lpacket) {
						lpacket = str[ret-1];

						decode(str, &x2, &y2, &x2v, &y2v);
		
						if (ret > 7) {
							str2[0] = str[6];
							str2[1] = str[7];
							str2[2] = str[8];
							str2[3] = str[9];
							str2[4] = str[10];
							str2[5] = str[11];
							str2[6] = '\0';
							decode(str2, &xball, &yball, &xspeed, &yspeed);
						}
					}

					lat = xtime4;
					lat2 = 0;
			
				}
			}	
			// if ESC key pressed exit game
			if(key[KEY_ESC]) {
			   	stop_sample(fundo);	
				fade_out(10);
				clear_keybuf();
				destroy_bitmap(skin2);
				destroy_bitmap(skin3);
				destroy_bitmap(toy);
				destroy_sample(fundo);
				destroy_sample(goal);
				destroy_sample(bounce);
				destroy_sample(shot);
				destroy_sample(bip);
				remove_int(xtimer);			
				return 0;
		   	}

			// if some events (ball out, goal...)
			if (player > -1) {
				event = 1;
				if (last_player == 1) {
				    xball = 120, yball = 300;
				    xspeed = 0, yspeed = 0;
				}
				if (last_player == 2) {
				    xball = 680, yball = 300;
				    xspeed = 0, yspeed = 0;
				}
				if (player == 1) {
				    play_sample(goal, 180, 180, 1000, 0);
				    goals1++;
				    xball = 120, yball = 300;
				    xspeed = 0, yspeed = 0;
				}
				if (player == 2) {
				    play_sample(goal, 180, 180, 1000, 0);
				    goals2++;
				    xball = 680, yball = 300;
				    xspeed = 0, yspeed = 0;
				}
				fade_out(2);
				play_sample(bip, 180, 180, 1000, 0);
				set_palette(op);
				clear_bitmap(screen);
				clear_bitmap(temp);
				
				pushed = 0;	
				x1 = 700, y1 = 300;
				x1v = 0, y1v = 0;
				x2 = 100, y2 = 300;
				x2v = 0, y2v = 0;
				if (arg == 3) {
					if (position == 1) {
						x1 = 700, y1 = 300, x1v = 0, y1v = 0;
						x2 = 100, y2 = 300, x2v = 0, y2v = 0;
					}
					if (position == 2) {
						x2 = 700, y2 = 300, x2v = 0, y2v = 0;
						x1 = 100, y1 = 300, x1v = 0, y1v = 0;
					}
				}
				player = -1;
				xtime = xtime2 = xtime3 = xtime4 = 0;
				break;
			}

			// update screen if nothing there or too much skips
			if (frameskip == 0 || frameskip > MAX_FRAMESKIP) {
				// count frames per second
				fps2++;
				if (xtime2 > 60) {
					fps = fps2;	
					fps2 = 0;
					pps = pps2;
					pps2 = 0;
					xtime2 = 0;
				}
				clear_to_color(temp,COURT_BACK_COLOR);
				if (COURT == 2) stretch_blit(skin2,temp,0,0,skin2->w,skin2->h,0,0,temp->w,temp->h);
				//blit(skin2,temp,0,0,0,0,SCREEN_W,SCREEN_H);
				if (COURT == 3) stretch_blit(skin3,temp,0,0,skin3->w,skin3->h,0,0,temp->w,temp->h);
				//blit(skin3,temp,0,0,0,0,SCREEN_W,SCREEN_H);
				//stretch_blit(temp,screen,0,0,temp->w,temp->h,0,0,SCREEN_W,SCREEN_H);
				vline(temp, 400, 15, 595, COURT_COLOR);
				hline(temp, 5, 15, 795, COURT_COLOR);
				hline(temp, 5, 595, 795, COURT_COLOR);
				vline(temp, 5, 15, 595, COURT_COLOR);
				vline(temp, 795, 15, 595, COURT_COLOR);
				rectfill(temp,795,300-(GOAL_SIZE/2),800,300+(GOAL_SIZE/2),COURT_COLOR);
				rectfill(temp,0,300-(GOAL_SIZE/2),5,300+(GOAL_SIZE/2),COURT_COLOR);
				textprintf(temp,font,180,4,COURT_COLOR,"LEFT = %d", goals2);
				textprintf(temp,font,580,4,COURT_COLOR,"RIGHT = %d", goals1);
				textprintf(temp,font,373,4,COURT_COLOR,"FPS = %d", fps);
				if (arg == 3) textprintf(temp,font,100,24,COURT_COLOR,"packets per sec = %d, latency = %d ms | %d %d | %d", pps, lat, lat2, xtime4, xtime5);
				circlefill(temp, x1, y1, PAD_SIZE, PAD1_COLOR);
				circlefill(temp, x2, y2, PAD_SIZE, PAD2_COLOR);
				if (x2 >= xball) draw_sprite_h_flip(temp, toy, x2-6, y2-6);
				if (x2 < xball) draw_sprite(temp, toy, x2-6, y2-6);
				if (x1 >= xball) draw_sprite_h_flip(temp, toy, x1-6, y1-6);
				if (x1 < xball) draw_sprite(temp, toy, x1-6, y1-6);
				circlefill(temp,xball,yball, BALL_SIZE,BALL_COLOR);
				vsync();
				stretch_blit(temp,screen,0,0,temp->w,temp->h,0,0,SCREEN_W,SCREEN_H);
				//blit(temp,screen,0,0,0,0,SCREEN_W,SCREEN_H);
				if(frameskip > MAX_FRAMESKIP) frameskip = 0;
			}
			clear_bitmap(temp);
			
			if(key[KEY_UP])    y1v -= PAD_SPEED;
			if(key[KEY_DOWN])  y1v += PAD_SPEED;
			if(key[KEY_LEFT])  x1v -= PAD_SPEED;
			if(key[KEY_RIGHT]) x1v += PAD_SPEED;

			if (arg == 2) {	
				if(key[KEY_W]) y2v -= PAD_SPEED;
				if(key[KEY_S]) y2v += PAD_SPEED;
				if(key[KEY_A]) x2v -= PAD_SPEED;
				if(key[KEY_D]) x2v += PAD_SPEED;
			}	
			
			x1v *= FRICTION;
			y1v *= FRICTION;
			x2v *= FRICTION;
			y2v *= FRICTION;
			xspeed *= BALL_FRICTION;
			yspeed *= BALL_FRICTION;
	
			if (xspeed > MAX_BALL_SPEED) xspeed = MAX_BALL_SPEED;
			if (yspeed > MAX_BALL_SPEED) yspeed = MAX_BALL_SPEED;
			if (xspeed < -MAX_BALL_SPEED) xspeed = -MAX_BALL_SPEED;
			if (yspeed < -MAX_BALL_SPEED) yspeed = -MAX_BALL_SPEED;
		
			if ((y1 >= 590) || (y1 <= 20)) {
				play_sample(bounce, 180, 180, 1000, 0);
		   		y1v *= -1;
			}
			if ((x1 <= 10) || (x1 >= 790)) { 
				play_sample(bounce, 180, 180, 1000, 0);
		   		x1v *= -1;
			}
			if ((y2 >= 590) || (y2 <= 20)) { 
		   		play_sample(bounce, 180, 180, 1000, 0);
		   		y2v *= -1;
			}
			if ((x2 <= 10) || (x2 >= 790)) { 
		   		play_sample(bounce, 180, 180, 1000, 0);
		   		x2v *= -1;
			}
		
			if (y1 >= 591) y1 = 589;
			if (y1 <= 19)  y1 = 21;
			if (x1 <= 9)  x1 = 11;
			if (x1 >= 791) x1 = 789;
		
			if (y2 >= 591) y2 = 589;
			if (y2 <= 19)  y2 = 21;
			if (x2 <= 9)  x2 = 11;
			if (x2 >= 791) x2 = 789;
		
			if (x1v > MAX_SPEED) x1v = MAX_SPEED;
			if (y1v > MAX_SPEED) y1v = MAX_SPEED;
			if (x1v < -MAX_SPEED) x1v = -MAX_SPEED;
			if (y1v < -MAX_SPEED) y1v = -MAX_SPEED;
	
			if (arg == 1) {
				if (x2v > CPU_SPEED) x2v = CPU_SPEED;
				if (y2v > CPU_SPEED) y2v = CPU_SPEED;
				if (x2v < -CPU_SPEED) x2v = -CPU_SPEED;
				if (y2v < -CPU_SPEED) y2v = -CPU_SPEED;
			}
	
			if ((arg == 2) || (arg == 3)) {	
				if (x2v > MAX_SPEED) x2v = MAX_SPEED;
				if (y2v > MAX_SPEED) y2v = MAX_SPEED;
				if (x2v < -MAX_SPEED) x2v = -MAX_SPEED;
				if (y2v < -MAX_SPEED) y2v = -MAX_SPEED;
			}
				
			x1 += x1v;
			y1 += y1v;
			x2 += x2v;
			y2 += y2v;

			// necessary to calculate player collisions		
			circlefill(temp, x1, y1, PAD_SIZE, PAD1_COLOR);
			circlefill(temp, x2, y2, PAD_SIZE, PAD2_COLOR);
	
			// players collide
			if ( (getpixel(temp,x1,y1) == PAD2_COLOR)
		  	|| (getpixel(temp,x1+PAD_SIZE,y1) == PAD2_COLOR) 
		  	|| (getpixel(temp,x1-PAD_SIZE,y1) == PAD2_COLOR)
		  	|| (getpixel(temp,x1,y1+PAD_SIZE) == PAD2_COLOR) 
		  	|| (getpixel(temp,x1,y1-PAD_SIZE) == PAD2_COLOR)
		  	|| (getpixel(temp,x1+PAD_SIZE*0.7,y1+PAD_SIZE*0.7) == PAD2_COLOR)
		  	|| (getpixel(temp,x1+PAD_SIZE*0.7,y1-PAD_SIZE*0.7) == PAD2_COLOR)
		  	|| (getpixel(temp,x1-PAD_SIZE*0.7,y1-PAD_SIZE*0.7) == PAD2_COLOR)
		  	|| (getpixel(temp,x1-PAD_SIZE*0.7,y1+PAD_SIZE*0.7) == PAD2_COLOR)) {
					x1v *= -2;
			    	y1v *= -2;
			    	x2v *= -2;
			    	y2v *= -2;
//				if ((arg != 3) || (position != 1)) {
					if (x1 > x2) {
						x1v += 5;
						x2v -= 5;
					}
					else {
						x1v -= 5;
						x2v += 5;
					}
					if (y1 > y2) {
						y1v += 5;
						y2v -= 5;
					}
					else {
						y1v -= 5;
						y2v += 5;
					}

			    	
//				}
//				if ((arg == 3) && (position == 1)) {

				
				/*t1 = x1v;
				t2 = y1v;
				x1v = x2v * 6;
		    	y1v = y2v * 6;
		    	x2v = t1 * 6;
		    	y2v = t2 * 6;*/

		    	pushed = 1;
		    	play_sample(bounce, 180, 180, 1000, 0);
		    }
	
			if (arg == 1) {
				// CPU thinking
				// no one has the ball
				if (posse == 0) {  
				    if (y2 > yball) y2v -= PAD_SPEED;
				    if (y2 < yball) y2v += PAD_SPEED;
				    if (x2 > xball) x2v -= PAD_SPEED;
				    if (x2 < xball) x2v += PAD_SPEED;
				}
		
				// puter has the ball
				if (posse == 2) {
				    // go towards the goal
				    if (y2 < 248) y2v += PAD_SPEED;
				    if (y2 > 252) y2v -= PAD_SPEED;
				    x2v += PAD_SPEED;
		
				    // adjust the ball for the puter    
				    if (pushed != 1) {
			        	if (xball < (x2-1)) xball += 0.2;
				        if (xball > (x2-1)) xball -= 0.2;
				        if (yball < y2) yball += 0.2;
					    if (yball > y2) yball -= 0.2;
			    	}
				}
				// player has the ball
				if (posse == 1) {
					if (y2 > y1) y2v -= PAD_SPEED;
					if (y2 < y1) y2v += PAD_SPEED;
					if (x1 > 420) {
				    	if (x2 > xball) x2v -= PAD_SPEED;
					    if (x2 < xball) x2v += PAD_SPEED;
				    }
				    else {
						if (x1 > 250) {
							if (x2 > 210) x2v -= PAD_SPEED;
							if (x2 < 190) x2v += PAD_SPEED;
						}
						else {
							if (x2 > xball) x2v -= PAD_SPEED;
							if (x2 < xball) x2v += PAD_SPEED;
						}
					}
					// slow down the puter to make more difficult to dribble him
					if (x1 > x2) if (x2v > 2) x2v = 2;
				}   // end of CPU A.I.
			}
	
			/////////// CALC START
			if ((yball >= 590) || (yball <= 20)) { 
				play_sample(bounce, 180, 180, 1000, 0);
				yspeed *= -1;
				event = 1;
			}
			if ((xball <= 10) || (xball >= 790)) {
				play_sample(bounce, 180, 180, 1000, 0);
				xspeed *= -1;
				event = 1;
			}
			if ((yball >= 594) || (yball <= 16) || (xball <= 6) || (xball >= 794)) 
			    player = 3;
		
			if (yball >= 590) yball = 589;
			if (yball <= 20) yball = 21;
			if (xball <= 10) xball = 11;
			if (xball >= 790) xball = 789;
		
		   	posse = 0;
			// player one with ball
			if (getpixel(temp,xball,yball) == PAD1_COLOR) {
				posse = 1;
			    last_player = 1;
		    	if (x1v > MAX_SPEED_WITH_BALL) x1v = MAX_SPEED_WITH_BALL;
			    if (y1v > MAX_SPEED_WITH_BALL) y1v = MAX_SPEED_WITH_BALL;
			    if (x1v < -MAX_SPEED_WITH_BALL) x1v = -MAX_SPEED_WITH_BALL;
			    if (y1v < -MAX_SPEED_WITH_BALL) y1v = -MAX_SPEED_WITH_BALL;
		
			    xspeed = x1v;
			    yspeed = y1v;
			    if (pushed == 1) {
			        if (yspeed > 0) yspeed += (rand() % 11) * 0.2;
			        if (yspeed < 0) yspeed -= (rand() % 11) * 0.2;
			        if (xspeed > 0) xspeed += (rand() % 11) * 0.2;
			        if (xspeed < 0) xspeed -= (rand() % 11) * 0.2;
			        pushed = 0;
		        }
		   		if (key[KEY_1_PAD]) {
		    	    play_sample(shot, 180, 180, 1000, 0);
			        xspeed *= 2;
			        yspeed *= 2;
		        }
			}
		
			// player 2 with ball
			if (getpixel(temp,xball,yball) == PAD2_COLOR) {
			    posse = 2;
			    last_player = 2;
			    if (x2v > MAX_SPEED_WITH_BALL) x2v = MAX_SPEED_WITH_BALL;
			    if (y2v > MAX_SPEED_WITH_BALL) y2v = MAX_SPEED_WITH_BALL;
			    if (x2v < -MAX_SPEED_WITH_BALL) x2v = -MAX_SPEED_WITH_BALL;
			    if (y2v < -MAX_SPEED_WITH_BALL) y2v = -MAX_SPEED_WITH_BALL;
			    xspeed = x2v;
			    yspeed = y2v;
			    if (pushed == 1) {
			        if (yspeed > 0) yspeed += (rand() % 11) * 0.2;
			        if (yspeed < 0) yspeed -= (rand() % 11) * 0.2;
			        if (xspeed > 0) xspeed += (rand() % 11) * 0.2;
			        if (xspeed < 0) xspeed -= (rand() % 11) * 0.2;
			        xspeed *= -1;
			        if ((rand() % 3) == 1) yspeed *= -1;
			        pushed = 0;
			    }
			    if (arg == 1) {
					// shoot ball if
				    if ((xspeed > 1) && (x2 > 500)) {
				        if (shoot(xball, yball, xspeed, yspeed) == 1) {
				            play_sample(shot, 180, 180, 1000, 0);
				            xspeed *= 2;
				            yspeed *= 2;
			       		}
				    }
				}
				if (arg == 2) {
					if (key[KEY_SPACE]) {
				        play_sample(shot, 180, 180, 1000, 0);
				        xspeed *= 2;
				        yspeed *= 2;
			        }
				}
		    }

			if (xspeed > MAX_BALL_SPEED) xspeed = MAX_BALL_SPEED;
			if (yspeed > MAX_BALL_SPEED) yspeed = MAX_BALL_SPEED;
			if (xspeed < -MAX_BALL_SPEED) xspeed = -MAX_BALL_SPEED;
			if (yspeed < -MAX_BALL_SPEED) yspeed = -MAX_BALL_SPEED;
			
			xball += xspeed;
			yball += yspeed;
			// CALC END
			
			// check if someone scored
			if ((yball > 300-(GOAL_SIZE/2)) && (yball < 300+(GOAL_SIZE/2))) {
		    	if (xball > 790) player = 2;
		    	if (xball < 10) player = 1;
		    }
		
			if (goals1 >= 3 || goals2 >= 3) {
		   		stop_sample(fundo);
		   		clear_bitmap(temp);
		   		clear_bitmap(screen);
				if ((arg == 1) && (goals1 >= 3)) textprintf(screen,font,330,280,215,"You Won !!");
				if ((arg == 2) && (goals1 >= 3)) textprintf(screen,font,330,280,215,"Player 1 Wins !!");
				if ((arg == 1) && (goals2 >= 3)) textprintf(screen,font,330,280,215,"GAME OVER");
				if ((arg == 2) && (goals2 >= 3)) textprintf(screen,font,330,280,215,"Player 2 Wins !!");
		   		rest(1000);
		   		clear_keybuf();
		   		readkey();
		   		fade_out(2);
		   		xball = 400, yball = 300;
				destroy_bitmap(skin2);
				destroy_bitmap(skin3);
				destroy_bitmap(toy);
				destroy_sample(fundo);
				destroy_sample(goal);
				destroy_sample(bounce);
				destroy_sample(shot);
				destroy_sample(bip);
				remove_int(xtimer);
				if (goals1 >= 3) return 1;
				if (goals2 >= 3) return 2;
		   	}
		}
	}
}

void about()      // about screen
{
	fade_out(4);
	vsync();
	clear_bitmap(screen);
	clear(temp);
	set_palette(op);
	
	textprintf(temp,font,310,80,215,"     by alucart ");
	textprintf(temp,font,310,100,215,"<alucart_@hotmail.com>");
	
	textprintf(temp,font,160,208,215," Player One Controls");
	textprintf(temp,font,150,220,215,"-----------------------");
	textprintf(temp,font,160,232,215," UP         - Up");
	textprintf(temp,font,160,244,215," DOWN       - Down");
	textprintf(temp,font,160,256,215," LEFT       - Left");
	textprintf(temp,font,160,268,215," RIGTH      - Rigth");
	textprintf(temp,font,160,280,215," NUM 1 PAD  - Pass/shot");
	
	textprintf(temp,font,460,208,215," Player Two Controls");
	textprintf(temp,font,450,220,215,"-----------------------");
	textprintf(temp,font,460,232,215," W     - Up");
	textprintf(temp,font,460,244,215," S     - Down");
	textprintf(temp,font,460,256,215," A     - Left");
	textprintf(temp,font,460,268,215," D     - Rigth");
	textprintf(temp,font,460,280,215," SPACE - Pass/shot");
	
	textprintf(temp, font, 320, 570, 215, "%s", VERSION);
	
	stretch_blit(temp,screen,0,0,temp->w,temp->h,0,0,SCREEN_W,SCREEN_H);
	
	rest(1000);
	clear_keybuf();
	readkey();
	fade_out(4);
	clear_bitmap(screen);
	clear_bitmap(temp);
	set_palette(op);
	}
	
int championship()      // the story mode 
{
	int ret;
	
	COURT = 1;
	image ("data//a1.pcx");
	image ("data//a2.pcx");
	PAD1_COLOR       = 18;
	PAD2_COLOR       = 2;
	BALL_COLOR       = 0;
	COURT_COLOR      = 216;
	COURT_BACK_COLOR = 217;
	GOAL_SIZE        = 100;
	ret = game(1);
	if (ret != 1) return 0;
	// second game
	image("data//a3.pcx");
	COURT = 2;
	PAD1_COLOR       = 18;
	PAD2_COLOR       = 2;
	BALL_COLOR       = 0;
	COURT_COLOR      = 216;
	COURT_BACK_COLOR = 217;
	GOAL_SIZE        = 100;
	CPU_SPEED++;
	ret = game(1);
	if (ret != 1) return 0;
	// third game
	image("data//a4.pcx");
	COURT = 3;
	PAD1_COLOR       = 18;
	PAD2_COLOR       = 2;
	BALL_COLOR       = 0;
	COURT_COLOR      = 216;
	COURT_BACK_COLOR = 217;
	GOAL_SIZE        = 100;
	CPU_SPEED++;
	ret = game(1);
	if (ret != 1) return 0;
	image("data//a5.pcx");
	quitgame();
	return 0;
}

void image(char *str)       // prints the images (for story mode)
{
	BITMAP *img;
	img = load_pcx(str, pal);
	vsync();
	clear_bitmap(screen);
	set_palette(op);
	stretch_blit(img,screen,0,0,img->w,img->h,0,0,SCREEN_W,SCREEN_H);
	//blit(img, screen, 0, 0, 0, 0, 800, 600);
	rest(500);
	clear_keybuf();
	readkey();
	fade_out(2);
	clear_bitmap(screen);
	set_palette(op);
	destroy_bitmap(img);
}

// should puter shoot the ball? if yes ret 1
int shoot(float xball, float yball, float xspeed, float yspeed)
{
    int xtmp, ytmp, xtmp2, ytmp2;    
    
    xtmp = xball;
    ytmp = yball;
    xtmp2 = xspeed*2;
    ytmp2 = yspeed*2;
    for ( ; xtmp < 795; ) {
        if ((ytmp >= 590) || (ytmp <= 20)) ytmp2 *= -1;
        xtmp += xtmp2;        
        ytmp += ytmp2;
    }
    
    if ((ytmp > (300-GOAL_SIZE/2)) && (ytmp < (300+GOAL_SIZE/2))) return 1;
    else return 0;

}

void quitgame()
{
	destroy_bitmap(temp);

	allegro_exit();
	exit(0);	
}

void xtimer(void)
{
   xtime++;
   xtime2++;
   xtime3++;
   xtime4++;
   xtime5++;
}

void encode(char *str, float a, float b, float c, float d)
{

	str[0] = a/10;
	str[1] = ((a/10) - (int)a/10) * 100;

	str[2] = b/10;
	str[3] = ((b/10) - (int)b/10) * 100;

	str[4] = c*10;
	str[5] = d*10;
	
	str[6] = '\0';

}

void decode(char *str, float *a, float *b, float *c, float *d)
{
	float tmp1, tmp2;

	tmp1 = str[0];
	tmp2 = str[1];
    *a = (float)(tmp1*10 + tmp2/10);

	tmp1 = str[2];
	tmp2 = str[3];
    *b = (float)(tmp1*10 + tmp2/10);

	tmp1 = str[4];
	*c = (float)(tmp1/10);

	tmp1 = str[5];
	*d = (float)(tmp1/10);
}

int netplay()
{
	int c;
	int i = -1;
	position = 0;	
	ip = (char *)malloc(256 * sizeof(char));
	memset(ip, 0, 256);	
	clear_bitmap(screen);
	clear_bitmap(temp);
	textprintf(screen, font, 160, 208, 215, "press [s] to act as server");
	textprintf(screen, font, 160, 228, 215, "press [c] to connect to a server");
    rest(1000);
	clear_keybuf();

	c = readkey();
	rest(10);
	clear_keybuf();
	if ((c >> 8) == KEY_ESC) {
		if (ip != NULL) free(ip);
		return -1;
	}
	if ((c & 0xff) == 's') position = 1;
	if ((c & 0xff) == 'c') {
		position = 2;
		for (;;) {
			vsync();
			stretch_blit(temp,screen,0,0,temp->w,temp->h,0,0,SCREEN_W,SCREEN_H);
			//blit(temp, screen, 0, 0, 1, 1, 800, 600);
			clear_bitmap(temp);
			textprintf(temp, font, 160, 208, 215, "ip address to connect: %s", ip);	
			if (keypressed()) {
				c = readkey();
				rest(10);
				clear_keybuf();
				if ((c >> 8) == KEY_ESC) {
					position = 0;
					break;
				}
				if ((c >> 8) == KEY_ENTER) break;
				if ((c >> 8) == KEY_ENTER_PAD) break;				
				if (((c & 0xff) == '\b') && (strlen(ip) > 0)) ip[strlen(ip)-1] = '\0';
				else if ((strlen(ip) < 255) && ((c & 0xff) != '\b')) ip[strlen(ip)] = (c & 0xff);
			}
		}
	}
	
	//printf("%s - %d - %d", ip, sizeof(ip), strlen(ip));
	if (position != 0) game(3);
	if (ip != NULL) free(ip);
	return 0;
}

END_OF_FUNCTION(xtimer);



