#include <allegro.h>
#include <ctype.h>
#include <string.h>
#include "aldumb.h"

#define FALSE 0                                                   

/* little vsync thingy */
AL_DUH_PLAYER *sbstatus = NULL;
int quit,leavegame=FALSE;

volatile unsigned int VSyncTimer;
void VSyncTimerFunc(void)
{
	VSyncTimer++;
}
END_OF_FUNCTION(VSyncTimer);
void QuitFunc(void)
{
	leavegame=TRUE;
	quit=TRUE;
}

BITMAP *VScreen;
int Skip;
int Framecount, QuitFlag;

#ifdef ALLEGRO_MACOSX
char DirtyLines[480];
int VSMode = 0;

void my_putpixel(BITMAP *target, int x, int y, int colour)
{
	putpixel(target, x, y, colour);
	if(!VSMode)
		DirtyLines[y] = 9;
}

void my_vline(BITMAP *target, int x, int y1, int y2, int colour)
{
	vline(target, x, y1, y2, colour);
	if(!VSMode)
		memset(&DirtyLines[y1], 9, y2-y1);
}

//#define my_blit				blit
void my_blit(BITMAP *source, BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height)
{
	blit(source, dest, source_x, source_y, dest_x, dest_y, width, height);
	if(!VSMode && dest_y < 200)
	{
		if(dest_y+height > 200)
			height = 200 - dest_y;
		memset(&DirtyLines[dest_y], 9, height);
	}
}

//#define my_stretch_sprite	stretch_sprite
void my_stretch_sprite(BITMAP *bmp, BITMAP *sprite, int x, int y, int w, int h)
{
	stretch_sprite(bmp, sprite, x, y, w, h);
	if(!VSMode && y < 200)
	{
		if(y+h > 200)
			h = 200 - y;
		memset(&DirtyLines[y], 9, h);
	}
}

//#define my_draw_rle_sprite	draw_rle_sprite
void my_draw_rle_sprite(BITMAP *bmp, const RLE_SPRITE *sprite, int x, int y)
{
	draw_rle_sprite(bmp, sprite, x, y);
	if(!VSMode && y < 200)
	{
		int h = sprite->h;
		if(y+h > 200)
			h = 200 - y;
		memset(&DirtyLines[y], 9, h);
	}
}

//#define my_draw_compiled_sprite	draw_compiled_sprite
void my_draw_compiled_sprite(BITMAP *bmp, const COMPILED_SPRITE *sprite, int x, int y)
{
	draw_compiled_sprite(bmp, sprite, x, y);
	if(!VSMode)
	{
		memset(&DirtyLines[y], 9, sprite->h);
	}
}

void my_draw_sprite(BITMAP *bmp, BITMAP *sprite, int x, int y)
{
	draw_sprite(bmp, sprite, x, y);
	if(!VSMode && y < 200)
	{
		int h = sprite->h;
		if(y+h > 200)
			h = 200 -y;
		memset(&DirtyLines[y], 9, h);
	}
}

void my_rectfill(BITMAP *b, int x1, int y1, int x2, int y2, int colour)
{
	rectfill(b, x1, y1, x2, y2, colour);
	if(!VSMode)
		memset(&DirtyLines[y1], 9, y2-y1+1);
}

#else
#define my_blit				blit
#define my_draw_rle_sprite	draw_rle_sprite
#define my_stretch_sprite	stretch_sprite
#define my_draw_compiled_sprite	draw_compiled_sprite
#define my_draw_sprite	draw_sprite
#define my_putpixel	putpixel
#define my_vline	vline
#define my_rectfill rectfill
#endif

void my_vsync()
{
	unsigned int Diff;

	if(sbstatus) al_poll_duh(sbstatus);

	Framecount++;
#ifdef ALLEGRO_MACOSX
	if(!Skip)
	{
		if(VSMode)
			stretch_blit(VScreen, screen, 0, 0, VScreen->w, VScreen->h, 0, 0, SCREEN_W, SCREEN_H);
		else
		{
			fixed pos = 0;
			fixed add = itofix(200) / 480;
			int y = 0;
			while(fixtoi(pos) < 200)
			{
				if(DirtyLines[fixtoi(pos)])
					stretch_blit(VScreen, screen, 0, fixtoi(pos), VScreen->w, 1, 0, y, SCREEN_W, 1);
				pos += add;
				y++;
			}
			memset(DirtyLines, 0, 200);
		}
	}
#elif !defined(ALLEGRO_DOS)
	blit(VScreen, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
#endif

	 Diff = 3 - VSyncTimer;
	if(Diff <= 3)
	{
		rest((Diff * 1000) / 210);
		VSyncTimer -= 3;
		Skip = 0;
	}
	else
	{
		VSyncTimer = 0;
		Skip = Framecount&7;
	}
}

void setup_my_vsync()
{
#ifndef ALLEGRO_DOS
	VScreen = create_bitmap(320, 200);
#else
	VScreen = screen;
#endif
	LOCK_FUNCTION(VSyncTimerFunc);
	LOCK_VARIABLE(VSyncTimer);
	 install_int_ex(VSyncTimerFunc, BPS_TO_TIMER(210));
	set_close_button_callback(QuitFunc);
}

void end_my_vsync()
{
	free(VScreen);
}


BITMAP *numbers[10],*title,*backdrop,*output,*gameover_text;
BITMAP *gameover,*landed,*scoredisplay,*letters[28],*scorebackground;
BITMAP *tempbit,*bossspr,*bossbackdrop,*citybackdrop;
COMPILED_SPRITE *bomb, *building[7];
RLE_SPRITE *ship[4];
SAMPLE *sounds0;
SAMPLE *sounds1, *sounds2,*sounds3,*sounds4,*sounds5,*sounds6;
DUH *menu, *game, *cp = NULL;
PALETTE pal[6];
int buildingshift[7],temp[3],score;
int buildingheight[10],sonics=TRUE;
int buildingtype[10][8];
float shipy[2],shipx[2];
int curship=0,oldship=0,bomb_launched=FALSE;
int bombx[2], bomby[2], bombabove;
int heightabove, exploding[2];
int explodebuilding=FALSE;
int newbomb;
int minbuildingheight, won=FALSE;
float moverate;
int scores[10][13],retscore[10],retlength;
int keyconv[58];
float fallrate;
float counter=0;

void drawscore(void);
void reset_vars(void);

void sb_mod_play(DUH *s)
{
	if(cp != s)
	{
		if(sbstatus)
			al_stop_duh(sbstatus);
			
		if(s)
			sbstatus = al_start_duh(cp = s, 2, 0, 1.0f, 4096, 48000);
		else
			sbstatus = NULL;
	}
}

void my_fade_out_range(int speed, int from, int to)
{
	PALETTE p, outp;
	int c;
	int level = 64;
	
	get_palette(p);

#ifdef ALLEGRO_MACOSX
	memset(DirtyLines, 1, 200);
#endif
	my_vsync();

	while(level > 0)
	{
		for(c = from; c <= to; c++)
		{
			outp[c].r = (p[c].r * level) >> 6;
			outp[c].g = (p[c].g * level) >> 6;
			outp[c].b = (p[c].b * level) >> 6;
		}
		set_palette(outp);
		my_vsync();
		level -= speed;
	}
}

void my_fade_in_range(PALETTE p, int speed, int from, int to)
{
	int level = 0;
	int c;
	PALETTE outp;
	
#ifdef ALLEGRO_MACOSX
	memset(DirtyLines, 1, 200);
#endif
	my_vsync();

	while(level < 64)
	{
		for(c = from; c <= to; c++)
		{
			outp[c].r = (p[c].r * level) >> 6;
			outp[c].g = (p[c].g * level) >> 6;
			outp[c].b = (p[c].b * level) >> 6;
		}
		set_palette(outp);
		my_vsync();
		level += speed;
	}
	set_palette(p);
}

void my_rest(int length)
{
	int c = length >> 3;
	while(c--)
	{
		rest(8);
		if(sbstatus) al_poll_duh(sbstatus);
	}
}

void my_readkey()
{
	while(!keypressed())
	{
		rest(10);
		if(sbstatus) al_poll_duh(sbstatus);
	}
	readkey();
}

void setup_sprites(void)
{
   FILE *scfile;

   output=load_pcx("bitmaps/sprites.pcx",pal[0]);
   citybackdrop=load_pcx("bitmaps/bkground.pcx",pal[0]);
   title=load_pcx("bitmaps/title.pcx",pal[1]);
   gameover=load_pcx("bitmaps/gameover.pcx",pal[2]);
   landed=load_pcx("bitmaps/landed.pcx",pal[3]);
   scorebackground=load_pcx("bitmaps/hiscores.pcx",pal[4]);
   gameover_text=load_pcx("bitmaps/gotxt.pcx",pal[2]);
   set_palette(pal[0]);

   tempbit=create_bitmap(19,15);
   blit(output, tempbit, 7, 0, 0, 0, 19, 15);
   building[0]=get_compiled_sprite(tempbit, FALSE);
   buildingshift[0]=7;
   destroy_bitmap(tempbit);

   tempbit=create_bitmap(21,15); //+2
   blit(output, tempbit, 6, 16, 0, 0, 21, 15);
   building[1]=get_compiled_sprite(tempbit, FALSE);
   buildingshift[1]=6;
   destroy_bitmap(tempbit);

   tempbit=create_bitmap(25,15); //+4
   blit(output, tempbit, 4, 32, 0, 0, 25, 15);
   building[2]=get_compiled_sprite(tempbit, FALSE);
   buildingshift[2]=4;
   destroy_bitmap(tempbit);

   tempbit=create_bitmap(29,15); //+4
   blit(output, tempbit, 2, 48, 0, 0, 29, 15);
   building[3]=get_compiled_sprite(tempbit, FALSE);
   buildingshift[3]=2;
   destroy_bitmap(tempbit);

   tempbit=create_bitmap(32,15); //+3
   blit(output, tempbit, 1, 64, 0, 0, 32, 15);
   building[4]=get_compiled_sprite(tempbit, FALSE);
   buildingshift[4]=1;
   destroy_bitmap(tempbit);

   tempbit=create_bitmap(34,15); //+2
   blit(output, tempbit, 0, 80, 0, 0, 34, 15);
   building[5]=get_compiled_sprite(tempbit, FALSE);
   buildingshift[5]=0;
   destroy_bitmap(tempbit);

   tempbit=create_bitmap(1,1);
   clear(tempbit);
   building[6]=get_compiled_sprite(tempbit, FALSE);
   buildingshift[6]=0;
   destroy_bitmap(tempbit);


   tempbit=create_bitmap(29,10);
   blit(output, tempbit, 39, 0,  0, 0, 29, 10);
   ship[0]=get_rle_sprite(tempbit);
   destroy_bitmap(tempbit);

   tempbit=create_bitmap(29,10);
   blit(output, tempbit, 39, 11,  0, 0, 29, 10);
   ship[1]=get_rle_sprite(tempbit);
   destroy_bitmap(tempbit);

   tempbit=create_bitmap(29,10);
   blit(output, tempbit, 39, 22,  0, 0, 29, 10);
   ship[2]=get_rle_sprite(tempbit);
   destroy_bitmap(tempbit);

   tempbit=create_bitmap(29,33);
   blit(output, tempbit, 39, 33,  0, 0, 29, 10);
   ship[3]=get_rle_sprite(tempbit);
   destroy_bitmap(tempbit);

   for(temp[0]=0;temp[0]<9;temp[0]++)
     {
      numbers[temp[0]+1]=create_bitmap(3,7);
      blit(output, numbers[temp[0]+1], 91+(temp[0]*4), 0, 0, 0, 3, 7);
     }

   numbers[0]=create_bitmap(3,7);
   blit(output, numbers[0], 127, 0, 0, 0, 3, 7);

   temp[2]=0;

   for(temp[0]=0;temp[0]<3;temp[0]++)
     for(temp[1]=0;temp[1]<9;temp[1]++)
       {
        letters[temp[2]]=create_bitmap(8,13);
        blit(output, letters[temp[2]], 36+(temp[1]*9), 45+(temp[0]*14), 0, 0, 8, 13);
        temp[2]++;
       }

   letters[27]=create_bitmap(8,12);
   clear(letters[27]);

   scoredisplay=create_bitmap(25,7);
   clear(scoredisplay);

   tempbit=create_bitmap(5,7);
   blit(output, tempbit, 85, 0, 0, 0, 5, 7);
   bomb=get_compiled_sprite(tempbit,FALSE);
   destroy_bitmap(tempbit);

   if(sonics == TRUE)
     {
      sounds0=load_wav("sounds/day0.wav");
      sounds1=load_wav("sounds/day1.wav");
      sounds2=load_wav("sounds/day2.wav");
      sounds3=load_wav("sounds/day3.wav");
      sounds4=load_wav("sounds/day4.wav");
      sounds5=load_wav("sounds/day5.wav");
      sounds6=load_wav("sounds/day6.wav");

      menu = dumb_load_mod_quick("mods/kent.mod");
      game = dumb_load_mod_quick("mods/idea2.mod");
     }

   if(scfile = fopen("scores.dat", "rb"))
   {
     for(temp[0]=0;temp[0]<10;temp[0]++)
	 {
       for(temp[1]=0;temp[1]<10;temp[1]++)
	     scores[temp[0]][temp[1]]=fgetc(scfile);

	     scores[temp[0]][10]=fgetc(scfile);
	     scores[temp[0]][10]|=fgetc(scfile) << 8;
	     scores[temp[0]][10]|=fgetc(scfile) << 16;
	     scores[temp[0]][10]|=fgetc(scfile) << 24;
	}
	   fclose(scfile);
   }
   else
   {

   for(temp[0]=0;temp[0]<10;temp[0]++)
     for(temp[1]=0;temp[1]<13;temp[1]++)
       scores[temp[0]][temp[1]]=26;

   scores[0][3]=17;
   scores[0][4]=4;
   scores[0][5]=0;
   scores[0][6]=11;

   scores[0][10]=50000;


   scores[1][2]=22;
   scores[1][3]=8;
   scores[1][4]=13;
   scores[1][5]=13;
   scores[1][6]=4;
   scores[1][7]=17;
   scores[1][8]=18;

   scores[1][10]=10000;


   scores[2][3]=3;
   scores[2][4]=14;
   scores[2][5]=13;
   scores[2][6]=19;

   scores[2][10]=6000;


   scores[3][3]=19;
   scores[3][4]=0;
   scores[3][5]=10;
   scores[3][6]=4;

   scores[3][10]=4000;


   scores[4][2]=3;
   scores[4][3]=17;
   scores[4][4]=20;
   scores[4][5]=6;
   scores[4][6]=18;

   scores[4][10]=3500;


   scores[5][10]=2500;


   scores[6][2]=4;
   scores[6][3]=23;
   scores[6][4]=2;
   scores[6][5]=4;
   scores[6][6]=15;
   scores[6][7]=19;

   scores[6][10]=1800;


   scores[7][2]=8;
   scores[7][3]=13;
   scores[7][4]=27;
   scores[7][5]=3;
   scores[7][6]=17;
   scores[7][7]=20;
   scores[7][8]=6;

   scores[7][10]=1500;


   scores[8][2]=19;
   scores[8][3]=0;
   scores[8][4]=10;
   scores[8][5]=8;
   scores[8][6]=13;
   scores[8][7]=6;

   scores[8][10]=1250;


   scores[9][1]=2;
   scores[9][2]=14;
   scores[9][3]=13;
   scores[9][4]=19;
   scores[9][5]=4;
   scores[9][6]=18;
   scores[9][7]=19;
   scores[9][8]=18;

   scores[9][10]=1000;
   }

   keyconv[16]=16;
   keyconv[17]=22;
   keyconv[18]=4;
   keyconv[19]=17;
   keyconv[20]=19;
   keyconv[21]=24;
   keyconv[22]=20;
   keyconv[23]=8;
   keyconv[24]=14;
   keyconv[25]=15;

   keyconv[30]=0;
   keyconv[31]=18;
   keyconv[32]=3;
   keyconv[33]=5;
   keyconv[34]=6;
   keyconv[35]=7;
   keyconv[36]=9;
   keyconv[37]=10;
   keyconv[38]=11;

   keyconv[44]=25;
   keyconv[45]=23;
   keyconv[46]=2;
   keyconv[47]=21;
   keyconv[48]=1;
   keyconv[49]=13;
   keyconv[50]=12;

   keyconv[52]=26;

   keyconv[57]=27;

   destroy_bitmap(output);
}

void chartoscore(int inscore)
{
	char buf[15], *bptr;
//   int number;

	sprintf(buf,"%d",inscore);
   retlength=strlen(buf);
   bptr = buf;
   while(*bptr)
   {
	retscore[bptr - buf] = *bptr - '0';
	bptr++;
   }

//	for(number=0;number<10;number++)
  //   {
/*      if(buf[number]=='0')
        {
         retscore[number]=0;
         retlength++;
        }

      if(buf[number]=='1')
        {
         retscore[number]=1;
         retlength++;
        }

      if(buf[number]=='2')
        {
         retscore[number]=2;
         retlength++;
        }

      if(buf[number]=='3')
        {
         retscore[number]=3;
         retlength++;
        }

      if(buf[number]=='4')
        {
         retscore[number]=4;
         retlength++;
        }

      if(buf[number]=='5')
        {
         retscore[number]=5;
         retlength++;
        }

      if(buf[number]=='6')
        {
         retscore[number]=6;
         retlength++;
        }

      if(buf[number]=='7')
        {
         retscore[number]=7;
         retlength++;
        }

      if(buf[number]=='8')
        {
         retscore[number]=8;
         retlength++;
        }

      if(buf[number]=='9')
        {
         retscore[number]=9;
         retlength++;
        }*/
//     }
}

void newlev_vars(void)
{
   shipx[0]=0;
   shipy[0]=50;
   bombx[0]=0;
   bomby[0]=0;
   curship=oldship=0;
	
   moverate+=0.001;

   newbomb=TRUE;
   explodebuilding=FALSE;

   fallrate+=0.001;

   if(minbuildingheight < 7)
     minbuildingheight++;
}

void clear_buffer(void)
{
   if(keypressed() == TRUE)
     do{
       readkey();
      }while(keypressed() == TRUE);

   if(keypressed() == TRUE)
     do{
       readkey();
      }while(keypressed() == TRUE);
}

void move_spaceship(void)
{
	temp[0]=shipx[1];
   temp[1]=0;

	if(shipx[1] < 0)
     {
      temp[0]=0;
      temp[1]=shipx[1];
     }

   my_blit(backdrop, VScreen, temp[0], shipy[1], temp[0], shipy[1], 29, 10);

   my_draw_rle_sprite(VScreen, ship[curship], shipx[0], shipy[0]);
}

void erase_spaceship(void)
{
	temp[0]=shipx[1];
   temp[1]=0;

	if(shipx[1] < 0)
     {
      temp[0]=0;
      temp[1]=shipx[1];
     }

   my_blit(backdrop, VScreen, temp[0], shipy[1], temp[0], shipy[1], 29, 10);
}

void inputscore(int pos)
{
//	int extemp,newletter;

#ifdef ALLEGRO_MACOSX
	memset(DirtyLines, 1, 200);
#endif
	my_vsync();

	temp[2]=0;
	clear_keybuf();
//   newletter=FALSE;

	do{
   	temp[1]=temp[2];
	if(keypressed())
	{
		int key= readkey();

		if((key >> 8) == KEY_BACKSPACE)
		{
			if(temp[2])
			{
				my_rectfill(VScreen, 135+(temp[2]*10), 44+(pos*15), 143+(temp[2]*10), 44+(pos*15)+12, 0);
				temp[2]--;
				scores[pos][temp[2]]=27;
			}
		}
		else
		if(temp[2] < 10)
		switch(key >> 8)
		{
			case KEY_STOP:
				scores[pos][temp[2]] = 26;
				temp[2] ++;
			break;
			case KEY_SPACE:
				scores[pos][temp[2]] = 27;
				temp[2] ++;
			break;
			default:
			{
				char ascii = tolower(key&0xff);
				if( ascii >= 'a' && ascii <= 'z')
				{
					scores[pos][temp[2]] = ascii - 'a';
					temp[2] ++;
				}
			}
			break;
		}
	}
 /*  	for(temp[0]=16;temp[0]<26;temp[0]++)
        if(key[temp[0]] && newletter == TRUE && temp[2]<10)
          {
           scores[pos][temp[2]]=keyconv[temp[0]];

             temp[2]++;

           temp[0]=26;
          }
   	
   	for(temp[0]=30;temp[0]<39;temp[0]++)
        if(key[temp[0]] && newletter == TRUE && temp[2]<10)
          {
           scores[pos][temp[2]]=keyconv[temp[0]];

             temp[2]++;

           temp[0]=39;
          }

   	for(temp[0]=44;temp[0]<51;temp[0]++)
        if(key[temp[0]] && newletter==TRUE && temp[2]<10)
          {
           scores[pos][temp[2]]=keyconv[temp[0]];

             temp[2]++;

           temp[0]=51;
          }

      if(key[52] && newletter == TRUE && temp[2]<10)
        {
         scores[pos][temp[2]]=keyconv[52];

           temp[2]++;
        }
        
      if(key[57] && newletter == TRUE && temp[2] < 10)
        {
         scores[pos][temp[2]]=keyconv[57];

           temp[2]++;
        }

      if(key[14] && temp[2] >= 1 && newletter == TRUE)
        {
         rectfill(VScreen, 135+(temp[2]*10), 44+(pos*15), 143+(temp[2]*10), 44+(pos*15)+12, 0);
         temp[2]--;
         temp[1]--;
         scores[pos][temp[2]]=27;
        }

      extemp=0;
      for(temp[0]=0;temp[0]<58;temp[0]++)
        if(key[temp[0]])
          extemp++;

      if(extemp == 0)
        newletter=TRUE;
      else
        newletter=FALSE;*/

      if(temp[2] != temp[1])
        my_draw_sprite(VScreen, letters[scores[pos][temp[1]]], 135+(temp[2]*10), 44+(pos*15));

      my_vsync();

   }while(!key[KEY_ENTER]);
}

void draw_scoreboard(void)
{
         my_blit(scorebackground,VScreen, 0, 0, 0, 0, 320, 200);
         set_palette(pal[4]);

         for(temp[0]=0;temp[0]<10;temp[0]++)
           {
            for(temp[1]=0;temp[1]<10;temp[1]++)
              draw_sprite(VScreen, letters[scores[temp[0]][temp[1]]], 145+(temp[1]*10), 44+(temp[0]*15));

            chartoscore(scores[temp[0]][10]);

            for(temp[1]=0;temp[1]<retlength;temp[1]++)
              draw_sprite(VScreen, numbers[retscore[temp[1]]], 263+(temp[1]*4), 46+(temp[0]*15));
           }
}

void move_bomb(void)
{
   my_blit(backdrop, VScreen, bombx[1], bomby[1], bombx[1], bomby[1], 5, 7);
   my_draw_compiled_sprite(VScreen, bomb, bombx[0], bomby[0]);
}

void erase_bomb(void)
{
   my_blit(backdrop, VScreen, bombx[0], bomby[0], bombx[0], bomby[0], 5, 7);
}

void redraw_building(int buildng)
{
   my_blit(backdrop, VScreen, 32*buildng, 200-(15*buildingheight[buildng]), 32*buildng, 200-(buildingheight[buildng]*15), 34, buildingheight[buildng]*15+15);

   for(temp[0] = 0;temp[0] < buildingheight[buildng]; temp[0]++)
     draw_compiled_sprite( VScreen, building[buildingtype[buildng][temp[0]]],(32*buildng)+buildingshift[buildingtype[buildng][temp[0]]], 185-(15*temp[0]) );
}

void redraw_buildings(void)
{
	my_blit(backdrop, VScreen, 0, 102, 0, 102, 320, 98);
   move_spaceship();

   for(temp[0]=0;temp[0]<10;temp[0]++)
     for(temp[1] = 0; temp[1] < buildingheight[temp[0]]; temp[1]++)
       my_draw_compiled_sprite(VScreen, building[buildingtype[temp[0]][temp[1]]], (32*temp[0])+buildingshift[buildingtype[temp[0]][temp[1]]], 185-(15*temp[1]));
}

void killship(void)
{
	int buildinghit,scorepos;

   tempbit=create_bitmap(320,200);

	leavegame=TRUE;
   counter=0;
   buildinghit=(shipx[0]+20)/32;
   erase_bomb();

   if(sonics==TRUE)
     {
//      sb_mod_pause();
      play_sample(sounds4, 255, 128, 1000, 0);
     }

   shipx[0]+=2;
   shipx[1]=shipx[0];

   do{
     	my_vsync();

      move_spaceship();
      redraw_building(buildinghit);
      if(buildinghit > 0)
        redraw_building(buildinghit-1);

      if(buildingtype[buildinghit][buildingheight[buildinghit]-1] < 6)
        buildingtype[buildinghit][buildingheight[buildinghit]-1]++;

      for(temp[0]=buildingheight[buildinghit]-2;temp[0] >= 0;temp[0]--)
        if(buildingtype[buildinghit][temp[0]+1] >= 2 && buildingtype[buildinghit][temp[0]] < 6)
          buildingtype[buildinghit][temp[0]]++;

      counter+=0.5;

     	oldship=curship;

     	if(counter<3)
     	  curship=counter;

      shipy[1]=shipy[0];
      shipy[0]+=0.1;//=10;

//      my_rest(100);

     }while(buildingtype[buildinghit][0] != 6 && shipy[0] != 190);

   erase_spaceship();
   redraw_building(buildinghit);

   if(buildinghit > 0)
     redraw_building(buildinghit-1);

   my_fade_out_range(3, 0, 255);

   my_blit(gameover, VScreen, 0, 0, 0, 0, 320, 200);
   my_fade_in_range(pal[2], 1, 0, 255);


   for(temp[0]=-311;temp[0]<5;temp[0]+=3)
     {
      my_blit(gameover, tempbit, 0, 0, 0, 0, 320, 200);
      my_stretch_sprite(tempbit, gameover_text, temp[0], 0, 311, 200);
      my_blit(tempbit, VScreen, 0, 0, 0, 0, 320, 200);
	  my_vsync();
     }

   for(temp[0]=200;temp[0]>37;temp[0]-=2)
     {
      my_blit(gameover, tempbit, 0, 0, 0, 0, 320, temp[0]);
      my_stretch_sprite(tempbit, gameover_text, 5, 0, 311, temp[0]);
      my_blit(tempbit, VScreen, 0, 0, 0, 0, 320, 200);
	  my_vsync();
     }


   my_rest(1000);
   my_fade_out_range(1, 0, 255);

   my_rest(500);

	sb_mod_play(NULL);
   temp[2]=FALSE;
   for(temp[0]=0;temp[0]<10;temp[0]++)
     if(score > scores[temp[0]][10])
       {
        scorepos=temp[0];

        for(temp[1]=9;temp[1]>temp[0];temp[1]--)
          for(temp[2]=0;temp[2]<11;temp[2]++)
            scores[temp[1]][temp[2]] = scores[temp[1]-1][temp[2]];

        for(temp[1]=0;temp[1]<10;temp[1]++)
          scores[scorepos][temp[1]]=27;

        scores[temp[0]][10]=score;

        draw_scoreboard();

        if(sonics == TRUE)
          play_sample(sounds6, 255, 128, 1000, 0);

        my_fade_in_range(pal[4], 10, 0, 255);

        rect(VScreen, 141, 42+(scorepos*15), 249, 57+(scorepos*15), 15);

        inputscore(scorepos);

        temp[1]=TRUE;
       }

   draw_scoreboard();

   if(temp[2] == FALSE)
     {
      if(sonics == TRUE)
        play_sample(sounds5, 255, 128, 1000, 0);
      my_fade_in_range(pal[4], 10, 0, 255);
     }

   temp[0]=0;
   do{
   	my_vsync();
      temp[0]++;
   }while(temp[0]<550);

   score=0;
   destroy_bitmap(tempbit);
}

void winner(void)
{
   my_fade_out_range(6, 0, 255);

   my_blit(landed, VScreen, 0, 0, 0, 0, 320, 200);
   if(sonics==TRUE)
     play_sample(sounds3, 255, 128, 1000, 0);
   my_fade_in_range(pal[3], 3, 0, 255);

   clear_buffer();
   my_readkey();
   my_fade_out_range(6, 0, 255);
   won=TRUE;
}

void maingame(void)
{
   float fltemp;


   set_palette(pal[0]);
   my_blit(backdrop, VScreen, 0, 0, 0, 0, 320, 200);

   srand(time(NULL));
   for(temp[0]=0;temp[0]<10;temp[0]++)
     {
      buildingheight[temp[0]]=rand()%7;

      if(buildingheight[temp[0]] < minbuildingheight)
        buildingheight[temp[0]]=minbuildingheight;

      for(temp[1]=0;temp[1]<7;temp[1]++)
        buildingtype[temp[0]][temp[1]]=0;
     }

   redraw_buildings();
   drawscore();

   won=FALSE;
   leavegame=FALSE;

sb_mod_play(game);
   do{
   	
//      if(sb_mod_active == NULL && sonics == TRUE)

     shipx[1]=shipx[0];
     shipy[1]=shipy[0];
     bombx[1]=bombx[0];
     bomby[1]=bomby[0];

     shipx[0]+=moverate;
     shipy[0]+=fallrate;

     if(shipx[0] > 320)
       shipx[0]=-ship[0]->w;

     my_vsync();
     move_spaceship();

     if(key[KEY_5])
       killship();

     if(key[KEY_SPACE] && newbomb == TRUE && shipx[0] > -13 && shipx[0] < 320-29+13-1)
       {
        bomb_launched=TRUE;
        bombx[0]=shipx[0]+13;
        bomby[0]=shipy[0]+9;

        heightabove=1;
        bombabove=10;

        if(bombx[0] > 2 && bombx[0] < 26 && buildingheight[0] != 0)
          {                             
           bombabove=0;
           heightabove=buildingheight[0]*15;
          }

        if(bombx[0] > 34 && bombx[0] < 58 && buildingheight[1] != 0)
          {
           bombabove=1;
           heightabove=buildingheight[1]*15;
          }

        if(bombx[0] > 66 && bombx[0] < 90 && buildingheight[2] != 0)
          {
           bombabove=2;
           heightabove=buildingheight[2]*15;
          }

        if(bombx[0] > 98 && bombx[0] < 122 && buildingheight[3] != 0)
          {
           bombabove=3;
           heightabove=buildingheight[3]*15;
          }

        if(bombx[0] > 130 && bombx[0] < 154 && buildingheight[4] != 0)
          {
           bombabove=4;
           heightabove=buildingheight[4]*15;
          }

        if(bombx[0] > 162 && bombx[0] < 186 && buildingheight[5] != 0)
          {
           bombabove=5;
           heightabove=buildingheight[5]*15;
          }

        if(bombx[0] > 194 && bombx[0] < 218 && buildingheight[6] != 0)
          {
           bombabove=6;
           heightabove=buildingheight[6]*15;
          }

        if(bombx[0] > 226 && bombx[0] < 250 && buildingheight[7] != 0)
          {
           bombabove=7;
           heightabove=buildingheight[7]*15;
          }

        if(bombx[0] > 258 && bombx[0] < 282 && buildingheight[8] != 0)
          {
           bombabove=8;
           heightabove=buildingheight[8]*15;
          }

        if(bombx[0] > 290 && bombx[0] < 314 && buildingheight[9] != 0)
          {
           bombabove=9;
           heightabove=buildingheight[9]*15;
          }

         newbomb=FALSE;
         heightabove=200-heightabove-7;
         if(sonics == TRUE)
           play_sample(sounds1, 255, 128, 1000, 0);
       }

     if(bomb_launched==TRUE)
       {
        bomby[0]++;
        move_bomb();

        if(bomby[0] > heightabove)
          if(bombabove != 10)
            {
             explodebuilding=TRUE;
             exploding[0]=bombabove;
             exploding[1]=buildingheight[bombabove]-1;
             erase_bomb();
             bomb_launched=FALSE;
             counter=0;

             if(sonics==TRUE)
               play_sample(sounds2, 255, 128, 1000, 0);
            }
          else
            {
             erase_bomb();
             bomb_launched=FALSE;
             newbomb=TRUE;
            }
       }


     if(explodebuilding==TRUE)
       {
        counter+=0.15;

        buildingtype[exploding[0]][exploding[1]]=counter;

        if(buildingtype[exploding[0]][exploding[1]] > 6)
          {
           buildingheight[exploding[0]]--;
           explodebuilding=FALSE;
           newbomb=TRUE;
           score+=10;
           drawscore();
          }

        redraw_building(exploding[0]);
       }

      if(shipy[0] >= 188)
        {
        	won=TRUE;
         leavegame=TRUE;
         winner();
        }

     if(shipy[0] > 95 && shipx[0] > -20)
       {
       	fltemp=temp[0]=(shipx[0]+20)/32;
         if(temp[0]==10)
           temp[0]=9;

       if(shipy[0]+10 > 200 - 15*buildingheight[temp[0]] && fltemp < temp[0]+0.2)
         killship();
       }

      if(key[KEY_ESC])
        leavegame=TRUE;

      if(buildingheight[0]==0 && buildingheight[1]==0 && buildingheight[2]==0 &&
         buildingheight[3]==0 && buildingheight[4]==0 && buildingheight[5]==0 &&
         buildingheight[6]==0 && buildingheight[7]==0 && buildingheight[8]==0 &&
         buildingheight[9]==0)
        {
        	won=TRUE;
         leavegame=TRUE;
         winner();
        }

     }while(leavegame==FALSE);
}

/*void boss(void)
{
	int pixelsleft,bossshift,pixeltemp[2];
   char buf[10];

   bossshift=201-bossspr->h;

//   blit(bossbackdrop, VScreen, 0, 0, 0, 0, 320, 200);
	draw_sprite(VScreen,bossspr,0,bossshift);

   won=FALSE;
   leavegame=FALSE;
   bomb_launched=FALSE;
   shipy[0]=0;

   pixelsleft=0;

   for(temp[0]=0;temp[0]<bossspr->w;temp[0]++)
     for(temp[1]=0;temp[1]<bossspr->h;temp[1]++)
       if(getpixel(bossspr, temp[0], temp[1]) > 0)
         pixelsleft++;

   tempbit=create_bitmap(21,21);
   clear(tempbit);
        sb_mod_play(game);


   do{
//      if(sb_mod_active == NULL && sonics == TRUE)

     shipx[1]=shipx[0];
     shipy[1]=shipy[0];
     bombx[1]=bombx[0];
     bomby[1]=bomby[0];

     if(bomb_launched == TRUE)
       bomby[0]++;

     shipx[0]+=moverate;
//     shipy[0]+=fallrate;

     if(shipx[0] > 320)
       shipx[0]=-ship[0]->w;

     my_vsync();
     move_spaceship();

     if(bomb_launched == TRUE)
       move_bomb();

     if(bomby[0] > 192 && bomb_launched == TRUE)
       {
        bomb_launched = FALSE;
        erase_bomb();
       }

     if(key[KEY_SPACE] && bomb_launched == FALSE && shipx[0] > -13 && shipx[0] < 320-29+13-1)
       {
        bomb_launched=TRUE;
        bombx[0]=shipx[0]+13;
        bomby[0]=shipy[0]+10;
       }

//     if(key[KEY_LEFT])
  //     shipx[0]+=moverate;

     if(key[KEY_Z])
       leavegame=TRUE;

     if(bomb_launched == TRUE)
       {
        temp[1]=0;
       	
        for(temp[0]=0;temp[0]<5;temp[0]++)
          temp[1]+=getpixel(bossspr,bombx[0]+temp[0],bomby[0]-bossshift+7);

        if(temp[1] > 0)
          {
           bomb_launched=FALSE;
           erase_bomb();

           pixeltemp[0]=0;
           pixeltemp[1]=0;

           for(temp[0]=bombx[0]-7;temp[0]<bombx[0]+2+10;temp[0]++)
             for(temp[1]=bomby[0]-bossshift+6-10;temp[1]<bomby[0]-bossshift+8+10;temp[1]++)
                if(getpixel(bossspr, temp[0], temp[1]) == 0)
                  pixeltemp[1]++;

           circlefill(bossspr,bombx[0]+2,bomby[0]-bossshift+7,10,0);
           circlefill(VScreen,bombx[0]+2,bomby[0]+7,10,187);

           for(temp[0]=bombx[0]-7;temp[0]<bombx[0]+2+10;temp[0]++)
             for(temp[1]=bomby[0]-bossshift+6-10;temp[1]<bomby[0]-bossshift+8+10;temp[1]++)
               {
                if(getpixel(bossspr, temp[0], temp[1]) == 0)
                  pixeltemp[1]++;
                else
                  {
                 putpixel(bossspr, temp[0], temp[1],1);
                 putpixel(VScreen, temp[0], temp[1]+bossshift,7);
                }
               }

           pixelsleft+=pixeltemp[0]-pixeltemp[1];

           my_vsync();
           blit(backdrop,VScreen,bombx[0]-8,bomby[0]-10+7,bombx[0]-10+2,bomby[0]-10+7,21,21);

           blit(bossspr,tempbit,bombx[0]-8,bomby[0]-bossshift+7-10,0,0,21,21);
//	draw_sprite(VScreen,bossspr,0,bossshift);
           draw_sprite(VScreen,tempbit,bombx[0]-10+2,bomby[0]-10+7);

     sprintf(buf,"%d ",pixelsleft);
     textout(VScreen,font,buf,0,10,128);
          }
       }

     if(key[KEY_ENTER])
       {
        pixelsleft=0;
       	
          for(temp[0]=0;temp[0]<bossspr->w;temp[0]++)
     for(temp[1]=0;temp[1]<bossspr->h;temp[1]++)
       if(getpixel(bossspr, temp[0], temp[1]) > 0)
         pixelsleft++;

     sprintf(buf,"%d ",pixelsleft);
     textout(VScreen,font,buf,0,10,128);


       }



   }while(leavegame==FALSE);
}*/

void titleVScreen(void)
{
	PALETTE temppal[2];
   int time,startgame=FALSE;
   float fltemp;
   int KeyEsc = key[KEY_ESC];

   clear_buffer();

   for(temp[0]=0;temp[0]<255;temp[0]++)
     temppal[0][temp[0]].r=temppal[0][temp[0]].g=temppal[0][temp[0]].b=64;

//   if(sonics==TRUE)
     sb_mod_play(menu);


   do{
   	
//      if(sb_mod_active == NULL && sonics == TRUE)
//        sb_mod_play(menu);

     set_palette(pal[1]);
     my_blit(title, VScreen, 0, 0, 0, 0, 320, 200);
     time=0;

     do{
   	  my_vsync();

        if((key[KEY_ESC]^KeyEsc)&key[KEY_ESC])
          {
           quit=TRUE;
           startgame=TRUE;
          }
		  KeyEsc = key[KEY_ESC];

        if(keypressed() == TRUE)
          startgame=TRUE;

        time++;

     }while(startgame == FALSE && time < (3*490));

     if(startgame==FALSE)
       {
        temp[0]=0;

        do{
        	my_vsync();
        	my_putpixel(VScreen,160,temp[0],14);

         temp[0]++;
        	
        }while(keypressed() != TRUE && temp[0] < 74);

        temp[0]=0;
        do{
        	my_vsync();
         my_vline(VScreen,160-temp[0], 0, 74, 14);
         my_vline(VScreen,160+temp[0], 0, 74, 14);

         temp[0]++;
        	
         if(keypressed() == TRUE)
           temp[0]=16;

        }while(keypressed() != TRUE && temp[0] < 15);

        for(fltemp=0;fltemp<10;fltemp+=0.5)
          {
           fade_interpolate(pal[1], temppal[0], temppal[1], 64/10*fltemp, 0, 255);
           set_palette(temppal[1]);
		   my_vsync();

           if(keypressed())
				break;
//           if(keypressed() == TRUE)
//             fltemp=10;
          }

         draw_scoreboard();

         time=0;
         do{
          my_vsync();
          time++;
         }while (keypressed() != TRUE && time < (3*210));
       }
     }while(startgame==FALSE);

/*   if(sonics == TRUE)
     sb_mod_play(game);*/
   clear_buffer();
}

void drawscore(void)
{
   chartoscore(score);
   clear(scoredisplay);

   for(temp[1]=0;temp[1]<retlength;temp[1]++)
     draw_sprite(scoredisplay, numbers[retscore[temp[1]]], temp[1]*4, 0);

   temp[0]=160-retlength*2;

   my_blit(backdrop, VScreen, temp[0], 0, temp[0], 0, 25, 7);
   my_draw_sprite(VScreen, scoredisplay, temp[0], 0);
}

int main(void)
{
	FILE *scfile;
   allegro_init();
   atexit(&dumb_exit);
   dumb_register_stdfiles();
   sonics = install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) ? FALSE : TRUE;

   if(install_timer() != 0)
     {
     	printf("THERE WAS AN ERROR INITIATING YOUR INTERNAL TIMER\n");
      goto error;
     }

   if(install_keyboard() != 0)
     {
     	printf("THERE WAS AN ERROR INITIATING THE KEYBOARD\n");
      goto error;
     }

#ifdef ALLEGRO_MACOSX
   if(set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) != 0)
#else
   if(set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0) != 0)
#endif
     {
     	printf("THERE WAS AN ERROR INITIATING GRAPHICS MODE\n\n\tThis game requires a VGA or MCGA 256k graphics adaptor\n");
      goto error;
     }

	setup_my_vsync();

/*   if(sb_install_driver(11025) != SB_SUCCESS)
     sonics=FALSE;*/

//   sonics=FALSE;

//   i_love_bill=TRUE;

   setup_sprites();
   reset_vars();
//   bossbackdrop=load_pcx("bitmaps/bback1.pcx",pal[5]);
//   bossspr=load_pcx("bitmaps/bosss1.pcx",pal[5]);
   set_palette(pal[5]);
//   backdrop=bossbackdrop;
//   boss();

   quit=FALSE;

   backdrop=citybackdrop;
   if(quit==FALSE)
     do{
        if(quit==FALSE && won==FALSE)
          {
           reset_vars();
           titleVScreen();
          }

        if(quit==FALSE)
          {
//my_vsync_setmode(0);
           maingame();
//   my_vsync_setmode(1);
           clear_buffer();
           newlev_vars();
          }

     }while(quit==FALSE);

   for(temp[0]=0;temp[0]<4;temp[0]++)
     destroy_rle_sprite(ship[temp[0]]);

   for(temp[0]=0;temp[0]<10;temp[0]++)
     destroy_bitmap(numbers[temp[0]]);

   for(temp[0]=0;temp[0]<7;temp[0]++)
     destroy_compiled_sprite(building[temp[0]]);

   destroy_bitmap(title);
   destroy_bitmap(backdrop);
   destroy_compiled_sprite(bomb);
   destroy_bitmap(gameover);
   destroy_bitmap(landed);
   destroy_bitmap(scoredisplay);
   destroy_bitmap(gameover_text);

   if(sonics == TRUE)
     {
        destroy_sample(sounds0);
        destroy_sample(sounds1);
        destroy_sample(sounds2);
        destroy_sample(sounds3);
        destroy_sample(sounds4);
        destroy_sample(sounds5);
        destroy_sample(sounds6);

      unload_duh(menu);
      unload_duh(game);
     }

   error:;
   
   end_my_vsync();
   if(scfile = fopen("scores.dat", "wb"))
   {
/*     for(temp[0]=0;temp[0]<10;temp[0]++)
       for(temp[1]=0;temp[1]<13;temp[1]++)
	     fputc(scores[temp[0]][temp[1]], scfile);
	   fclose(scfile);*/
     for(temp[0]=0;temp[0]<10;temp[0]++)
	 {
       for(temp[1]=0;temp[1]<10;temp[1]++)
	     fputc(scores[temp[0]][temp[1]], scfile);
	
	     fputc(scores[temp[0]][10]&0xff, scfile);
	     fputc((scores[temp[0]][10] >> 8)&0xff, scfile);
	     fputc((scores[temp[0]][10] >> 16)&0xff, scfile);
	     fputc(scores[temp[0]][10] >> 24, scfile);
		}
	   fclose(scfile);
	}

   return 0;
}
END_OF_MAIN()

void reset_vars(void)
{
   shipx[0]=0;
   shipy[0]=50;
   bombx[0]=0;
   bomby[0]=0;
   curship=oldship=0;
	
   fallrate=5.0/320.0;
   minbuildingheight=1;
   moverate=1;
   score=0;

   newbomb=TRUE;
   explodebuilding=FALSE;
   won=FALSE;
}

