#include "masking.h"
#include "math.h"


using namespace MAS;

void newobj(const char *string);
void renameobj(const char *string);
void browse();
int getbgcolor();
bool drawlastframe();
int gettransparency();
void renameframe(const char *string);
bool crosshair();
void clearall();

void Save();
void Load();

int tool();

int selected();

void updatecolbox();

class table;
class MyDialog;

MyDialog *dlg;

bool paintmode = false;

bool mousedown=false,released=true;
bool rightmousedown=false; int startx=0,starty=0,offx=0,offy=0,toffx=0,toffy=0;
bool popupped=false;

unsigned char frame=0;

bool focussed();

void resetBexrange();
void setspinner();

int zoom=1;

int color;

bool setexrange=false;

int lpx=0,lpy=0;

struct ExportRange
{
int x1,y1,x2,y2;
int start, end;
}exrange = {0,0,0,0,0,0};


bool edgeset=false;
void pixel(BITMAP *foo,int x,int y,int foob);

class Pinkmap
{
bool *data;
int w,h;
public:


void Line(int x1,int y1,int x2,int y2)
 {
 do_line(NULL, x1, y1, x2, y2, 0, pixel);
 }
void draw(Bitmap* bmp,int xx,int yy,int col)
 {
 for(int x=0;x<w;x++)
 for(int y=0;y<h;y++)
 if(data[x+y*w])bmp->Putpixel(xx+x,yy+y,col);
 }
void size(int ww,int hh){h=hh;w=ww;if(data)delete[] data; data=new bool[w*h];memset(data,0,sizeof(bool)*w*h);}
void clear(){memset(data,0,sizeof(bool)*w*h);}
friend void pixel(BITMAP *foo,int x,int y,int foob);
};
Pinkmap pinkmap;

void pixel(BITMAP *foo,int x,int y,int foob)
{
pinkmap.data[x+y*pinkmap.w]=true;
}


Bitmap drawlayer;

class MyMessageBox : public MAS::MessageBox {
bool MsgClose()
{
Dialog::MsgClose();
popupped=false;
}
public:
MyMessageBox(char *string){
               button1.SetText("Yes");
	           button2.SetText("No");
	           line1.SetText(string);
               title.SetText("Delete object...");
               }
};


class Tile
{
public:
        Bitmap face;
        short x[256],y[256];
        unsigned char angle[256],stretch[256];
        char path[1024];
        bool loaded;
        bool visible[256];
       void draw()
            {
            
            }
       void loadBitmap()
            {
            face.Destroy();
            if(!face.Load(path))loaded=true;else loaded=false;
            
            }
       void saveBitmap()
            {
            if(loaded)face.Save(path);
            }
friend class MyDialog;
friend void newobj(const char *string);
friend void browse();
friend class table;
};


Tile *tile[256];
unsigned char tiles=0;



class Board
{
public:
short len;
short x[256],y[256];
unsigned char angle[256],stretch[256];
bool visible[256];
};
Board *board;



class AddWindow : public MAS::Window {
	protected:
        EditBox name;
        Label lname;
        Button ok;
	public:
		AddWindow() : MAS::Window() {
			title.SetText("New object...");
			lname.Setup(5,35,30,20,0,0,"Name:",0);
			name.Setup(45,30,150,25,0,D_EXIT,"",0);
			ok.Setup(45,70,100,20,0,D_EXIT,"OK");
			Add(name);
			Add(lname);
			Add(ok);
			ClearFlag(D_RESIZABLE);
		}

		void UpdateSize() {
			Window::UpdateSize();
			minSize = Size(210,125);
			name.Shape(45,30,w()-80,25,0);
		}
		
bool MsgClose()
{
Dialog::MsgClose();
popupped=false;
}
void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0) {
			Dialog::HandleEvent(obj, msg, arg1, arg2);
            
            
            if (msg == MSG_ACTIVATE) {
				if(obj == ok){newobj(name.GetText());}
				if(obj == name){newobj(name.GetText());}
			}
			
		}
friend class MyDialog;
};

class RenameWindow : public MAS::Window {
	protected:
        EditBox name;
        Label lname;
        Button ok;
	public:
		RenameWindow() : MAS::Window() {
			title.SetText("Rename object...");
			lname.Setup(5,35,30,20,0,0,"Name:",0);
			name.Setup(45,30,150,25,0,D_EXIT,"",0);
			ok.Setup(45,70,100,20,0,D_EXIT,"OK");
			Add(name);
			Add(lname);
			Add(ok);
			ClearFlag(D_RESIZABLE);
		}

		void UpdateSize() {
			Window::UpdateSize();
			minSize = Size(210,125);
			name.Shape(45,30,w()-80,25,0);
		}
void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0) {
			Dialog::HandleEvent(obj, msg, arg1, arg2);
            
            
			
            if (msg == MSG_ACTIVATE) {
				if(obj == ok){renameobj(name.GetText());}
                if(obj == name){renameobj(name.GetText());}          
			}
			
		}
		
bool MsgClose()
{
Dialog::MsgClose();
popupped=false;
}
friend class MyDialog;
};

class ExportWindow : public MAS::Window {
	protected:
        EditBox name;
        Label lname;
        Button ok;
	public:
		ExportWindow() : MAS::Window() {
			title.SetText("Export...");
			lname.Setup(5,35,30,20,0,0,"Name:",0);
			name.Setup(45,30,150,25,0,D_EXIT,"",0);
			ok.Setup(45,70,100,20,0,D_EXIT,"OK");
			Add(name);
			Add(lname);
			Add(ok);
			ClearFlag(D_RESIZABLE);
		}

		void UpdateSize() {
			Window::UpdateSize();
			minSize = Size(210,125);
			name.Shape(45,30,w()-80,25,0);
		}
void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0) {
			Dialog::HandleEvent(obj, msg, arg1, arg2);
            
            
			
            if (msg == MSG_ACTIVATE) {
				if(obj == ok){renameobj(name.GetText());}
                if(obj == name){renameobj(name.GetText());}          
			}
			
		}
		
bool MsgClose()
{
Dialog::MsgClose();
popupped=false;
}
friend class MyDialog;
};

class RenameFrameWindow : public MAS::Window {
	protected:
        EditBox name;
        Label lname;
        Button ok;
	public:
		RenameFrameWindow() : MAS::Window() {
			title.SetText("Rename frame...");
			lname.Setup(5,35,30,20,0,0,"Name:",0);
			name.Setup(45,30,150,25,0,D_EXIT,"",0);
			ok.Setup(45,70,100,20,0,D_EXIT,"OK");
			Add(name);
			Add(lname);
			Add(ok);
			ClearFlag(D_RESIZABLE);
		}

		void UpdateSize() {
			Window::UpdateSize();
			minSize = Size(210,125);
			name.Shape(45,30,w()-80,25,0);
		}
void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0) {
			Dialog::HandleEvent(obj, msg, arg1, arg2);
            
            
			
            if (msg == MSG_ACTIVATE) {
				if(obj == ok){renameframe(name.GetText());}
                if(obj == name){renameframe(name.GetText());}          
			}
			
		}
		
bool MsgClose()
{
Dialog::MsgClose();
popupped=false;
}
friend class MyDialog;
};


class colorbox : public Widget
{
void Draw(Bitmap &canvas){
     canvas.Clear(color);
     }
};



class table: public Widget {
      public:
      
      bool bo;
      
      void Draw(Bitmap &canvas) {
			if(rightmousedown){toffx=parent->GetMousePos().x()-startx;toffy=parent->GetMousePos().y()-starty;}
		if(!paintmode)
		{
			Bitmap pre(400,300);
			pre.Clear(getbgcolor());
			if(crosshair()){pre.Vline(200+(offx+toffx)/zoom,0,300,makecol(255,255,255));
                              pre.Hline(0,150+(offy+toffy)/zoom,400,makecol(255,255,255));}
			if(drawlastframe() && frame>0)
			{
            Bitmap opre(400,300);
            opre.Clear(makecol(255,0,255));
            for(int i=0;i<tiles;i++)
             if(tile[i]->loaded && tile[i]->visible[frame-1])
              {
              int tmp = (int)sqrtl(tile[i]->face.w()*tile[i]->face.w()+tile[i]->face.h()*tile[i]->face.h());
              Bitmap tmpbmp(tmp,tmp);
              tmpbmp.Clear(makecol(255,0,255));
              tmpbmp.RotateSprite(tile[i]->face, tmp/2-tile[i]->face.w()/2, tmp/2-tile[i]->face.h()/2, itofix(tile[i]->angle[frame-1]));
              Bitmap tmpbmp2(int(tmpbmp.w()*((float)tile[i]->stretch[frame-1]/100)),int(tmpbmp.h()*((float)tile[i]->stretch[frame-1]/100)));
              tmpbmp2.Clear(makecol(255,0,255));
              tmpbmp2.StretchSprite(tmpbmp,0,0,int(tmpbmp.w()*((float)tile[i]->stretch[frame-1]/100)),int(tmpbmp.h()*((float)tile[i]->stretch[frame-1]/100)));
              
              opre.DrawSprite(tmpbmp2,int(tile[i]->x[frame-1]-.5*tmpbmp.w()*((float)tile[i]->stretch[frame-1]/100))+200+(offx+toffx)/zoom, int(tile[i]->y[frame-1]-.5*tmpbmp.w()*((float)tile[i]->stretch[frame-1]/100))+150+(offy+toffy)/zoom);
              tmpbmp2.Destroy();
              tmpbmp.Destroy();
              }
              set_trans_blender(0,0,0, gettransparency());
              pre.DrawTransSprite(opre,0,0);
            opre.Destroy();
            }
            
            
            for(int i=0;i<tiles;i++)
             if(tile[i]->loaded && tile[i]->visible[frame])
              {
              int tmp = (int)sqrtl(tile[i]->face.w()*tile[i]->face.w()+tile[i]->face.h()*tile[i]->face.h());
              Bitmap tmpbmp(tmp,tmp);
              tmpbmp.Clear(makecol(255,0,255));
              tmpbmp.RotateSprite(tile[i]->face, tmp/2-tile[i]->face.w()/2, tmp/2-tile[i]->face.h()/2, itofix(tile[i]->angle[frame]));
              pre.StretchSprite(tmpbmp,int(tile[i]->x[frame]-.5*tmpbmp.w()*((float)tile[i]->stretch[frame]/100))+200+(offx+toffx)/zoom,int(tile[i]->y[frame]-.5*tmpbmp.w()*((float)tile[i]->stretch[frame]/100))+150+(offy+toffy)/zoom,int(tmpbmp.w()*((float)tile[i]->stretch[frame]/100)),int(tmpbmp.h()*((float)tile[i]->stretch[frame]/100)));
              
              tmpbmp.Destroy();
              }
              
              int sel = selected();
              if(sel>=0)if(tile[sel]->loaded)
               {
               int x = int(tile[sel]->x[frame]-.5*tile[sel]->face.w()*((float)tile[sel]->stretch[frame]/100))+200;
               int y = int(tile[sel]->y[frame]-.5*tile[sel]->face.h()*((float)tile[sel]->stretch[frame]/100))+150;
               int x2 = int(tile[sel]->x[frame]+.5*tile[sel]->face.w()*((float)tile[sel]->stretch[frame]/100))+200;
               int y2 = int(tile[sel]->y[frame]+.5*tile[sel]->face.h()*((float)tile[sel]->stretch[frame]/100))+150;
               //pre.Rectangle(x-1+(offx+toffx)/zoom,y-1+(offy+toffy)/zoom,x2+(offx+toffx)/zoom,y2+(offy+toffy)/zoom,makecol(0,255,0));
               }
              
              pre.Rectangle(exrange.x1+(offx+toffx)/zoom+200,exrange.y1+(offy+toffy)/zoom+150,exrange.x2+(offx+toffx)/zoom+200,exrange.y2+(offy+toffy)/zoom+150,makecol(255,255,255));
            
            pre.StretchBlit(canvas,200-200/zoom,150-150/zoom,400/zoom,300/zoom,0,0,400,300);  
            
            pre.Destroy();
            }
            else
            {
            Bitmap pre(400,300);
            pre.Clear(getbgcolor());
            if(crosshair()){pre.Vline(200+(offx+toffx)/zoom,0,300,makecol(255,255,255));
                              pre.Hline(0,150+(offy+toffy)/zoom,400,makecol(255,255,255));}
            if(tiles>0)
            if(tile[selected()]->loaded)
             {
             int sel = selected();
             int x=0;
             int y=0;
             int x2=0;
             int y2=0;
             
             if(!(tile[sel]->face.w() % 2))
             {
             x = int(-.5*tile[sel]->face.w()+200-1);
             x2 = int(.5*tile[sel]->face.w()+200);
             }
             else 
             {
             x = int(-.5*tile[sel]->face.w()+200);
             x2 = int(.5*tile[sel]->face.w()+200+1);
             }
             
             if(!(tile[sel]->face.h() % 2))
             {
             y = int(-.5*tile[sel]->face.h()+150-1);
             y2 = int(.5*tile[sel]->face.h()+150);
             }
             else 
             {
             y = int(-.5*tile[sel]->face.h()+150);
             y2 = int(.5*tile[sel]->face.h()+150+1);
             }
             
             pre.Rectangle(x+(offx+toffx)/zoom,y+(offy+toffy)/zoom,x2+(offx+toffx)/zoom,y2+(offy+toffy)/zoom,makecol(0,255,0));
             
             pre.DrawSprite(tile[selected()]->face,200-tile[selected()]->face.w()/2+(offx+toffx)/zoom,150-tile[selected()]->face.h()/2+(offy+toffy)/zoom);
             
             
              if(!drawlayer){drawlayer.Destroy();drawlayer.Create(tile[selected()]->face.w(),tile[selected()]->face.h());drawlayer.Clear(makecol(255,0,255));pinkmap.size(tile[selected()]->face.w(),tile[selected()]->face.h());}
              if(drawlayer.w()!=tile[selected()]->face.w() || drawlayer.h()!=tile[selected()]->face.h()){drawlayer.Destroy();drawlayer.Create(tile[selected()]->face.w(),tile[selected()]->face.h());drawlayer.Clear(makecol(255,0,255));pinkmap.size(tile[selected()]->face.w(),tile[selected()]->face.h());}
              pre.DrawSprite(drawlayer,200-tile[selected()]->face.w()/2+(offx+toffx)/zoom,150-tile[selected()]->face.h()/2+(offy+toffy)/zoom);
              pinkmap.draw(&pre,200-tile[selected()]->face.w()/2+(offx+toffx)/zoom,150-tile[selected()]->face.h()/2+(offy+toffy)/zoom,getbgcolor());
             }
             
             
             
             pre.StretchBlit(canvas,200-200/zoom,150-150/zoom,400/zoom,300/zoom,0,0,400,300);
             pre.Destroy();
            }
            
            }
void MsgGotmouse()
{
Widget::MsgGotmouse();
SetCursor(Skin::MOUSE_CROSSHAIR);
}    

void MsgLostmouse()
{
Widget::MsgLostmouse();
SetCursor(Skin::MOUSE_NORMAL);
}


void MsgTick() {
     if(setexrange)
     {
     if(!edgeset && parent->GetMouse()->flags & 1){edgeset=true;exrange.x1=(parent->GetMousePos().x()-x()-200)/zoom-(offx+toffx)/zoom;exrange.y1=(parent->GetMousePos().y()-y()-150)/zoom-(offy+toffy)/zoom;}
     
     if(edgeset && parent->GetMouse()->flags & 1){exrange.x2=(parent->GetMousePos().x()-x()-200)/zoom-(offx+toffx)/zoom;exrange.y2=(parent->GetMousePos().y()-y()-150)/zoom-(offy+toffy)/zoom;Redraw();}
     
     if(edgeset && !(parent->GetMouse()->flags &1)){edgeset=false;setexrange=false;resetBexrange();setspinner();}
     
     }else
     {
     
     
     
     if(parent->GetMouse()->flags & 2)
      {
      if(!rightmousedown){rightmousedown=true;startx=parent->GetMousePos().x(); starty = parent->GetMousePos().y();}
      Redraw();
      
      }
     if(!(parent->GetMouse()->flags & 2) && rightmousedown){rightmousedown=false;offx=offx+toffx;offy=offy+toffy;toffx=0;toffy=0;Redraw();}
     
     
     
     
     if(!mousedown && parent->GetMouse()->flags & 1)
      if(parent->GetMousePos().x() > x() && parent->GetMousePos().x() < x()+w() && parent->GetMousePos().y() > y() && parent->GetMousePos().y() < y()+h())bo=true;
      else bo=false;
     mousedown=parent->GetMouse()->flags & 1;
     if(!released && !mousedown)released=true;
     if(popupped)released=false;
     
     if(!paintmode)
     {
     
     if(bo && released && !popupped)
     if(parent->GetMouse()->flags & 1 && parent->GetMousePos().x() > x() && parent->GetMousePos().x() < x()+w()
                                      && parent->GetMousePos().y() > y() && parent->GetMousePos().y() < y()+h())
                     {
                     if(tiles>0)
                     {
                     tile[selected()]->x[frame]=(parent->GetMousePos().x()-x()-200)/zoom-(offx+toffx)/zoom;
                     tile[selected()]->y[frame]=(parent->GetMousePos().y()-y()-150)/zoom-(offy+toffy)/zoom;
                     Redraw();
                     }
                     } 
     }else
     {
     if(!popupped)
     {
     
     if(drawlayer)if(parent->GetMouse()->flags & 4)
        {
        color=getpixel(drawlayer,(int)(parent->GetMousePos().x()-x()-200-offx)/zoom+tile[selected()]->face.w()/2,(parent->GetMousePos().y()-y()-150-offy)/zoom+tile[selected()]->face.h()/2);
        if(getr(color)==255 && getg(color)==0 && getb(color)==255)color=getpixel(tile[selected()]->face,(int)(parent->GetMousePos().x()-x()-200-offx)/zoom+tile[selected()]->face.w()/2,(parent->GetMousePos().y()-y()-150-offy)/zoom+tile[selected()]->face.h()/2);
        updatecolbox();
        }
     
     if(tool()==0)
     {
     
     if(parent->GetMouse()->flags & 1 && parent->GetMousePos().x() > x() && parent->GetMousePos().x() < x()+w()
                                      && parent->GetMousePos().y() > y() && parent->GetMousePos().y() < y()+h())
                     {
                     
                     if(tiles>0)if(tile[selected()]->loaded)
                     {
                     if(drawlayer.w()!=tile[selected()]->face.w() || drawlayer.h()!=tile[selected()]->face.h()){drawlayer.Destroy();drawlayer.Create(tile[selected()]->face.w(),tile[selected()]->face.h());drawlayer.Clear(makecol(255,0,255));pinkmap.size(tile[selected()]->face.w(),tile[selected()]->face.h());}
                     if(lpx>-1)
                      {
                      if(getr(color)==255 && getg(color)==0 && getb(color)==255) pinkmap.Line(lpx,lpy,(int)(parent->GetMousePos().x()-x()-200-offx-.5)/zoom+tile[selected()]->face.w()/2,(parent->GetMousePos().y()-y()-150-offy)/zoom+tile[selected()]->face.h()/2);
                      else drawlayer.Line(lpx,lpy,(int)(parent->GetMousePos().x()-x()-200-offx)/zoom+tile[selected()]->face.w()/2,(parent->GetMousePos().y()-y()-150-offy)/zoom+tile[selected()]->face.h()/2, color);
                      }
                     
                     Redraw();
                     lpx=(int)(parent->GetMousePos().x()-x()-200-offx)/zoom+tile[selected()]->face.w()/2;
                     lpy=(int)(parent->GetMousePos().y()-y()-150-offy)/zoom+tile[selected()]->face.h()/2;
                     }
                     }
     if(!(parent->GetMouse()->flags & 1))lpx=-100;
     }
     else if(tool()==4)
     {
     
     if(parent->GetMouse()->flags & 1 && parent->GetMousePos().x() > x() && parent->GetMousePos().x() < x()+w()
                                      && parent->GetMousePos().y() > y() && parent->GetMousePos().y() < y()+h())
                     {
                     
                     if(tiles>0)if(tile[selected()]->loaded)
                     {
                     if(drawlayer.w()!=tile[selected()]->face.w() || drawlayer.h()!=tile[selected()]->face.h()){drawlayer.Destroy();drawlayer.Create(tile[selected()]->face.w(),tile[selected()]->face.h());drawlayer.Clear(makecol(255,0,255));pinkmap.size(tile[selected()]->face.w(),tile[selected()]->face.h());}
                     drawlayer.Floodfill((int)(parent->GetMousePos().x()-x()-200-offx)/zoom+tile[selected()]->face.w()/2,(int)(parent->GetMousePos().y()-y()-150-offy)/zoom+tile[selected()]->face.h()/2,color);
                     Redraw();
                     }
                     }
     
     }
     }
     }
     
     }		
     }
};



class MyDialog : public Dialog {
	public:
        Button spahs;   
		ClearScreen desktop;
		GroupBox gbobj;
		table thetable;
		Button Bkillobj;
		Button Brenameobj;
        Button Bnewobj;
        AddWindow Wnewobj;
        RenameWindow Wrenameobj;
        Button up;
        Button down;
        Scroller angleslider;
        Scroller stretchslider;
        Label lbl[18];
        Button Bloadpic;
        Button Bsavepic;
        Button Bbrowsepic;
        Panel Pangstr;
        EditBox Epath;
        Dialog shit;
        Slider slid_r,slid_g,slid_b;
        GroupBox gbbg;
        Panel gblt;
        ListBox frames;
        CheckBox Cshowlastframe;
        Slider slf;
	    CheckBox Cvisible;
	    Button Brenameframe;
	    Button Bcopyframe;
	    Button Bpasteframe;
	    Button Bstartpos;
	    Button Bendpos;
	    Button Bcolsel;
	    Menu MainMenu,Zoom,FileMenu,ViewMenu;
	    CheckBox Crosshair;
	    Button Bsetexrange;
	    Panel Pexrange;
	    ListBoxEx objs;
        SpinBox erx1,ery1,erx2,ery2;
        RadioButton Rpen,Rline,Rellipse,Rrectangle,Rfill,Rselect;
        Button Bmergelayer;
        Button Bclearlayer;
        Button Bcolor;
        colorbox colbox;
        
		MyDialog();






void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0) {
			Dialog::HandleEvent(obj, msg, arg1, arg2);
            
            
            
            if (msg == MSG_ACTIVATE) {
				if(obj == Bnewobj)
                     {
                     popupped=true;
                     Wnewobj.name.SetText("");
                     Wnewobj.Popup(this);
                     
                     if(objs.GetItemCount()>0){
                              Cvisible.Enable();
                              Brenameobj.Enable();
                              Bbrowsepic.Enable();
                              Bloadpic.Enable();
                              Bsavepic.Enable();
                              angleslider.Enable();
                              stretchslider.Enable();
                              Epath.Enable();
                              Bclearlayer.Enable();
                              Bmergelayer.Enable();
    
                              }
                     if(objs.GetItemCount()>1)Bkillobj.Enable();
                     }
			    
			    else if(obj == up)
                     {
                     if(objs.GetItemCount()>1)
                      {
                      if(!selected()==0)
                      {
                          
                          char name[256];
                          sprintf(name,"%s",objs.GetItem(selected())->GetText());
                          objs.DeleteItem(selected());
                          objs.InsertItem(name,selected()-1);
                          
                          
                          Tile *tmptile;
                          tmptile = tile[selected()];
                          tile[selected()] = tile[selected()-1];
                          tile[selected()-1] = tmptile;
                          
                          objs.Select(selected()-1);
                          }
                      }
                     thetable.Redraw();
                     }
                else if(obj == down)
                     {
                     if(selected()!=objs.GetItemCount()-1)
                     if(objs.GetItemCount()>1)
                      {

                      char name[256];
                      sprintf(name,"%s",objs.GetItem(selected())->GetText());
                      objs.DeleteItem(selected());
                      objs.InsertItem(name,selected()+1);
                      
                      
                      Tile *tmptile;
                      tmptile = tile[selected()];
                      tile[selected()] = tile[selected()+1];
                      tile[selected()+1] = tmptile;
                      objs.Select(selected()+1);
                      }
                      thetable.Redraw();
                     } 
                else if(obj == Bkillobj)
                     {
                     if(objs.GetItemCount()>0)
                      {
                      
                      int sel=selected();
                      char tmpstr[256];
                      sprintf(tmpstr,"Delete %s ?",objs.GetItem(sel)->GetText());
                      popupped=true;
                      MyMessageBox msg(tmpstr);
			          
                      if(msg.Popup(this)!=1)return;
                      
                      
                      delete tile[sel];
                      if(sel!=objs.GetItemCount()-1)objs.DeleteItem(sel);
                       else {
                            char tmpstr[256];
                            sprintf(tmpstr,"%s",objs.GetItem(sel-1)->GetText());
                            objs.DeleteItem(sel-1);
                            objs.GetItem(sel-1)->SetText(tmpstr);
                            }
                                                                              
                      tiles--;
                      for(int i=sel;i<tiles;i++)tile[i]=tile[i+1];
                      
                      
                      
                      if(objs.GetItemCount()==0){
                              Cvisible.Disable();
                              Brenameobj.Disable();
                              Bbrowsepic.Disable();
                              Bloadpic.Disable();
                              Bsavepic.Disable();
                              angleslider.Disable();
                              stretchslider.Disable();
                              Epath.Disable();
                              Bclearlayer.Disable();
                              Bmergelayer.Disable();
    
                              }
                      if(objs.GetItemCount()>1){Bkillobj.Enable();}else Bkillobj.Disable();
                     if(objs.GetItemCount()>0)
                     {
                      if(tile[selected()]->visible[frame])Cvisible.Select();
                      else Cvisible.Deselect();
                     angleslider.SetPosition(tile[selected()]->angle[frame]);
                     stretchslider.SetPosition(tile[selected()]->stretch[frame]-1);
                     char tempstr[4];
                     sprintf(tempstr,"%i",tile[selected()]->angle[frame]);
                     lbl[2].SetText(tempstr);
                     
                     sprintf(tempstr,"%i%c",tile[selected()]->stretch[frame],'%');
                     lbl[3].SetText(tempstr);
                     
                     Epath.SetText(tile[selected()]->path);
                     
                     gbobj.Redraw();
                     }
                      }
                      thetable.Redraw();
                     } 
                else if(obj == Brenameobj)
                     {
                     if(objs.GetItemCount()>0)
                      {
                      popupped=true;
                      Wrenameobj.name.SetText(objs.GetItem(selected())->GetText());
                      Wrenameobj.Popup(this);
                      }
                     } 
                else if(obj == Bbrowsepic)
                     {
                     browse();
                     } 
                else if(obj == Bloadpic)
                     {

                     tile[selected()]->loadBitmap();
                     thetable.Redraw();
                     } 
                else if(obj == Bsavepic)
                     {
                     tile[selected()]->saveBitmap();
                     }
                else if(obj == Cshowlastframe)
                     {

                     thetable.Redraw();
                     } 
                else if(obj == Cvisible)
                     {
                     tile[selected()]->visible[frame]=Cvisible.Selected();
                     thetable.Redraw();
                     }           
                else if(obj == Bcopyframe)
                     {
                     board->len=0;
                     for(int i=0;i<tiles;i++)
                      {
                      board->visible[i]=tile[i]->visible[frame];
                      board->angle[i]=tile[i]->angle[frame];
                      board->stretch[i]=tile[i]->stretch[frame];
                      board->x[i]=tile[i]->x[frame];
                      board->y[i]=tile[i]->y[frame];
                      board->len++;
                      }
                     if(board->len>0)Bpasteframe.Enable();
                     } 
                 else if(obj == Bpasteframe)
                     {
                     for(int i=0;i<board->len;i++)
                      {
                      tile[i]->visible[frame]=board->visible[i];
                      tile[i]->angle[frame]=board->angle[i];
                      tile[i]->stretch[frame]=board->stretch[i];
                      tile[i]->x[frame]=board->x[i];
                      tile[i]->y[frame]=board->y[i];
                      }
                      if(tile[selected()]->visible[frame])Cvisible.Select();
                      else Cvisible.Deselect();
                     angleslider.SetPosition(tile[selected()]->angle[frame]);
                     stretchslider.SetPosition(tile[selected()]->stretch[frame]-1);
                     char tempstr[4];
                     sprintf(tempstr,"%i",tile[selected()]->angle[frame]);
                     lbl[2].SetText(tempstr);
                     
                     sprintf(tempstr,"%i%c",tile[selected()]->stretch[frame],'%');
                     lbl[3].SetText(tempstr);
                     
                     Epath.SetText(tile[selected()]->path);
                     
                     gbobj.Redraw();
                     thetable.Redraw();
                     } 
                 else if(obj==Brenameframe)
                      {
                      popupped=true;
                      RenameFrameWindow RFW;
                      RFW.Place(SCREEN_W/2-100, SCREEN_H/2-100);
	                  RFW.GetClientArea()->Resize(200, 100);
                      RFW.Popup(this);
                      }
                 else if(obj==Crosshair)thetable.Redraw();
                 else if(obj==Bsetexrange){Bsetexrange.SetText("draw the range");setexrange=true;}
                 else if(obj==Bstartpos){
                       exrange.start=frames.Selection();
                       char tmpstr[50];
                       sprintf(tmpstr, "Export from %i to %i",exrange.start,exrange.end);
                       lbl[16].SetText(tmpstr);
                       Pexrange.Redraw();
                       }
                 else if(obj==Bendpos){
                       exrange.end=frames.Selection();
                       char tmpstr[50];
                       sprintf(tmpstr, "Export from %i to %i",exrange.start,exrange.end);
                       lbl[16].SetText(tmpstr);
                       Pexrange.Redraw();
                       }
                 else if(obj==Bmergelayer){if(tiles>0)if(tile[selected()]->loaded){tile[selected()]->face.DrawSprite(drawlayer,0,0);pinkmap.draw(&tile[selected()]->face,0,0,makecol(255,0,255));drawlayer.Clear(makecol(255,0,255));pinkmap.clear();}}
                 else if(obj==Bclearlayer){if(tiles>0)if(drawlayer){drawlayer.Clear(makecol(255,0,255));pinkmap.clear();}thetable.Redraw();}
                 else if(obj==Bcolor){
                      Color col;
                      col.r(getr(color));
                      col.g(getg(color));
                      col.b(getb(color));
                      ColorSelect cs("Select color",col);
                      popupped=true;
                      col=cs.Popup(this);
                      if(col)color=makecol(col.r(),col.g(),col.b());
                      popupped=false;
                      }
                  }
             else if(msg==245)
                  {
                  if(exrange.start>exrange.end){
                                                popupped=true;
                                                MessageBox MB("Export","Start position is higher than end position!");
                                                MB.Popup(this);
                                                popupped=false;
                                                
                                                }
                  else
                  {
                  popupped=true;
                  FileSelect EW("Export File",NULL,"Bitmaps (*.bmp)|All files (*.*)",FA_ARCH);
                  char *path = EW.Popup(this);
                  popupped=false;
                   if(path)
                   {
                   int x1;
                   int y1;
                   if(exrange.x1 > exrange.x2)x1=exrange.x2;
                    else x1=exrange.x1;
                   
                   if(exrange.y1 > exrange.y2)y1=exrange.y2;
                    else y1=exrange.y1;
                   
                   Bitmap pre(abs(exrange.x1-exrange.x2),abs(exrange.y1-exrange.y2));
                   Bitmap rte(abs(exrange.x1-exrange.x2)*(exrange.end-exrange.start+1),abs(exrange.y1-exrange.y2));
                   rte.Clear(getbgcolor());
                   pre.Clear(getbgcolor());
                   for(int ff=exrange.start;ff<exrange.end+1;ff++)
                   {
                   for(int i=0;i<tiles;i++)
                    if(tile[i]->loaded && tile[i]->visible[ff])
                      {
                      int tmp = (int)sqrtl(tile[i]->face.w()*tile[i]->face.w()+tile[i]->face.h()*tile[i]->face.h());
                      Bitmap tmpbmp(tmp,tmp);
                      tmpbmp.Clear(makecol(255,0,255));
                      tmpbmp.RotateSprite(tile[i]->face, tmp/2-tile[i]->face.w()/2, tmp/2-tile[i]->face.h()/2, itofix(tile[i]->angle[ff]));
                      pre.StretchSprite(tmpbmp,int(tile[i]->x[ff]-.5*tmpbmp.w()*((float)tile[i]->stretch[ff]/100))+200-(200+x1),int(tile[i]->y[ff]-.5*tmpbmp.w()*((float)tile[i]->stretch[ff]/100))+150-(150+y1),int(tmpbmp.w()*((float)tile[i]->stretch[ff]/100)),int(tmpbmp.h()*((float)tile[i]->stretch[ff]/100)));
                      
                      tmpbmp.Destroy();
                      }
                    pre.Blit(rte,0,0,pre.w()*(ff-exrange.start),0,pre.w(),pre.h());
                    pre.Clear(getbgcolor());
                    }
                    pre.Destroy();
                    save_bmp(path, rte, NULL);
                   }
                   }
                  }
             else if(msg==246){
                  ViewMenu.Uncheck(0);ViewMenu.Check(1);
                  paintmode=false;
                  offx=0;
                  offy=0;
                  Bcolor.Hide();
                  angleslider.Unhide();
                  stretchslider.Unhide();
                  Cvisible.Unhide();
                  lbl[0].Unhide();
                  lbl[1].Unhide();
                  lbl[2].Unhide();
                  lbl[3].Unhide();
                  lbl[8].Unhide();
                  lbl[9].Unhide();
                  Rpen.Hide();
                  Rellipse.Hide();
                  Rrectangle.Hide();
                  Rline.Hide();
                  Rfill.Hide();
                  Rselect.Hide();
                  Bsetexrange.Enable();
                  Bmergelayer.Hide();
                  Bclearlayer.Hide();
                  lbl[17].Hide();
                  colbox.Hide();
                  }
             else if(msg==247){
                  ViewMenu.Uncheck(1);ViewMenu.Check(0);
                  paintmode=true;
                  offx=0;
                  offy=0;
                  Bcolor.Unhide();
                  angleslider.Hide();
                  stretchslider.Hide();
                  Cvisible.Hide();
                  lbl[0].Hide();
                  lbl[1].Hide();
                  lbl[2].Hide();
                  lbl[3].Hide();
                  lbl[8].Hide();
                  lbl[9].Hide();
                  Rpen.Unhide();
                  Rellipse.Unhide();
                  Rrectangle.Unhide();
                  Rline.Unhide();
                  Rfill.Unhide();
                  Rselect.Unhide();
                  Bsetexrange.Disable();
                  Bmergelayer.Unhide();
                  Bclearlayer.Unhide();
                  lbl[17].Unhide();
                  colbox.Unhide();
                  }
             else if(msg==248){clearall();}
             else if(msg==249){dlg->Close();}
             else if(msg==250){Load();}   
             else if(msg==251){Save();}
             else if(msg==252){zoom=1;Zoom.Check(0); Zoom.Uncheck(1);Zoom.Uncheck(2);Zoom.Uncheck(3);}
             else if(msg==253){zoom=2;Zoom.Check(1); Zoom.Uncheck(0);Zoom.Uncheck(2);Zoom.Uncheck(3);}
             else if(msg==254){zoom=4;Zoom.Check(2); Zoom.Uncheck(0);Zoom.Uncheck(1);Zoom.Uncheck(3);}
             else if(msg==255){zoom=8;Zoom.Check(3); Zoom.Uncheck(0);Zoom.Uncheck(1);Zoom.Uncheck(2);}
			else if (msg == MSG_SCROLL) {
				if(obj == slid_r || obj == slid_g || obj == slid_b)
                     {
                     thetable.Redraw();
                     } 
                else if(obj==erx1){exrange.x1=(int)erx1.GetPosition();thetable.Redraw();}
                else if(obj==ery1){exrange.y1=(int)ery1.GetPosition();thetable.Redraw();}
                else if(obj==erx2){exrange.x2=(int)erx2.GetPosition();thetable.Redraw();}
                else if(obj==ery2){exrange.y2=(int)ery2.GetPosition();thetable.Redraw();}
                 
                if(obj == frames && tiles>0)
                     {
                     frame=arg1;
                     
                     
                     
                     if(tile[selected()]->visible[frame])Cvisible.Select();
                      else Cvisible.Deselect();
                     
                     angleslider.SetPosition(tile[selected()]->angle[frame]);
                     stretchslider.SetPosition(tile[selected()]->stretch[frame]-1);
                     char tempstr[256];
                     sprintf(tempstr,"%i",tile[selected()]->angle[frame]);
                     lbl[2].SetText(tempstr);
                     
                     sprintf(tempstr,"%i%c",tile[selected()]->stretch[frame],'%');
                     lbl[3].SetText(tempstr);
                     
                     Epath.SetText(tile[selected()]->path);
                     
                     
                     sprintf(tempstr,"Frame: %i",frame);
                     lbl[8].SetText(tempstr);
                     
                     sprintf(tempstr,"Object: %s",objs.GetItem(selected())->GetText());
                     lbl[9].SetText(tempstr);
                     
                     gbobj.Redraw();
                     thetable.Redraw();
                     }      
                if(obj == angleslider)
                     {

                     char tempstr[3];
                     sprintf(tempstr,"%i",arg1);
                     lbl[2].SetText(tempstr);
                     gbobj.Redraw();
                     tile[selected()]->angle[frame]=arg1;
                     thetable.Redraw();
                     } 
                if(obj == stretchslider)
                     {

                     char tempstr[3];
                     sprintf(tempstr,"%i%c",arg1+1,'%');
                     lbl[3].SetText(tempstr);
                     gbobj.Redraw();
                     tile[selected()]->stretch[frame]=arg1+1;
                     thetable.Redraw();
                     } 
                
                if(obj == slf)
                     {

                     thetable.Redraw();
                     } 
                if(obj == objs)
                     {
                     
                     if(objs.GetItemCount()>0)
                     {
                     
                     
                     if(tile[selected()]->visible[frame])Cvisible.Select();
                      else Cvisible.Deselect();
                     angleslider.SetPosition(tile[selected()]->angle[frame]);
                     stretchslider.SetPosition(tile[selected()]->stretch[frame]-1);
                     char tempstr[256];
                     sprintf(tempstr,"%i",tile[selected()]->angle[frame]);
                     lbl[2].SetText(tempstr);
                     
                     sprintf(tempstr,"%i%c",tile[selected()]->stretch[frame],'%');
                     lbl[3].SetText(tempstr);
                     
                     sprintf(tempstr,"Object: %s",objs.GetItem(selected())->GetText());
                     lbl[9].SetText(tempstr);
                     
                     Epath.SetText(tile[selected()]->path);
                     
                     gbobj.Redraw();
                     thetable.Redraw();
                     }
                     } 
                
              }else if (msg == MSG_LOSTFOCUS) {
                 if(obj == Epath)
                     {
                     
                     strcpy(tile[selected()]->path,Epath.GetText());
                     } 
              
            } else if (  msg == MSG_GOTMOUSE)
                   if(obj == desktop)
                   {
                   MainMenu.Deselect();
                   }
		}

};

MyDialog::MyDialog() : Dialog() {
	
    gbobj.Shape(130,355, 400, 115);
    gbobj.SetTitle("Object values");
    
    Bnewobj.Setup(5, 390, 90, 25, 0, 0, "NEW OBJECT");
    objs.Shape(0, 50, 100, 330);
	
    thetable.Shape(130, 50, 400, 300);
    
    colbox.Shape(330,415,30,30);
    colbox.Hide();
    
    Bsavepic.Setup(442,445,80,20,0,0,"EXPORT PIC");
    Bloadpic.Setup(442,425,80,20,0,0,"IMPORT PIC");
    Bbrowsepic.Setup(442,405,80,20,0,0,"BROWSE");
    
    angleslider.Setup(195, 433, 200, 10, 0, 0, 256, 1,  0, 1);
    stretchslider.Setup(195, 451, 200, 10, 0, 0, 200, 1,  100, 1);
    Cvisible.Shape(375,412,55,15);
    Cvisible.SetText("Visible");
    
    gbbg.Shape(535,355, 100, 115);
    gbbg.SetTitle("BG color");
    
    slid_r.Setup(555,373,10,90,0,0,0,255,0,0);
    slid_g.Setup(580,373,10,90,0,0,0,255,0,0);
    slid_b.Setup(605,373,10,90,0,0,0,255,0,0);
    
    spahs.Shape(0,0,640,480);
    
    frames.Shape(535, 50, 100, 115);
    
    Bstartpos.Setup(535,205-40+3,100,19,0,0,"SET START");
    Bendpos.Setup(535,205-20+3,100,19,0,0,"SET FINISH");
    Brenameframe.Setup(535,205+3,100,19,0,0,"RENAME FRAME");
    Bcopyframe.Setup(535,225+2,100,19,0,0,"COPY FRAME");
    Bpasteframe.Setup(535,245+1,100,19,0,0,"PASTE FRAME");
    
    Crosshair.Shape(540,275,70,15);
    Crosshair.SetText("Crosshair");
    Crosshair.Select();
    
    Cshowlastframe.Shape(540,303,75,15);
    Cshowlastframe.SetText("Onionskin");
    gblt.Shape(534,267, 102,85);
    gblt.SetBitmap(Skin::PANEL_GROOVE);
    
    Pexrange.Shape(129,3, 508,44);
    Pexrange.SetBitmap(Skin::PANEL_GROOVE);
    
    Bsetexrange.Setup(135,14,130,20,0,0,"SET EXPORT RANGE");
    erx1.Setup(310-15, 22, 65, 20, 0, 0, -999999, 999999, 0, 1);
    ery1.Setup(400-15, 22, 65, 20, 0, 0, -999999, 999999, 0, 1);
    erx2.Setup(490-15, 22, 65, 20, 0, 0, -999999, 999999, 0, 1);
    ery2.Setup(580-15, 22, 65, 20, 0, 0, -999999, 999999, 0, 1);
    lbl[10].Setup(561-15,26,0,0,0,0,"Y2:");
    lbl[11].Setup(471-15,26,0,0,0,0,"X2:");
    lbl[12].Setup(381-15,26,0,0,0,0,"Y1:");
    lbl[13].Setup(291-15,26,0,0,0,0,"X1:");
    
    lbl[16].Setup(291-15,6,50,10,0,0,"Export from 0 to 0");
    
    Rpen.Setup(140,412,80,15,0,D_SELECTED,"Pen",0);
    Rpen.Hide();
    Rline.Setup(140,432,80,15,0,0,"Line",0);
    Rline.Hide();
    Rrectangle.Setup(140,452,80,15,0,0,"Rectangle",0);
    Rrectangle.Hide();
    Rellipse.Setup(220,412,80,15,0,0,"Ellipse",0);
    Rellipse.Hide();
    Rfill.Setup(220,432,80,15,0,0,"Fill",0);
    Rfill.Hide();
    Rselect.Setup(220,452,80,15,0,0,"Select",0);
    Rselect.Hide();
    
    Bcolor.Setup(320,448,50,19,0,0,"COLOR");
    Bcolor.Hide();
    
    Bmergelayer.Setup(380,448,50,19,0,0,"MERGE");
    Bclearlayer.Setup(380,428,50,19,0,0,"CLEAR");
    lbl[17].Setup(390,410,50,10,0,0,"Layer");
    
    Bmergelayer.Hide();
    Bclearlayer.Hide();
    lbl[17].Hide();
    
    slf.Setup(540, 318, 90, 10, 0, 0, 0, 255,  0, 1);
    
    for(int i=0;i<256;i++){char tmpchar[3]; sprintf(tmpchar,"%i",i);frames.InsertItem((new ListItemString(tmpchar)),i);}
    
    Pangstr.Shape(129,405,310,66);
    Pangstr.SetBitmap(Skin::PANEL_GROOVE);
    
    Epath.Setup(195,375,325,25,0,0, "");
    
    lbl[0].Setup(140,435,50,10,0,0,"Angle:");
    lbl[1].Setup(140,453,50,10,0,0,"Stretch:");
    
    lbl[2].Setup(400,435,50,10,0,0,"0");
    lbl[3].Setup(400,453,50,10,0,0,"100%");
    
    lbl[4].Setup(140,380,50,10,0,0,"Path:");
    
    //lbl[5].Setup(555,288,0,0,0,0,"");
    //lbl[6].Setup(558,303,0,0,0,0,"");
    
    lbl[7].Setup(540,334,0,0,0,0,"transparency");
    char *tmpstr[256];
    
    lbl[8].Setup(140,412,50,10,0,0,"");
    
    lbl[9].Setup(200,412,50,10,0,0,"");
    
    Wnewobj.Place(SCREEN_W/2-100, SCREEN_H/2-100);
	Wnewobj.GetClientArea()->Resize(200, 100);
	
	Wrenameobj.Place(SCREEN_W/2-100, SCREEN_H/2-100);
	Wrenameobj.GetClientArea()->Resize(200, 100);
	
	Bkillobj.Setup(5, SCREEN_H-60, 90, 25, 0, 0, "DELETE OBJ.");
	
	Brenameobj.Setup(5, SCREEN_H-30, 90, 25, 0, 0, "RENAME OBJ.");
	
	MainMenu.Add("File",FileMenu);
	MainMenu.Add("View",ViewMenu);
	MainMenu.Add("Zoom",Zoom);
	
	ViewMenu.Add("Edit single bitmap",247);
	ViewMenu.Add("Edit animation",246);
	
    Zoom.Add("1x",252);
	Zoom.Add("2x",253);
	Zoom.Add("4x",254);
	Zoom.Add("8x",255);
	
	Zoom.Check(0);
	ViewMenu.Check(1);
	
    FileMenu.Add("New",248);
	FileMenu.Add("Save",251);
	FileMenu.Add("Load",250);
	FileMenu.Add("Export as bmp",245);
	FileMenu.Add("Exit",249);
	
	up.Setup(105,200,20,20,0,0,"^");
	down.Setup(105,230,20,20,0,0,"V");
	  
      Cvisible.Disable();
      Bkillobj.Disable();
      Brenameobj.Disable();
      Bbrowsepic.Disable();
      Bloadpic.Disable();
      Bsavepic.Disable();
      angleslider.Disable();
      stretchslider.Disable();
      Epath.Disable();
      
    
      Bpasteframe.Disable();
    
      Bclearlayer.Disable();
      Bmergelayer.Disable();
    
    Add(desktop);
    
    
	Add(objs);
	Add(Bnewobj);
    Add(up);
    Add(down);
    Add(Brenameobj);
    Add(Bkillobj);
    
    Add(thetable);
    Add(gbobj);
    Add(Pangstr);
    Add(angleslider);
    Add(stretchslider);
    Add(Bloadpic);
    Add(Bbrowsepic);
    Add(Epath);
    Add(gbbg);
    Add(slid_r);
    Add(slid_g);
    Add(slid_b);
    Add(frames);
    Add(gblt);
    Add(Cshowlastframe);
    Add(slf);
    Add(Cvisible);
    Add(Brenameframe);
    Add(Bcopyframe);
    Add(Bpasteframe);
    Add(Bcolsel);
    Add(MainMenu);
    Add(Crosshair);
    Add(Pexrange);
    Add(Bsetexrange);
    Add(erx1);
    Add(ery1);
    Add(erx2);
    Add(ery2);
    Add(Rpen);
    Add(Rellipse);
    Add(Rline);
    Add(Rfill);
    Add(Rselect);
    Add(Rrectangle);
    Add(Bstartpos);
    Add(Bendpos);
    Add(Bmergelayer);
    Add(Bclearlayer);
    Add(Bcolor);
    Add(Bsavepic);
    Add(colbox);
    for(int i=0;i<18;i++)Add(lbl[i]);
}

bool drawlastframe()
{
return dlg->Cshowlastframe.Selected();
}

class FileSelect0r : public MAS::FileSelect {
bool MsgClose()
{
Dialog::MsgClose();
popupped=false;
}
public:
FileSelect0r(){
               FillMaskList("All bitmaps (*.bmp;*.pcx;*.tga)|BMP files (*.bmp)|PCX files (*.pcx)|TGA files (*.tga)|All files (*.*)");
               FillDriveList();
	           FillFileList();
	           title.SetText("Open Image");
               }
~FileSelect0r(){}
};


void newobj(const char *string)
{
if(tiles>0)
{
int swap=0;
Tile *tmptile[2];
for(int i=selected()+1;i<tiles+1;i++)
        {
        tmptile[swap] = tile[i];
        swap=1-swap;
        tile[i]=tmptile[swap];
        }
tile[selected()+1]=new Tile;
tiles++;

for(int i=0;i<256;i++)
        {
        tile[selected()+1]->angle[i]=0;
        tile[selected()+1]->stretch[i]=100;
        tile[selected()+1]->x[i]=0;
        tile[selected()+1]->y[i]=0;
        tile[selected()+1]->loaded=false;
        tile[selected()+1]->visible[i]=true;
        }
memset(tile[selected()+1]->path,0,sizeof(tile[selected()+1]->path));

dlg->objs.InsertItem(string,selected()+1);
dlg->objs.Select(selected()+1);
dlg->Cvisible.Select();

dlg->angleslider.SetPosition(0);
dlg->stretchslider.SetPosition(100);
char tempstr[256];
sprintf(tempstr,"%i",0);
dlg->lbl[2].SetText(tempstr);

dlg->lbl[3].SetText("100%");

dlg->Epath.SetText("");

sprintf(tempstr,"Object: %s",dlg->objs.GetItem(selected())->GetText());
dlg->lbl[9].SetText(tempstr);
dlg->gbobj.Redraw();
return;
}
else
{
tile[0]=new Tile;
tiles++;

for(int i=0;i<256;i++)
        {
        tile[0]->angle[i]=0;
        tile[0]->stretch[i]=100;
        tile[0]->x[i]=0;
        tile[0]->y[i]=0;
        tile[0]->loaded=false;
        tile[0]->visible[i]=true;
        }
memset(tile[0]->path,0,sizeof(tile[0]->path));

dlg->objs.InsertItem(string,0);

char tempstr[256];
sprintf(tempstr,"Object: %s",dlg->objs.GetItem(0)->GetText());
dlg->lbl[9].SetText(tempstr);
 
return;
}
}

int selected()
{
if(dlg->objs.GetItemCount()>0)return dlg->objs.GetSelectedIndex();
return -1;
}

bool crosshair()
{
return dlg->Crosshair.Selected();
}

void renameobj(const char *string)
{
int sel=selected();

if(dlg->objs.GetItemCount()>1)
{
 dlg->objs.DeleteItem(sel);
 dlg->objs.InsertItem(string,sel);
 dlg->objs.Select(sel);
}
else
{
 dlg->objs.InsertItem(string,1);
 dlg->objs.DeleteItem(0);
}
char tempstr[256];
sprintf(tempstr,"Object: %s",dlg->objs.GetItem(selected())->GetText());
dlg->lbl[9].SetText(tempstr);
return;
}

void add_bmp(PACKFILE *f, BITMAP *bmp) 
{

   pack_iputl(bmp->w, f);
   pack_iputl(bmp->h, f);
  
   
   for (int i=bmp->h-1; i>=0; i--) {
      for (int j=0; j<bmp->w; j++) {
	 
	    int c = getpixel(bmp, j, i);
	    pack_putc(getr24(c), f);
	    pack_putc(getg24(c), f);
	    pack_putc(getb24(c), f);
	 
      }
   }
}

BITMAP *get_bmp(PACKFILE *f) 
{

   int w = pack_igetl(f);
   int h = pack_igetl(f);
  
   BITMAP *bmp = create_bitmap(w,h);
  
   unsigned char r,g,b;
    
   for (int i=h-1; i>=0; i--) {
      for (int j=0; j<w; j++) {
	    r = pack_getc(f);
	    g = pack_getc(f);
	    b = pack_getc(f);
	    _putpixel32(bmp, j, i, makecol24(r, g, b));
        
	  }
   }
return bmp;
}

void clearall()
{
board->len=0;
dlg->Bpasteframe.Disable();
dlg->objs.DeleteAllItems();
for(int i=0;i<tiles;i++)
                      {
                      delete tile[i];
                      }
tiles=0;
dlg->Cvisible.Disable();
dlg->Brenameobj.Disable();
dlg->Bbrowsepic.Disable();
dlg->Bloadpic.Disable();
dlg->Bsavepic.Disable();
dlg->angleslider.Disable();
dlg->stretchslider.Disable();
dlg->Epath.Disable();
dlg->Bkillobj.Disable();
dlg->Bclearlayer.Disable();
dlg->Bmergelayer.Disable();
    
dlg->thetable.Redraw();


}


void Save()
{
popupped=true;
FileSelect tmpdlg("Save File",NULL,"Sprite Files (*.spf)|All files (*.*)",FA_ARCH);
char *path = tmpdlg.Popup(dlg);
popupped=false;

if(path)
{
PACKFILE *file = pack_fopen(path,"wp");
if(!file)return;
pack_fwrite(&tiles,sizeof(int),file);

pack_fwrite(&exrange.x1,sizeof(int),file);
pack_fwrite(&exrange.y1,sizeof(int),file);
pack_fwrite(&exrange.x2,sizeof(int),file);
pack_fwrite(&exrange.y2,sizeof(int),file);

for(int i=0;i<256;i++)
{
char tmpstr[3];
sprintf(tmpstr,"%i",i);
if(strcmp(dlg->frames.GetItem(i)->GetText(),tmpstr)==0)
 {
 unsigned char len=0;
 pack_fwrite(&len,sizeof(char),file);
 }
 else
 {
 unsigned char len=strlen(dlg->frames.GetItem(i)->GetText());
 pack_fwrite(&len,sizeof(char),file);
 pack_fwrite(dlg->frames.GetItem(i)->GetText(),len,file);
 }
}

for(int i=0;i<tiles;i++)
 {
 unsigned char len = strlen(dlg->objs.GetItem(i)->GetText());
 pack_fwrite(&len,sizeof(char),file);
 pack_fwrite(dlg->objs.GetItem(i)->GetText(),len,file);
 unsigned short len2 = strlen(tile[i]->path);
 pack_fwrite(&len2,sizeof(short),file);
 pack_fwrite(tile[i]->path,len2,file);
 for(int j=0;j<256;j++)
  {
  pack_fwrite(&tile[i]->x[j],2,file);
  pack_fwrite(&tile[i]->y[j],2,file);
  pack_fwrite(&tile[i]->angle[j],1,file);
  pack_fwrite(&tile[i]->stretch[j],1,file);
  pack_fwrite(&tile[i]->visible[j],1,file);
  }
  pack_fwrite(&tile[i]->loaded,1,file);
 if(tile[i]->loaded)add_bmp(file,tile[i]->face);
 }
pack_fclose(file);
}
}

void Load()
{
clearall();
popupped=true;
FileSelect tmpdlg("Load File",NULL,"Sprite Files (*.spf)|All files (*.*)",FA_ARCH);
char *path = tmpdlg.Popup(dlg);
popupped=false;

if(path)
{
PACKFILE *file = pack_fopen(path,"rp");
if(!file)return;
int tmp=0;
pack_fread(&tmp,sizeof(int),file);
pack_fread(&exrange.x1,sizeof(int),file);
pack_fread(&exrange.y1,sizeof(int),file);
pack_fread(&exrange.x2,sizeof(int),file);
pack_fread(&exrange.y2,sizeof(int),file);
dlg->frames.DeleteAllItems();
for(int i=0;i<256;i++)
{
 
 unsigned char len=0;
 char tmpstr[256];
 pack_fread(&len,sizeof(char),file);
 if(len>0)
  {
  pack_fread(tmpstr,len,file);
  dlg->frames.InsertItem(new ListItemString(tmpstr),i);
  }
 else
  {
  sprintf(tmpstr,"%i",i);
  dlg->frames.InsertItem(new ListItemString(tmpstr),i);
  }
 
}

for(int i=0;i<tmp;i++)
 {
 char tmpstr[256];
 memset(tmpstr,0,sizeof(tmpstr));
 unsigned char len=0;
 pack_fread(&len,sizeof(char),file);
 pack_fread(&tmpstr,len,file);
 newobj(tmpstr);
 unsigned short len2 = 0;
 pack_fread(&len2,sizeof(short),file);
 pack_fread(tile[i]->path,len2,file);
 for(int j=0;j<256;j++)
  {
  
  pack_fread(&tile[i]->x[j],2,file);
  pack_fread(&tile[i]->y[j],2,file);
  pack_fread(&tile[i]->angle[j],1,file);
  pack_fread(&tile[i]->stretch[j],1,file);
  pack_fread(&tile[i]->visible[j],1,file);
  }
 pack_fread(&tile[i]->loaded,1,file);
 if(tile[i]->loaded)tile[i]->face = get_bmp(file);
 
 }
pack_fclose(file);
if(dlg->objs.GetItemCount()>0){
  dlg->Cvisible.Enable();
  dlg->Brenameobj.Enable();
  dlg->Bbrowsepic.Enable();
  dlg->Bloadpic.Enable();
  dlg->Bsavepic.Enable();
  dlg->angleslider.Enable();
  dlg->stretchslider.Enable();
  dlg->Bclearlayer.Enable();
  dlg->Bmergelayer.Enable();
    
  dlg->Epath.Enable();dlg->Epath.SetText(tile[selected()]->path);
  }
if(dlg->objs.GetItemCount()>1)dlg->Bkillobj.Enable();
}
setspinner();
}

void setspinner(){dlg->erx1.SetPosition(exrange.x1);
                  dlg->ery1.SetPosition(exrange.y1);
                  dlg->erx2.SetPosition(exrange.x2);
                  dlg->ery2.SetPosition(exrange.y2);}

void resetBexrange(){dlg->Bsetexrange.SetText("SET EXPORT RANGE");}

int tool()
{
if(dlg->Rpen.Selected())return 0;
if(dlg->Rfill.Selected())return 4;
return -1;
}


void renameframe(const char *string)
{
int sel=dlg->frames.Selection();
dlg->frames.DeleteItem(sel);
dlg->frames.InsertItem(new ListItemString(string),sel);
return;
}

void browse()
{
popupped=true;
FileSelect0r tmpdlg;
char *path = tmpdlg.Popup(dlg);
if (path) dlg->Epath.SetText(path);
if (path)strcpy(tile[selected()]->path,path);

}

void updatecolbox()
{
dlg->colbox.Redraw();
}


int gettransparency()
{
return (int)dlg->slf.GetPosition();
}

int getbgcolor()
{

return makecol(int(dlg->slid_r.GetPosition()),int(dlg->slid_g.GetPosition()),int(dlg->slid_b.GetPosition()));
}

int main() {
	Error err = InstallMASkinG("allegro.cfg");
	if (err) {
		err.Report();
	}
    board = new Board;
    memset(board,0,sizeof(board));
    
    color=makecol(0,0,0);
    
	dlg = new MyDialog;
	dlg->Execute();
	delete dlg;
    delete board;
    delete []tile;
    
	ExitMASkinG();
	return 0;
}
END_OF_MAIN();
