#include "TextWriter.h"
#include "MatrixStack.h"
#include "Object.h"

/* alphabet */
float Alphabet[][32] = 
{
	/* SPACE */
	{ 0 },

	/* ! */
	{	2,	0.5, 0.2,	0.5, 1,
		2,	0.5, 0,		0.5, 0,
		0},

	/* " */
	{ 0 },

	/* # */
	{ 0 },

	/* $ */
	{ 0 },

	/* % */
	{ 0 },

	/* & */
	{ 0 },

	/* ' */
	{	2,	0.5, 0.9,	0.5, 1,
		0 },

	/* ( */
	{	4,	0.75, 1,	0.5, 0.75,	0.5, 0.25, 0.75, 0,
		0 },

	/* ) */
	{	4,	0.25, 1,	0.5, 0.75,	0.5, 0.25, 0.25, 0,
		0 },

	/* * */
	{ 0 },

	/* + */
	{ 0 },

	/* , */
	{	2, 0.5, 0.1, 0.4, 0,
		0},

	/* - */
	{	2, 0.1, 0.5, 0.9, 0.5,
		0 },

	/* . */
	{ 	2, 0.5, 0, 0.5, 0,
		0 },

	/* / */
	{	2,	0, 0, 1, 1,
		0},

	/* 0 */
	{	6,	1, 1,	1, 0,	0, 0, 0, 1, 1, 1, 0, 0,
		0},

	/* 1 */
	{	3,	0.5, 0, 0.5, 1, 0.22, 0.75,
		2, 0, 0, 1, 0,
		0 },

	/* 2 */
	{	6, 0, 0.75, 0, 1, 1, 1, 1, 0.75, 0, 0, 1, 0,
		0 },

	/* 3 */
	{	4, 0, 1, 1, 1, 1, 0, 0, 0,
		2, 0.5, 0.5, 1, 0.5,
		0 },

	/* 4 */
	{	3, 0, 1, 0, 0.25, 1, 0.25,
		2, 0.5, 0.5, 0.5, 0,
		0 },

	/* 5 */
	{	6,	0, 0,	1, 0,	1, 0.5,	0, 0.5,	0, 1, 1, 1,
		0},

	/* 6 */
	{	6,	1, 1,		0, 1,		0, 0,	1, 0,		1, 0.5, 0, 0.5,
		0},

	/* 7 */
	{	3, 0, 1, 1, 1, 1, 0,
		0},

	/* 8 */
	{	5, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0,
		2, 0, 0.5, 1, 0.5,
		0},

	/* 9 */
	{	5, 0, 0.5, 0, 1, 1, 1, 1, 0, 0, 0,
		2, 0, 0.5, 1, 0.5,
		0},

	/* : */
	{ 	2, 0.5, 0.3, 0.5, 0.1,
		2, 0.5, 0.7, 0.5, 0.9,
		0 },

	/* ; */
	{ 0 },

	/* < */
	{ 0 },

	/* = */
	{ 0 },

	/* > */
	{ 0 },

	/* ? */
	{	5,	0, 1, 1, 1, 1, 0.5, 0.5, 0.5, 0.5, 0.2,
		2, 0.5, 0, 0.5, 0,
		0 },

	/* @ */
	{ 0 },

	/* A */
	{	4,	0, 0,	0, 1,	1, 1,	1, 0,
		2,	0, 0.5, 1, 0.5,	
		0},

	/* B */
	{	9,	0, 0.5,		0.5, 0.5,	1, 0.25,	0.5, 0,		0, 0,	0, 1,	0.5, 1, 1, 0.75, 0.5, 0.5,
		0},

	/* C */
	{	4,	1, 0,	0, 0, 0, 1,	1, 1,
		0},

	/* D */
	{	7,	1, 0.25,	0.5, 0,	0, 0,	0, 1,	0.5, 1, 1, 0.75,		1, 0.25,
		0},

	/* E */
	{	4,	1, 0, 0, 0,	0, 1,	1, 1,
		2,	0, 0.5, 1, 0.5,	
		0},

	/* F */
	{	3,	0, 0,	0, 1,	1, 1,
		2,	0, 0.5, 1, 0.5,	
		0},

	/* G */
	{	5,	1, 0.5,		1, 0,	0, 0,	0, 1,	1, 1,
		2,	0.5, 0.5,	1, 0.5,	
		0},

	/* H */
	{	2,	0, 0,	0, 1,	
		2,	1, 1,	1, 0,		
		2,	0, 0.5, 1, 0.5,	
		0},

	/* I */
	{	2,	0, 0,	1, 0,
		2,	1, 1,	0, 1,
		2,	0.5, 0, 0.5, 1,	
		0},

	/* J */
	{	2,	0, 1,	1, 1,
		4,	0.5, 1,		0.5, 0,		0, 0, 0, 0.5,
		0},

	/* K */
	{	3,	1, 0,	0, 0.5,	1, 1,
		2,	0, 0, 0, 1,
		0},

	/* L */
	{	3,	1, 0,	0, 0,	0, 1,
		0},

	/* M */
	{	5,	0, 0,	0, 1,	0.5, 0.5, 1, 1,	1, 0,
		0},

	/* N */
	{	4,	0, 0,	0, 1,	1, 0,	1, 1,
		0},

	/* O */
	{	5,	0, 0,	0, 1,	1, 1,	1, 0,	0, 0,
		0},

	/* P */
	{	5,	0, 0,	0, 1,	1, 1,	1, 0.5,	0, 0.5,
		0},

	/* Q */
	{	6,	0, 0,	0, 1,	1, 1,	1, 0.5, 0.5, 0, 0, 0,
		2,	0.67, 0.25, 1, 0,
		0},

	/* R */
	{	4,	0, 0,	0, 1,	1, 1,	1, 0.5f,
		3,	1, 0.5,	0, 0.5, 1, 0,
		0},

	/* S */
	{	6,	0, 0,	1, 0,	1, 0.5,	0, 0.5,	0, 1, 1, 1,
		0},

	/* T */
	{	2,	0.5, 0,	0.5, 1,
		2,	0, 1,	1, 1,	
		0},

	/* U */
	{	4,	0, 1,	0, 0,	1, 0, 1, 1,
		0},

	/* V */
	{	5,	0, 1,	0, 0.5,		0.5, 0, 1, 0.5, 1, 1,
		0},

	/* W */
	{	5,	0, 1,	0, 0,	0.5, 0.5, 1, 0,	1, 1,
		0},

	/* X */
	{	2,	0, 0,	1, 1,
		2,	0, 1,	1, 0,
		0},

	/* Y */
	{	4,	0, 1,	0, 0.5,	1, 0.5,	1, 1,
		2,	0.5, 0, 0.5f, 0.5,	
		0},

	/* Z */
	{	4,	0, 1,	1, 1,	0, 0,	1, 0,		
		0},
};


#include <stdarg.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

void WriteText(TextPlacings t, char *fmt, ...)
{
	char ResultBuffer[100];
	va_list Args;
	
	va_start(Args, fmt);
	vsprintf(ResultBuffer, fmt, Args);
	va_end(Args);

	char *P = ResultBuffer;
	alPushMatrix();
	float xTrans = 0;
	switch(t)
	{
		default: break;
		case TP_RIGHT: xTrans = -((float)strlen(ResultBuffer)); break;
		case TP_CENTRE: xTrans = ((float)strlen(ResultBuffer))*-0.5f; break;
	}
	alTranslatef(xTrans, -0.5f, 0.0f);
	alScalef(0.8f, 1.0f, 1.0f);
	while(*P)
	{
		int index = toupper(*P)-32;
		if(index < 64)
			DrawObject2d(Alphabet[index]);
		alTranslatef(1 / 0.8f, 0, 0);
		P++;
	}
	alPopMatrix();
}
