#include "ScreenUpdate.h"

BITMAP *Pages[2] = {NULL, NULL}, *CurrentScreen;

bool SetupScreen(int w, int h, bool fullscreen)
{
	ShutdownScreen();
	if(set_gfx_mode(fullscreen ? GFX_AUTODETECT : GFX_AUTODETECT_WINDOWED, w, h, 0, 0))
		return false;
	Pages[0] = create_video_bitmap(SCREEN_W, SCREEN_H);
	Pages[1] = create_video_bitmap(SCREEN_W, SCREEN_H);

	if(!Pages[1] || !Pages[0])
	{
		destroy_bitmap(Pages[0]);
		destroy_bitmap(Pages[1]);
		Pages[0] = create_bitmap(SCREEN_W, SCREEN_H);
		Pages[1] = NULL;

		if(!Pages[0])
			return false;

		clear(Pages[0]);
	}
	else
	{
		clear(Pages[0]);
		clear(Pages[1]);
	}
	CurrentScreen = Pages[0];

	return true;
}

void ShutdownScreen()
{
	destroy_bitmap(Pages[0]);
	destroy_bitmap(Pages[1]);
	Pages[0] = Pages[1] = NULL;
}

void SwapBuffer()
{
	if(Pages[1])
	{
		show_video_bitmap(Pages[0]);
		BITMAP *t;
		t = Pages[1]; Pages[1] = Pages[0]; Pages[0] = t;
		CurrentScreen = Pages[0];
	}
	else
	{
		blit(Pages[0], screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	}
}

void LockScreen()
{
	acquire_bitmap(CurrentScreen);
}

void ReleaseScreen()
{
	release_bitmap(CurrentScreen);
}

void ClearScreen()
{
	clear_bitmap(CurrentScreen);
}
