#include "Primitives.h"
#include "ScreenUpdate.h"
#include "MatrixStack.h"
#include "GlobalTimer.h"

#include <math.h>
int AddTables[64][256];
void SetupPrimitives()
{
	int oc = 64;
	while(oc--)
	{
		float Intensity = 255.0f - ( (cos((oc / 64.0f)*AL_PI)+1.0f) * 64);
		int c = 256;
		while(c--)
		{
			AddTables[oc][c] = (int)(Intensity*sin( ((float)c*3.141592654f) / 512.0f)) >> 2;
		}
	}
}

#define SATURATION	63

/* the 2d grunt work of plotting pixels */
void DoLine(fixed *Start, fixed *End)
{
	fixed DiffX, DiffY;
	int LocalTimer = GlobalTimer >> 1;
	int *AddTab = AddTables[(LocalTimer&63) ^ ((LocalTimer&64) ? 63 : 0)];

	/* last chance rejection */
	if(End[0] < itofix(1) && Start[0] < itofix(1)) return;
	if(End[0] > itofix(SCREEN_W-2) && Start[0] > itofix(SCREEN_W-2)) return;
	if(End[1] < itofix(1) && Start[1] < itofix(1)) return;
	if(End[1] > itofix(SCREEN_H-2) && Start[1] > itofix(SCREEN_H-2)) return;

	/* hard clip - just to avoid rounding errors causing memory overflow */
	if(End[0] < itofix(1)) End[0] = itofix(1);
	if(End[0] > itofix(SCREEN_W-2)) End[0] = itofix(SCREEN_W-2);
	if(Start[0] < itofix(1)) Start[0] = itofix(1);
	if(Start[0] > itofix(SCREEN_W-2)) Start[0] = itofix(SCREEN_W-2);

	if(End[1] < itofix(1)) End[1] = itofix(1);
	if(End[1] > itofix(SCREEN_H-2)) End[1] = itofix(SCREEN_H-2);
	if(Start[1] < itofix(1)) Start[1] = itofix(1);
	if(Start[1] > itofix(SCREEN_H-2)) Start[1] = itofix(SCREEN_H-2);

	/* now, draw line */
	DiffX = End[0] - Start[0];
	DiffY = End[1] - Start[1];
	acquire_bitmap(CurrentScreen);
	if(abs(DiffX) > abs(DiffY))
	{
		/* run positively along x */
		if(End[0] < Start[0])
		{
			fixed *T = End; End = Start; Start = T;
		}
		fixed Adder = fdiv(DiffY, DiffX);
		fixed XPos = Start[0], YPos = Start[1];
		fixed sub;
		
		/* do end points */
		if(Start[0]&65535)
		{
			int Pel1 = ((unsigned char *)CurrentScreen->line[Start[1] >> 16])[Start[0] >> 16]&SATURATION;
			int Pel2 = ((unsigned char *)CurrentScreen->line[1+(Start[1] >> 16)])[Start[0] >> 16]&SATURATION;

			Pel2 += AddTab[fmul(Start[1]&65535, 65535-(Start[0]&65535)) >> 8]; if(Pel2 > SATURATION) Pel2 = SATURATION;
			Pel1 += AddTab[fmul(65535-(Start[1]&65535), 65535-(Start[0]&65535)) >> 8]; if(Pel1 > SATURATION) Pel1 = SATURATION;

			((unsigned char *)CurrentScreen->line[Start[1] >> 16])[Start[0] >> 16] = Pel1 | CurrentColour;
			((unsigned char *)CurrentScreen->line[1+(Start[1] >> 16)])[Start[0] >> 16] = Pel2 | CurrentColour;

			sub = XPos&65535;
			XPos += 65536-sub;
			YPos += fmul(Adder, 65536-sub);
		}

		if(End[0]&65535)
		{
			int Pel1 = ((unsigned char *)CurrentScreen->line[End[1] >> 16])[1+(End[0] >> 16)]&SATURATION;
			int Pel2 = ((unsigned char *)CurrentScreen->line[1+(End[1] >> 16)])[1+(End[0] >> 16)]&SATURATION;

			Pel2 += AddTab[fmul(End[1]&65535, End[0]&65535) >> 8]; if(Pel2 > SATURATION) Pel2 = SATURATION;
			Pel1 += AddTab[fmul(65535-(End[1]&65535), End[0]&65535) >> 8]; if(Pel1 > SATURATION) Pel1 = SATURATION;

			((unsigned char *)CurrentScreen->line[End[1] >> 16])[1+(End[0] >> 16)] = Pel1 | CurrentColour;
			((unsigned char *)CurrentScreen->line[1+(End[1] >> 16)])[1+(End[0] >> 16)] = Pel2 | CurrentColour;

			End[0] &= ~65535;
		}

		/* do main line segment */
		while(XPos <= End[0])
		{
			int Pel1 = ((unsigned char *)CurrentScreen->line[YPos >> 16])[XPos >> 16]&SATURATION;
			int Pel2 = ((unsigned char *)CurrentScreen->line[1+(YPos >> 16)])[XPos >> 16]&SATURATION;

			Pel2 += AddTab[(YPos&65535) >> 8]; if(Pel2 > SATURATION) Pel2 = SATURATION;
			Pel1 += AddTab[(65535-(YPos&65535)) >> 8]; if(Pel1 > SATURATION) Pel1 = SATURATION;
			
			((unsigned char *)CurrentScreen->line[YPos >> 16])[XPos >> 16] = Pel1 | CurrentColour;
			((unsigned char *)CurrentScreen->line[1+(YPos >> 16)])[XPos >> 16] = Pel2 | CurrentColour;

			YPos += Adder;
			XPos += itofix(1);
		}
	}
	else
	{
		/* run positively along y */
		if(End[1] < Start[1])
		{
			fixed *T = End; End = Start; Start = T;
		}
		fixed Adder = fdiv(DiffX, DiffY);
		fixed XPos = Start[0], YPos = Start[1];
		fixed sub;

		/* do end points */
		if(Start[1]&65535)
		{
			int Pel1 = ((unsigned char *)CurrentScreen->line[Start[1] >> 16])[Start[0] >> 16]&SATURATION;
			int Pel2 = ((unsigned char *)CurrentScreen->line[Start[1] >> 16])[1+(Start[0] >> 16)]&SATURATION;

			Pel2 += AddTab[fmul(Start[0]&65535, 65535-(Start[1]&65535)) >> 8]; if(Pel2 > SATURATION) Pel2 = SATURATION;
			Pel1 += AddTab[fmul(65535-(Start[0]&65535), 65535-(Start[1]&65535)) >> 8]; if(Pel1 > SATURATION) Pel1 = SATURATION;

			((unsigned char *)CurrentScreen->line[Start[1] >> 16])[Start[0] >> 16] = Pel1 | CurrentColour;
			((unsigned char *)CurrentScreen->line[Start[1] >> 16])[(Start[0] >> 16)+1] = Pel2 | CurrentColour;

			sub = YPos&65535;
			YPos += 65536-sub;
			XPos += fmul(Adder, 65536-sub);
		}

		if(End[1]&65535)
		{
			int Pel1 = ((unsigned char *)CurrentScreen->line[1+(End[1] >> 16)])[End[0] >> 16]&SATURATION;
			int Pel2 = ((unsigned char *)CurrentScreen->line[1+(End[1] >> 16)])[1+(End[0] >> 16)]&SATURATION;

			Pel2 += AddTab[fmul(End[0]&65535, End[1]&65535) >> 8]; if(Pel2 > SATURATION) Pel2 = SATURATION;
			Pel1 += AddTab[fmul(65535-(End[0]&65535), End[1]&65535) >> 8]; if(Pel1 > SATURATION) Pel1 = SATURATION;

			((unsigned char *)CurrentScreen->line[1+(End[1] >> 16)])[End[0] >> 16] = Pel1 | CurrentColour;
			((unsigned char *)CurrentScreen->line[1+(End[1] >> 16)])[1+(End[0] >> 16)] = Pel2 | CurrentColour;

			End[1] &= ~65535;
		}

		/* do main line segment */
		while(YPos <= End[1])
		{
			int Pel1 = ((unsigned char *)CurrentScreen->line[YPos >> 16])[XPos >> 16]&SATURATION;
			int Pel2 = ((unsigned char *)CurrentScreen->line[YPos >> 16])[(XPos >> 16)+1]&SATURATION;

			Pel2 += AddTab[(XPos&65535) >> 8]; if(Pel2 > SATURATION) Pel2 = SATURATION;
			Pel1 += AddTab[(65535-(XPos&65535)) >> 8]; if(Pel1 > SATURATION) Pel1 = SATURATION;
			
			((unsigned char *)CurrentScreen->line[YPos >> 16])[XPos >> 16] = Pel1 | CurrentColour;
			((unsigned char *)CurrentScreen->line[YPos >> 16])[(XPos >> 16)+1] = Pel2 | CurrentColour;

			XPos += Adder;
			YPos += itofix(1);
		}
	}
	release_bitmap(CurrentScreen);
}

/* 3d conversion stuff */
void Transform3f(float x, float y, float z, float *Output)
{
	apply_matrix_f(CurrentMatrix, x, y, z, &Output[0], &Output[1], &Output[2]);
	Output[1] *= 4.0f / 3.0f;
}
void Project3f(float *Input, fixed *Output)
{
	Output[0] = ftofix((SCREEN_W >> 1) + ((SCREEN_W >> 1)-1)*(Input[0]/Input[2]));
	Output[1] = ftofix((SCREEN_H >> 1) - ((SCREEN_H >> 1)-1)*(Input[1]/Input[2]));
}

#define ClipIfClause()	\
		{\
			Result[0][0] = (1 - Ratio)*Result[0][0] + Ratio*Result[1][0];\
			Result[0][1] = (1 - Ratio)*Result[0][1] + Ratio*Result[1][1];\
			Result[0][2] = (1 - Ratio)*Result[0][2] + Ratio*Result[1][2];\
		}\
		else\
		{\
			Result[1][0] = (1 - Ratio)*Result[0][0] + Ratio*Result[1][0];\
			Result[1][1] = (1 - Ratio)*Result[0][1] + Ratio*Result[1][1];\
			Result[1][2] = (1 - Ratio)*Result[0][2] + Ratio*Result[1][2];\
		}

void Line3f(float x1, float y1, float z1, float x2, float y2, float z2)
{
	float Result[2][3];
	Transform3f(x1, y1, z1, Result[0]);
	Transform3f(x2, y2, z2, Result[1]);

	/* test for trivial throwaway */
	if(Result[0][2] < 1.0f && Result[1][2] < 1.0f) return;
	if(Result[0][1] > Result[0][2] && Result[1][1] > Result[1][2]) return;
	if(Result[0][0] > Result[0][2] && Result[1][0] > Result[1][2]) return;
	if(Result[0][1] < -Result[0][2] && Result[1][1] < -Result[1][2]) return;
	if(Result[0][0] < -Result[0][2] && Result[1][0] < -Result[1][2]) return;

	/* clip to font plane, if necessary */
	if(!(Result[0][2] >= 1.0f && Result[1][2] >= 1.0f))
	{
		float Ratio = (Result[0][2]-1.0f) / (Result[0][2] - Result[1][2]);
		if(Result[0][2] < 1.0f)
			ClipIfClause()
	}

	/* right plane */
	if(!(Result[0][0] <= Result[0][2] && Result[1][0] <= Result[1][2]))
	{
		/*
			Result[0][0] + r*(Result[1][0] - Result[0][0]) = Result[0][2] + r*(Result[1][2] - Result[0][2])
			
			=> (Result[0][0] - Result[0][2]) = r*(Result[1][2] - Result[0][2] - Result[1][0] + Result[0][0])
			=> r = (Result[0][0] - Result[0][2]) / (Result[1][2] - Result[0][2] - Result[1][0] + Result[0][0])
		*/
		float Ratio = (Result[0][0] - Result[0][2]) / (Result[1][2] - Result[0][2] - Result[1][0] + Result[0][0]);
		if(Result[0][0] > Result[0][2])
			ClipIfClause()
	}

	/* left plane */
	if(!(Result[0][0] >= -Result[0][2] && Result[1][0] >= -Result[1][2]))
	{
		float Ratio = (Result[0][0] + Result[0][2]) / (- Result[1][2] + Result[0][2] - Result[1][0] + Result[0][0]);
		if(Result[0][0] < -Result[0][2])
			ClipIfClause()
	}

	/* top plane */
	if(!(Result[0][1] <= Result[0][2] && Result[1][1] <= Result[1][2]))
	{
		float Ratio = (Result[0][1] - Result[0][2]) / (Result[1][2] - Result[0][2] - Result[1][1] + Result[0][1]);
		if(Result[0][1] > Result[0][2])
			ClipIfClause()
	}

	/* bottom plane */
	if(!(Result[0][1] >= -Result[0][2] && Result[1][1] >= -Result[1][2]))
	{
		float Ratio = (Result[0][1] + Result[0][2]) / (- Result[1][2] + Result[0][2] - Result[1][1] + Result[0][1]);
		if(Result[0][1] < -Result[0][2])
			ClipIfClause()
	}

	/* project both lines, draw line */
	fixed Start[2], End[2];
	Project3f(Result[0], Start);
	Project3f(Result[1], End);
	DoLine(Start, End);
}

void Line3f(float *One, float *Two)
{
	Line3f(One[0], One[1], One[2], Two[0], Two[1], Two[2]);
}

void Line2f(float x1, float y1, float x2, float y2)
{
	Line3f(x1, y1, 0, x2, y2, 0);
}

void Line2f(float *One, float *Two)
{
	Line3f(One[0], One[1], 0, Two[0], Two[1], 0);
}
