#include "Player.h"
#include "Primitives.h"
#include "MatrixStack.h"
#include "TextWriter.h"
#include "Map.h"

float PlayerView[16];
float PlayerVec[3];
float LaunchView[16];
int NumMissiles, Round;
bool Bonus;
int HighRound = 1;

void AddHud()
{
	SetColour(GREEN);
	Line3f(0, 0.25, 1, 0, 0.05, 1);
	Line3f(0, -0.25, 1, 0, -0.05, 1);
	Line3f(0.25, 0, 1, 0.05, 0, 1);
	Line3f(-0.25, 0, 1, -0.05, 0, 1);
	
	alPushMatrix();
		alTranslatef(0, 10.5, 20);
		WriteText(TP_CENTRE, "Altitude %0.2f", PlayerView[13]);
		alTranslatef(0, -1.5, 0);
		WriteText(TP_CENTRE, "Distance %0.2f", City.GetDistanceFromTarget(&PlayerView[12]));
		alTranslatef(-20, 5.5, 0);
		WriteText(TP_LEFT, "Missiles %d", NumMissiles);
	alPopMatrix();
}

#include <math.h>

#define DOT_SPACING	100.0f
#define DOTS_ACROSS	20
float BackgroundRotation;
float *BackgroundGeometry = NULL;

void ShutdownBackground()
{
	delete[] BackgroundGeometry;
}

void SetupBackground()
{
	float Background2d[] =
	{
		5,		0, 0,	4, 10,	13, 18,		27, 9,	41, 6,
		3,		32, 7.928571428571,	42, 9,	55, 16,
		4,		38, 5,	48, 8,	55, 16,		69, 2,
		3,		67, 4,	77, 14,	86, 0,

		3,		94, 0,	105, 18,	119, 7,
		3,		98, 6.545454545455,	103, 10,	105, 18,
		3,		112, 13,	117, 15,	137, 0,
		2,		116, 9.357142857143,	117, 15,

		3,		152, 0, 166, 16, 176, 1.928571428571,		//-1.407142857143
		3,		175, 1, 189, 14, 196, 0,
		3,		172, 7.557142857142, 177, 12, 181, 6.571428571429,
		3,		175, 3.335714285713, 177, 7, 177, 12,

		0
	};
	
	/* count vertices */
	int Verts = 0, pos = 0;
	while(Background2d[pos])
	{
		Verts += (int)Background2d[pos];
		pos += 1 + 2*(int)Background2d[pos];
	}

	BackgroundGeometry = new float[1 + (pos - (Verts*2)) + Verts*3];

	/* convert geometry */
	pos = 0;
	int target =0;
	while(Background2d[pos])
	{
		Verts = (int)Background2d[pos];
		BackgroundGeometry[target++] = Background2d[pos++];
		while(Verts--)
		{
			/* copy height */
			BackgroundGeometry[target+1] = Background2d[pos+1] / 10.0f;

			/* map offset to circle */
			BackgroundGeometry[target] = 10*sin((Background2d[pos] / 100.0f)*AL_PI);
			BackgroundGeometry[target+2] = 10*cos((Background2d[pos] / 100.0f)*AL_PI);

			target += 3;
			pos += 2;
		}
	}
	BackgroundGeometry[target++] = 0;
}

void AddBackground()
{
	/* add some "ground detail" */
	float MidX, MidZ;
	float DrawMat[16];

	alGetMatrix(DrawMat);
	alInvertMatrix(DrawMat);
	MidX = DrawMat[12] - fmod(DrawMat[12], DOT_SPACING);
	MidZ = DrawMat[14] - fmod(DrawMat[14], DOT_SPACING);

	SetColour(BLUE);
	alPushMatrix();
		alTranslatef(MidX - DOT_SPACING*DOTS_ACROSS*0.5f, 0, MidZ - DOT_SPACING*DOTS_ACROSS*0.5f);

		for(int x = 0; x < DOTS_ACROSS; x++)
		{
			for(int y = 0; y < DOTS_ACROSS; y++)
			{
				WriteText(TP_CENTRE, ".");
				alTranslatef(0, 0, DOT_SPACING);
			}
			alTranslatef(DOT_SPACING, 0, -DOT_SPACING*DOTS_ACROSS);
		}
	alPopMatrix();

	alPushMatrix();
		alTranslatef(DrawMat[12], DrawMat[13], DrawMat[14]);
		alRotatef(BackgroundRotation, 0, 1, 0);

		/* draw background scenery here */
		float *VertexInfo = BackgroundGeometry;
		while(1)
		{
			int Verts = (int)VertexInfo[0];
			if(!Verts) break;
			VertexInfo++;
			Verts--;
			while(Verts--)
			{
				Line3f(VertexInfo[0], VertexInfo[1], VertexInfo[2], VertexInfo[3], VertexInfo[4], VertexInfo[5]);
				VertexInfo += 3;
			}
			VertexInfo += 3;
		}
	alPopMatrix();
}

void RandomiseBackground()
{
	BackgroundRotation = randf()*360.0f;
}
