#ifndef __MATRIXSTACK_H
#define __MATRIXSTACK_H

#include "allegro.h"

extern MATRIX_f *CurrentMatrix;
extern int CurrentColour;
extern int RequestedColour;

extern void SetupMatrixStack();

extern void alPushMatrix();
extern void alPopMatrix();
extern void alRotatef(float angle, float x, float y, float z);
extern void alTranslatef(float x, float y, float z);
extern void alScalef(float x, float y, float z);
extern void alLoadIdentity();
extern void alMultMatrix(float *);
extern void alGetMatrix(float *);

extern void alInvertMatrix(float *);
extern void alCopyInvertMatrix(float *in, float *out);
extern void alRotateMatrix(float *M, float angle, float x, float y, float z);

#define	WHITE		0x00
#define	RED			0x40
#define GREEN		0x80
#define BLUE		0xc0
#define NOCHANGE	0xff
extern void SetColour(int);

float ApplyNormal(float *Input, float *Vector);

#endif
