#include "MatrixStack.h"

MATRIX_f MatrixStack[25];
MATRIX_f *CurrentMatrix;

void SetupMatrixStack()
{
	MatrixStack[0] = identity_matrix_f;
	CurrentMatrix = &MatrixStack[0];
}

void alLoadIdentity()
{
	*CurrentMatrix = identity_matrix_f;
}

void alPushMatrix()
{
	CurrentMatrix++;
	CurrentMatrix[0] = CurrentMatrix[-1];
}

void alPopMatrix()
{
	CurrentMatrix--;
}

void alRotatef(float angle, float x, float y, float z)
{
	MATRIX_f T;
	get_vector_rotation_matrix_f(&T, x, y, z, (angle*128.0f)/180.0f);
	matrix_mul_f(&T, CurrentMatrix, CurrentMatrix);
}

void alTranslatef(float x, float y, float z)
{
	MATRIX_f T;
	get_translation_matrix_f(&T, x, y, z);
	matrix_mul_f(&T, CurrentMatrix, CurrentMatrix);
}

void alScalef(float x, float y, float z)
{
	MATRIX_f T;
	get_scaling_matrix_f(&T, x, y, z);
	matrix_mul_f(&T, CurrentMatrix, CurrentMatrix);
}

float ApplyNormal(float *n, float *Vector)
{
	/* transform normal */
	float EndNormal[3];
	EndNormal[0] = CurrentMatrix->v[0][0]*n[0] + CurrentMatrix->v[0][1]*n[1] + CurrentMatrix->v[0][2]*n[2];
	EndNormal[1] = CurrentMatrix->v[1][0]*n[0] + CurrentMatrix->v[1][1]*n[1] + CurrentMatrix->v[1][2]*n[2];
	EndNormal[2] = CurrentMatrix->v[2][0]*n[0] + CurrentMatrix->v[2][1]*n[1] + CurrentMatrix->v[2][2]*n[2];

	float EndVector[3];
	apply_matrix_f(CurrentMatrix, Vector[0], Vector[1], Vector[2], &EndVector[0], &EndVector[1], &EndVector[2]);

	return -(EndNormal[0]*EndVector[0] + EndNormal[1]*EndVector[1] + EndNormal[2]*EndVector[2]);
}

void alGetMatrix(float *m)
{
	m[0] = CurrentMatrix->v[0][0]; m[1] = CurrentMatrix->v[1][0]; m[2] = CurrentMatrix->v[2][0]; m[3] = 0;
	m[4] = CurrentMatrix->v[0][1]; m[5] = CurrentMatrix->v[1][1]; m[6] = CurrentMatrix->v[2][1]; m[7] = 0;
	m[8] = CurrentMatrix->v[0][2]; m[9] = CurrentMatrix->v[1][2]; m[10] = CurrentMatrix->v[2][2]; m[11] = 0;
	m[12] = CurrentMatrix->t[0]; m[13] = CurrentMatrix->t[1]; m[14] = CurrentMatrix->t[2]; m[15] = 1;
}

void alMultMatrix(float *m)
{
	MATRIX_f N;
	
	N.v[0][0] = m[0]; N.v[1][0] = m[1]; N.v[2][0] = m[2];
	N.v[0][1] = m[4]; N.v[1][1] = m[5]; N.v[2][1] = m[6];
	N.v[0][2] = m[8]; N.v[1][2] = m[9]; N.v[2][2] = m[10];
	N.t[0] = m[12]; N.t[1] = m[13]; N.t[2] = m[14];
	matrix_mul_f(&N, CurrentMatrix, CurrentMatrix);
}

int CurrentColour, RequestedColour;
void SetColour(int c)
{
	RequestedColour = c;
	if(RequestedColour != NOCHANGE) CurrentColour = c;
}

void alInvertMatrix(float *Matrix)
{
	float TempVar[3];

	/* translational part */
	TempVar[0] = -(Matrix[0]*Matrix[12] + Matrix[1]*Matrix[13] + Matrix[2]*Matrix[14]);
	TempVar[1] = -(Matrix[4]*Matrix[12] + Matrix[5]*Matrix[13] + Matrix[6]*Matrix[14]);
	TempVar[2] = -(Matrix[8]*Matrix[12] + Matrix[9]*Matrix[13] + Matrix[10]*Matrix[14]);

	Matrix[12] = TempVar[0];
	Matrix[13] = TempVar[1];
	Matrix[14] = TempVar[2];

	/* transpose main part of matrix. A funny and suboptimal way of doing things, but otherwise the MSVC (5) optimiser gets things all wrong */
	float *Ptr[3];

	Ptr[0] = &Matrix[4];
	Ptr[1] = &Matrix[8];
	Ptr[2] = &Matrix[9];

	TempVar[0] = *Ptr[0];
	TempVar[1] = *Ptr[1];
	TempVar[2] = *Ptr[2];

	Matrix[4] = Matrix[1];
	Matrix[8] = Matrix[2];
	Matrix[9] = Matrix[6];

	Matrix[1] = TempVar[0];
	Matrix[2] = TempVar[1];
	Matrix[6] = TempVar[2];
}

void alCopyInvertMatrix(float *Matrix, float *OutMatrix)
{
	/* translational part */
	OutMatrix[12] = -(Matrix[0]*Matrix[12] + Matrix[1]*Matrix[13] + Matrix[2]*Matrix[14]);
	OutMatrix[13] = -(Matrix[4]*Matrix[12] + Matrix[5]*Matrix[13] + Matrix[6]*Matrix[14]);
	OutMatrix[14] = -(Matrix[8]*Matrix[12] + Matrix[9]*Matrix[13] + Matrix[10]*Matrix[14]);

	/* transpose main part of matrix  */
	OutMatrix[4] = Matrix[1];
	OutMatrix[8] = Matrix[2];
	OutMatrix[9] = Matrix[6];

	OutMatrix[1] = Matrix[4];
	OutMatrix[2] = Matrix[8];
	OutMatrix[6] = Matrix[9];
	
	OutMatrix[0] = Matrix[0];
	OutMatrix[5] = Matrix[5];
	OutMatrix[10] = Matrix[10];

	/* reset bottom row */
	OutMatrix[3] = OutMatrix[7] = OutMatrix[11] = 0;
	OutMatrix[15] = 1;
}

void alRotateMatrix(float *M, float angle, float x, float y, float z)
{
	MATRIX_f RotMat;
	get_vector_rotation_matrix_f(&RotMat, x, y, z, (angle*128.0f)/180.0f);

	apply_matrix_f(&RotMat, M[0], M[1], M[2], &M[0], &M[1], &M[2]);
	apply_matrix_f(&RotMat, M[4], M[5], M[6], &M[4], &M[5], &M[6]);
	apply_matrix_f(&RotMat, M[8], M[9], M[10], &M[8], &M[9], &M[10]);
}
