#include "LevelIntroScreen.h"
#include "MatrixStack.h"
#include "TextWriter.h"
#include "LaunchScreen.h"
#include "Map.h"
#include "Player.h"

#define RUNLENGTH	250

CLevelIntroScreen::CLevelIntroScreen()
{
	LocTimer = 0;
}

int CLevelIntroScreen::Update()
{
	LocTimer++;
	if(LocTimer == RUNLENGTH || key[KEY_SPACE])
	{
		/* seed player position */
		float Angle, Distance;
		City.GetStartPos(Angle, Distance);
		alPushMatrix();
			alTranslatef(0.0f, -5.0f, Distance);
			alRotatef(Angle, 0, 1, 0);
			City.CentreOnTarget();
			alGetMatrix(LaunchView);
		alPopMatrix();

		alInvertMatrix(LaunchView);

		/* push game screen */
		CLaunchScreen *NewScreen = new CLaunchScreen;
		PushContent(NewScreen);

		/* do switch */
		return CBO_INTERCHANGE;
	}
	return CBO_CONTINUE;
}

void CLevelIntroScreen::Draw()
{
	switch((LocTimer >> 1)&3)
	{
		default:
		case 0: SetColour(WHITE); break;
		case 1: SetColour(RED); break;
		case 2: SetColour(GREEN); break;
		case 3: SetColour(BLUE); break;
	}
	alPushMatrix();
		alTranslatef(0.0f, 10.0f, 15.0f);
		WriteText(TP_CENTRE, "Target");
	alPopMatrix();
	
	float Angle, Distance, Ratio;
	City.GetStartPos(Angle, Distance);
	Ratio = (float)(RUNLENGTH - LocTimer) / RUNLENGTH;

	alPushMatrix();
		alTranslatef(0.0f, -(1.0f - Ratio)*5.0f, 32.0f + (1.0f - Ratio)*(Distance-32.0f));
		alRotatef(Ratio*90, 1, 0, 0);
		alRotatef(LocTimer - RUNLENGTH + Angle, 0, 1, 0);
		City.CentreOnTarget();

		AddBackground();
		City.Draw();
	alPopMatrix();
}
