#include "AttractScreen.h"
#include "ScreenUpdate.h"
#include "Primitives.h"
#include "MatrixStack.h"
#include "TextWriter.h"
#include "Sound.h"
#include "GameScreen.h"
#include "Player.h"
#include "ControlsScreen.h"

#define LEADIN		150
#define PRETEXT		870
#define ENDTEXT		1370

#define SCROLLPOS(n) (((n) - PRETEXT)/40.0f)

char *InstructionText[] =
{
	"Faced with states he",
	"suspects of developing",
	"nuclear weapons, the",
	"leader has decided to",
	"launch a pre-emptive",
	"strike on key buildings",
	"in their command",
	"structure using the",
	"latest in mini-nukes.",
	"",
	"A missile launcher has",
	"been deployed to the",
	"outskirts of every major",
	"enemy city.",
	"",
	"OICW, a great war",
	"hero, must aim and",
	"guide the leader's",
	"missiles towards their",
	"strategically chosen",
	"targets.",
	"",
	"For each mission",
	"successfully completed",
	"you will be rewarded",
	"with more missiles for",
	"use on the next target.",
	"You will gain a further",
	"missile if you are able",
	"to hit your target without",
	"altering the path of",
	"the missile during flight.",
	"",
	"You will be penalised",
	"for every wrong building",
	"hit as this time the",
	"leader needs an",
	"ideologically clean",
	"victory."
	"",
	NULL
};
#define LEADOUT		10

void AddBow(int side)
{
	co3dAddLine(side, side,		1, -1, 0.2,		1, -0.2, 0.2);
	co3dAddLine(side, side,		1, 0.2, 0.2,	1, 1, 0.2);

	co3dAddLine(side, side,		1, -1, -0.2,	1, -0.2, -0.2);
	co3dAddLine(side, side,		1, 0.2, -0.2,	1, 1, -0.2);

	co3dAddLine(side, side,		1, 0.2, -1,		1, 0.2, -0.2);
	co3dAddLine(side, side,		1, 0.2, 0.2,	1, 0.2, 1);

	co3dAddLine(side, side,		1, -0.2, -1,	1, -0.2, -0.2);
	co3dAddLine(side, side,		1, -0.2, 0.2,	1, -0.2, 1);
}

#include "Buildings.h"

CAttractScreen::CAttractScreen()
{
	/* count the number of text lines */
	NumTextLines = 0;
	while(InstructionText[NumTextLines])
		NumTextLines++;

	NumTextLines += LEADOUT;
	NumTextLines += NumTextLines >> 1;

	Box = CreateObject3d(6, 8*6 + 19 + 12);
	alPushMatrix();
		alLoadIdentity();

		co3dAddFace(1, 0, 0, 1, 0, 0);
		co3dAddFace(-1, 0, 0, -1, 0, 0);
		co3dAddFace(0, 1, 0, 0, 1, 0);
		co3dAddFace(0, -1, 0, 0, -1, 0);
		co3dAddFace(0, 0, 1, 0, 0, 1);
		co3dAddFace(0, 0, -1, 0, 0, -1);

		SetColour(GREEN);
		alPushMatrix();
			AddBow(0);
			alRotatef(90, 0, 1, 0);
			AddBow(4);
			alRotatef(90, 0, 1, 0);
			AddBow(1);
			alRotatef(90, 0, 1, 0);
			AddBow(5);
			alRotatef(90, 0, 0, 1);
			AddBow(3);
			alRotatef(180, 0, 0, 1);
			AddBow(2);
		alPopMatrix();

		/* the bow */
		co3dAddLine(2, 2,	0, 1, 0,	0.4, 1.35, 0);
		co3dAddLine(2, 2,	0.4, 1.35, 0,	0.6, 1.15, 0);
		co3dAddLine(2, 2,	0.6, 1.15, 0,	0, 1, 0);

		co3dAddLine(2, 2,	0, 1, 0,	0.05, 1.5, 0);
		co3dAddLine(2, 2,	0.05, 1.5, 0,	-0.25, 1.5, 0);
		co3dAddLine(2, 2,	-0.25, 1.5, 0,	-0.3, 1.1, 0);
		co3dAddLine(2, 2,	-0.3, 1.1, 0,	0, 1, 0);

		/* box edges */
		SetColour(BLUE);
		co3dAddLine(0, 2,	1, 1, -1, 1, 1, -0.2); 		co3dAddLine(0, 2,	1, 1, 0.2, 1, 1, 1);
		co3dAddLine(0, 3,	1, -1, -1, 1, -1, -0.2);	co3dAddLine(0, 3,	1, -1, 0.2, 1, -1, 1);
		co3dAddLine(0, 4,	1, -1, 1, 1, -0.2, 1);		co3dAddLine(0, 4,	1, 0.2, 1, 1, 1, 1);
		co3dAddLine(0, 5,	1, -1, -1, 1, -0.2, -1);	co3dAddLine(0, 5,	1, 0.2, -1, 1, 1, -1);

		co3dAddLine(1, 2,	-1, 1, -1, -1, 1, -0.2);	co3dAddLine(1, 2,	-1, 1, 0.2, -1, 1, 1);
		co3dAddLine(1, 3,	-1, -1, -1, -1, -1, -0.2);	co3dAddLine(1, 3,	-1, -1, 0.2, -1, -1, 1);
		co3dAddLine(1, 4,	-1, -1, 1, -1, -0.2, 1);	co3dAddLine(1, 4,	-1, 0.2, 1, -1, 1, 1);
		co3dAddLine(1, 5,	-1, -1, -1, -1, -0.2, -1);	co3dAddLine(1, 5,	-1, 0.2, -1, -1, 1, -1);

		co3dAddLine(2, 4,	-1, 1, 1, -0.2, 1, 1);		co3dAddLine(2, 4,	0.2, 1, 1, 1, 1, 1);
		co3dAddLine(2, 5,	-1, 1, -1, -0.2, 1, -1);	co3dAddLine(2, 5,	0.2, 1, -1, 1, 1, -1);

		co3dAddLine(3, 4,	-1, -1, 1, -0.2, -1, 1);	co3dAddLine(3, 4,	0.2, -1, 1, 1, -1, 1);
		co3dAddLine(3, 5,	-1, -1, -1, -0.2, -1, -1);	co3dAddLine(3, 5,	0.2, -1, -1, 1, -1, -1);

	alPopMatrix();
}

CAttractScreen::~CAttractScreen()
{
	FreeObject3d(Box);
}

int CAttractScreen::Update()
{
	Timer++;
	if(Timer == PRETEXT)
	{
		TriggerSoundEvent(SND_BOUNCE);
	}
	if(SCROLLPOS(Timer) > NumTextLines)
	{
		TriggerSoundEvent(SND_TITLESCREEN);
		Timer = 0;
	}
	
	if(key[KEY_SPACE])
	{
		HaltSound();
		Bonus = false;
		CGameScreen *Game = new CGameScreen;
		PushContent(Game);
		return CBO_DESCEND;
	}

	if(key[KEY_K])
	{
		HaltSound();
		CControlsScreen *Controls = new CControlsScreen;
		PushContent(Controls);
		return CBO_DESCEND;
	}

	return CBO_CONTINUE;
}

void CAttractScreen::Draw()
{
	if(Timer > PRETEXT)
	{
		SetColour(RED);
		alPushMatrix();
			alTranslatef(0.0f, 7.0f, 10.0f);
			WriteText(TP_CENTRE, "Game Instructions");
		alPopMatrix();
		SetColour(WHITE);
		alPushMatrix();
			alTranslatef(0.0f, -7.0f, 10.0f);
			alRotatef(-50.0f, 1, 0, 0);
			
			float Offset = SCROLLPOS(Timer);
			alTranslatef(0.0f, SCROLLPOS(Timer), 0.0f);

			int c = 0;
			while(InstructionText[c] && Offset > -1.5f)
			{
				WriteText(TP_CENTRE, InstructionText[c]);
				c++;
				alTranslatef(0.0f, -1.5f, 0.0f);
				Offset -= 1.5f;
			}
		alPopMatrix();
	}
	else
	{
		SetColour(WHITE);
		alPushMatrix();

			if(Timer > LEADIN)
			{
				alTranslatef(0.0f, 0.0f, 10.0f);
				alRotatef((float)(Timer - 150.0f), 1, 0, 0);
			}
			else
			{
				alTranslatef(0.0f, (Timer - 150.0f)/15.0f, 10.0f);
				alRotatef((float)(150.0f - Timer), 0, 1, 0);
			}

			WriteText(TP_CENTRE, "Nuclear Attack!");
		alPopMatrix();

		if(Timer > LEADIN)
		{
			alPushMatrix();
				SetColour(BLUE);
				alTranslatef(0.0f, 11.5f, 20.0f);
				WriteText(TP_CENTRE, "Highest city reached: %d", HighRound);
				
				SetColour(WHITE);
				alTranslatef(0.0f, -1.5f, 0.0f);
				WriteText(TP_CENTRE, "Press space to start");

				SetColour(RED);
				alTranslatef(0.0f, -1.5f, 0.0f);
				WriteText(TP_CENTRE, "Press K to see controls");
				
				SetColour(WHITE);
				alTranslatef(0.0f, -13.5f, 10.0f);
				WriteText(TP_CENTRE, "By Thomas Harte");

				alTranslatef(0.0f, 0.0f, -20.0f);
				alRotatef(Timer, 0, 1, 0);
				DrawObject3d(Box);
			alPopMatrix();
		}
	}
}

void CAttractScreen::Enter()
{
	TriggerSoundEvent(SND_TITLESCREEN);
	Timer = 0;
}
