#include "Sound.h"
#include "allegro.h"

SAMPLE *Sounds[NUM_SOUNDS];

void SetupSound()
{
	if(!install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL))
	{
		Sounds[SND_TITLESCREEN] = load_wav("sound/start.wav");
		Sounds[SND_STARTGAME] = load_wav("sound/bonus.wav");
		Sounds[SND_BOUNCE] = load_wav("sound/bounce.wav");
		Sounds[SND_SHOT] = load_wav("sound/shot.wav");
		Sounds[SND_PULSE] = load_wav("sound/pulse.wav");
	}
	else
	{
		int c = NUM_SOUNDS;
		while(c--)
			Sounds[c] = NULL;
	}
}

void ShutdownSound()
{
	int c = NUM_SOUNDS;
	while(c--)
		if(Sounds[c])
		{
			stop_sample(Sounds[c]);
			destroy_sample(Sounds[c]);
			Sounds[c] = NULL;
		}
}

void TriggerSoundEvent(int e)
{
	if(Sounds[e])
		play_sample(Sounds[e], 255, 128, 1000, 0);
}

void HaltSound()
{
	int c = NUM_SOUNDS;
	while(c--)
		if(Sounds[c])
			stop_sample(Sounds[c]);
}
