#ifndef __OBJECT_H
#define __OBJECT_H

struct Object3d
{
	struct F
	{
		float Normal[3];
		float Distance;
		float SurfacePoint[3];
		bool Visible;
	} *Faces;
	struct L
	{
		int Faces[2];
		float Start[3], End[3];
		int Colour;
	} *Lines;

	int NumLines, NumFaces;
};

void DrawObject2d(float *obj);

Object3d *CreateObject3d(int NumFaces, int NumLines);
void co3dAddFace(float nx, float ny, float nz, float px, float py, float pz);
void co3dAddLine(int f1, int f2, float x1, float y1, float z1, float x2, float y2, float z2);
void FreeObject3d(Object3d *);

void DrawObject3d(Object3d *obj);
bool QueryPenetration(Object3d *obj, float *startpos, float *endpos);

#endif
