#include <math.h>
#include "Object.h"
#include "Primitives.h"
#include "MatrixStack.h"

void DrawObject2d(float *Info)
{
	while(1)
	{
		int c = (int)Info[0]; Info++;
		if(!c) return;

		float PosBuffer[4];
		PosBuffer[0] = Info[0];
		PosBuffer[1] = Info[1];
		Info += 2; c --;

		while(c--)
		{
			PosBuffer[2] = Info[0];
			PosBuffer[3] = Info[1];
			Info += 2;
			Line2f(PosBuffer[0], PosBuffer[1], PosBuffer[2], PosBuffer[3]);
			PosBuffer[0] = PosBuffer[2];
			PosBuffer[1] = PosBuffer[3];
		}
	}
}

Object3d *CObj;

Object3d *CreateObject3d(int NumFaces, int NumLines)
{
	CObj = new Object3d;
	CObj->NumLines = CObj->NumFaces = 0;
	CObj->Lines = new Object3d::L[NumLines];
	CObj->Faces = new Object3d::F[NumFaces];
	return CObj;
}

void FreeObject3d(Object3d *o)
{
	if(!o) return;
	delete[] o->Lines;
	delete[] o->Faces;
	delete o;
}

void co3dAddFace(float nx, float ny, float nz, float px, float py, float pz)
{
	float Divider = 1.0f / sqrt(nx*nx + ny*ny + nz*nz);
	CObj->Faces[CObj->NumFaces].Normal[0] = nx * Divider;
	CObj->Faces[CObj->NumFaces].Normal[1] = ny * Divider;
	CObj->Faces[CObj->NumFaces].Normal[2] = nz * Divider;

	CObj->Faces[CObj->NumFaces].SurfacePoint[0] = px;
	CObj->Faces[CObj->NumFaces].SurfacePoint[1] = py;
	CObj->Faces[CObj->NumFaces].SurfacePoint[2] = pz;

	CObj->Faces[CObj->NumFaces].Distance = px*nx + py*ny + pz*nz;

	CObj->NumFaces++;
}

void co3dAddLine(int f1, int f2, float x1, float y1, float z1, float x2, float y2, float z2)
{
	CObj->Lines[CObj->NumLines].Colour = RequestedColour;

	CObj->Lines[CObj->NumLines].Faces[0] = f1;
	CObj->Lines[CObj->NumLines].Faces[1] = f2;
	
	float Start[3], End[3];
	apply_matrix_f(CurrentMatrix, x1, y1, z1, &Start[0], &Start[1], &Start[2]);
	apply_matrix_f(CurrentMatrix, x2, y2, z2, &End[0], &End[1], &End[2]);

	CObj->Lines[CObj->NumLines].Start[0] = Start[0];
	CObj->Lines[CObj->NumLines].Start[1] = Start[1];
	CObj->Lines[CObj->NumLines].Start[2] = Start[2];
	CObj->Lines[CObj->NumLines].End[0] = End[0];
	CObj->Lines[CObj->NumLines].End[1] = End[1];
	CObj->Lines[CObj->NumLines].End[2] = End[2];

	CObj->NumLines++;
}

void DrawObject3d(Object3d *obj)
{
	/* calculate face visibility */
	int c = obj->NumFaces;
	while(c--)
	{
		obj->Faces[c].Visible = ApplyNormal(obj->Faces[c].Normal, obj->Faces[c].SurfacePoint) > 0;
	}

	/* draw any visible lines */
	c = obj->NumLines;
	while(c--)
	{
		if(obj->Faces[obj->Lines[c].Faces[0]].Visible || obj->Faces[obj->Lines[c].Faces[1]].Visible)
		{
			SetColour(obj->Lines[c].Colour);
			Line3f(obj->Lines[c].Start, obj->Lines[c].End);
		}
	}
}

bool QueryPenetration(Object3d *obj, float *startpos, float *endpos)
{
	/* try and find a plane both poss are outside of, test strike point of any intersected */
	int c = obj->NumFaces;
	while(c--)
	{
		float d1, d2;

		d1 = obj->Faces[c].Normal[0]*startpos[0] + obj->Faces[c].Normal[1]*startpos[1] + obj->Faces[c].Normal[2]*startpos[2] - obj->Faces[c].Distance;
		d2 = obj->Faces[c].Normal[0]*endpos[0] + obj->Faces[c].Normal[1]*endpos[1] + obj->Faces[c].Normal[2]*endpos[2] - obj->Faces[c].Distance;

		if(d1 > 0 && d2 > 0)
			return false;

		if(d1 > 0 && d2 < 0)
		{
			/* get strike point */
			float StrikePos[3];
			float Ratio;

			Ratio = d1 / (d1 - d2);
			StrikePos[0] = (1-Ratio)*startpos[0] + Ratio*endpos[0];
			StrikePos[1] = (1-Ratio)*startpos[1] + Ratio*endpos[1];
			StrikePos[2] = (1-Ratio)*startpos[2] + Ratio*endpos[2];

			/* try and get separation of strike point using some other plane */
			int ic = obj->NumFaces;
			while(ic--)
				if(ic != c)
				{
					if((obj->Faces[ic].Normal[0]*StrikePos[0] + obj->Faces[ic].Normal[1]*StrikePos[1] + obj->Faces[ic].Normal[2]*StrikePos[2] - obj->Faces[ic].Distance) > 0)
						break;
				}
			if(ic < 0) return true;
		}
	}

	return true;
}
