#ifndef __MAP_H
#define __MAP_H

#include "Object.h"

#define NOHIT	0
#define BADHIT	1
#define GOODHIT	2

class CMap
{
	public:
		CMap();
		~CMap();

		void Draw();
		void Setup(int round);

		void CentreOnTarget();
		void GetStartPos(float &Angle, float &Distance);
		float GetDistanceFromTarget(float *PlayerPos);

		int GetHit(float *StartPos, float *EndPos);

	private:
		class Node
		{
			public:
				Node();
				~Node();
				void Draw(float lowx, float lowy, float highx, float highy);
				void Setup(int level, int round, float lowx, float lowy, float highx, float highy);
				bool SetTarget(CMap *Parent, int level, int round, float lowx, float lowy, float highx, float highy);
				int GetHit(float *StartPos, float *EndPos, float lowx, float lowy, float highx, float highy);

				Object3d *Shape;
				Node *Children;
				bool Target;
		} *Tree, *Target;
		friend class Node;

		float TargetX, TargetY, TargetScale;
		float PlayerAngle, PlayerDistance;
};

extern CMap City;

#endif
