#include <stdio.h>
#include "ScreenUpdate.h"
#include "Primitives.h"
#include "ContentBase.h"
#include "AttractScreen.h"
#include "MatrixStack.h"
#include "Sound.h"
#include "Buildings.h"
#include "Player.h"

/* timer and quit button callback */
volatile int TimeVar;
void TimerFunc(void)
{
	TimeVar++;
}
END_OF_FUNCTION(TimerFunc);

volatile bool Quit = false;
void QuitFunc(void)
{
	Quit = true;
}
END_OF_FUNCTION(QuitFunc);

CContentBase *ContentStack[5];
int ContentPointer, PushPointer;
void PushContent(CContentBase *C)
{
	ContentStack[PushPointer++] = C;
}

float randf()
{
	return (float)rand() / RAND_MAX;
}

int randr(int r)
{
	int res = (int)(randf()*r);
	if(res == r) res--;
	return res;
}

#define SCRW_FS	1024
#define	SCRH_FS	768
#define SCRW_W	640
#define	SCRH_W	480

#define SCRW ((Fullscreen && HighRes) ? SCRW_FS : SCRW_W)
#define SCRH ((Fullscreen && HighRes) ? SCRH_FS : SCRH_W)

/* a TIMER_MULTIPLIER*50 BPS timer will be installed */
#define TIMER_MULTIPLIER	4

unsigned int GlobalTimer;

#define SetScreen()	\
			if(!SetupScreen(SCRW, SCRH, Fullscreen))\
			{\
				Fullscreen = false;\
				if(!SetupScreen(SCRW, SCRH, Fullscreen))\
				{\
					allegro_message("Unable to set base %dx%d resolution - %s", SCRW, SCRH, allegro_error);\
					Quit = true;\
				}\
			}

int main(int argc, const char *argv[])
{
	bool HighRes = false;
	bool Fullscreen = false;

	allegro_init();
	install_keyboard();
	install_timer();
	srand(time(NULL));
	
	FILE *Preferences = fopen("state.dat", "rb");
	if(Preferences)
	{
		int GFXMode = fgetc(Preferences);
		
		if(!feof(Preferences) && !(GFXMode&0xfc))
		{
			Fullscreen = (GFXMode&1) ? true : false;
			HighRes = (GFXMode&2) ? true : false;
		}

		int HR;
		HR = fgetc(Preferences);
		HR |= fgetc(Preferences) << 8;
		HR |= fgetc(Preferences) << 16;
		HR |= fgetc(Preferences) << 24;

		if(!feof(Preferences))
			HighRound = HR;

		fclose(Preferences);
	}
	
	SetScreen();

	SetupMatrixStack();
	SetupSound();
	SetupPrimitives();
	SetupBuildings();
	SetupBackground();

	LOCK_VARIABLE(TimeVar);
	LOCK_FUNCTION(TimerFunc);
	LOCK_FUNCTION(QuitFunc);

	set_close_button_callback(QuitFunc);
	install_int_ex(TimerFunc, BPS_TO_TIMER(TIMER_MULTIPLIER*50));

	PALETTE GrayScale;
	int c = 64;
	while(c--)
	{
		GrayScale[c].r = GrayScale[c].g = GrayScale[c].b = c;
		GrayScale[c+64].r = c; GrayScale[c+64].g = GrayScale[c+64].b = 0;
		GrayScale[c+128].r = 0; GrayScale[c+128].g = c; GrayScale[c+128].b = 0;
		GrayScale[c+192].r = GrayScale[c+192].g = 0; GrayScale[c+192].b = c;
	}
	set_palette(GrayScale);

	GlobalTimer = 0;
	ContentPointer = 0;
	ContentStack[0] = new CAttractScreen;

	int OldEnter = 0, OldEsc = 0, OldF2 = 0;
	TimeVar = 0;

	bool SkipFrame = false;
	ContentStack[ContentPointer]->Enter();
	while(!Quit)
	{
		PushPointer = ContentPointer+1;
		int res = ContentStack[ContentPointer]->Update();

		/* a hard defined key */
		if((key[KEY_ESC]^OldEsc)&key[KEY_ESC])
		{
			while(ContentPointer > 1)
			{
				ContentStack[ContentPointer]->Exit();
				delete ContentStack[ContentPointer];
				ContentPointer--;
			}
			res = CBO_ASCEND;
		}
		OldEsc = key[KEY_ESC];

		switch(res)
		{
			default: break;
			case CBO_ASCEND: ContentStack[ContentPointer]->Exit(); delete ContentStack[ContentPointer]; ContentPointer--; if(ContentPointer >= 0) ContentStack[ContentPointer]->Enter(); break;
			case CBO_DESCEND: ContentStack[ContentPointer]->Exit(); ContentPointer++; ContentStack[ContentPointer]->Enter(); break;
			case CBO_INTERCHANGE:
				ContentStack[ContentPointer]->Exit();
				delete ContentStack[ContentPointer];
				ContentStack[ContentPointer] = ContentStack[ContentPointer+1];
				ContentStack[ContentPointer]->Enter();
			break;
			case CBO_INTERCHANGE_DESCEND:	/* okay - getting a bit silly now */
				ContentStack[ContentPointer]->Exit();
				delete ContentStack[ContentPointer];
				ContentStack[ContentPointer] = ContentStack[ContentPointer+1];
				ContentStack[ContentPointer+1] = ContentStack[ContentPointer+2];
				ContentPointer++;
				ContentStack[ContentPointer]->Enter();
			break;
			case CBO_INTERCHANGE_ASCEND:	/* very silly indeed */
				ContentStack[ContentPointer]->Exit();
				delete ContentStack[ContentPointer];
				delete ContentStack[ContentPointer-1];
				ContentStack[ContentPointer-1] = ContentStack[ContentPointer+1];
				ContentPointer--;
				ContentStack[ContentPointer]->Enter();
			break;
		}
		if(ContentPointer < 0) break;
		if(!SkipFrame)
		{
			if(gfx_capabilities&GFX_HW_FILL)
			{
				ClearScreen();
				LockScreen();
			}
			else
			{
				LockScreen();
				ClearScreen();
			}
			ContentStack[ContentPointer]->Draw();
			ReleaseScreen();

			/* grab a screenshot if requested */
			if(key[KEY_F12] || key[KEY_F1])
			{
				BITMAP *temp = create_bitmap(SCREEN_W, SCREEN_H);
				blit(CurrentScreen, temp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
				char Filename[530];
				get_executable_name(Filename, 512);

				int SaveNum = 0;
				while(1)
				{
					sprintf(get_filename(Filename), "shot%04d.bmp", SaveNum);
					if(!exists(Filename) || (SaveNum == 9999)) break;
					SaveNum++;
				}

				save_bmp(Filename, temp, GrayScale);
				destroy_bitmap(temp);
			}

			/* swap buffers */
			SwapBuffer();
		}

		/* try and switch to or from fullscreen if requested */
		bool ForceChange = false;
		if((key[KEY_F2]^OldF2)&key[KEY_F2] && Fullscreen)
		{
			HighRes ^= true;
			ForceChange = true;
		}

		if(((key[KEY_ENTER]^OldEnter)&key[KEY_ENTER]) || ForceChange)
		{
			Fullscreen ^= !ForceChange;
			SetScreen();
			set_palette(GrayScale);
		}
		OldEnter = key[KEY_ENTER];
		OldF2 = key[KEY_F2];

		/* limit to 50 fps */
		unsigned int Wait = TIMER_MULTIPLIER - TimeVar;
		if(Wait <= TIMER_MULTIPLIER)
		{
			rest((20 * Wait) / TIMER_MULTIPLIER);
			SkipFrame = false;
			TimeVar -= TIMER_MULTIPLIER;
		}
		else
		{
			SkipFrame = (GlobalTimer&16) ? false : true;
			TimeVar = 0;
		}
		GlobalTimer++;
	}

	if(ContentPointer >= 0)
	while(ContentPointer--)
		delete ContentStack[ContentPointer];
		
	ShutdownBackground();
	ShutdownBuildings();
	ShutdownSound();
	ShutdownScreen();

	Preferences = fopen("state.dat", "wb");
	if(Preferences)
	{
		fputc((Fullscreen? 1 : 0) | (HighRes ? 2 : 0), Preferences);
		fputc(HighRound&255, Preferences);
		fputc((HighRound >> 8)&255, Preferences);
		fputc((HighRound >> 16)&255, Preferences);
		fputc((HighRound >> 24)&255, Preferences);
		fclose(Preferences);
	}

	return 0;
}
END_OF_MAIN();
