#include <math.h>
#include <string.h>
#include "LaunchScreen.h"
#include "MatrixStack.h"
#include "TextWriter.h"
#include "Buildings.h"
#include "Map.h"
#include "Player.h"
#include "Primitives.h"
#include "GuideScreen.h"
#include "Sound.h"

CLaunchScreen::CLaunchScreen()
{
	LocTimer = 0;
	Power = 0;
	OldSpace = 0;
	SpaceReleased = key[KEY_SPACE] ? false: true;
	
	PlayerView[12] = LaunchView[12];
	PlayerView[13] = LaunchView[13];
	PlayerView[14] = LaunchView[14];
}

int CLaunchScreen::Update()
{
	LocTimer++;

	float YRot = 0, XRot = 0;
	if(key[KEY_UP]) YRot-=0.25;
	if(key[KEY_DOWN]) YRot+=0.25;
	if(key[KEY_RIGHT]) XRot-=0.25;
	if(key[KEY_LEFT]) XRot+=0.25;
//	if(key[KEY_RIGHT]) XRot-=5;
//	if(key[KEY_LEFT]) XRot+=5;

	/* rotate  */
	alRotateMatrix(LaunchView, YRot, LaunchView[0], LaunchView[1], LaunchView[2]);
	alRotateMatrix(LaunchView, XRot, 0, 1, 0);

	bool Launch = false;
	if(key[KEY_SPACE])
	{
		if(SpaceReleased)
		{
			Power += 0.015f;
			if(Power >= 1.0f)
				Launch = true;
		}
	}
	else
	{
		if(SpaceReleased)
			Launch = true;
		SpaceReleased = true;
	}

	if(OldSpace && Launch && SpaceReleased)
	{
		/* duplicate view matrix */
		memcpy(PlayerView, LaunchView, 16*sizeof(float));

		/* launch!! */
		PlayerVec[0] = PlayerView[8]*Power*8.0f;
		PlayerVec[1] = PlayerView[9]*Power*8.0f;
		PlayerVec[2] = PlayerView[10]*Power*8.0f;

		CGuideScreen *NewScreen = new CGuideScreen;
		PushContent(NewScreen);

		TriggerSoundEvent(SND_PULSE);
		return CBO_INTERCHANGE;
	}
	OldSpace = key[KEY_SPACE];

	return CBO_CONTINUE;
}

void CLaunchScreen::Draw()
{
	float ViewMatrix[16];
	alCopyInvertMatrix(LaunchView, ViewMatrix);

	/* add city, as viwed from player */
	alPushMatrix();
		alMultMatrix(ViewMatrix);
		AddBackground();
		City.Draw();
	alPopMatrix();

	/* add crosshair & distance */
	AddHud();

	/* add power bar */
	SetColour(GREEN);
	Line3f(0.9, 0.9, 1.8, 1, 0.9, 1.8);
	Line3f(0.9, -0.9, 1.8, 1, -0.9, 1.8);

	SetColour(RED);
	float ypos = (Power*1.8f) - 0.9f;
	Line3f(0.9, ypos, 1.8, 1, ypos, 1.8);
	Line3f(0.95, ypos, 1.8, 0.95, -0.9, 1.8);
}
