#include <math.h>
#include "GuideScreen.h"
#include "Player.h"
#include "Map.h"
#include "MatrixStack.h"
#include "LaunchScreen.h"
#include "Sound.h"
#include "PenaltyScreen.h"
#include "GameOverScreen.h"

#define GRAVITY		0.01
#define DAMPING		0.999
#define INFLUENCE	0.00

#define	VECMULT		1.0f

void CGuideScreen::Enter()
{
	Bonus = true;
}

int CGuideScreen::Update()
{
	float YRot = 0, XRot = 0;
	if(key[KEY_RIGHT]) {YRot-=0.25f; Bonus = false;}
	if(key[KEY_LEFT]) {YRot+=0.25f; Bonus = false;}
	
	float XRotFactor;

	switch(Round / 5)
	{
		case 0:	/* 1-4 */
			XRotFactor = 0.1f;
		break;
		case 1: /* 5-14 */
		case 2:
			XRotFactor = 0.075f;
		break;
		case 3:	/* 15-24 */
		case 4:
			XRotFactor = 0.06f;
		break;
		case 5:
		case 6: /* 25 - 34 */
			XRotFactor = 0.04f;
		break;
		default: /* 35+ */
			XRotFactor = 0.02f;
		break;
	}

	if(key[KEY_UP]) {XRot -= XRotFactor; Bonus = false;}
	if(key[KEY_DOWN]) {XRot += XRotFactor; Bonus = false;}

	MATRIX_f RotMat;
	get_vector_rotation_matrix_f(&RotMat, PlayerView[4], PlayerView[5], PlayerView[6], (YRot*128.0f)/180.0f);
	apply_matrix_f(&RotMat, PlayerVec[0], PlayerVec[1], PlayerVec[2], &PlayerVec[0], &PlayerVec[1], &PlayerVec[2]);
	get_vector_rotation_matrix_f(&RotMat, PlayerView[0], PlayerView[1], PlayerView[2], (XRot*128.0f)/180.0f);
	apply_matrix_f(&RotMat, PlayerVec[0], PlayerVec[1], PlayerVec[2], &PlayerVec[0], &PlayerVec[1], &PlayerVec[2]);

	/* update PlayerVec */
	PlayerVec[1] -= GRAVITY;

	/* update PlayerView */
	float len = 1.0f / sqrt(PlayerVec[0]*PlayerVec[0] + PlayerVec[1]*PlayerVec[1] + PlayerVec[2]*PlayerVec[2]);

	// front vector
	PlayerView[8] = PlayerVec[0] * len;
	PlayerView[9] = PlayerVec[1] * len;
	PlayerView[10] = PlayerVec[2] * len;

	// side vector
	len = 1.0f / sqrt(PlayerView[10]*PlayerView[10] + PlayerView[8]*PlayerView[8]);
	PlayerView[0] = PlayerView[10] * len;
	PlayerView[1] = 0;
	PlayerView[2] = -PlayerView[8] * len;

	// up vector
	cross_product_f(PlayerView[8], PlayerView[9], PlayerView[10], PlayerView[0], PlayerView[1], PlayerView[2], &PlayerView[4], &PlayerView[5], &PlayerView[6]);

	bool BadEnding = false;
	float EndPos[3];
	
	EndPos[0] = PlayerView[12] + PlayerVec[0];
	EndPos[1] = PlayerView[13] + PlayerVec[1];
	EndPos[2] = PlayerView[14] + PlayerVec[2];

	switch(City.GetHit(&PlayerView[12], EndPos))
	{
		default: break;
		case BADHIT:	BadEnding = true; break;/* hit the wrong thing */
		case GOODHIT: /* hit the right thing */
			if(Bonus)
			{
				/* report a bonus */
//				CBonusScreen *NewScreen = new CBonusScreen;
//				PushContent(NewScreen);
//				return CBO_INTERCHANGE;
			}
			else
				NumMissiles--;
			return CBO_ASCEND;
	}

	PlayerView[12] = EndPos[0];
	PlayerView[13] = EndPos[1];
	PlayerView[14] = EndPos[2];

	if(BadEnding || PlayerView[13] < 0)	/* ground hit */
	{
		TriggerSoundEvent(SND_SHOT);

		/* dec num missiles */
		NumMissiles--;
		if(BadEnding)
			NumMissiles--;
		if(NumMissiles > 0)
		{
			/* set up for a new launch */
			CLaunchScreen *NewScreen = new CLaunchScreen;
			PushContent(NewScreen);

			if(BadEnding)
			{
				/* report a penalty if relevant */
				CPenaltyScreen *NewScreen = new CPenaltyScreen;
				PushContent(NewScreen);
				return CBO_INTERCHANGE_DESCEND;
			}

			return CBO_INTERCHANGE;
		}
		else
		{
			/* gameover */
			CGameOverScreen *NewScreen = new CGameOverScreen;
			PushContent(NewScreen);
			return CBO_INTERCHANGE_ASCEND;
		}
	}

	return CBO_CONTINUE;
}

void CGuideScreen::Draw()
{
	float ViewMatrix[16];
	alCopyInvertMatrix(PlayerView, ViewMatrix);

	/* add city, as viwed from player */
	alPushMatrix();
		alMultMatrix(ViewMatrix);
		AddBackground();
		City.Draw();
	alPopMatrix();

	/* add crosshair & distance */
	AddHud();
}
