#include "GameScreen.h"
#include "MatrixStack.h"
#include "TextWriter.h"
#include "LevelIntroScreen.h"
#include "Map.h"
#include "Player.h"
#include "Sound.h"

#define DISPLAYTIME	100

CGameScreen::CGameScreen()
{
	Round = NumMissiles = 0;
}

void CGameScreen::Exit()
{
	if(Round > HighRound)
		HighRound = Round;
}

void CGameScreen::Enter()
{
	RandomiseBackground();
	TriggerSoundEvent(SND_STARTGAME);
	LocTimer = 0;
	Round++;

	if(Round < 5)
		NumMissiles += 3;
	else
		if(Round < 13)
			NumMissiles += 2;
		else
			NumMissiles++;

	City.Setup(Round);
}

int CGameScreen::Update()
{
	LocTimer++;
	if(LocTimer == DISPLAYTIME)
	{
		CLevelIntroScreen *LevelIntroScreen = new CLevelIntroScreen();
		PushContent(LevelIntroScreen);
		return CBO_DESCEND;
	}
	return CBO_CONTINUE;
}

void CGameScreen::Draw()
{
	SetColour(WHITE);
	alPushMatrix();
		alTranslatef(0.0f, 0.0, (1.0f - ((float)LocTimer / (float)DISPLAYTIME))*27.0f);
		WriteText(TP_CENTRE, "City %d", Round);
	alPopMatrix();
	
	if(Bonus)
	{
		SetColour(GREEN);
		alPushMatrix();
			alTranslatef(0.0f, -14.0f, 20.0f);
			WriteText(TP_CENTRE, "Great shot!!");
		alPopMatrix();
	}
}
