#include "GameOverScreen.h"
#include "TextWriter.h"
#include "MatrixStack.h"
#include "Player.h"

CGameOverScreen::CGameOverScreen()
{
	OldSpace = LocTimer = 0;
}

int CGameOverScreen::Update()
{
	LocTimer++;
	if((key[KEY_SPACE]^OldSpace)&OldSpace)
		return CBO_ASCEND;
	OldSpace = key[KEY_SPACE];

	return CBO_CONTINUE;
}

void CGameOverScreen::Draw()
{
	SetColour(RED);
	alPushMatrix();
		alTranslatef(0, 0, 8.0f);
		alRotatef(-LocTimer*0.75f, 0, 0, 1);
		alRotatef(LocTimer, 0.25f, 0.5f, 0);
		WriteText(TP_CENTRE, "Game Over");
	alPopMatrix();

	SetColour(GREEN);
	alPushMatrix();
		alTranslatef(0.0f, -11.0f, 16.0f);
		WriteText(TP_CENTRE, "City %d", Round);
	alPopMatrix();
}
