#include <math.h>
#include "Buildings.h"
#include "MatrixStack.h"

Object3d *BuildingList[NUM_BUILDINGS+1];

#define CYLINDER_EDGES	8
void SetupBuildings()
{
	SetColour(NOCHANGE);

	/* cube */
	BuildingList[SQUARE] = CreateObject3d(6, 12);
	alPushMatrix();
		alLoadIdentity();

		co3dAddFace(1, 0, 0, 1, 0, 0);
		co3dAddFace(-1, 0, 0, -1, 0, 0);
		co3dAddFace(0, 1, 0, 0, 1, 0);
		co3dAddFace(0, -1, 0, 0, -1, 0);
		co3dAddFace(0, 0, 1, 0, 0, 1);
		co3dAddFace(0, 0, -1, 0, 0, -1);

		co3dAddLine(0, 2,	1, 1, -1, 1, 1, 1);
		co3dAddLine(0, 3,	1, -1, -1, 1, -1, 1);
		co3dAddLine(0, 4,	1, -1, 1, 1, 1, 1);
		co3dAddLine(0, 5,	1, -1, -1, 1, 1, -1);

		co3dAddLine(1, 2,	-1, 1, -1, -1, 1, 1);
		co3dAddLine(1, 3,	-1, -1, -1, -1, -1, 1);
		co3dAddLine(1, 4,	-1, -1, 1, -1, 1, 1);
		co3dAddLine(1, 5,	-1, -1, -1, -1, 1, -1);

		co3dAddLine(2, 4,	-1, 1, 1, 1, 1, 1);
		co3dAddLine(2, 5,	-1, 1, -1, 1, 1, -1);

		co3dAddLine(3, 4,	-1, -1, 1, 1, -1, 1);
		co3dAddLine(3, 5,	-1, -1, -1, 1, -1, -1);
	alPopMatrix();

	/* cylinder */
	BuildingList[CYLINDER] = CreateObject3d(CYLINDER_EDGES+2, CYLINDER_EDGES*3);
	alPushMatrix();
		alLoadIdentity();

		/* create "top" and "bottom" edges */
		co3dAddFace(0, 1, 0, 0, 1, 0);
		co3dAddFace(0, -1, 0, 0, -1, 0);

		/* create outer edges & rims */
		int c;
		for(c = 0; c < CYLINDER_EDGES; c++)
		{
			float Points[2][3], Normal[3];
			float ang1, ang2;
			
			ang1 = ((float)c / CYLINDER_EDGES)*2*AL_PI;
			ang2 = ((float)(c+1) / CYLINDER_EDGES)*2*AL_PI;

			Points[0][0] = sin(ang1);
			Points[0][1] = -1;
			Points[0][2] = cos(ang1);

			Points[1][0] = sin(ang2);
			Points[1][1] = -1;
			Points[1][2] = cos(ang2);
			
			Normal[0] = Points[0][2] - Points[1][2];
			Normal[1] = 0;
			Normal[2] = Points[1][0] - Points[0][0];

			co3dAddFace(Normal[0], Normal[1], Normal[2], Points[0][0], Points[0][1], Points[0][2]);
			co3dAddLine(1, c+2,	Points[0][0], Points[0][1], Points[0][2], Points[1][0], Points[1][1], Points[1][2]);
			co3dAddLine(0, c+2,	Points[0][0], Points[0][1]+2, Points[0][2], Points[1][0], Points[1][1]+2, Points[1][2]);
			
			int c2 = (c+1)%CYLINDER_EDGES;
			co3dAddLine(c+2, c2+2, Points[1][0], Points[1][1], Points[1][2], Points[1][0], Points[1][1]+2, Points[1][2]);
		}

	alPopMatrix();

	/* cone */
	BuildingList[CONE] = CreateObject3d(CYLINDER_EDGES+1, CYLINDER_EDGES*2);
	alPushMatrix();
		alLoadIdentity();

		/* create "bottom" edge */
		co3dAddFace(0, -1, 0, 0, -1, 0);

		/* create outer edges & rims */
		for(c = 0; c < CYLINDER_EDGES; c++)
		{
			float Points[2][3], Normal[3];
			float ang1, ang2;
			
			ang1 = ((float)c / CYLINDER_EDGES)*2*AL_PI;
			ang2 = ((float)(c+1) / CYLINDER_EDGES)*2*AL_PI;

			Points[0][0] = sin(ang1);
			Points[0][1] = -1;
			Points[0][2] = cos(ang1);

			Points[1][0] = sin(ang2);
			Points[1][1] = -1;
			Points[1][2] = cos(ang2);

			cross_product_f(Points[1][0], Points[1][1]-1, Points[1][2], Points[1][0] - Points[0][0], Points[1][1] - Points[0][1], Points[1][2] - Points[0][2], &Normal[0], &Normal[1], &Normal[2]);

			co3dAddFace(Normal[0], Normal[1], Normal[2], Points[0][0], Points[0][1], Points[0][2]);
			co3dAddLine(0, c+1,	Points[0][0], Points[0][1], Points[0][2], Points[1][0], Points[1][1], Points[1][2]);

			int c2 = (c+1)%CYLINDER_EDGES;
			co3dAddLine(c+1, c2+1, Points[1][0], Points[1][1], Points[1][2], 0, 1, 0);
		}
		
	alPopMatrix();

	/* "crater" */
	BuildingList[CRATER] = CreateObject3d(1, 8);
	alPushMatrix();
		alLoadIdentity();
		
		/* due to the way I've just sketched this on graph paper */
		alTranslatef(0, -1, 0);
		alScalef( 1.0f/25.0f, 1.0f/25.0f, 1.0f/25.0f);

		/* create single face */
		co3dAddFace(0, 1, 0, 0, -1, 0);

		/* add lines */
			co3dAddLine(0, 0,	3.0f, 0.0f, 15.0f,		4.0f, 0.0f, 8.0f);
			co3dAddLine(0, 0,	4.0f, 0.0f, 8.0f,		-3.0f, 0.0f, 0.0f);
			co3dAddLine(0, 0,	-2.0f, 0.0f, 18.0f,		-8.0f, 0.0f, 5.0f);
			co3dAddLine(0, 0,	-8.0f, 0.0f, 5.0f,		1.0f, 0.0f, -5.0f);
			co3dAddLine(0, 0,	1.0f, 0.0f, -5.0f,		16.0f, 0.0f, -2.0f);
			co3dAddLine(0, 0,	1.0f, 0.0f, -5.0f,		-9.0f, 0.0f, -16.0f);
			co3dAddLine(0, 0,	-9.0f, 0.0f, -16.0f,	-14.0f, 0.0f, -12.0f);
			co3dAddLine(0, 0,	-3.0f, 0.0f, -9.0f,		4.0f, 0.0f, -18.0f);
	alPopMatrix();
}

void ShutdownBuildings()
{
	int c = NUM_BUILDINGS;
	while(c--)
		FreeObject3d(BuildingList[c]);
}

Object3d *GetBuilding(int num)
{
	return (num <= NUM_BUILDINGS) ? BuildingList[num] : NULL;
}
