/*
Name: Revenge of the Ketchup II  (main.cpp)
Author: Richard Cassan  
Description: The main source file for Revenge of the Ketchup II.
Date: 20/07/02 14:50
*/

#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CAnim.h"
#include "CObject.h"
#include "CParts.h"
#include "CTile.h"
#include "CTileSet.h"
#include "CObjectSet.h"
#include "CDialog.h"
#include "CCinematic.h"
#include "CMapObject.h"
#include "CMapObjects.h"
#include "CForeground.h"
#include "CMap.h"
#include "CProjectile.h"
#include "CProjectiles.h"
#include "CCharacter.h"
#include "CEnims.h"
#include "CLevel.h"
#include "CLevels.h"
#include "CSaveState.h"
#include "CPlayer.h"
#include "CWorld.h"
#include "CRevengeScript.h"
#include "CMenuItem.h"
#include "CMenu.h"
#include "CEnvEffect.h"

#define max_object_types    150
#define MAX_UNDOS   5

#define target_fps  30

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define Rad2AllegroDeg  40.74366543153


#define SEC_HISTORY 25
#define TARGET_FPS  30
#define BPS 30


void allegro_startup(void);
void calc_fps(void);
void draw_all(void);
void move_all(void);
void move_camera(void);
void move_cinematic_camera(void);
void init_game(void);
void edit_mode(void);
void get_keys(void);
void place_platforms(void);
void slide_show(char *filename);
void fade_to(BITMAP *second);
void clean_up_box(void);
void paused_screen(void);
void menu(void);
void get_game_name(int n);
void set_game_from_saved(int n);
void move_and_check_projs(void);
void reset_all(void);
void display_item_counts(void);
void play_song(char *filename);
void stop_song(void);
void floodFillTiles(int x,int y);
void restartLevel(void);
void displayBackgr(void);
void loadLevel(void);
void quit_level_menu_draw(void);
void quit_level_menu_move(void);

void esc_menu_draw(void);
void esc_menu_move(void);

void move_dying(void);
void draw_dying(void);

void savePrevMap(void);     //for undo
void restorePrevMap(void);  //for undo
bool doText(char *buf);

void calcFps(void);
void displayFps(void);

void setupEnvEffects(void);
void update_music_state(void);
void update_music_volume(void);

//will orgaize the objects for use in the editor using the object_map array
void organizeEditorObjects(void);   
void start_game_after_opening_cin(void);

/*****************************TIMER STUFF**************************************/
int igLoops=0;
int ilLoops=0;
volatile int msec=0;     
void goSec()
{
    msec++;
}
END_OF_FUNCTION(goSec);

int secHistory[SEC_HISTORY];
int secHistoryDepth;
float fps;
int frames_skipped=0;
/******************************************************************************/


volatile int sec=0,sec2=0;
int cycles=0,cycles2=0;
float actual_seconds;

int display_item_counter;   //counter for how long the item pictures will be drawn on the screen
int trans_level=0;

int cur_page=0;
//bool hardware_accel=true;

bool editing=false;
bool tile_edit=false;
bool KeyPressed=false;
int mouse_clicked=false;
int wait=0;             //for moving the edit square in edit mode
float bx1=-1,by1=-1;    //for drawing a selection box
bool clean_up_mode=false;

bool paused=false;
bool menu_on=true;
bool quit_level_menu_on=false;
bool esc_menu_on=false;
int dying=0;

/*************FOR THE MUSIC PLAYING*************/
float current_volume=.7f;
float target_volume=.7f;
char next_song[200]="none";
bool song_on=false;
bool fading_out=false;
/**********************************************/

/*************FOR THE MAIN MENU****************/
int menu_num=1;
char player_name[50];
int curMessagePos=0;
/**********************************************/


/************FOR THE EDIT MODE*****************/
int picked_up_object=-1 , picked_up_object2=-1;
bool deleting=false;        //whether or not an object has been deleted thsi cycle

int iEditx=0 , iEdity=0;    //the x y position for the edit box;
int iEditSize=32;
int current_layer=1;
int current_tile=1;
int current_object=0;
int number_of_objects=0;
int pointer_num=0;
/***********************************************/



bool quit_game=false;
bool quit_level=false;

void go_sec(void);
void go_sec()
	{
    sec++;
    sec2++;
    msec++;
	}
END_OF_FUNCTION(go_sec);

BITMAP *backgr, *bTemp, *bmpWeb, *backgr3;
BITMAP *page[2];

DUH *current_song;
AL_DUH_PLAYER *mod_player;

DATAFILE *data,*sounds;

CTile tTile1, tTemp;
CTileSet tsTileSet1;
CObjectSet osObjectSet1;
CEnims enims;
CLevels levels;
CWorld world1(&levels);
CMapObject ob1;
CMapObject object[max_object_types];    //holds one of every object for use in the map editor
int object_map[max_object_types];       //object_map[4] will contain the array index for the object in the above array
Point pTemp;
CParts pParts;
CSaveState game[4];     //the saved games
CAnim jumping_fry;
CProjectiles projs;

CMap mMap1;             //the map that is being play on
CMapObjects oObjects1;  //all the object that are being used
CPlayer player;         //the player's info (lives, level, score)
CDialog dialog;         //all the dialog for the game

CMenu mi,main_menu;
CEnvEffect env_effect;
EffectAtts env_effect_atts[10];

FILE *fp;


CMap prevMaps[MAX_UNDOS];   //for undo
int prevMap=-1;     //for undo

float s_x=0,s_y=0;
float lookx=0,looky=0;


ob obPlayer= {0,-1,"animations/ketchup.anm","none",-1,-1,-1,-1,-1,-1,true,true,false,true};

float cos_rad;
float cos_deg;

bool selecting_level=false;
bool splashing_level=false;

int iLogicLoops=0, iGraphicsLoops=0;

CCinematic ingameCin;
CCinematic cin1;
int global_game_selected=0;


int main() 
{         
    int iRunGameCounter=0;
    //dumb_resampling_quality=0;
/*
    printf("CTile: %f\n",(float)sizeof(CTile)/1000000);
    printf("CTileSet: %f\n",(float)sizeof(CTileSet)/1000000);
    printf("CObjectSet: %f\n",(float)sizeof(CObjectSet)/1000000);
    printf("CEnims: %f\n",(float)sizeof(CEnims)/1000000);
    printf("CLevels: %f\n",(float)sizeof(CLevels)/1000000);
    printf("CMapObject: %f\n",(float)(sizeof(CMapObject)*40)/1000000);
    printf("CSaveState: %f\n",(float)(sizeof(CSaveState)*4)/1000000); 
    printf("CAnim: %f\n",(float)sizeof(CAnim)/1000000);
    printf("CProjectiles: %f\n",(float)sizeof(CProjectiles)/1000000);
    printf("CMap: %f\n",(float)sizeof(CMap)/1000000);
    printf("CMapObjects: %f\n",(float)sizeof(CMapObjects)/1000000);
    printf("CPlayer :%f\n",(float)sizeof(CPlayer)/1000000);
    system("pause");
*/
    allegro_startup();
      
   // play_sample((SAMPLE*)data[bond_theme1].dat,1000,250,FALSE);
     
 /*   clear(screen);
    BITMAP *sub = create_sub_bitmap(screen,160,100,320,200);
    //play_sample((SAMPLE*)data[bond_theme1].dat,100,125,1000,FALSE);
    rest(5100);
    play_memory_fli(data[bond1].dat,sub,false,NULL);
    destroy_bitmap(sub);       */

  //  slide_show("slides.dat");
  

    world1.loadWorld("world.world");
    //world1.splashWorld(screen,(FONT*)data[f1].dat,200);
    

    dialog.load("dialog.txt");
    //dialog.print(0,screen,font,40,40,200,makecol(255,255,255));
    //dialog.print(1,screen,font,40,200,300,makecol(255,255,255));
    

    RGB c1={100,0,0},c2={255,0,0},c3={100,25,0},c4={255,50,0};
    itemInfo info1={(FONT*)data[f2].dat,c1,c2,c3,c4};
    
    mi.init();
    
    mi.add_menu_item("MUSIC QUALITY",info1,0,0);
    mi.add_subitem(0,"MAX");
    mi.add_subitem(0,"HIGH");
    mi.add_subitem(0,"MEDIUM");
    mi.add_subitem(0,"LOW");
    
    mi.add_menu_item("MUSIC VOLUME",info1,0,30);
    mi.add_subitem(1,"sliderbar");

    mi.add_menu_item("FX VOLUME",info1,0,60);
    mi.add_subitem(2,"sliderbar");
    
    //readkey();
  /*  while(!key[KEY_ESC])
    {
        rectfill(backgr,0,0,640,480,makecol(0,0,0));
        

        mi.draw_menu(backgr,200,200);           
        mi.do_menu();    
              
        blit(backgr,screen,0,0,0,0,640,480);
    }*/
  

//    ingameCin.start();

   
    if(menu_on==false)
    {
        reset_all();
        set_game_from_saved(0);
        play_song("music/DMOON.IT");
    }
    play_song("music/GLDNPHNX.IT");
    while(key[KEY_ENTER]){poll_keyboard();}
    
    //play_song("music/CRIMSON.IT");
    //play_midi((MIDI*)data[valley_clouds].dat,TRUE);


    sec=0;
    iLogicLoops=0;
    iGraphicsLoops=0;

    int incr=(int)((1/(float)TARGET_FPS) * (float)BPS);
    int count=msec+incr;

    while(quit_game==false)
    {    
        update_music_state();
        if(msec>=(int)floor(count))
            update_music_volume();

        al_poll_duh(mod_player);
        poll_keyboard();

        if(cin1.isOn()==true)
        {
            if(msec>=(int)floor(count))
            {
                //clear(backgr);
                cin1.move(&player,(int)s_x,(int)s_y);
                    
                
            
                displayBackgr();
                count=msec + incr;
            }
            cin1.draw(backgr);
            
            if(key[KEY_ESC])
            {
                //cinOn=false;
                cin1.end();
                while(key[KEY_ESC]){poll_keyboard();}
            }
            
            if(cin1.isOn()==false)
            {
                cin1.unload();
                KeyPressed=true;   
                start_game_after_opening_cin();
            } 
        }
        
        else if(selecting_level==true)
        {
            
            //while(iLogicLoops / ((float)sec/1000) < target_fps)
            if(msec>=(int)floor(count))
            {
                //iLogicLoops++;
                rectfill(backgr,0,0,backgr->w,backgr->h,makecol(0,0,0));
                world1.selectLevel(backgr,(FONT*)data[f7].dat,data,&player);
                
                
                if(KeyPressed==false)
                {
                    if(key[KEY_ESC])
                    {
                        selecting_level=false;
                        menu_num=1;
                        menu_on=true;   
                    }    
                    if(key[KEY_ENTER])
                    {
                        env_effect.stop_effect();
                        //make sure level is not locked
                        if(player.ret_level_state(world1.retSelectedLevel()) == LEVEL_UNPLAYED ||
                           player.ret_level_state(world1.retSelectedLevel()) == LEVEL_PLAYED )
                        {                   
                            selecting_level=false;
                            splashing_level=true;  
                            stop_song();  
                        }  
                        else if(player.ret_level_state(world1.retSelectedLevel())==LEVEL_LOCKED)
                            play_sample((SAMPLE*)data[sound07].dat,100,125,1000,FALSE);
                    }
                }    
                if(key[KEY_ESC] || key[KEY_ENTER])
                    KeyPressed=true;
                else
                    KeyPressed=false;
                
                count=msec + incr;
                
            }
            displayBackgr();
        }
        else if(splashing_level==true)
        {
            if(msec>=(int)floor(count))
            {
                player.splash_level(world1.retSelectedLevel(),backgr,(FONT*)data[f1].dat);
                
                //play_sample((SAMPLE*)data[menu_open].dat,100,125,1000,FALSE);
                
                //while(!key[KEY_ENTER]) { al_poll_duh(mod_player); }
                //while(key[KEY_ENTER]) { al_poll_duh(mod_player); }
                if(KeyPressed==true)
                {
                    if(!key[KEY_ENTER])
                        KeyPressed=false;   
                }    
                
                else if(KeyPressed==false && key[KEY_ENTER])
                {
                    player.go_to_level(world1.retSelectedLevel());
                    loadLevel();  
                    play_song(/*"music/DMOON.IT"*/player.ret_cur_song_filename());
                    KeyPressed=true;
                    splashing_level=false;
                    iGraphicsLoops=0;
                    
                    if(mMap1.ret_background()==DEATH_BACKGROUND)
                    {
                        env_effect.set_effect(&env_effect_atts[RAIN]);
                        env_effect.start_effect(false,(int)s_x,(int)s_y,300);    
                    }
                }    
                count=msec + incr;
                 
            }  
            displayBackgr();    
        }    
                
        else if(menu_on==true)
        {
            //while(iLogicLoops / ((float)sec/1000) < target_fps && menu_on==true)
            //    menu();
            if(msec>=(int)floor(count))
            {
                menu();
                count=msec + incr;
            }
            
        }
        else
        {
//            calcFps(); 
            if(msec>=count)
            {
                ilLoops++;
                //logicLoop();
                //al_poll_duh(mod_player);
                
                if(ingameCin.isOn()==true && iRunGameCounter==0)
                {
                    int ret=ingameCin.move(&player,(int)s_x,(int)s_y);
                     move_cinematic_camera();
                     player.return_character()->not_left_or_right();
                     
                     if(ingameCin.getMoveDuringCin()==true)
                        move_all();
//                    if(ret==CIN_FINISHED)
//                        inGameCinOn=false;
                    if( ret<0) //means to run the game for a few frames
                        iRunGameCounter=-ret;
                }
                else if(paused==true)
                {
                
                }
                else if(quit_level_menu_on==true)
                {
                    quit_level_menu_move();
                }
                else if(esc_menu_on==true)
                {
                    esc_menu_move();
                }
                else if(dying>0)    //ketchup is dying, so play the dying anim
                {
                    move_dying();

                    //character.
                }
                else
                {
                    if(ingameCin.isOn()==false)
                        get_keys();
                    else        //means an ingame cinematic is on
                    {
                        player.return_character()->not_left_or_right();
                    }
                    
                    if(editing==true)
                        edit_mode();
                    else
                    {
                        move_all();
                        move_camera();
                    }
                        

                }
                
                if(iRunGameCounter>0)
                    iRunGameCounter--;
                
                count=msec + incr;
            } 
            
//            if(fps >= TARGET_FPS)
            {
                
                //al_poll_duh(mod_player);
                //graphicsLoop(); 
                if(iGraphicsLoops>20)
                    draw_all();
                    
                iGraphicsLoops++;
                
                if(paused==true)
                    paused_screen();
                else if(quit_level_menu_on==true)
                    quit_level_menu_draw();
                else if(esc_menu_on==true)
                    esc_menu_draw();
                if(ingameCin.isOn()==true)
                    ingameCin.draw(backgr);
                if(dying>0)     //ketchup is in the process of dying
                    draw_dying();
                
                if(menu_on==false)
                    displayBackgr();
                    

            }
            //else
            //    frames_skipped++;
        }
    }

    al_stop_duh(mod_player);
    if(current_song)
        unload_duh(current_song);
    rest(20);

    outtext(LOG,"Destorying objects");
    for(int n=0 ; n<number_of_objects ; n++)
        object[n].destroy();
    outtext(LOG,"Destorying map");
    mMap1.destroy_map();
    outtext(LOG,"Destorying background");
    destroy_bitmap(backgr);
    destroy_bitmap(bTemp);
    destroy_bitmap(bmpWeb);
    outtext(LOG,"Unloading data");
    unload_datafile(data);
    outtext(LOG,"Unloading sounds");
    unload_datafile(sounds);
    outtext(LOG,"Destorying tileset");
    tsTileSet1.destroy_ts();
    
    /*if(current_song)
    {
        outtext(LOG,"Unloading song");
        unload_duh(current_song);
    }  */  
    outtext(LOG,"Quitting normally");
    return 0;
}     
END_OF_MAIN();

float sx_vel=0,sy_vel=0,sx_accel=0,sy_accel=0;
    

void move_all(void)
{
    int ret=-1;
    cycles++;
    cycles2++;

    iLogicLoops++;
     //update_music();
    ret=player.check_col_with_objects(&oObjects1,&pParts,&dialog);

    if(ret==1 || ret==2 || ret==8)    //a fry or cheese or score item was picked up
    {
        display_item_counter=300;
    }

    enims.check_col_with_player(player.return_character(),&pParts,&dialog);
    enims.move(&mMap1,&oObjects1,&pParts,&projs,s_x,s_y);
    oObjects1.move_map_objects();

    player.move_character(&mMap1,&oObjects1,&pParts,s_x,s_y);
    
    if(player.return_life()<=0)
    {
        player.tellDead();  //tell the player class that the character died
        restartLevel();

    }
    
    

    

    pParts.move_all();
    move_and_check_projs();
    env_effect.move((int)s_x,(int)s_y);
    
    if(key[KEY_G])
        env_effect.start_effect(true,(int)s_x,(int)s_y,300);
    else if(key[KEY_H])
        env_effect.stop_effect();

}

void draw_all(void)
{
    //iGraphicsLoops++;


    if(s_x>5500)
        s_x=5500;
    if(s_y>3840)
        s_y=3840;
    
                 
//    draw_rle_sprite(backgr,(RLE_SPRITE*)data[back1].dat,-(int)(s_x/8),-(int)(s_y/10));
//    draw_rle_sprite(backgr,(RLE_SPRITE*)data[back2].dat,-(int)(s_x/3),-(int)(s_y/3));

/*
    draw_rle_sprite(backgr,(RLE_SPRITE*)data[back1].dat,-(int)(s_x/8),-(int)(s_y/10));
    for(int n=0 ; n<2 ; n++)    //goes through background tiles
        draw_rle_sprite(backgr,(RLE_SPRITE*)data[back2].dat,(((RLE_SPRITE*)data[back2].dat)->w*(n))-(int)(s_x/3),-(int)(s_y/8));
*/
    
    
    /********DESERT BACKGROUND***********/
    //rectfill(backgr,0,0,S_W,S_H,makecol(200,150,0));
    //circlefill(backgr,320-(int)(s_x/32),525,250,makecol(255,228,0));

    /********GRASS_BACKGROUND***********/
    //rectfill(backgr,0,0,S_W,S_H,makecol(0,130,255));

    /********DEATH BACKGROUND***********/
    //rectfill(backgr,0,0,S_W,S_H,makecol(60,0,0));

    clear_to_color(backgr,makecol(255,255,255));
    mMap1.draw_background(backgr,s_x,s_y);
    env_effect.draw_background(backgr,(int)s_x,(int)s_y); 
    env_effect.draw(backgr,(int)s_x,(int)s_y);
    mMap1.draw_layer0(backgr,s_x,s_y);

    if(tile_edit==true)
    {
        //draws all of the tiles in the set onto the screen
        tsTileSet1.display_tiles(backgr);
    }
    else if(editing==true)
    {


        
        mMap1.draw_grid(backgr,s_x,s_y); //drwas a map with a grid

        //draws the selection rectangle
        rect(backgr,iEditx-(int)s_x,iEdity-(int)s_y,iEditx+iEditSize-(int)s_x-1,iEdity+iEditSize-(int)s_y-1,makecol(255,0,0));
        rect(backgr,iEditx-(int)s_x-1,iEdity-(int)s_y-1,iEditx+iEditSize-(int)s_x,iEdity+iEditSize-(int)s_y,makecol(255,0,0));

        //draws the current object being placed onto the map
        ob1.draw_preview(backgr,(int)s_x,(int)s_y);
        oObjects1.draw_preview(backgr,(int)s_x,(int)s_y);
        
        
        if(pointer_num==0) //if the cursor is normal
        {
            //draws a preview of the current selected object where the mouse is
            object[object_map[current_object]].draw_trans(backgr,-mouse_x,-mouse_y);
        }

        //displays a preview tile
        tsTileSet1.display_tile(backgr,current_tile,(float)600,(float)0);

        if(bx1!=-1)
        {
            rect(backgr,(int)bx1-(int)s_x,(int)by1-(int)s_y,mouse_x,mouse_y,makecol(0,0,200));
        }
    }
    else
    {
                mMap1.draw_map(backgr,s_x,s_y);   
        oObjects1.draw_all(backgr,(int)s_x,(int)s_y);
        enims.draw_all(backgr,(int)s_x,(int)s_y);
     
        
    }

    player.draw_player(backgr,s_x,s_y,(FONT*)data[f2].dat);
    projs.draw_all(backgr,s_x,s_y);


    pParts.draw_all(backgr,s_x,s_y);
  
    oObjects1.draw_foreground(backgr,(int)s_x,(int)s_y);

    mMap1.draw_layer2(backgr,s_x,s_y);

    //env_effect.draw(backgr,(int)s_x,(int)s_y);

    player.draw_health(backgr,&pParts,(FONT*)data[f2].dat,(int)s_x,(int)s_y);

    if(editing==true)  //draw the different mouse pointers
    {
        if(pointer_num==0)  //normal pointer
            draw_sprite(backgr,(BITMAP*)data[pointer1+pointer_num].dat,mouse_x,mouse_y);
        else if(pointer_num==1)   //move object pointer needs to be drawn with an offset
            draw_sprite(backgr,(BITMAP*)data[pointer1+pointer_num].dat,mouse_x-9,mouse_y-9);
    }


    displayFps();
 //   rectfill(screen,0,0,640,480,0);
    //textprintf(backgr,font,0,0,makecol(255,0,0),"%d %d %f  %f",sec,iGraphicsLoops,iLogicLoops / ((float)sec/1000),iGraphicsLoops / ((float)sec/1000));
//    textprintf(backgr,font,0,70,makecol(255,0,0),"%f %f",s_x,s_y);
    //textprintf(backgr,font,0,90,makecol(255,0,0),"%d %d",iEditx,iEdity);
    
    if(editing==true)
        textprintf_ex(backgr,(FONT*)data[f2].dat,200,0,makecol(200,0,0),-1,"Current Layer: %d",current_layer);

    display_item_counts();


    if(iGraphicsLoops<4)
        rectfill(screen,0,0,640,480,makecol(0,0,0));
}

void move_cinematic_camera(void)
{
    //a new camera position has been set
    if(player.return_character()->ret_new_screen_x()>=0 && player.return_character()->ret_new_screen_y()>=0)
    {
        static float dx=0,dy=0;
        
        float dist_x = s_x - player.return_character()->ret_new_screen_x();
        float dist_y = s_y - player.return_character()->ret_new_screen_y();
        /*
        if(dist_x>dx)
            dx++;
        else if(dist_x<dx)
            dx--;
            
        if(dist_y>dy)
            dy++;
        else if(dist_y<dy)
            dy--;
            
        s_x+=dx;
        s_y+=dy;*/
        
        s_x -= dist_x / 30;
        s_y -= dist_y / 30;
        
        /*if( player.return_character()->ret_new_screen_x() > s_x+1)
            s_x+=1;
        else if(player.return_character()->ret_new_screen_x() < s_x-1)
            s_x-=1;

        
        if( player.return_character()->ret_new_screen_y() > s_y+1)
            s_y+=1;
        else if(player.return_character()->ret_new_screen_y() < s_y-1)
            s_y-=1;

            
        s_x+=dx;
        s_y+=dy;  */         
        
    }
    else
        move_camera();

}

void move_camera(void)
{
    float dsx=0,dsy=0; 
    static float sx_vel=0,sy_vel=0;
    if(s_x!=0)
        dsx = (player.return_character()->ret_x()- S_W/2 + (player.return_character()->dir==1?75:-75)) - s_x ;
    else
        dsx = player.return_character()->ret_x()- S_W/2;
    if(s_y!=0)
        dsy = (player.return_character()->ret_y()- S_H/2) - s_y;
    else
        dsy = player.return_character()->ret_y()- S_H/2;
    
    
    sx_vel+=dsx/30; sy_vel+=dsy/15;
    
    s_x+=sx_vel;
    s_y+=sy_vel;
    
    sx_vel*=.77;
    sy_vel*=.73;

    if(abval(sx_vel)<.25)
        sx_vel=0;
    if(abval(sy_vel)<.25)
        sy_vel=0;

    if(s_x<0)
        s_x=0;
    if(s_y<0)
        s_y=0;
        
    if(s_x+lookx<0)
        lookx=-s_x;
    else if(s_y+looky<0)
        looky=-s_y;
        
    s_x+=lookx;
    s_y+=looky;
}

void calc_fps(void)
{
    actual_seconds = (float)sec/target_fps;

    fps = (float)cycles2 / ((float)sec2/target_fps);
    if(cycles2%300 == 0)
    {
        cycles2=0;
        sec2=0;
    }
}

void allegro_startup(void)
{

     allegro_init();
     install_keyboard();
     install_timer();
     install_mouse();

   // textprintf(screen,font,100,100,makecol(0,255,0),"Waiting");
   // while(!key[KEY_ESC]){}

     atexit(&dumb_exit);
     dumb_register_stdfiles();

    set_color_depth(16);
    if(set_gfx_mode(GFX_AUTODETECT,S_W,S_H,0,0)<0)
    {
        set_color_depth(15);
        if(!set_gfx_mode(GFX_AUTODETECT,S_W,S_H,0,0)<0)
        {
            set_color_depth(32);
            set_gfx_mode(GFX_AUTODETECT,S_W,S_H,0,0);    
        }       
    }    
   //  if(os_type == OSTYPE_WIN98)
   //      {
   //set_gfx_mode(GFX_AUTODETECT_WINDOWED,S_W,S_H,0,0);
          //if(!set_gfx_mode(GFX_AUTODETECT,S_W,S_H,0,0))
               //set_gfx_mode(GFX_SAFE,S_W,S_H,0,0);
   //      }
   //  else
   //      {
   //       if(!set_gfx_mode(GFX_AUTODETECT,S_W,S_H,0,0))
   //             set_gfx_mode(GFX_SAFE,S_W,S_H,0,0);
    //     }
     //reserve_voices(16,1);
     if(install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL)<0)
     {
     exit(0);
     }
     //set_volume(200,200);
      


     srand(0);

	 data=load_datafile("data/rotk2.dat");   //datafile will be loaded here
     sounds=load_datafile("data/sounds.dat");
     
     
     if(!sounds)
        readkey();

     //creates a black tile-sized bitmap
     if(hardware_accel==true)
        bTemp=create_video_bitmap(32,32);
 
         else
        bTemp=create_bitmap(32,32);
        
     rectfill(bTemp,0,0,32,32,makecol(255,0,255));
     //creates an 'empty' tile using the clear (magenta) bitmap
     tTemp.init_tile(bTemp,EMPTY,0,0,-1);


     bmpWeb=create_bitmap(5,5);
     rectfill(bmpWeb,0,0,5,5,makecol(255,0,255));
     rectfill(screen,0,0,S_W,S_H,0);

    init_game();


    if(hardware_accel==false)
    {
        backgr=create_bitmap(SCREEN_W,SCREEN_H);
    }
    else if(hardware_accel==true)
    {
        backgr=create_video_bitmap(SCREEN_W,SCREEN_H);
        page[0]=create_video_bitmap(SCREEN_W,SCREEN_H);
        page[1]=create_video_bitmap(SCREEN_W,SCREEN_H);

        rectfill(page[0],0,0,SCREEN_W,SCREEN_H,0);
        rectfill(page[1],0,0,SCREEN_W,SCREEN_H,0);
        backgr=page[cur_page];
    }

//     rectfill(trans,0,0,SCREEN_W,SCREEN_H,makecol(100,0,0));
	 rectfill(backgr,0,0,SCREEN_W,SCREEN_H,0);

     //text_mode(-1);
     
     set_volume(200,130);

     set_trans_blender(100,100,200,100);
     LOCK_VARIABLE(sec);
     LOCK_FUNCTION(go_sec);
	 install_int_ex(go_sec, BPS_TO_TIMER(BPS));
}

void reset_all(void)
{
    oObjects1.init_all();          //resets all the objects
    enims.init();                  //readies the enims
    pParts.init();                 //readies the particle system
    projs.init_all();              //readies the projectiles
    mMap1.init(&tTemp);            //initializes the map using the given tile (tTemp is an empty tile)

    
    
  //  player.set_up_level(&mMap,&oObjects1,&osObjectSet1,
}


void init_game(void)
{
    player.init_player();          //readies the player
    osObjectSet1.init_set();       //readies the object set
    levels.init_all();             //readies the levels
    enims.init();                  //readies the enims
    pParts.init();                 //readies the particle system
    projs.init_all();              //readies the projectiles
    mMap1.init(&tTemp);             //initializes the map using the given tile     
    jumping_fry.init();             //readies the jumping fry anim for the menu screen
    oObjects1.init_all();           //readies all of the objects to be used in the game
     
    for(int n=0 ; n<4 ; n++)    //readies the 3 save slots
        game[n].init();
        
     ob1.init_mo();             //init this one temp object (used in map editor)
     
     
     //initilizes the temp object for use in the map editor
     for(int n=0 ; n<max_object_types ; n++)
        object[n].init_mo();


    //creates the animation for the jumping menu fry
    jumping_fry.create("animations/fry1.anm");

    //defines all of the levels in the game
    //gives the filename of the level, its name, and the world it is in.
    levels.init_all();
    
    
//    levels.create_level("maps/l1_1.map","THE BEGINING",1);
//    //levels.create_level("l6_1.map","THE BEGINING",1);
//    levels.create_level("maps/level2.map","LEVEL 2",1);
//    levels.create_level("maps/level3.map","LEVEL 3",1);
//    levels.create_level(/*"maps/level1.map"*/"maps/level5_5.map"/*"empty.map"*/,"NORTHLAND",1);


    //load all of the saved games
    //loads the three saved games into the three save slots (game[0],game[1],game[2])
    game[0].load_game("saves/game1.sav",&levels);
    game[1].load_game("saves/game2.sav",&levels);
    game[2].load_game("saves/game3.sav",&levels);

    tsTileSet1.init(); //creates the tile set object
//    tsTileSet1.load_tile_set("tiles/set3.ts");  //loads the tile set using the given data
    
    //loads the object set. The object set holds a prototype for every object in the game
//    osObjectSet1.load_object_set("set1.obs");
   
    //sets up the game
    //levels.set_up_all_levels(&mMap1,&oObjects1,&osObjectSet1,&tsTileSet1,data,&tTemp,&enims);

    //creates the player's character giving it the attributes found the the obPlayer object
    player.create_character(obPlayer,data,sounds,0,0,5,&ingameCin); 
    //creates the player giving it the levels it play in.    
    player.create_player(&levels,(BITMAP*)data[health_bar_full].dat,
                                 (BITMAP*)data[health_bar_empty].dat,
                                 (BITMAP*)data[health_bar_bottle].dat);

    player.return_character()->set_web_left(1000);
    player.return_character()->swinging=false;
    player.set_script("scripts/pscript.rsr");
    
    //creates the prototype objects from the info in the object set
    //one of each type of object it made this way. These objects are used
    //in the map editor
  /*  object[0].create_mo(&osObjectSet1,0,data,0,0,pTemp);
    object[1].create_mo(&osObjectSet1,1,data,0,0,pTemp);
    object[2].create_mo(&osObjectSet1,2,data,0,0,pTemp);
    object[3].create_mo(&osObjectSet1,3,data,0,0,pTemp);
    object[4].create_mo(&osObjectSet1,4,data,0,0,pTemp);
    object[5].create_mo(&osObjectSet1,5,data,0,0,pTemp);
    object[6].create_mo(&osObjectSet1,6,data,0,0,pTemp);
    object[7].create_mo(&osObjectSet1,7,data,0,0,pTemp);
    object[8].create_mo(&osObjectSet1,8,data,0,0,pTemp);
    object[9].create_mo(&osObjectSet1,9,data,0,0,pTemp);
    object[10].create_mo(&osObjectSet1,10,data,0,0,pTemp);
    object[11].create_mo(&osObjectSet1,11,data,0,0,pTemp);
    object[12].create_mo(&osObjectSet1,12,data,0,0,pTemp);
    object[13].create_mo(&osObjectSet1,13,data,0,0,pTemp);
    object[14].create_mo(&osObjectSet1,14,data,0,0,pTemp);
    object[15].create_mo(&osObjectSet1,15,data,0,0,pTemp);
    object[16].create_mo(&osObjectSet1,16,data,0,0,pTemp);*/
  //  number_of_objects=17;
    number_of_objects = osObjectSet1.add_all_objects(object,data,&ingameCin);
    organizeEditorObjects();
 
    setupEnvEffects();
    env_effect.set_effect(&env_effect_atts[RAIN]);

          
}

void edit_mode(void)
{
    static bool mouseTiles=false;
    
    cycles++;
    cycles2++;
    iLogicLoops++; 
    
    if(key[KEY_LSHIFT])
    {
        mouse_x -= (mouse_x+(int)s_x+2)%16 ;
        mouse_y -= (mouse_y+(int)s_y)%16 ;
    }
    
    if(mouse_b & 2) //right mouse button
    {
        mouseTiles = !mouseTiles;
    }
       
    if(key[KEY_F] && wait==0)   //flood fill
    {
        savePrevMap();  //for undo
        floodFillTiles((int)(iEditx/32),(int)(iEdity/32));
        wait=20;
    }   
       
    if(key[KEY_UP] && iEdity>0 && wait==0)
    {
        iEdity-=32;
        wait=2;
    }
    else if(key[KEY_DOWN] && iEdity< 4288 && wait==0)
    {
        iEdity+=32;
        wait=2;
    }

    if(key[KEY_LEFT] && iEditx>0 && wait==0)
    {
        iEditx-=32;
        wait=2;
    }
    else if(key[KEY_RIGHT] && iEdity<6112 && wait==0)
    {
        iEditx+=32;
        wait=2;
    }

    if(key[KEY_SPACE])  //sets the start position for ketchup
    {
        mMap1.setStart(mouse_x+(int)s_x,mouse_y+(int)s_y);
    }

    if(iEditx-s_x >= S_W)
        s_x+=32;
    else if(iEditx-s_x<0)
        s_x-=32;

    if(iEdity-s_y >= S_H)
        s_y+=32;
    else if(iEdity-s_y<0)
        s_y-=32;

    if(wait>0)
        wait--;
}

void get_keys(void)
{
    if(key[KEY_PGUP] || key[KEY_PGDN] || key[KEY_E] || key[KEY_T] || key[KEY_S] || key[KEY_L] || key[KEY_HOME] || key[KEY_END] || key[KEY_P] || key[KEY_Z] || key[KEY_N] || key[KEY_SPACE]
     ||key[KEY_ENTER] || key[KEY_DEL] || key[KEY_C] || key[KEY_M])
        {
        if(KeyPressed==false)
            {
            if(key[KEY_PGUP])
                current_tile++;
            else if(key[KEY_PGDN])
                current_tile--;

            if(key[KEY_HOME])
                current_object++;
            else if(key[KEY_END])
                current_object--;

            if(key[KEY_S])
                {
                if(key[KEY_LCONTROL] || key[KEY_RCONTROL])
                    {
//                    game[0].save_game("saves/game1.sav");
//                    game[1].save_game("saves/game2.sav");
//                    game[2].save_game("saves/game3.sav");
                    }
                else
                    {
                    enims.find_enims(&oObjects1); //searchs through the objects to find enemies

                    char name[60];
                    //strcpy(name,"");
                    strcpy(name,mMap1.retFilename());
                    
                    DIALOG input_dlg[] = {
                        { d_edit_proc , 275, 200, 100, 50, 90, makecol(255,0,0), 0, D_EXIT, 60, 0, name},
                        { NULL },
                    };
                    rectfill(screen,0,0,S_W,S_H,0);
                    textprintf_centre_ex(screen,font,S_W/2,180,makecol(255,0,0),-1,"Please enter the filename");

                    while(key[KEY_ENTER]) {poll_keyboard(); }
                    clear_keybuf();
                    while(!key[KEY_ENTER])
                    {
                        poll_keyboard();
                        do_dialog(input_dlg,0);
                    }    

                    if(!(strcmp(name,"")==0))
                        mMap1.save_map(name,&oObjects1);

                    }
                }
            else if(key[KEY_L])
                {
                if(key[KEY_LCONTROL] || key[KEY_RCONTROL])
                    {
                    game[0].load_game("saves/game1.sav",&levels);
                    game[1].load_game("saves/game2.sav",&levels);
                    game[2].load_game("saves/game3.sav",&levels);
                    }
                else
                    {
                    mMap1.load_map("maps/map1.map",&tsTileSet1,&tTemp,data,&osObjectSet1,&oObjects1, &ingameCin);
                    enims.find_enims(&oObjects1);
                    }
                }
            else if(key[KEY_E] /*&& key[KEY_T]*/)
                {
                if(editing==false)
                    {
                    editing=true;
                    iEditx=(int)(s_x/32)*32;
                    iEdity=(int)(s_y/32)*32;
                    oObjects1.enter_edit_mode();
                    picked_up_object=-1;
                    picked_up_object2=-1;
                    }
                else if(editing==true)
                    editing=false;

                clear_keybuf();
                }

            /*else if(key[KEY_T])
            {
                if(tile_edit==false)
                    tile_edit=true;
                else if(tile_edit==true)
                    tile_edit=false;
            }*/

            if(key[KEY_P])
            {
                paused=true;
                //quit_level_menu_on=true;
            }

            if(key[KEY_N] && key[KEY_M])
            {
                player.go_to_next_level();
                loadLevel();                
            }

            if(key[KEY_C])
            {
                savePrevMap();  //for undo
                //mMap1.clean_up_all(data,&tsTileSet1,current_layer);
                mMap1.clean_up_layer(&tsTileSet1,current_layer);
            }

            if(key[KEY_Z] && key[KEY_LCONTROL] && editing==true) //undo
            {
                restorePrevMap();
            }



            if(key[KEY_SPACE])
            {
               // player.shoot_web(&projs,bmpWeb);
            }
            
            /*if((key[KEY_ENTER] || key[KEY_DEL]) && editing==true)
            {
            
            }*/


            if(current_tile>=tsTileSet1.ret_max_tiles())
                current_tile=1;
            else if(current_tile<1)
                current_tile=tsTileSet1.ret_max_tiles()-1;

            if(current_object>=number_of_objects)
                current_object=0;
            else if(current_object<0)
                current_object=number_of_objects-1;

            KeyPressed=true;
            }
        }
    else
        KeyPressed=false;



    if(key[KEY_C] && key[KEY_LCONTROL])
    {
        reset_all();
        //player.set_up_level(&mMap1,&oObjects1,&osObjectSet1,&tsTileSet1,data,&tTemp,&enims);
        player.levels->count_items(&oObjects1);
        player.game->set_item_count(player.levels);   //count the items in the level for the saved game

    }

    if((key[KEY_LCONTROL] || key[KEY_RCONTROL]) && editing==false)
    {
        if(key[KEY_UP] && s_y+SCREEN_H/2 > player.return_character()->ret_centy()-100)
            looky-=4;
        else if(key[KEY_DOWN] && s_y+SCREEN_H/2 < player.return_character()->ret_centy()+100)
            looky+=4;
        
        if(key[KEY_RIGHT] && s_x+SCREEN_W/2 < player.return_character()->ret_centx()+100)
            lookx+=4;
        else if(key[KEY_LEFT] && s_x+SCREEN_W/2 > player.return_character()->ret_centx()-100)
            lookx-=4;   
        player.return_character()->not_left_or_right();
    }
    else
    {
        if(lookx>6 /*&& lookx>player.return_character()->ret_dx()*/)
            lookx-=10;
        else if(lookx<-6 /*&& lookx<player.return_character()->ret_dx()*/)
            lookx+=10;
        else
            lookx=0;
            
        if(looky>6 /*&& lookx>player.return_character()->ret_dy()*/)
            looky-=10;
        else if(looky<-6 /*&& lookx<player.return_character()->ret_dy()*/)
            looky+=10;
        else
            looky=0;
            
    
        if(key[KEY_UP])
        {
            player.return_character()->key_up();

            //player.adjust_web_length(UP);
        }

        if(key[KEY_DOWN])
        {
            //player.adjust_web_length(DOWN);
            player.return_character()->key_down();
            //player.return_character()->not_left_or_right();
        }
        else
            player.return_character()->not_key_down();
    
        if(key[KEY_LEFT])
        {
            player.return_character()->key_left();
        }
        else if(key[KEY_RIGHT])
        {
            player.return_character()->key_right();
        }
        else
            player.return_character()->not_left_or_right();
            
    }


    if( key[KEY_LCONTROL] || key[KEY_RCONTROL] || bx1!=-1)
    {
        clean_up_box();
    }
    else
    {
        if(clean_up_mode==true)
            {
            clean_up_mode=false;
            mouse_clicked=false;
            }
        bx1=-1;
        by1=-1;

        place_platforms();
    }
    

    if(key[KEY_0])
        current_layer=0;
    else if(key[KEY_1])
        current_layer=1;
    else if(key[KEY_2])
        current_layer=2;
    
    //for placing, and deleting tiles
    if(key[KEY_ENTER] && editing==true)
    {
        savePrevMap();
    
        mMap1.add_tile(&tsTileSet1,current_tile,(int)(iEditx/32),(int)(iEdity/32),current_layer);
        
    }

    if(key[KEY_DEL] && mouse_clicked==false)
    {
        savePrevMap();
    
        mMap1.del_tile(&tTemp,(int)(iEditx/32),(int)(iEdity/32),current_layer);
        
    }

        if(key[KEY_O])
            player.return_character()->startCharge1();

    if(key[KEY_ESC])
    {
        //ready=true;

        esc_menu_on=true;
        while(key[KEY_ESC]) poll_keyboard();
        //menu_on=true;
      //  play_midi((MIDI*)data[valley_clouds].dat,TRUE);
    }
}

void place_platforms(void)
{
    pointer_num=0;

    //if the object, or the object's other movement point, change the mouse pointer
    if( oObjects1.return_object_num(mouse_x+s_x,mouse_y+s_y) !=-1 ||
        oObjects1.return_object_num2(mouse_x+s_x,mouse_y+s_y) !=-1 )
        pointer_num=1;

    if( (mouse_b&1) && mouse_clicked==false) //just clicking now
        {
         //let the program know that the mouse has been clicked already
         mouse_clicked=true;

         //gets the object number that the mouse clicked on

         //this is the number of the object whose first movement point was clicked on
         picked_up_object=oObjects1.return_object_num(mouse_x+s_x,mouse_y+s_y);

         //this is the number of the object whose second movement point was clicked on
         picked_up_object2=oObjects1.return_object_num2(mouse_x+s_x,mouse_y+s_y);

         if(picked_up_object==-1 && picked_up_object2==-1) //if no object has been clicked on
            {
            //when the mouse is clicked, but no object is under the pointer we must create a
            //new object at that point

            //to get the actual position, take the mouse position and add the screen position
            pTemp.x=mouse_x+s_x;
            pTemp.y=mouse_y+s_y;

            //ob1 is the current object being added. It has not been added to the game's array
            //of map objects yet, its just a tempory object for storing the object being worked with.
            //Set this temperory object equal to the current object type being added
//            ob1 = object[current_object];
            ob1 = object[object_map[current_object]];

            //move this temp object to the real world position of the mouse pointer
            ob1.move_to(mouse_x+s_x,mouse_y+s_y);
            ob1.move_to2(mouse_x+s_x,mouse_y+s_y);
            }
        }
    else if( (mouse_b&1) && mouse_clicked==true) //dragging mouse
        {
        if(picked_up_object!=-1) //moving an existing object
            {
            //move the selected object to the mouse's real world position
            oObjects1.move_object_to(picked_up_object,mouse_x+s_x,mouse_y+s_y);
            pointer_num=1;
            if(key[KEY_DEL])
                {
                oObjects1.destroy_object(picked_up_object);
                picked_up_object=-1;
                picked_up_object2=-1;
                deleting=true;
                }
            }
        else if(picked_up_object2!=-1)
            {
            oObjects1.move_object_to2(picked_up_object2,mouse_x+s_x,mouse_y+s_y);
            pointer_num=1;
            if(key[KEY_DEL])
                {
                oObjects1.destroy_object(picked_up_object2);
                //rest(300);
                //while(key[KEY_DEL]) {   }
                picked_up_object=-1;
                picked_up_object2=-1;
                deleting=true;
                //while(mouse_b&1) {}
                //picked_up_object2=-1;
                //mouse_clicked=false;
                }
            }
        else //no object is being moved
            {
            if(ob1.obInfo.moving==true) //a moving object, so set up the second movement point
                {
                pTemp.x=mouse_x+s_x;
                pTemp.y=mouse_y+s_y;
                }
            else     //it is not a moving object so it has no second movement point
                {
                pTemp.x = ob1.x;
                pTemp.y = ob1.y;
                }

            ob1.set_p2(pTemp); //set the second movement point for the object
            }
        }
    else if( !(mouse_b&1) && mouse_clicked==true) //releasing mouse
    {
        mouse_clicked=false;

        if(picked_up_object!=-1)    //moving an existing object
        {
            oObjects1.finalize_movement(picked_up_object);
        }
        else if(picked_up_object2!=-1)   //move the second movement point of the object
        {
            oObjects1.finalize_movement(picked_up_object2);
        }
        else if(deleting==false)  //no object is being moved
        {
            oObjects1.add_object(&osObjectSet1,&ob1,data,&ingameCin);    //add the temp object to the map

            ob1.exist=false;    //now the temp object is not displayed
        }
        deleting=false;
        enims.find_enims(&oObjects1);
    }
}

void slide_show(char *filename)
{
    DATAFILE *temp = load_datafile(filename);
  //  bool key_hit=false;
    int slide=0;

    while(slide<6)
        {
         
        blit((BITMAP*)temp[slide].dat , screen ,0,0,0,0,S_W,S_H);

        readkey();

        while (keypressed()) {
             
            }

        if(!keypressed())
            {
            fade_to((BITMAP*)temp[slide+1].dat);
            slide++;
            }
        }

    unload_datafile(temp);
}

void fade_to(BITMAP *second)
{
    int num=10;

    while (num < 200)
        {
        if(num!=10);
            rest(20);
        num+=10;
        set_trans_blender(num,num,num,num);
        draw_trans_sprite(screen,second,0,0);
        }
}

void clean_up_box(void)
{
    if(mouse_clicked==false && (mouse_b&1) )    //just clicking mouse now
    {
        clean_up_mode=true;
        bx1 = mouse_x+s_x;
        by1 = mouse_y+s_y;
        mouse_clicked=true;
    }

    else if(mouse_clicked==true && !(mouse_b&1) )   //letting go of the mouse
    {
        savePrevMap();  //for undo
        mMap1.clean_up_box(data,&tsTileSet1,bx1,by1,mouse_x+s_x,mouse_y+s_y,current_layer);

        //reset the values for the box
        bx1=-1;
        by1=-1;
    }
}

void paused_screen(void)
{
    static int level_num=-1/*player.ret_cur_level()*/;
    static int y=480;
    static bool unpausing=false;
    cycles++;
    iLogicLoops++;

 //   blit(backgr3,backgr,0,0,0,0,640,480);

    pParts.move_all();          //still move the particles even when paused

    if(key[KEY_P] || key[KEY_LEFT] || key[KEY_RIGHT])
    {
        if(KeyPressed==false)
        {

            if(key[KEY_P])
            {
                unpausing=true;
             /*   iLogicLoops=0;
                iGraphicsLoops=0;
                sec=0;
                cycles=0;
                sec2=0;
                cycles2=0;*/
                }
            else if(key[KEY_LEFT] && level_num>-1)
                level_num--;
            else if(key[KEY_RIGHT] && level_num<player.ret_number_of_levels()-1)
                level_num++;
        }
        KeyPressed=true;
    }
    else
        KeyPressed=false;

    int alpha=y/2;
    
    if(alpha<70)
        alpha=70;
    else if(alpha>255)
        alpha=255;

//    set_trans_blender(200,255,255,255-alpha);

   /* for(int n=0 ; n<480 ; n+=2)
        line(backgr,0,n,640,n,0);*/

    //BITMAP *rect=create_bitmap(S_W,S_H);
    //rectfill(rect,0,0,S_W,S_H,0);
    
    //draw lucent rectangle over the screen to darken it
//    draw_trans_sprite(backgr,rect,0,0);         
    //destroy_bitmap(rect);
//    draw_trans_sprite(backgr,(BITMAP*)data[pane2].dat,100,y);
    rectfill(backgr,0,0,backgr->w,backgr->h,makecol(0,0,0));

    //redraw the character so that it is not affected by the darkening of the background
    player.draw_player(backgr,s_x,s_y,(FONT*)data[f2].dat);
    player.draw_health(backgr,&pParts,(FONT*)data[f2].dat,(int)s_x,(int)s_y);

    //textprintf_centre(backgr,(FONT*)data[f1].dat,318,10,makecol(0,0,0),"PAUSED");
    //textprintf_centre(backgr,(FONT*)data[f1].dat,322,6,makecol(255,0,0),"PAUSED");


    //player.display_fries(backgr,(BITMAP*)data[large_fry].dat,(FONT*)data[f1].dat,20,35);    
    //player.display_chesses(backgr,(BITMAP*)data[large_cheese].dat,(FONT*)data[f1].dat,540,35);
    player.display_cheeses_and_fries(backgr,(BITMAP*)data[large_cheese].dat,(BITMAP*)data[large_fry].dat,(FONT*)data[f7].dat);

    if(level_num>=0)
        player.display_level_info(backgr,level_num,(FONT*)data[f1].dat,(FONT*)data[f2].dat,y+16);
    else
        player.display_game_info(backgr,(FONT*)data[f1].dat,(FONT*)data[f2].dat,y+16);


    if(unpausing==true)
    {
        if(y<480)
            y+=8;
        else
        {
            paused=false;
            unpausing=false;
        }
    }
    else if(y>80)
        y-=8;


 /*   if(hardware_accel==false)
        {
        blit(backgr,screen,0,0,0,0,640,480);
        //draw_trans_sprite(screen,backgr,0,0);
        }
    else if(hardware_accel==true)
        {
        show_video_bitmap(backgr);

        cur_page = (cur_page+1)%2;
        backgr = page[cur_page];
        }*/
}

void menu(void)
{
    static int x=-300,selected=0;
    static int y=480;
    static int game_selected=0;
    static bool ready=true;

    cycles++;
    iLogicLoops++;
    iGraphicsLoops++;
 
 
 
    blit((BITMAP*)data[title].dat,backgr,0,0,0,0,S_W,S_H);

    if(menu_num==1)
    {
        textprintf_ex(backgr,(FONT*)data[f6].dat,50,300,makecol(95,66,22),-1,"PLAY");
        textprintf_ex(backgr,(FONT*)data[f6].dat,50,350,makecol(95,66,22),-1,"OPTIONS");
        textprintf_ex(backgr,(FONT*)data[f6].dat,50,400,makecol(95,66,22),-1,"QUIT");

        if(selected==0)
        {
            textprintf_ex(backgr,(FONT*)data[f6].dat,50,300,makecol(123,87,29),-1,"PLAY");
            line(backgr,50,300+text_height((FONT*)data[f6].dat),290,300+text_height((FONT*)data[f6].dat),makecol(123,87,29));
        }    
        else if(selected==1)
        {
            textprintf_ex(backgr,(FONT*)data[f6].dat,50,350,makecol(123,87,29),-1,"OPTIONS");
            line(backgr,50,350+text_height((FONT*)data[f6].dat),290,350+text_height((FONT*)data[f6].dat),makecol(123,87,29));
        }    
        else if(selected==2)
        {
            textprintf_ex(backgr,(FONT*)data[f6].dat,50,400,makecol(123,87,29),-1,"QUIT");
            line(backgr,50,400+text_height((FONT*)data[f6].dat),290,400+text_height((FONT*)data[f6].dat),makecol(123,87,29));
        }    
    }
    else if(menu_num==2)
    {
        //draw_sprite(backgr,(BITMAP*)data[pane].dat,0,200);
        
        //write the information for each saved game
        textprintf_ex(backgr,(FONT*)data[f6].dat,30,240,makecol(95,66,22),-1,"SLOT A");
        game[0].write_info(backgr,30,245,(FONT*)data[f7].dat);

        textprintf_ex(backgr,(FONT*)data[f6].dat,30,325,makecol(95,66,22),-1,"SLOT B");
        game[1].write_info(backgr,30,330,(FONT*)data[f7].dat);

        textprintf_ex(backgr,(FONT*)data[f6].dat,30,410,makecol(95,66,22),-1,"SLOT C");
        game[2].write_info(backgr,30,415,(FONT*)data[f7].dat);
        
        if(selected==0)
        {
            //rectfill(backgr,25,235,300,235+74,makecol(10,10,10));
            textprintf_ex(backgr,(FONT*)data[f6].dat,30,240,makecol(123,87,29),-1,"SLOT A");
            rect(backgr,25,235,300,235+74,makecol(123,87,29));
            game[0].write_info(backgr,30,245,(FONT*)data[f7].dat);
        }    
        else if(selected==1)
        {
            //rectfill(backgr,25,320,300,320+74,makecol(10,10,10));
            textprintf_ex(backgr,(FONT*)data[f6].dat,30,325,makecol(123,87,29),-1,"SLOT B");
            rect(backgr,25,320,300,320+74,makecol(123,87,29));
            game[1].write_info(backgr,30,330,(FONT*)data[f7].dat);
        }    
        else if(selected==2)
        {
            //rectfill(backgr,25,405,300,479,makecol(10,10,10));
            textprintf_ex(backgr,(FONT*)data[f6].dat,30,410,makecol(123,87,29),-1,"SLOT C");
            rect(backgr,25,405,300,479,makecol(123,87,29));
            game[2].write_info(backgr,30,415,(FONT*)data[f7].dat);
        }    
                
        
        jumping_fry.move();
    }

    else if(menu_num==3)
    {

        textprintf_ex(backgr,(FONT*)data[f6].dat,50,290,makecol(95,66,22),-1,"PLAY");
        textprintf_ex(backgr,(FONT*)data[f6].dat,50,330,makecol(95,66,22),-1,"DELETE");

        if(selected==0)
        {
            textprintf_ex(backgr,(FONT*)data[f6].dat,50,290,makecol(123,87,29),-1,"PLAY");
            line(backgr,50,290+text_height((FONT*)data[f6].dat),290,290+text_height((FONT*)data[f6].dat),makecol(123,87,29));
        }
        

        if(selected==1)
        {
            textprintf_ex(backgr,(FONT*)data[f6].dat,50,330,makecol(123,87,29),-1,"DELETE");
            line(backgr,50,330+text_height((FONT*)data[f6].dat),290,330+text_height((FONT*)data[f6].dat),makecol(123,87,29));
        }
        
        selected = selected%2;
    }
    else if(menu_num==5)
    {
        textprintf_ex(backgr,(FONT*)data[f7].dat,50,300,makecol(123,87,29),-1,"Enter your name:");
        textprintf_ex(backgr,(FONT*)data[f7].dat,50,330,makecol(123,87,29),-1,player_name);
        textprintf_ex(backgr,(FONT*)data[f7].dat,50+text_length((FONT*)data[f7].dat,player_name),330,makecol(123,87,29),-1,"_");

        if(doText(player_name)==true)
        {
            //enter has been pressed  
            
            //set the players name in the game
            strcpy(game[game_selected].name , player_name); 
            
            //save the games
            game[0].save_game("saves/game1.sav");
            game[1].save_game("saves/game2.sav");
            game[2].save_game("saves/game3.sav");
            

            //play the opening cinematic
            cin1.init("cinematics/c2.cin");
            cin1.start();
            while(key[KEY_ENTER]) poll_keyboard();
            clear_keybuf();
            global_game_selected = game_selected;
            //and start the game
            selected=0;
            
  
                        /*player.go_to_level(game_selected);
                        loadLevel();  
                        player.splash_current_level(backgr,(FONT*)data[f1].dat);
                        displayBackgr();
                        while(key[KEY_ENTER]) { al_poll_duh(mod_player); }
                        while(!key[KEY_ENTER]) { al_poll_duh(mod_player); }*/
        }  
    }    

    if((key[KEY_UP] || key[KEY_DOWN] || key[KEY_ENTER] || key[KEY_ESC]) && ready==true)
    {
        if(KeyPressed==false && ready==true)
        {
            if(key[KEY_UP])
            {
                selected--;
            }
            else if(key[KEY_DOWN])
            {
                selected++;
            }
             play_sample((SAMPLE*)data[click].dat,100,125,1000,FALSE);


            if(key[KEY_ESC] && menu_num>1)
            {
                selected=0;
                menu_num=1;
                play_sample((SAMPLE*)data[menu_close].dat,100,125,1000,FALSE);

                ready=false;
            }

            if(key[KEY_ENTER])
            {
                if(menu_num==1)   //when on the main ie first menu
                {
                    if(selected==0)     //choose 'Play'
                    {
                        //hitting enter will bring you to the next menu
                        menu_num=2;
                        play_sample((SAMPLE*)data[menu_open].dat,100,125,1000,FALSE);

                        ready=false;
                        selected=0;

                        //load all of the saved games
                        game[0].load_game("saves/game1.sav",&levels);
                        game[1].load_game("saves/game2.sav",&levels);
                        game[2].load_game("saves/game3.sav",&levels);
                    }
                        
                    if(selected==1)     //choose 'Options'
                    {
//                        menu_num=4;
//                        play_sample((SAMPLE*)data[menu_open].dat,100,125,1000,FALSE);
                        //ready=false;
//                        selected=0;
                    
                    }
                            
                    if(selected==2)     //choose 'Quit"
                    {
                        menu_on==false;
                        quit_game=true;
                        play_sample((SAMPLE*)data[fry_bye].dat,100,125,1000,FALSE);
                        rest(800);
                    }
                }
                else if(menu_num==2)  //on the menu for the saved games
                {
                   /* sec=0;
                    cycles=0;
                    iLogicLoops=0;
                    iGraphicsLoops=0;*/
                    game_selected = selected;


                    //if the current slot is empty
                    if(strcmp(game[game_selected].name,"New")==0)
                    {
                        game[game_selected].new_game();
                        
                        strcpy(player_name,"Name");
                        while(key[KEY_ENTER]) poll_keyboard();  clear_keybuf();
                        menu_num=5; //the get name menu
                        
                    }
                     else  //there is already a game saved there
                    {
                        selected=0;
                        //advance to the next menu asking to play or
                        //delete the selected game
                        menu_num=3;
                        play_sample((SAMPLE*)data[menu_open].dat,100,125,1000,FALSE);

                        ready=false;
                    }

                    //reset all of the counters and timers
                  /*  sec=0;
                    sec2=0;
                    cycles=0;
                    cycles2=0;
                    iLogicLoops=0;
                    iGraphicsLoops=0;*/
                }
                else if(menu_num==3)    //play or delete
                {
                    if(selected==0) //play
                    {
                        player.set_game(&game[game_selected]); 
                        game[game_selected].count_items(player.levels);

//                        player.levels->set_up_all_levels(&mMap1,&oObjects1,&osObjectSet1,&tsTileSet1,data,&tTemp,&enims,&ingameCin);
//                        game->set_item_count(player.levels);

                        
                        menu_on=false;
                        selecting_level=true;
                        
                        while(key[KEY_ENTER]){poll_keyboard();}
                        clear_keybuf();
                    }     
                    else        //delete
                    {
                        while(key[KEY_ENTER]) poll_keyboard();
                        clear_keybuf();
                        
                        rectfill(backgr,45,387,250,415,makecol(0,0,0));
                        rect(backgr,45,387,250,415,makecol(123,87,29));
                        textprintf_ex(backgr,(FONT*)data[f7].dat,50,390,makecol(123,87,29),-1,"Are you sure? Y/N");
                        displayBackgr();
                        while(!keypressed()) {al_poll_duh(mod_player); poll_keyboard();}
                        if( (readkey() >> 8) == KEY_Y)
                        {
                        
                        game[game_selected].init();
                        selected=0;
                        menu_num=2;
                        
                        //save the games
                        game[0].save_game("saves/game1.sav");
                        game[1].save_game("saves/game2.sav");
                        game[2].save_game("saves/game3.sav");
                        
                        }    
                    }
                }  
            }
        }
        KeyPressed=true;
    }
    else
        KeyPressed=false;

    if(selected<0)
        selected=2;
    else if(selected>2)
        selected=0;

    if(menu_num==2)
    {
        ready=true;

    }
    else if(menu_num==1)
    {
        ready=true;
    }
    else if(menu_num==3)
    {
        ready=true;
    }
    else if(menu_num==4)
    {
        
        
    }
             
    displayBackgr();
}

void get_game_name(int n)
{
    char name[20]="Name";
    DIALOG input_dlg[] = {
        { d_edit_proc , 275, 200, 100, 50, 90, makecol(255,0,0), 0, D_EXIT, 20, 0, name},
        { NULL },
    };

    rectfill(screen,0,0,S_W,S_H,0);
    textprintf_centre_ex(screen,font,S_W/2,180,makecol(255,0,0),-1,"Please enter your name");

    while(key[KEY_ENTER]) {poll_keyboard(); }
    while(!key[KEY_ENTER])
    {
        do_dialog(input_dlg,0);
        poll_keyboard();
    }    

    strcpy(game[n].name , name);
}

void set_game_from_saved(int n)
{
    /*
    player.set_game(&game[n]);
    game[n].count_items(player.levels);
    reset_all();
    //sets up the given map for the given level
    loadLevel();
    //levels.set_up_level(0,&mMap1,&oObjects1,&osObjectSet1,&tsTileSet1,data,&tTemp);
    player.splash_current_level(backgr,(FONT*)data[f1].dat);
    displayBackgr();
    
    menu_on=false;
    while(key[KEY_ENTER]) { al_poll_duh(mod_player); }
    while(!key[KEY_ENTER]) { al_poll_duh(mod_player); }
    
    */
    player.set_game(&game[n]);
    world1.setSelectedLevel(0);
    menu_on=false;
    splashing_level=true;  
    stop_song();  
    
}

void move_and_check_projs(void)
{
    Point pTemp1={-1,-1};
    pTemp1=projs.move_all(&mMap1);

    if(projs.return_type(LATEST)==WEB)
        {
        if(pTemp1.x>0 && pTemp1.y>0 && player.return_character()->swinging==false)
            player.return_character()->start_pivot(pTemp1);
        }
}

void display_item_counts(void)
{
    // int trans_level;
        
     /*   if(display_item_counter<50)
                trans_level = display_item_counter*4;
        else if(display_item_counter==50)
                trans_level = 255;
        else if(display_item_counter>50)
                trans_level = (100 - display_item_counter)*4;*/
        

     //   player.display_fries(backgr,(BITMAP*)data[large_fry].dat,(FONT*)data[f1].dat,20,35);
     //   player.display_chesses(backgr,(BITMAP*)data[large_cheese].dat,(FONT*)data[f1].dat,540,35);
        player.display_cheeses_and_fries(backgr,(BITMAP*)data[large_cheese].dat,(BITMAP*)data[large_fry].dat,(FONT*)data[f7].dat);

}

void floodFillTiles(int x,int y)
{
    if(mMap1.isEmpty(x,y,current_layer)==true)
    {
        mMap1.add_tile(&tsTileSet1,current_tile,x,y,current_layer);
        
        if(x>0)
            floodFillTiles(x-1,y);
        if(x<mw-2)
            floodFillTiles(x+1,y);
        if(y>0)
            floodFillTiles(x,y-1);
        if(y<mh-2)
            floodFillTiles(x,y+1);
    }
}

void play_song(char *filename)
{
//    if(current_song)
//    {
//        al_stop_duh(mod_player);
//        unload_duh(current_song);
//    }    
    
//    current_song= dumb_load_it(filename);
//    mod_player=al_start_duh(current_song/*song*/, 2/*sterio*/, 0/**/,0.7f/*volume*/, 512/*buffer*/, 11025/*frequency*/);
    
    if(current_song)    //have to fade the current song out first
    {
        fading_out=true; 
        //outtext(LOG,"fading out current song");
        //current_volume=.6f; 
        target_volume=0; 
    }    
    else            //have to fade the new song in
    {
        fading_out=false;
        current_volume=0;
        target_volume=.6f;
    }    
    
    strcpy(next_song,filename);
        
    song_on=true;
    
   /* char temp[20];
    sprintf(temp,"%f",current_volume);
    outtext(LOG,temp);*/
}

void stop_song(void)
{
    //if(current_song)
    //{
    //    al_stop_duh(mod_player);
    //    unload_duh(current_song);
    //} 
    if(current_song)
    {
        fading_out=true; 
        target_volume=0; 
        strcpy(next_song,"none"); 
    }           
}    

void update_music_state(void)
{
    if(song_on==true)
    {
        if(fading_out==false)   //it is fading in
        {
            //if it hasn't started yet
            if(current_volume==0)
            {
                //if there  is a new song waiting
                if(next_song && strcmp(next_song,"none")!=0)
                {
                    if(current_song)
                    {
                        //unload the current song
                        al_stop_duh(mod_player);
                        unload_duh(current_song);
                        current_song=0;
                    }
                        
                    //start the next song
                    current_song= dumb_load_it(next_song);
                    outtext(LOG,next_song);
                    mod_player=al_start_duh(current_song, 2, 0,0.1f, 512, 10000);          
                    current_volume+=0.1f;
                    target_volume=0.6f;  
                } 
                else    //there is no song waiting
                {
                    al_stop_duh(mod_player);
                    unload_duh(current_song);
                    current_song=0;  
                    song_on=false;
                }                     
            }          
        }  
        else if(fading_out==true)   //it is fading out
        {
            if(current_volume==0)   //it is done fading
            {
                fading_out=false;    
            }        
        }         
    }    
}
    
void update_music_volume(void)
{
    if(song_on==true && current_song)
    {
        if(current_volume+.005f < target_volume)
        {
            current_volume+=.005f;
            al_duh_set_volume(mod_player,current_volume);
        }    
        else if(current_volume-.005f > target_volume)
        {
            current_volume-=.005f;
            al_duh_set_volume(mod_player,current_volume);
        }    
        else
            current_volume = target_volume;
            
            
                       /* char temp[20];
                    sprintf(temp,"%f",current_volume);
                    outtext(LOG,temp);*/
    }    
}    

/*
void update_music(void)
{
    if(song_on==true)
    {
         if(fading_out==true)
         {
            if(current_volume>0)
            {
                current_volume-=0.01f;
                al_duh_set_volume(mod_player,current_volume);
                char temp[20];
                sprintf(temp,"%f",current_volume);
                outtext(LOG,temp);
            
                //al_poll_duh(mod_player);
                //al_duh_set_volume(mod_player,0.2f); 
            }       
            else if(current_volume<=0)   //volume is at zero
            {
                //stop the current song
                if(current_song)
                {
                    al_stop_duh(mod_player);
                    unload_duh(current_song);
                    current_song=0;
                    fading_out=false;  
                    song_on=false; 
                    outtext(LOG,"Stopped song");
                }
                
                current_volume=0;
                //outtext(LOG,"0");
            }
                   
        }
        if(fading_out==false)
        {
            if(current_volume==0 && next_song && strcmp(next_song,"none")!=0) //next song is not 'none'
            {
                //start the next song
                current_song= dumb_load_it(next_song);
                outtext(LOG,next_song);
                mod_player=al_start_duh(current_song, 2, 0,0.01f, 512, 8000);          
                current_volume+=0.1f;
                target_volume=0.6f;
            }
            else if(mod_player && current_volume < target_volume )
            {
                current_volume+=0.1f;    
                al_duh_set_volume(mod_player,current_volume); 
                //char temp[20];
                //sprintf(temp,"%f",current_volume);
                //outtext(LOG,temp);
            }    
        }           
    }    
    al_poll_duh(mod_player);
}    */

void savePrevMap(void)
{
    static int prevX=0,prevY=0;
    if(prevX!=iEditx || prevY!=iEdity)
    {
        prevMap++;
            
        if(prevMap>=MAX_UNDOS)
        {
            prevMap=MAX_UNDOS-1;
            for(int i=0 ; i<MAX_UNDOS-1 ; i++)
                prevMaps[i]=prevMaps[i+1];
        }
                
        prevMaps[prevMap].copy(&mMap1);    
    }
    prevX=iEditx;
    prevY=iEdity;
}

void restorePrevMap(void)
{
    if(prevMap>=0)
    {
        mMap1.copy(&prevMaps[prevMap]);
        prevMap--;
    }
}

void restartLevel(void)
{
    dying=140;

/*
    //displays level title over again
    player.splash_current_level(backgr,(FONT*)data[f1].dat);
    textprintf_centre(backgr,(FONT*)data[f1].dat,320,350,makecol(0,255,255),"LETS TRY THAT AGAIN");
    displayBackgr();
    
    //resets the level
    reset_all();
    loadLevel();
    
    menu_on=false;
    while(key[KEY_ENTER]) { al_poll_duh(mod_player); }
    while(!key[KEY_ENTER]) { al_poll_duh(mod_player); }    
        
    //resets timers
    iLogicLoops=0;
    iGraphicsLoops=0;
    sec=0; 
*/
}

void displayBackgr(void)
{
//    textprintf_ex(backgr,font,20,20,makecol(255,0,0),-1,"Cur vol: %f target vol: %f",current_volume, target_volume);
    
    if(hardware_accel==false)
        blit(backgr,screen,0,0,0,0,S_W,S_H);
    else if(hardware_accel==true)
    {
        show_video_bitmap(backgr);
        cur_page = (cur_page+1)%2;
        backgr = page[cur_page];
    }
}

void loadLevel(void)
{
    player.set_up_level(&mMap1,&oObjects1,&osObjectSet1,&tsTileSet1,data,&tTemp,&enims,&ingameCin);
    number_of_objects = osObjectSet1.add_all_objects(object,data,&ingameCin);
    s_x = player.return_character()->ret_x()- S_W/2;
    s_y = player.return_character()->ret_y()- S_H/2;
    organizeEditorObjects();
    
    
    //play_song(/*"music/DMOON.IT"*/player.ret_cur_song_filename());
    //play_song("music/DMOON.IT");
}


/*
Urinfy  \
          -> Synonyms
Pistol  /
*/

void calcFps(void)
{
    static int iLastlLoops=0;
    
    if(secHistoryDepth<SEC_HISTORY)
    {
        secHistory[secHistoryDepth]=(int)msec;
        secHistoryDepth++;
    }
    else
    {
        for(int n=0 ; n<SEC_HISTORY-1 ; n++)
        {
            secHistory[n] = secHistory[n+1];
        }
        secHistory[SEC_HISTORY-1]=msec;
    }
    if(secHistory[secHistoryDepth-1]-secHistory[0] > 0)
        fps=((float)(secHistoryDepth-1) / (float)(secHistory[secHistoryDepth-1]-secHistory[0])) * BPS;
    else
        fps=0;
}

void displayFps(void)
{
    //clear(screen);
//    textprintf(backgr,font,0,0,makecol(255,0,0),"logical fps %0.0f",((float)ilLoops / (float)msec) * BPS);
//    textprintf(backgr,font,0,30,makecol(255,0,0),"graphical fps: %0.0f",fps);
//    textprintf(backgr,font,0,40,makecol(255,0,0),"frames skipped: %d",frames_skipped);
}


short int option_selected=0;
void quit_level_menu_move(void)
{
    pParts.move_all();          //still move the particles even when paused

    if(key[KEY_ENTER] || key[KEY_UP] || key[KEY_DOWN])
    {
        if(KeyPressed==false)
        {
            if(key[KEY_UP])
                option_selected--;
            else if(key[KEY_DOWN])
                option_selected++;
            else if(key[KEY_ENTER])
            {
                quit_level_menu_on=false;    
                if(option_selected==1)  //save and go to new level
                {
                    //saves the games
                    game[0].save_game("saves/game1.sav");
                    game[1].save_game("saves/game2.sav");
                    game[2].save_game("saves/game3.sav");
                    selecting_level=true;   //go to the select level screen
                    while(key[KEY_ENTER]) poll_keyboard();
                    play_song("music/GLDNPHNX.IT");
                }
                option_selected=0;
            }
                
            
            if(option_selected>1)
                option_selected=0;
            else if(option_selected<0)
                option_selected=1;
        
        }
        KeyPressed=true;
    }
    else
        KeyPressed=false;

}

void quit_level_menu_draw(void)
{
    rectfill(backgr,80,100,backgr->w-80,backgr->h-100,makecol(0,0,0));
    //player.display_cheeses_and_fries(backgr,(BITMAP*)data[large_cheese].dat,(BITMAP*)data[large_fry].dat,(FONT*)data[f1].dat);

    rect(backgr,84,104,backgr->w-84,backgr->h-104,makecol(95,66,22));
    rect(backgr,88,108,backgr->w-88,backgr->h-108,makecol(95,66,22));
    
    rect(backgr,105,125,backgr->w-105,backgr->h-125,makecol(95,66,22));



    textprintf_centre_ex(backgr,(FONT*)data[f6].dat,backgr->w/2,130,makecol(182,111,34),-1,"You have reached the exit");


    textprintf_centre_ex(backgr,(FONT*)data[f6].dat,backgr->w/2,200,makecol(95,66,22),-1,"Continue level");
    textprintf_centre_ex(backgr,(FONT*)data[f6].dat,backgr->w/2,240,makecol(95,66,22),-1,"Save scores and leave");
    
    if(option_selected==0)
    {
        textprintf_centre_ex(backgr,(FONT*)data[f6].dat,backgr->w/2,200,makecol(123,87,29),-1,"Continue level");
        line(backgr,115,200+text_height((FONT*)data[f6].dat), backgr->w-115, 200+text_height((FONT*)data[f6].dat), makecol(123,87,29));
    }    
    else if(option_selected==1)
    {
        textprintf_centre_ex(backgr,(FONT*)data[f6].dat,backgr->w/2,240,makecol(123,87,29),-1,"Save scores and leave");
        line(backgr,115,240+text_height((FONT*)data[f6].dat), backgr->w-115, 240+text_height((FONT*)data[f6].dat), makecol(123,87,29));
    }
        
    if(player.ret_fries_left()>0)
        textprintf_centre_ex(backgr,(FONT*)data[f7].dat,backgr->w/2,320,makecol(123,87,29),-1,"There are %d fries left on this level",player.ret_fries_left());
    
}


void esc_menu_draw(void)
{
    rectfill(backgr,80,100,backgr->w-80,backgr->h-100,makecol(0,0,0));
    //player.display_cheeses_and_fries(backgr,(BITMAP*)data[large_cheese].dat,(BITMAP*)data[large_fry].dat,(FONT*)data[f1].dat);

    //rect(backgr,80,100,backgr->w-80,backgr->h-100,makecol(95,66,22));
    rect(backgr,84,104,backgr->w-84,backgr->h-104,makecol(95,66,22));
    rect(backgr,88,108,backgr->w-88,backgr->h-108,makecol(95,66,22));
    
    rect(backgr,110,130,backgr->w-110,backgr->h-130,makecol(95,66,22));

/*makecol(95,66,22)
makecol(123,87,29)*/


    textprintf_centre_ex(backgr,(FONT*)data[f6].dat,backgr->w/2,180,makecol(95,66,22),-1,"Continue playing");
    textprintf_centre_ex(backgr,(FONT*)data[f6].dat,backgr->w/2,220,makecol(95,66,22),-1,"Back to level select");
    
    if(option_selected==0)
    {
        textprintf_centre_ex(backgr,(FONT*)data[f6].dat,backgr->w/2,180,makecol(123,87,29),-1,"Continue playing");
        line(backgr,120,180+text_height((FONT*)data[f6].dat), backgr->w-120, 180+text_height((FONT*)data[f6].dat), makecol(123,87,29));
    }    
    else if(option_selected==1)
    {
        textprintf_centre_ex(backgr,(FONT*)data[f6].dat,backgr->w/2,220,makecol(123,87,29),-1,"Back to level select");
        line(backgr,120,220+text_height((FONT*)data[f6].dat), backgr->w-120, 220+text_height((FONT*)data[f6].dat), makecol(123,87,29));
    }
    
    if(option_selected==1)
    {
        textprintf_centre_ex(backgr,(FONT*)data[f7].dat,backgr->w/2,280,makecol(123,87,29),-1,"Current progress on this");
        textprintf_centre_ex(backgr,(FONT*)data[f7].dat,backgr->w/2,310,makecol(123,87,29),-1,"level will not be saved!");
    }
                                        

}

void esc_menu_move(void)
{
    pParts.move_all();          //still move the particles even when paused

    if(key[KEY_ENTER] || key[KEY_UP] || key[KEY_DOWN])
    {
        if(KeyPressed==false)
        {
            if(key[KEY_UP])
                option_selected--;
            else if(key[KEY_DOWN])
                option_selected++;
            else if(key[KEY_ENTER])
            {
                esc_menu_on=false;    
                if(option_selected==1)  //don't save, and go to the menu
                {
                    //menu_on=true;
                    /*game[0].load_game("saves/game1.sav",&levels);
                    game[1].load_game("saves/game2.sav",&levels);
                    game[2].load_game("saves/game3.sav",&levels);*/
                    while(key[KEY_ENTER]) poll_keyboard();
                    //menu_num=1;
                    
                    option_selected=0;
                    game[0].load_game("saves/game1.sav",&levels);
                    game[1].load_game("saves/game2.sav",&levels);
                    game[2].load_game("saves/game3.sav",&levels);
                    selecting_level=true;   //go to the select level screen
                    player.game->count_items(player.levels);
                    
                    play_song("music/GLDNPHNX.IT");
                }
            }
                
            
            if(option_selected>1)
                option_selected=0;
            else if(option_selected<0)
                option_selected=1;
        
        }
        KeyPressed=true;
    }
    else
        KeyPressed=false;    
}


void move_dying(void)
{
    pParts.move_all();
    dying--;
    
    
    if(dying>70)
    {
        player.return_character()->anim.set_bounds(0,0);   
        player.return_character()->move_anim();
    }    
    if(dying==70)
    {
        player.return_character()->play_dying();
        player.check_col_with_objects(&oObjects1,&pParts,&dialog);
        player.return_character()->x-=5;
        player.return_character()->y-=10;
        
    }    
    if(dying<=70)
        player.return_character()->move_anim();
    
    if(dying==0)
    {
        //player.return_character()->reset_to_start();
        player.reset_character_to_start();
        if(player.ret_lives_left()==0)
        {
            option_selected=0;
            game[0].load_game("saves/game1.sav",&levels);
            game[1].load_game("saves/game2.sav",&levels);
            game[2].load_game("saves/game3.sav",&levels);
            selecting_level=true;   //go to the select level screen
            player.game->count_items(player.levels);
        }
    }
}



void draw_dying(void)
{   
    
    mMap1.draw_background(backgr,s_x,s_y);


    mMap1.draw_layer0(backgr,s_x,s_y);
    mMap1.draw_map(backgr,s_x,s_y);
    mMap1.draw_layer2(backgr,s_x,s_y);
    
    rectfill(backgr,backgr->w/2-(140-dying)*8,backgr->h/2-(140-dying)*6,backgr->w/2+(140-dying)*8,backgr->h/2+(140-dying)*6,makecol(0,0,0));

    
    player.draw_player(backgr,s_x,s_y,(FONT*)data[f2].dat);
    pParts.draw_all(backgr,s_x,s_y);
    
    player.draw_health(backgr,&pParts,(FONT*)data[f2].dat,(int)s_x,(int)s_y);

}

bool doText(char *buf)
{
    bool ret=false;
    
    if(keypressed())
    {
        char key=readkey()& 0xff;
            
        /*if(buf[0]==0)
            cursor=0;   */
        curMessagePos = strlen(buf); 
            
        if(key==13)     //enter
        {
            //curMessagePos=0;
            ret=true; 
        }
        else if(key==8) //backspace
        {
            curMessagePos--;
            if(curMessagePos<0)
                curMessagePos=0;
            buf[curMessagePos]=0;  
        }
        else
        {
            if(key==32) //space
                buf[curMessagePos]='_';
            else
                buf[curMessagePos]=key;
                
            if(curMessagePos<=13)   //max 14 characters
                curMessagePos++;
            buf[curMessagePos]=0;
        }
    }
    return ret;
}

void setupEnvEffects(void)
{
    env_effect_atts[RAIN].type=RAIN;
    env_effect_atts[RAIN].x_speed=0;
    env_effect_atts[RAIN].y_speed=12;   
    env_effect_atts[RAIN].sound[0] = (SAMPLE*)data[sound08].dat;
    env_effect_atts[RAIN].sound[1] = (SAMPLE*)data[sound09].dat;
    env_effect_atts[RAIN].num_sounds=2;
    
}    

void organizeEditorObjects(void)
{
//max_object_types
    
    
    /*int ob_list_counter_counter=0;
    int curtype=-1;
    for(int n=0 ; n<max_object_types ; n++)
    {
        ob obInfo = object[n].obInfo;
        curtype = obInfo.type;
        for(int i=0 ; i<max_object_types ; i++)
        {
            if(object[i].obInfo.type == curtype)
            {
                object_map[n] = i;
                n++;
            }
        }
    }*/
    
    int map_counter=0;
    int type_counter=0;
    
    for(int i=0 ; i<10 ; i++)
    {
    /*char thing[40];
    sprintf(thing,"%d: %d\n",object[i].obInfo.type);
    outtext("thing.txt", thing);*/
        for(int j=0 ; j<number_of_objects ; j++)
        {
            if(object[j].obInfo.type==type_counter)
            {
                object_map[map_counter] = j;
                map_counter++;
            }
        }
        type_counter++;
    }
}

void start_game_after_opening_cin(void)
{
    set_game_from_saved(global_game_selected);
    selecting_level=false;
}    
