#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CSaveState.h"

void CSaveState::reset_level(int n)
{
    level[n].fries_collected=0;
    level[n].cheeses_collected=0;
}

void CSaveState::write_info(BITMAP *backgr, float x, float y, FONT *f)
{
    textprintf_ex(backgr,f,(int)x+140,(int)y-3,makecol(95,66,22),-1,"%s",name);
    textprintf_ex(backgr,f,(int)x+6,(int)y+20,makecol(95,66,22),-1,"Level: %d",current_level>0?current_level:0);
    textprintf_ex(backgr,f,(int)x+120,(int)y+20,makecol(95,66,22),-1,"Score: %d",score);
    textprintf_ex(backgr,f,(int)x+6,(int)y+40,makecol(95,66,22),-1,"Fries: %d",count_fries_collected());
    textprintf_ex(backgr,f,(int)x+120,(int)y+40,makecol(95,66,22),-1,"Cheeses: %d",count_cheeses_collected());

}

void CSaveState::new_game(void)
{
    init();
    current_level=0;
}

void CSaveState::save_game(char *filename)
{
    FILE *fp=fopen(filename,"w");
    if(fp)
    {
        fprintf(fp,"%s ",name);

        //save the skills
        for(int n=0 ; n<MAX_ABILITIES ; n++)
        {
            fprintf(fp,"%d ",skills->ability[n]);
        }
        
        //save the level info
        for(int n=0 ; n<max_levels ; n++)
        {
            fprintf(fp,"%d ",level[n].best_fries_collected);
            fprintf(fp,"%d ",level[n].best_cheeses_collected);
        }

    }
    fclose(fp);
}

void CSaveState::load_game(char *filename, CLevels *levels)
{
    FILE *fp = fopen(filename,"r");

    init();
    set_item_count(levels);

    if(fp)
    {
        fscanf(fp,"%s ",name);
        
        //load the skills
        for(int n=0 ; n<MAX_ABILITIES ; n++)
        {
            fscanf(fp,"%d",&temp.ability[n]);
        }
        
        for(int n=0 ; n<max_levels ; n++)
        {
            fscanf(fp,"%d ",&level[n].best_fries_collected);
            fscanf(fp,"%d ",&level[n].best_cheeses_collected);
            
            if(level[n].best_fries_collected==0 && level[n].best_cheeses_collected==0)  //this level has not been played yet
            {
                if(current_level==-1)
                    current_level=n;
            }
        }
        fclose(fp);
    }
}

int CSaveState::count_fries_collected(void)
{
    int ret=0;
    for(int n=0 ; n<max_levels ; n++)
    {
        ret += level[n].best_fries_collected;
    }
    return ret;
}


int CSaveState::ret_total_fries(int level_num)
{
    return level[level_num].total_fries;
}

int CSaveState::ret_fries_collected(int level_num)
{
    return level[level_num].fries_collected;
}

int CSaveState::ret_best_fries_collected(int level_num)
{
    return level[level_num].best_fries_collected;
}

int CSaveState::count_cheeses_collected(void)
{
    int ret=0;
    for(int n=0 ; n<max_levels ; n++)
        {
        ret += level[n].best_cheeses_collected;
        }
    return ret;
}


int CSaveState::ret_total_cheeses(int level_num)
{
    return level[level_num].total_cheeses;
}

int CSaveState::ret_cheeses_collected(int level_num)
{
    return level[level_num].cheeses_collected;
}

int CSaveState::ret_best_cheeses_collected(int level_num)
{
    return level[level_num].best_cheeses_collected;
}




void CSaveState::picked_up_fry(int level_num)
{
    if(level_num<max_levels)
    {
        level[level_num].fries_collected++;

        if(level[level_num].fries_collected>level[level_num].best_fries_collected)
            level[level_num].best_fries_collected = level[level_num].fries_collected;
    }
}

void CSaveState::picked_up_cheese(int level_num)
{
    if(level_num<max_levels)
    {
        level[level_num].cheeses_collected++;

        if(level[level_num].cheeses_collected>level[level_num].best_cheeses_collected)
            level[level_num].best_cheeses_collected = level[level_num].cheeses_collected;
    }
}

void CSaveState::set_item_count(CLevels *levels)
{
    //levels.count_items();
    /*for(int n=0 ; n<levels->next_level ; n++)
    {
        level[n].total_fries = levels->level[n].total_fries;
        level[n].total_cheeses = levels->level[n].total_cheeses;
        //level[n].fries_collected = 0;
    }*/
}

void CSaveState::increase_score(int n)
{
    score+=n;
}

int CSaveState::return_score(void)
{
    return score;
}

void CSaveState::setSkills(TSkills *_skills) 
{
    *_skills = temp;
    skills = _skills;
}


void CSaveState::count_items(CLevels *levels)
{
    FILE *fp;
    int t1,t2,total_fries,total_cheeses;
    for(int n=0 ; n<levels->next_level ; n++)
    {   
    
        fp = fopen(levels->level[n].retFilename(),"rt");
        if(fp)
        {
            fscanf(fp,"%d %d %d %d ",&t1,&t2,&total_fries,&total_cheeses);    
            level[n].total_fries=total_fries;
            level[n].total_cheeses=total_cheeses;
        }        
    }        
}    

void CSaveState::init(void)
{
    for(int n=0 ; n<max_levels ; n++)
    {
        level[n].fries_collected=0;
        level[n].total_fries=0;
        level[n].best_fries_collected=0;

        level[n].cheeses_collected=0;
        level[n].total_cheeses=0;
        level[n].best_cheeses_collected=0;
    }
    score=0;
    current_level=-1;
    strcpy(name,"New");
    
    skills = &temp;
    for(int n=0 ; n<MAX_ABILITIES ; n++)
        temp.ability[n]=false;
}
