#ifndef def_cpart
#define def_cpart

#include "Standards.h"

class CPart
{
private:
	float x,y;		//position of part;
	BITMAP *pic;	//picture if particle is a picture
	RGB colour;		//colour if particle is a pixel
	float dx,dy;	//direction of movement
	float speed;
	int exist;
	int type;		//1 is bitmap, 2 is pixel
	int degrade;	//amount colour degrades over time
    bool grav;
    int radius;

public:
	void init(void);
	void dest(void);
	void create(float _x, float _y, BITMAP *_pic, float _dx, float _dy, float _speed, bool _grav, int _radius);
	void create(float _x, float _y, RGB _colour, float _dx, float _dy, float _speed, int _degrade, bool _grav, int _radius);
	void draw(BITMAP *backgr, float s_x, float s_y);
	void move(void);
};




class CParts
{
private:
	CPart part[max_parts];
	int next_part;
public:
	void init(void);
	void dest(void);
	void draw_all(BITMAP *backgr, float s_x, float s_y);
	void create_new(float x, float y, BITMAP *pic, float dx, float dy, float speed, bool grav, int radius);
	void create_new(float x, float y, RGB colour, float dx, float dy, float speed, int degrade, bool grav, int radius);
	void move_all(void);
	void create_exaust(BITMAP *pic, float x, float y, float dx, float dy);

	void create_explosion(float x, float y, RGB colour, int number, int degrade, float speed);

	void create_explosion2(float cx, float cy, int _diameter, SAMPLE *ex);
	void create_sparks(CParts *parts, float x, float y, float angle);

    void create_colour_burst(float x, float y, int density, float speed, char *_colour, int p_radius);
    void create_colour_burst(float x, float y, int density, float speed, int _colour, int p_radius);
   // void create_red_burst(float x, float y, int density, float speed);
};

#endif


