#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CParts.h"

void CPart::move(void)
{
	if(exist==1)
	{
		x+=dx/**speed*/;
		y+=dy/**speed*/;

        if(grav==true)
            dy+=0.4;


		if(degrade>0)
		{
			if(colour.r>=degrade)
				colour.r-=degrade;
			if(colour.g>=degrade)
				colour.g-=degrade;
			if(colour.b>=degrade)
				colour.b-=degrade;

			if(colour.r<20 && colour.g<20 && colour.b<20)
				exist=0;
		}

	}
}


void CPart::draw(BITMAP *backgr, float s_x, float s_y)
{
	if(exist==1)
	{
		if(x-s_x>1 && x-s_x<backgr->w-1  && y-s_y>1 && y-s_y<backgr->h-1) //clipping
		{
			if(type==1)
				draw_sprite(backgr,pic,(int)x-(int)s_x,(int)y-(int)s_y);
			else if(type==2)
			{
			//	_putpixel16(backgr,(int)x-(int)s_x, (int)y-(int)s_y, makecol(colour.r,colour.g,colour.b));
			if(radius==0)
			    ((short*)backgr->line[(int)y-(int)s_y])[(int)x-(int)s_x] = makecol(colour.r,colour.g,colour.b);
	        else
                circlefill(backgr,(int)x-(int)s_x,(int)y-(int)s_y,radius-1,makecol(colour.r,colour.g,colour.b));
    	    }
        }
		else if(x-s_x>-300 && x-s_x<backgr->w+300  && y-s_y>-200 && y-s_y<backgr->h+600) //clipping
		{
			exist=0;
        }
	}
}

void CPart::create(float _x, float _y, BITMAP *_pic, float _dx, float _dy, float _speed, bool _grav, int _radius)
{
	if(exist==0)
	{
		x=_x;
		y=_y;
		pic=_pic;
		speed=_speed;
		dx=_dx*speed;
		dy=_dy*speed;
		exist=1;
		type=1;
        grav=_grav;
        radius=_radius;
	}
}

void CPart::create(float _x, float _y, RGB _colour, float _dx, float _dy, float _speed, int _degrade, bool _grav, int _radius)
{
	if(exist==0)
	{
		x=_x;
		y=_y;
		colour=_colour;
		speed=_speed;
		dx=_dx*speed;
		dy=_dy*speed;
		degrade=_degrade;
		exist=1;
		type=2;
        grav=_grav;
        radius=_radius;
	}
}

void CPart::dest(void)
{
	destroy_bitmap(pic);
}

void CPart::init(void)
{
	x=0;
	y=0;
	dx=0;
	dy=0;
	speed=0;
	exist=0;
	type=0;
    grav=true;
    radius=0;
}   

void CParts::create_colour_burst(float x, float y, int density, float speed, int _colour, int p_radius)
{
    RGB col={getr(_colour),getg(_colour),getb(_colour)};
    float dx,dy;
    float angle;
    float s;
    int num;

    for(int n=0 ; n<density ; n++)
    {
        angle=rand()%360;
        //angle-=115;
        angle *= (M_PI/180);    //convert degrees to rads

        dx= sin(angle);
        dy=-cos(angle);

        s = rand()%50;
        s/=10;
        
        if(rand()%10 == 1)
            s*=rand()%2+2;
        
        create_new(x,y,col,dx,dy,s,0,true,p_radius);
    }
}

void CParts::create_colour_burst(float x, float y, int density, float speed, char *_colour, int p_radius)
{
    RGB col={0,0,0};
    float dx,dy;
    float angle;
    float s;
    int num;

    for(int n=0 ; n<density ; n++)
        {
        angle=rand()%360;
        //angle-=115;
        angle *= (M_PI/180);    //convert degrees to rads

        dx= sin(angle);
        dy=-cos(angle);

        if(!strcmp(_colour,"all"))
        {
        num=rand()%3;
        if(num==0)
            {
            col.r=255;
            col.g=0;
            col.b=0;
            }
        else if(num==1)
            {
            col.r=0;
            col.g=255;
            col.b=0;
            }
        else if(num==2)
            {
            col.r=0;
            col.g=0;
            col.b=255;
            }
        }
        
        else if(!strcmp(_colour,"red"))
        {
            col.r=255;
            col.g=0;
            col.b=0;
        }
        else if(!strcmp(_colour,"brown"))
        {
            col.r=189;
            col.g=147;
            col.b=82;
        }

        s = rand()%50;
        s/=10;
        
        if(rand()%10 == 1)
            s*=rand()%2+2;
        
        create_new(x,y,col,dx,dy,s,0,true,p_radius);
        //create_new(x,y,bmpPart,dx,dy,speed+1,true);
        //create_new(x,y,bmpPart,dx,dy,speed-1,true);
        }

}

void CParts::create_sparks(CParts *parts, float x, float y, float angle)
{
	float r;
	float dx,dy;
	RGB col={0,170,170};

	for(int n=0 ; n<5 ; n++)
	{
		r=rand()%60;
		r-=30;
		r/=Rad2AllegroDeg;

		dy=-cos(angle+r);
		dx=sin(angle+r);

		create_new(x,y,col,dx,dy,1,4,true,0);
	}
}

void CParts::create_explosion2(float cx, float cy, int diameter, SAMPLE *ex)
{
	RGB col={255,0,0};


	int rad=diameter/2;
	float dist;
	float div;
	int temp;
	float radiu=0;
	float dx,dy;
	int vol=0;
	float ang;
	float speed;
	float rand_speed;

	div=255/rad;

	vol=100+(diameter*4);
	if(vol>254)
		vol=254;

	play_sample(ex,vol,125,1000,FALSE);

	//creates the core explosion
	for(int x=-rad ; x<rad ; x++)
		for(int y=-rad ; y<rad  ; y++)
		{
			if( (x*x + y*y) < (rad*rad))
			{
				dist=get_dist(0,0,(float)x,(float)y);

				col.r=255-(int)( dist*div  );
		
				temp=(int)(col.r/1.2);
				col.g=rand()%temp;

				radiu = atan2(y, x);

				dy = -cos( radiu);
                dx = sin ( radiu);

				rand_speed=rand()%10;
				rand_speed/=100;

				create_new(x+cx,y+cy,col,dx,dy, 0.07+rand_speed ,1,false,0);

				create_new(x+cx,y+cy,col,dx,dy, 0.4 ,1,false,0);
			}
		}


	//creates the extra bit to go flying really far
	for(int n=0 ; n<diameter*1.5 ; n++)
	{
		col.r=255-rand()%100;
		
		temp=(int)(col.r/1.2);
		col.g=rand()%temp;

		ang=rand()%360;
		ang/=Rad2AllegroDeg;

		dy = -cos( ang);
        dx = sin ( ang);

		speed=rand()%30;
		speed+=1;

		speed/=10;

		create_new(cx,cy,col,dx,dy, speed ,1,false,0);
	}
}


void CParts::create_explosion(float x, float y, RGB colour, int number, int degrade, float speed)
{
	float dx,dy;
	float ang=0;
	int rand_angle=0;
	float rand_speed=0;
	int speed2=(int)(speed*100);

	
	for(int n=0 ; n<number ; n++)
	{	
		rand_angle=rand()%360;
		ang=Degree*rand_angle;

		rand_speed=rand()%speed2;
		rand_speed/=100;
		rand_speed+=speed/2;

		dy=-cos(ang);
		dx=sin(ang);
		create_new(x,y,colour,dx,dy, rand_speed ,degrade,false,0);
	}
}

void CParts::create_exaust(BITMAP *pic, float x, float y, float dx, float dy)
{
	RGB col={150,150,150};


	float mx=0,my=0;
	float ang=0,angle=0;
	float speed=0;
	int col_amount;

	for(int n=0 ; n<2 ; n++)
	{

		ang=rand()%2000;
		ang-=100;
		ang/=100;
		ang/=Rad2AllegroDeg;

		speed=rand()%10;
		speed+=2;
		speed/=10;

		col_amount=rand()%75;
		col_amount+=40;

		col.r=col_amount;
		col.g=col_amount;
		col.b=col_amount;

		angle = atan2(dy, dx);
		angle+=Degree*90;

		ang+=angle;

		mx = sin(ang);  
		my = -cos(ang);

		create_new(x+pic->w/2,y+pic->h/2,col,-mx,-my, speed ,1,false,0);
	}
}

void CParts::move_all(void)
{
	for(int n=0 ; n<max_parts ; n++)
		part[n].move();
}

void CParts::create_new(float x, float y, BITMAP *pic, float dx, float dy, float speed,bool grav, int radius)
{
	part[next_part].create(x,y,pic,dx,dy,speed,grav, radius);
	next_part++;
	if(next_part>=max_parts-2)
		next_part=0;
}

void CParts::create_new(float x, float y, RGB colour, float dx, float dy, float speed, int degrade, bool grav, int radius)
{
	part[next_part].create(x,y,colour,dx,dy,speed,degrade,grav, radius);
	next_part++;
	if(next_part>=max_parts-2)
		next_part=0;
}

void CParts::init(void)
{
	next_part=0;
	for(int n=0 ; n<max_parts ; n++)
		part[n].init();
}

void CParts::dest(void)
{
	for(int n=0 ; n<max_parts ; n++)
		part[n].dest();
}

void CParts::draw_all(BITMAP *backgr, float s_x, float s_y)
{
	for(int n=0 ; n<max_parts ; n++)
		part[n].draw(backgr,s_x,s_y);
}
