#include <allegro.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CObject.h"
#include "CParts.h"
#include "CAnim.h"
#include "CTile.h"
#include "CTileSet.h"
#include "CObjectSet.h"
#include "CMapObject.h"
#include "CMapObjects.h"
#include "CMapObjects.h"
#include "CForeground.h"
#include "CMap.h"
#include "CProjectile.h"
#include "CProjectiles.h"
#include "CCharacter.h"
#include "CEnims.h"
#include "CLevel.h"
#include "CLevels.h"
#include "CSaveState.h"
#include "CPlayer.h"

CObject CObject::operator=(CObject &op2)
{
    //pic=create_bitmap(op2->pic->w,op2-pic->h);
    if(hardware_accel==false)
        pic = op2.pic;
    else
    {
        if(pic)
            destroy_bitmap(pic);
        pic = create_video_bitmap(op2.pic->w,op2.pic->h);
        blit(op2.pic,pic,0,0,0,0,pic->w,pic->h);
    }
    anim=op2.anim;
    x=op2.x;
    y=op2.y;
    dy=op2.dy;
    dx=op2.dx;
    dir=op2.dir;
    //value=op2.value;
    angle=op2.angle;
    iSpecialCollisionCondition=op2.iSpecialCollisionCondition;
    
    curpic=pic;
}

CObject::CObject(BITMAP *_pic, float _x, float _y)
{
    /*pic = _pic;
    x=_x;
    y=_y;
    exist=true;*/

    init(_pic,_x,_y);
}

void CObject::init_blank(void)
{
    exist=0;
    x=0;
    y=0;
    angle=0;
    iSpecialCollisionCondition=SCC_NONE;
//    w=0;
}

void CObject::draw(BITMAP *backgr, float s_x, float s_y, int rotate)
{
    if(exist==1)
    {
  
        if(DEBUG==1)
        {
            if(iSpecialCollisionCondition==SCC_LEFT_HALF)
                rect(backgr,(int)ceil(x-s_x),(int)ceil(y-s_y),(int)ceil(x-s_x)+pic->w/2,(int)ceil(y-s_y)+pic->h,makecol(0,255,0));
            else if(iSpecialCollisionCondition==SCC_RIGHT_HALF)
                rect(backgr,(int)ceil(x-s_x)+pic->w/2,(int)ceil(y-s_y),(int)ceil(x-s_x)+pic->w,(int)ceil(y-s_y)+pic->h,makecol(0,255,0));
            else  
                rect(backgr,(int)ceil(x-s_x),(int)ceil(y-s_y),(int)ceil(x-s_x)+pic->w,(int)ceil(y-s_y)+pic->h,makecol(0,255,0));
        }
    
        if(rotate==0)
            draw_sprite(backgr , curpic , (int)ceil(x-s_x) , (int)ceil(y-s_y) );
        else if(rotate==1)
            rotate_sprite(backgr, curpic , (int)ceil(x-s_x) , (int)ceil(y-s_y), ftofix(angle));
    }
}

void CObject::init(BITMAP *_pic, float _x, float _y,int _iSpecialCollisionCondition)
{
    x=_x;
    y=_y;
    angle=0;


    
    if(hardware_accel==true)
    {
        if(pic)
            destroy_bitmap(pic);
        pic = create_video_bitmap(_pic->w,_pic->h);
        blit(_pic,pic,0,0,0,0,pic->w,pic->h);
    }
    else
        pic = _pic;
    
    curpic = pic;

    iWidth=curpic->w;
    iHeight=curpic->h;
    
    dir=RIGHT;
    exist=true;
    iSpecialCollisionCondition=_iSpecialCollisionCondition;
}

void CObject::setPic(BITMAP *_pic)
{
    if(hardware_accel==true)
    {
        if(pic)
            destroy_bitmap(pic);
        pic = create_video_bitmap(_pic->w,_pic->h);
        blit(_pic,pic,0,0,0,0,pic->w,pic->h);
        curpic = pic;
    }
    else
    {
        pic = _pic;
        curpic = pic;
    }
}

CObject::~CObject(void)
{
  //  if(hardware_accel==true && pic)
  //      destroy_bitmap(pic);
}

bool CObject::check_col(CObject *ob2)
{
    bool ret=false;
    if(ob2 && curpic && ob2->curpic)
    {
        
        float x1 = x,
            y1 = y,
            w1 = iWidth,
            h1 = iHeight,
            x2 = ob2->x,
            y2 = ob2->y,
            w2 = ob2->iWidth,
            h2 = ob2->iHeight;
            
        if(iSpecialCollisionCondition==SCC_LEFT_HALF)
        {
            w1/=2;
        }
        else if(iSpecialCollisionCondition==SCC_RIGHT_HALF)
        {
            w1/=2;
            x1+=w1;
        }
        
        if(ob2->iSpecialCollisionCondition==SCC_LEFT_HALF)
        {
            w2/=2;
        }
        else if(ob2->iSpecialCollisionCondition==SCC_RIGHT_HALF)
        {
            w2/=2;
            x2+=w2;
        }
    
        if(x1 + w1 >= x2 && x1 <= x2 + w2 && 
           y1 + h1 >= y2 && y1 <= y2 + h2)
            return true;
    
        //if(x <= ob2->x && x <= ob2->x + ob2->pic->w &&
        //   y <= ob2->y && y <= ob2->y + ob2->pic->h)
/*        if(x + iWidth >= ob2->x && x <= ob2->x + ob2->iWidth && 
           y + pic->h >= ob2->y && y <= ob2->y + ob2->pic->h)
        {
            return true;
                    
            //they are colliding according to the bounding box test, so do a more
            //in-depth test
            
            //find rectangle where their bounding boxes overlap:
            int x1,x2,y1,y2,w1,w2,h1,h2;
            x1=(int)x; y1=(int)y; x2=(int)ob2->x; y2=(int)ob2->y;   //this makes it more readable
            w1=(int)iWidth; w2=(int)ob2->iWidth;
            h1=(int)pic->h; h2=(int)ob2->pic->h;
            
            if(x2 >= x1+w1/2)    //object2 is on right half of object1
            {
                if(y2 >= y1+h1/2)   //object2 is on the lower half of object1
                {
                    for(int xx=x2 ; xx<x1+w1 ; xx++)
                    {
                        for(int yy=y2 ; yy<y1+h1 ; yy++)
                        {
                            //this is the rectangle of overlap in world positions
                            ret = checkColAtPixel(ob2,xx,yy);
                            if (ret==true)
                                return ret;
                        }
                    }
                }
                
                else if(y2 < y1+h1/2)   //object2 is on the upper half of object1
                {
                    for(int xx=x2 ; xx<x1+w1 ; xx++)
                    {
                        for(int yy=y1 ; yy<y2+h2 ; yy++)
                        {
                            //this is the rectangle of overlap in world positions
                            ret = checkColAtPixel(ob2,xx,yy);
                            if(ret==true)
                                return ret;
                        }   
                    }                    
                } 
            }

            else if(x2 < x1+w1/2)    //object2 is on left half of object1
            {
                if(y2 >= y1+h1/2)   //object2 is on the lower half of object1
                {
                    for(int xx=x1 ; xx<x2+w2 ; xx++)
                    {
                        for(int yy=y2 ; yy<y1+h1 ; yy++)
                        {
                            //this is the rectangle of overlap in world positions
                            ret = checkColAtPixel(ob2,xx,yy);
                            if (ret==true)
                                return ret;
                        }
                    }
                }
                
                else if(y2 < y1+h1/2)   //object2 is on the upper half of object1
                {
                    for(int xx=x1 ; xx<x2+w2 ; xx++)
                    {
                        for(int yy=y1 ; yy<y2+h2 ; yy++)
                        {
                            //this is the rectangle of overlap in world positions
                            ret = checkColAtPixel(ob2,xx,yy);
                            if(ret==true)
                                return ret;
                        }   
                    }                    
                } 
            }
    
    
           // while(!key[KEY_ENTER])
            
            //ret=true;    
    
          
        }*/
    }
    return ret;  
}

bool CObject::checkColAtPixel(CObject *ob2, int px, int py)
{
    int x1,y1,x2,y2;
    
    x1 = px - (int)x;
    y1 = py - (int)y;
    x2 = px - (int)ob2->x;
    y2 = py - (int)ob2->y;
    
/*    if(dir==LEFT)   //object1 is flipped
    {
        x1 = pic->w-x1+1; //flip the x-coord
    }
    if(ob2->dir==LEFT)
    {
        x2 = ob2->pic->w-x2+1;
    }*/
    
/*    
    //textprintf(screen,font,100,100,makecol(255,0,0),"%d, %d   %d, %d",x1,y1,x2,y2);
    //while(!key[KEY_ENTER]){}
    if(x1>0 && x1 < iWidth &&
       y1>0 && y1 < pic->h &&
       x2>0 && x2 < ob2->iWidth &&
       y2>0 && y2 < ob2->pic->h )
   {
    
    int c1=_getpixel16(pic,x1,y1);
    
    //putpixel(screen,px,py,makecol(0,255,0));
    
    if( !(getr16(c1)==255 && getg16(c1)==0 && getb16(c1)==255 ) )
    {
        int c2=_getpixel16(ob2->pic,x2,y2);
        if( !(getr16(c2)==255 && getg16(c2)==0 && getb16(c2)==255 ) )
        {
 //           putpixel(screen,px,py,makecol(255,0,0));
            return true;
        }
    }
    

    
    }
*/        
    return false;
}
