#ifndef cmapobjects_def
#define cmapobjects_def

#define max_objects    1000

#include "CDialog.h"
#include "CMapObject.h"
#include "CObject.h"
#include "CParts.h"
#include "CAnim.h"
#include "CTile.h"
#include "CTileSet.h"
#include "CObjectSet.h"
#include "CMapObject.h"

class CMapObjects
{
private:
public:
    /*CCharacter*/CMapObject object[max_objects];
    int next_object;
    void init_all(void);

    void add_all_objects(CObjectSet *set, CMapObject *object);

    //adds the given object to the map using the given data
    void add_object(CObjectSet *set, CMapObject *ob, DATAFILE *d, CCinematic *ingameCin);
    //used when adding an object that uses an animation
    //void add_object(CMapObject *ob);
    //retuns the type of the object with the given number
    ob* return_object_status(int num);
    //returns the type of the object at the given position
    ob* return_object_status(float x, float y);
    //moves all of the mobile objects on the map
    void move_map_objects(void);
    //returns the object
    CMapObject* return_object(int n);
    //returns the number of the object at the given positon
    int return_object_num(float x,float y);
    //returns the number of the object that has it's p2 movement point at the given position
    int return_object_num2(float x, float y);
     //moves the positon of the object(and the p1 movement point) to the given point
    void move_object_to (int num, float x, float y);
    //move the p2 movement point to the given position
    void move_object_to2 (int num, float x, float y);
    //set up everything for the given object
    void finalize_movement(int num);
    //sets up everything for edit mode
    void enter_edit_mode(void);
    void destroy_object(int num);
    void draw_preview(BITMAP *backgr, int s_x, int s_y);
    void draw_all(BITMAP *backgr, int s_x, int s_y);
    void draw_foreground(BITMAP *backgr, int s_x, int s_y);
    void save_objects(FILE *fp);
    void load_objects(CObjectSet *set, FILE *fp, DATAFILE *d, CCinematic *ingameCin);
    int check_col_with_object(CMapObject *ob, CParts *parts, CDialog *dialog);
    void use_up_object(int num);
    float ret_x(int num);
    float ret_y(int num);
    
    int check_platform_col_with_bbox(int x1,int y1,int x2,int y2);
    
    float ret_cenx(int num) {return object[num].ret_centx();}
    float ret_ceny(int num) {return object[num].ret_centy();}

    int count_fries(void);
    int count_cheeses(void);
};

#endif
