#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CMapObjects.h"

int CMapObjects::count_fries(void)
{
    int ret=0;
    for(int n=0 ; n<next_object ; n++)
        {
        if(object[n].obInfo.pickup_type==3)  //it is a fry
            ret++;
        }

    return ret;
}

int CMapObjects::count_cheeses(void)
{
    int ret=0;
    for(int n=0 ; n<next_object ; n++)
        {
        if(object[n].obInfo.pickup_type==4)  //it is a cheese
            ret++;
        }

    return ret;
}

float CMapObjects::ret_x(int num)
{
    if(num<next_object)
        return object[num].x;
}

float CMapObjects::ret_y(int num)
{
    if(num<next_object)
        return object[num].y;
}

void CMapObjects::use_up_object(int num)
{
    if(num<next_object)
        object[num].consume();
}

int CMapObjects::check_col_with_object(CMapObject *ob, CParts *parts, CDialog *dialog)
{
    int ret=-1;

    if(ob->exist && ob->curpic)
    {
        for(int n=0 ; n<next_object ; n++)
        {
            if(object[n].exist && object[n].curpic)
            {
                if(object[n].check_col_with_object(ob,parts,dialog)==1  //the objects are touching
                && object[n].obInfo.tile_type==-1          //the object does not act like a tile
                && object[n].obInfo.type!=7                //and it is not a foreground object
                && object[n].obInfo.pickup_type!=-1        //and it is a pickup
                && object[n].obInfo.enim_type==-1)         //and it is not an enemy               
                {
                    ret=n;
                    break;
                }
    
                //break;
            }
        }
    }

    return ret;
}

void CMapObjects::load_objects(CObjectSet *set, FILE *fp, DATAFILE *d, CCinematic *ingameCin)
{
    int temp_exist,temp_object_num;
    Point pTemp={0,0};
    fscanf(fp,"%d ",&next_object);

    for(int n=0 ; n<next_object ; n++)
        {

        fscanf(fp,"%d ",&temp_exist);
        fscanf(fp,"%d ",&temp_object_num);

        object[n].create_mo(set,temp_object_num,d,0,0,pTemp,ingameCin);

        fscanf(fp,"%f ",&object[n].p1.x);
        fscanf(fp,"%f ",&object[n].p1.y);
        fscanf(fp,"%f ",&object[n].p2.x);
        fscanf(fp,"%f ",&object[n].p2.y);

        object[n].x = object[n].p1.x;
        object[n].y = object[n].p1.y;

        object[n].set_up_points();
        object[n].finalize_movement();
        object[n].exist=true;

        }
}

void CMapObjects::save_objects(FILE *fp)
{
    fprintf(fp,"%d ",next_object);  //the total number of objects

    for(int n=0 ; n<next_object ; n++)
        {
        object[n].finalize_movement();
        if(object[n].exist==true)
            {
            fprintf(fp,"%d ",object[n].exist);
            fprintf(fp,"%d ",object[n].object_num);
            fprintf(fp,"%f ",object[n].p1.x);
            fprintf(fp,"%f ",object[n].p1.y);
            fprintf(fp,"%f ",object[n].p2.x);
            fprintf(fp,"%f ",object[n].p2.y);
            }
        }
}

void CMapObjects::draw_all(BITMAP *backgr, int s_x, int s_y)
{
    for(int n=0 ; n<next_object ; n++)
        {
            if(object[n].obInfo.enim_type==-1 && object[n].obInfo.type!=7)  //it can't be an enemy
                object[n].draw(backgr,s_x,s_y);
        }
}

void CMapObjects::draw_foreground(BITMAP *backgr, int s_x, int s_y)
{
    for(int n=0 ; n<next_object ; n++)
        {
            if(object[n].obInfo.type==7)  //it is a foreground object
                object[n].draw(backgr,s_x,s_y);
        }
}

void CMapObjects::draw_preview(BITMAP *backgr, int s_x, int s_y)
{
    for(int n=0 ; n<next_object ; n++)
    {
        object[n].draw_preview(backgr,s_x,s_y);
    }
}

void CMapObjects::destroy_object(int num)
{
    if(num<next_object)
    {
        for(int n=num ; n<next_object-1 ; n++)
        {
            object[n] = object[n+1];
        }
        next_object--;
    }
}

//reset all of the values for the objects to their standards
void CMapObjects::enter_edit_mode(void)
{
    for(int n=0 ; n<next_object ; n++)
        object[n].enter_edit_mode();
}

//update all of the variables for the object
void CMapObjects::finalize_movement(int num)
{
    object[num].finalize_movement();
}

//moves the main object
void CMapObjects::move_object_to (int num, float x, float y)
{
    object[num].move_to(x,y);
}

//move the second movement point
void CMapObjects::move_object_to2(int num, float x, float y)
{
    object[num].move_to2(x,y);
}

//returns the number of the object that is being clicked on (the movement point)
int CMapObjects::return_object_num2(float x,float y)
{
    int num=-1;

    for(int n=0 ; n<next_object ; n++)
        {
        if(object[n].exist==true)
            {
            num=object[n].check_col_with_point2(x,y);
            if(num!=-1)
                {
                num=n;
                break;
                }
            }
        }

    return num;
}

CMapObject* CMapObjects::return_object(int n)
{
    if(n<next_object && n>=0)
        return &object[n];
}

//returns the number of the object being clicked on
int CMapObjects::return_object_num(float x,float y)
{
    int num=-1;

    for(int n=0 ; n<next_object ; n++)
    {
        if(object[n].exist==true)
        {
            num=object[n].check_col_with_point(x,y);
            if(num!=-1)
            {
                num=n;
                break;
            }
        }
    }

    return num;
}

void CMapObjects::move_map_objects(void)
{
    for(int n=0 ; n<next_object ; n++)
        if(object[n].obInfo.enim_type==-1)  //it can't be an enemy
            object[n].move_mo();
}

ob* CMapObjects::return_object_status(int num)
{
    //ob status={-1,-1,"NULL","none","none","none",-1,-1,-1,-1,-1,-1,-1};

    if(num<next_object)
    {
        if(object[num].exist==true)
        {
            //status=object[num].obInfo;
            return &object[num].obInfo;
            //return status;
        }
    }
    //return status;
}

ob* CMapObjects::return_object_status(float x, float y)
{
    //int status=-1;
    int num=return_object_num(x,y);
    /*if(num!=-1)
        status=return_object_status(num); */

    return return_object_status(num);
}

void CMapObjects::add_object(CObjectSet *set, CMapObject *ob, DATAFILE *d, CCinematic *ingameCin)
{
    if(next_object<max_objects)
    {
        object[next_object].create_mo(set, ob->object_num,d,ob->x,ob->y,ob->p2,ingameCin);
        next_object++;
    }
}


void CMapObjects::init_all(void)
{
    
    for(int n=0 ; n<max_objects ; n++)
        object[n].init_mo();
    next_object=0;
}

int CMapObjects::check_platform_col_with_bbox(int x1,int y1, int x2, int y2)
{
    //returns the number of the colliding object
    int ret=-1;
    for(int n=0 ; n<max_objects ; n++)
    {
        if(object[n].obInfo.tile_type!=-1)   //it acts like a tile
        {
            if(object[n].check_col_with_bbox(x1,y1,x2,y2)==true)
            {
                ret=n;
                break;
            }
        }
    }
    return ret;
}
