//special objects that will appear on the map such as moving platforms, etc
//#include "CObject.h"

#include "allegro.h"
#include "standards.h"
#include "canim.h"
#include "CObjectSet.h"
#include "CCinematic.h"


#ifndef cmapobject_define
#define cmapobject_define

#define USEBITMAP   1
#define USEANIM     2

#include "CRevengeScript.h"
class CRevengeScript;
class CObjectSet;


class CMapObject : public CObject
{
private:

protected:
    int invinc_counter;


public:
    DATAFILE *data;
    bool not_moving;        //wether or not the object is moving
    int picture_type;    
    bool still;             //wether or not the object can move 
    bool flamed;            //set to true when he lands on lava
    bool touching_ground;
    bool consumed;          //for consumable objects
    
    float speed;
    Point p1,p2;  //points for the movement of the platform
    float swing_pos_x,swing_pos_y;  //the location where the rope is attached to the character




    bool swinging;
    Point pivot_point;
    float angle2;
    float angle_vel, angle_acc;
    float length;


    int object_num;     //reffers to the number of the object that this is based on

    CRevengeScript script;
    CCinematic *ingameCin;

    bool has_script;
    
    int ambient_voice;
    bool playing_ambient;

    ob obInfo;
    bool anim_on;

    bool exist;
    bool offscreen;
    void init_mo(void);

    void create_mo(CObjectSet *obSet, int num, DATAFILE *d, float _x , float _y, Point _p2, CCinematic *_ingameCin);
    void create_mo(ob info, DATAFILE *d, float _x, float _y, Point _p2, CCinematic *_ingameCin);
    void create_mo(CMapObject *ob);

    void destroy(void);
    void draw(BITMAP *backgr, int s_x, int s_y);
    void draw_trans(BITMAP *backgr, int s_x, int s_y);
    void draw_preview(BITMAP *backgr, int s_x, int s_y);
    void move_mo(void);
    void move_platform(void);

    int check_col_with_point(float px,float py);
    void set_angle(float a, float s);
    void set_p2(Point p);
    void set_up_points(void);
    void move_to(float _x, float _y);
    void move_to2(float _x, float _y);
    void finalize_movement(void);

    int check_col_with_point2(float px, float py);
    void enter_edit_mode(void);
    void display_info(BITMAP *backgr, int x, int y, FONT *f);
    void toggle_anim(void);
    void set_anim(char *filename);
    virtual int check_col_with_object(CMapObject *ob, CParts *parts, CDialog *dialog);
    void consume(void);

    void move_swinging(void);
    void set_up_pivot(Point pivot);
    
    void stop_anim(void) {anim.stop_anim();}
    
    float ret_centx(void) {return (x+iWidth/2);}
    float ret_centy(void) {return (y+iHeight/2);}
    void load_script(char *filename);
    
    int move_anim(void);
    
    bool check_col_with_bbox(int x1,int y1, int x2, int y2);
};

#endif
