#include "allegro.h"
//#include "CObject.h"
#include "CTileSet.h"

#ifndef CMap_def

#define CMap_def

#include "CMapObjects.h"

//the heigth and width of the map
#define mw  200
#define mh  200
//#define max_objects 50

class CMapObjects;

class CMap
{
private:
    CTile *tile[mw][mh];
    CTile *layer2[mw][mh];
    CTile *layer0[mw][mh];
    int background;
    int startX,startY;
    char name[60];
    int total_fries, total_cheeses;

public:
    void copy(CMap *m);

    //fill the map with the given tile
    void init(CTile *tTemp);
    //adds the given tile number from the given tileset at the pos_x,pos_y
    void add_tile(CTileSet *TileSet, int tile_num, int pos_x, int pos_y, int layer);
    //draws the map starting with the top left corner at s_x, s_y
    void draw_map(BITMAP *backgr, float s_x, float s_y);
    //draws the map with a coloured-coded grid
    void draw_grid(BITMAP *backgr, float s_x, float s_y);
    //retuns the type of the tile at the world position of x,y
    int return_tile_status(float x, float y, int layer=1);
    //returns true if there is not tile at index x,y and false it there is one
    bool isEmpty(int x, int y, int layer);
    
    int ret_background(void) {return background;}
    
    void retTileAt(CObject *ret, float x, float y, int layer);  //returns the tile at world pos x,y
    float retFrictionAt(float x, float y);
    
    //saves the map to the given filename
    void save_map(char *filename,CMapObjects *objects);
    //loads the map using the given tileset, the given blank tile, and the given datafile
    void load_map(char *filename, CTileSet *ts, CTile *blank, DATAFILE *d, CObjectSet *os, CMapObjects *objects, CCinematic *_ingameCin);
    
    void load_layer(FILE *fp, CTile *t[mw][mh], CTileSet *ts, CTile *blank);
    void save_layer(FILE *fp, CTile *t[mw][mh]);
    
    void destroy_map(void);
    void del_tile (CTile *tTemp, int x, int y, int layer);
    void move_enim(void);

    void clean_up_all(DATAFILE *d, CTileSet *ts, int layer);

    void clean_up_tile(int x, int y, DATAFILE *d, CTileSet *ts);
    void clean_up2(int x, int y, DATAFILE *d, CTileSet *ts);

    void clean_up_tile_l2(int x, int y, DATAFILE *d, CTileSet *ts);
    void clean_up2_l2(int x, int y, DATAFILE *d, CTileSet *ts);

    int return_tile_num(int x, int y, int layer=1);

    void clean_up_box(DATAFILE *d, CTileSet *ts, float x1, float y1, float x2, float y2, int layer);

    void draw_layer2(BITMAP *backgr, float s_x, float s_y);
    void draw_layer0(BITMAP *backgr, float s_x, float s_y);
    void draw_background(BITMAP *backgr, float s_x, float s_y, int vert_slide=0);

    //cleans up tile at position [x][y]
    void clean_up_at(int x, int y, CTileSet *ts, int layer);
    void clean_up_layer(CTileSet *ts, int layer);

    int retStartx(void) {return startX;}
    int retStarty(void) {return startY;}
    void setStart(int x, int y) {startX=x; startY=y;}
    char* retFilename(void) {return name;}
};









#endif
