#ifndef clevel_def
#define clevel_def

#include "CObject.h"
#include "CParts.h"
#include "CAnim.h"
#include "CTile.h"
#include "CTileSet.h"
#include "CObjectSet.h"
#include "CMapObject.h"
#include "CMapObjects.h"
#include "CMapObjects.h"
#include "CForeground.h"
#include "CMap.h"
#include "CProjectile.h"
#include "CProjectiles.h"
#include "CCharacter.h"
#include "CEnims.h"

class CLevel
{
private:
    char *map_name,*tileset_name,*objectset_name,*song_name;
    
    bool exist;
    int world_num;
    bool played_before;
    int iFriesNeeded,iCheeseNeeded;

public:
    int total_fries,total_cheeses;
    int map_pos_x, map_pos_y;
    char *level_name;
    void init(void);
    void create_level(char *_map_name, char *_level_name, char *_tileset_name, char *_objectset_name, char *_song_name,
                      int _world_num, int _iFriesNeeded, int _iCheeseNeeded,
                      int _map_pos_x, int _map_pos_y);

    void set_up_level(CMap *map, CMapObjects *obs ,CObjectSet *os, CTileSet *ts, DATAFILE *d, CTile *blank, CEnims *enims, CCinematic *ingameCin);
    void splash_level(BITMAP *bmp, FONT *f, int y);
    void count_items(CMapObjects *obs);
    
    int retFriesNeeded(void) {return iFriesNeeded;}
    int retCheesesNeeded(void) {return iCheeseNeeded;}
    char* retFilename(void) {return map_name;}
    char* ret_song_filename(void);
    // void save_level_state(FILE *fp);
    //void load_level_state(FILE *fp);
};

/*void CLevel::load_level_state(FILE *fp)
{
    fscanf(fp,"%d ",&played_before);
    fscanf(fp,"%d ",&total_fries);
    //fscanf(fp,"%d ",&fries_left);
}

void CLevel::save_level_state(FILE *fp)
{
    fprintf(fp,"%d ",played_before);
    fprintf(fp,"%d ",total_fries);
    //fprintf(fp,"%d ",fries_left);
}   */




#endif
