#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CForeground.h"

void CForeground::draw_objects(BITMAP *backgr, float s_x, float s_y)
{
    for(int n=0 ; n<next_object ; n++)
        {
        object[n].draw(backgr,s_x,s_y,0);
        }
}

void CForeground::remove_object(int num)
{
    if(num<next_object)
        {
        for(int n=num ; n<next_object ; n++)
            {
            if(n+1<max_foreobjects)
                {
                object[n].x = object[n+1].x;
                object[n].y = object[n+1].y;
                object[n].pic = object[n+1].pic;
                object[n].exist = object[n+1].exist;
                }
            }
        next_object--;
        }
}

void CForeground::add_object(BITMAP *_pic, float _x, float _y)
{
    object[next_object].init(_pic);
    object[next_object].x=_x;
    object[next_object].y=_y;
    object[next_object].exist=true;

    if (next_object+1 < max_foreobjects)
        next_object++;
}


void CForeground::init(void)
{
    for(int n=0 ; n<max_foreobjects ; n++)
        {
        object[n].init_blank();
        }
    next_object=0;
}
