#include <allegro.h>
#include "CMapObjects.h"
#include "CCharacter.h"

#ifndef cenims_def
#define cenims_def

#include "CObject.h"
#include "CParts.h"
#include "CAnim.h"
#include "CTile.h"
#include "CTileSet.h"
#include "CObjectSet.h"
#include "CDialog.h"
#include "CMapObject.h"
#include "CMapObjects.h"
#include "CMapObjects.h"
#include "CForeground.h"
#include "CMap.h"
#include "CProjectile.h"
#include "CProjectiles.h"
#include "CCharacter.h"

#define max_enims   50

/*
Enemies need to act as both CMapObjects (so that they can be placed on maps, etc
and also as CCharacters (so that they react to gravity and the terrain).  That
posed some problems so to get around it I made sure that CCharacters are inherated
from CMapObjects, and them I created this class CEnims (inhereted from CMapObjects)
to store the enemies.  It is kind of hacked together, but I got it to work
with the function find_enims.  It searches through the objects passed to it
to find enim objects.  Once it finds enims in the object array it creates enemies
from them for use in the CMapObjects class

*/

class CEnims : public CMapObjects
{
private:
    CCharacter object[max_enims];
    //int next_enim;

public:
    void init(void);
    void add_enim(CMapObject ob);
    void move(CMap *map, CMapObjects *objects, CParts *parts, CProjectiles *projs, float s_x, float s_y);
    void find_enims(CMapObjects *obs);
    void draw_all(BITMAP *backgr, int s_x, int s_y);
    void check_col_with_player(CCharacter *p, CParts *parts, CDialog *dialog);
};





#endif
