#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CEnims.h"


void CEnims::check_col_with_player(CCharacter *p, CParts *parts, CDialog *dialog)
{
    for(int n=0 ; n<next_object ; n++)
        {
        if(object[n].check_col_with_character(p,parts,dialog)==1)  //colliding with a player
            {
           // if(object[n].obInfo.enim_type==1) //type 1 enemy
                p->life_down(1,parts);
            }
        }
}

void CEnims::draw_all(BITMAP *backgr, int s_x, int s_y)
{
    for(int n=0 ; n<next_object ; n++)
        object[n].draw(backgr,s_x,s_y);
}

void CEnims::find_enims(CMapObjects *obs)
{
    init(); //clear everything
    for(int n=0 ; n<obs->next_object ; n++)
    {
        if(obs->object[n].exist==true)
        {
            if(obs->object[n].obInfo.enim_type!=-1)    //it is an enim
            {
                add_enim(obs->object[n]);
               // obs->object[n].finalize_movement();
                //obs->object[n].exist=false;
            }
        }
    }
    
    for(int n=0 ; n<next_object ; n++)
        object[n].set_max_speed(3.5);
}

void CEnims::move(CMap *map, CMapObjects *objects, CParts *parts, CProjectiles *projs, float s_x, float s_y)
{
    for(int n=0 ; n<next_object ; n++)
    {
    //if(object[n].still==false)
        object[n].move(map,objects,parts,s_x,s_y);
        
        //this line check to see if the enemies are hit by projectiles
        //it doesn't currently work right, so it is commented out
     //   object[n].check_col_with_projs(projs);
    }

}

void CEnims::init(void)
{
    for(int n=0 ; n<max_enims ; n++)
    {
        object[n].init_c();
        object[n].set_max_speed(3.6);
    }
    next_object=0;


}

void CEnims::add_enim(CMapObject ob)
{
    object[next_object].create_c(&ob);
    object[next_object].finalize_movement();
    next_object++;

    if(next_object>=max_enims-1)
        next_object=max_enims-1;
}
