#include "CDialog.h" // class's header file
#include <string.h>

// class constructor
CDialog::CDialog()
{
	dialogs=0;
    iNumDialogs=0;
}

void CDialog::move(int n)
{
    if(dialogs[n].iPrintTo<strlen(dialogs[n].string) )
        dialogs[n].iPrintTo++;
}

void CDialog::moveToEnd(int n)
{
    dialogs[n].iPrintTo=strlen(dialogs[n].string);
}

void CDialog::resetDialog(int n)
{
    if(n>=0 && n<iNumDialogs)
        dialogs[n].iPrintTo=0;
}

int CDialog::retDialogLength(int n)
{
    if(n>=0 && n<iNumDialogs)
    {
        return strlen(dialogs[n].string);
    }
    return 0;
}

void CDialog::print(int n, BITMAP *backgr,FONT *f, int x, int y, int width, int colour)
{
    int pos=0,px=x,py=y,peek;
    int peekLength=0;
    char c[2];
    
    width-=20;
    if(n>=0 && n<iNumDialogs && dialogs)
    {
        if(dialogs[n].string)
        {
            //goes through the string
            for(pos=0 ; pos < strlen(dialogs[n].string) && pos < dialogs[n].iPrintTo ; pos++)
            { 
                if(dialogs[n].string[pos]=='^')
                {
                    //go to a new line
                    px=x;
                    py+=text_height(f);
                    while(dialogs[n].string[pos]==' ' && pos < strlen(dialogs[n].string))
                        pos++;
                    continue;
                }
                //this section looks for the next space. If it finds the space, and keeps
                //track of its position in the int peekPos
                peek=pos;
                peekLength=0;
                while(dialogs[n].string[peek]!=' ' && peek < strlen(dialogs[n].string))
                {                    
                    //get the character at the peek position and add its length
                    //to the peekLength
                    c[0]=dialogs[n].string[peek]; c[1]=0;
                    peekLength+=text_length(f,c);
                    
                    peek++; //go forward another step
                }
                
                //if the peek position is larger than the width of the block
                if(px+peekLength >= x+width)
                {
                    //go to a new line
                    px=x;
                    py+=text_height(f);
                    while(dialogs[n].string[pos]==' ' && pos < strlen(dialogs[n].string))
                        pos++;
                }
                
                textprintf_ex(backgr,f,px,py,colour,-1,"%c",dialogs[n].string[pos]);

                c[0]=dialogs[n].string[pos]; c[1]=0;
                px+=text_length(f,c);
            }
        }
    }
}

void CDialog::load(char *filename)
{
    FILE *fp = fopen(filename,"rt");
    if(fp)
    {
        fscanf(fp,"%d",&iNumDialogs);
        
        dialogs = new TDialog[iNumDialogs]; //allocate memory for the dialogs
        
        for(int n=0 ; n<iNumDialogs ; n++)
        {
            readString(&dialogs[n].string,fp,'|');
            dialogs[n].iPrintTo=0;
        }
    
        fclose(fp);
    }
}

// class destructor
CDialog::~CDialog()
{
    if(dialogs)
    {
        for(int n=0 ; n<iNumDialogs ; n++)
        {
            delete [](dialogs->string);
        }
	    delete []dialogs; 
    }
}

void CDialog::readString(char **into, FILE *from, char delim)
{    
    char c=1;
    int length=0,counter=0;
    
    fpos_t oldPos;
    fgetpos(from,&oldPos);
    
    //get the length of the block of text
    do 
    {
        c=fgetc(from);
        if(c!=delim && c>31)
        {
            //into[counter]=c;
            length++;
        }
    }while(c!=EOF && c!=delim);
    
    *into = new char[length+1];
    
    fsetpos(from,&oldPos);
    
    do 
    {
        c=fgetc(from);
        if(c!=delim && c>31)
        {
            (*into)[counter]=c;
            counter++;
        }
    }while(c!=EOF && c!=delim);
    
    (*into)[counter]=0;

   // textprintf(screen,font,10,10,makecol(255,255,255),"%s %d",into,length);
}
