#include "stdio.h"

#ifndef def_canim
#define def_canim

class CAnim
{
private:
    DATAFILE *data;     //pointer to the datafile that holds the frames of animation
    BITMAP **frames;
    int number_of_frames;   //the frames in the anim
    int current_frame;      //the frame being displayed
    int frame_wait;         //the wait between frames
    int countdown;          //the amout of wait left
    bool exist;
    bool stopped;
    bool looping;
    int p1,p2;              //frame numbers for the looping
    int np1,np2;

    int widest;

public:
    bool readyforanim;
    void init(void);
    void create(char *filename);
    void draw(BITMAP *backgr, float x, float y);
    int move(void);
    BITMAP* return_current_frame(void);
    BITMAP* return_frame(int n);
    void destroy(void);
    void reset_anim(void);
    void stop_anim(void) {stopped=true;}    
    //start the animation at the given frame, -1 to start at current frame
    void start_anim(int n) {stopped=false; if(n!=-1) current_frame=n; }
    void set_bounds(int _p1, int _p2);
    void set_new_bounds(int _p2, int _p2);
    void set_looping(bool _looping) {looping = _looping;}
    int ret_frame_number(void) {return current_frame;}
    void set_frame(int n) {current_frame=n;}
    void set_frame_wait(int n) {frame_wait = n;}
    void reset_countdown(void) {countdown = frame_wait;}
    
    int ret_widest(void);
    int ret_first_w(void);
    int ret_first_h(void);
    
    CAnim(void);
    ~CAnim(void);
};

#endif




