#ifndef CWORLD_H
#define CWORLD_H

#include <stdio.h>
#include <allegro.h>
#include "CLevel.h"
#include "CLevels.h"
#include "CPlayer.h"

#define NAME_LENGTH 50

class CWorld
{
private:
    char sName[NAME_LENGTH];
    int iNumLevels;
    CLevels *levels;
    int selected;

public:
    void setLevels(CLevels *l) {levels = l;}

    void loadWorld(char *filename);

    void splashWorld(BITMAP *backgr, FONT *f, int y);
    
    void selectLevel(BITMAP *backgr, FONT *f, DATAFILE *data, CPlayer *player);
    
    void readString(char *into, FILE *from, char delim);
    
    int retSelectedLevel(void) {return selected;}
    void setSelectedLevel(int _selected) {selected = _selected;}
    
	// class constructor
	CWorld(CLevels *l);
	// class destructor
	~CWorld();
};

#endif // CWORLD_H

