#include "CWorld.h" // class's header file

void CWorld::selectLevel(BITMAP *backgr, FONT *f, DATAFILE *data, CPlayer *player)
{

    static bool keypressed=false;
    static float counter=0;
    static int selected_state;
    
    int y=0;
    //if(selected*140>S_H-140)
    if(selected>=2)
        y=(selected-2)*(text_height(f)+2);
    
    
    int lower = (selected>2?selected-2:0);
    if(lower>iNumLevels-4)
    {
        lower = iNumLevels-4;
        y-=(text_height(f)+2);
        
    }    
        
    //draw_sprite(backgr,(BITMAP*)data[title2].dat,234,40);   
    //draw_sprite(backgr,(BITMAP*)data[map_game].dat,140,205);  //draws the map
        
    draw_sprite(backgr,(BITMAP*)data[title2].dat,370,130);   
    draw_sprite(backgr,(BITMAP*)data[map_game].dat,13,205);  //draws the map

        
        
    textprintf_centre_ex(backgr,(FONT*)data[f6].dat,320,10,makecol(200,100,35),-1,"Select Level");
       
    rect(backgr,90,70,550,200,makecol(95,66,22));  //rectangle around the list of levels  
    //rect(backgr,48,84,467,202,makecol(95,66,22));  
          
    for(int n= lower ; n< (lower+4<iNumLevels?lower+4:iNumLevels) ; n++)
    {
        if(player->ret_level_state(n)!=LEVEL_LOCKED)
            textprintf_ex(backgr,f,100,85+n*(text_height(f)+2) -y,makecol(123,87,29),-1,"%s",levels->ret_name(n));
        else
            textprintf_ex(backgr,f,100,85+n*(text_height(f)+2) -y,makecol(123,87,29),-1,"???????");
            
            
        if(n==selected) //draw the selected item in a different colour, and draw a line under it
        {
            line(backgr,93,85+(n+1)*(text_height(f)+2)-y-3,310,85+(n+1)*(text_height(f)+2)-y-3,makecol(200,100,35));
            
            if(player->ret_level_state(n)!=LEVEL_LOCKED)
                textprintf_ex(backgr,f,100,85+n*(text_height(f)+2) -y,makecol(200,100,35),-1,"%s",levels->ret_name(n));   
            else
                textprintf_ex(backgr,f,100,85+n*(text_height(f)+2) -y,makecol(200,100,35),-1,"???????"); 
        }  
    }
  
    

    
    selected_state = player->ret_level_state(selected);
    
    //if the selected level is not locked, then draw a white circle showing its position on the world map
    if(selected_state!=LEVEL_LOCKED)
        circle(backgr,13+levels->retMapPosX(selected),200+levels->retMapPosY(selected),(int)counter,makecol(255,255,255));


    rect(backgr,310,80,540,190,makecol(200,100,35));  //rectangle around the selected level info  (230 x 110)
    //rect(backgr,48,238,267,392,makecol(95,66,22));
    
    if(selected_state==LEVEL_LOCKED)    //if the selected level is locked
    {
        textprintf_centre_ex(backgr,f,400,85,makecol(200,100,35),-1,"Level Locked!");     
        textprintf_ex(backgr,f,320,105+(text_height(f)+5),makecol(123,87,29),-1,"Fries Needed: %d",levels->level[selected].retFriesNeeded()); 
        textprintf_ex(backgr,f,320,105+(text_height(f)+5)*2,makecol(123,87,29),-1,"Cheeses Needed: %d",levels->level[selected].retCheesesNeeded()); 
    }    
    else if(selected_state==LEVEL_UNPLAYED) //the level is unlocked, but it has not been played
    {
        textprintf_centre_ex(backgr,f,400,85,makecol(200,100,35),-1,"Enter Level");    
    }    
    else if(selected_state==LEVEL_PLAYED)
    {
        textprintf_centre_ex(backgr,f,400,85,makecol(200,100,35),-1,"Retry Level"); 
        //textprintf(backgr,f,53,230+(text_height(f)+5),makecol(95,66,22),"Fries: %d/%d",levels->level[selected].retFriesNeeded()); 
        //textprintf(backgr,f,53,230+(text_height(f)+5)*2,makecol(95,66,22),"Cheeses: %d/%d",levels->level[selected].retCheesesNeeded()); 
        textprintf_ex(backgr,f,320,105+(text_height(f)+5),makecol(123,87,29),-1,"Fries: %d/%d",player->game->ret_best_fries_collected(selected),player->game->ret_total_fries(selected));
        textprintf_ex(backgr,f,320,105+(text_height(f)+5)*2,makecol(123,87,29),-1,"Cheeses: %d/%d",player->game->ret_best_cheeses_collected(selected),player->game->ret_total_cheeses(selected));
            
    }    
    
    //changes size of location circle on the map
    counter+=.4;
    if(counter>=4)
        counter=0;
    
    draw_sprite(backgr,(BITMAP*)data[large_fry].dat,5,9);
    textprintf_ex(backgr,f,50,20,makecol(200,100,35),-1,"%d",player->game->count_fries_collected());

    draw_sprite(backgr,(BITMAP*)data[large_cheese].dat,SCREEN_W-140,9);
    textprintf_ex(backgr,f,SCREEN_W-90,20,makecol(200,100,35),-1,"%d",player->game->count_cheeses_collected());

    
    
    if(key[KEY_DOWN] || key[KEY_UP])
    {
        if(keypressed==false)
        {
            if(key[KEY_DOWN] && selected<iNumLevels-1)
            {
                selected++;
                play_sample((SAMPLE*)data[click].dat,100,125,1000,FALSE);
            }
            else if(key[KEY_UP] && selected>0)
            {
                selected--; 
                play_sample((SAMPLE*)data[click].dat,100,125,1000,FALSE);
            }

                
        }    
        keypressed=true;
    }
    else
        keypressed=false;
    
}

void CWorld::loadWorld(char *filename)
{
    FILE *fp = fopen(filename,"rt");


    char levelName[NAME_LENGTH],levelFile[NAME_LENGTH],tilesetName[NAME_LENGTH],objectsetName[NAME_LENGTH];
    char songName[NAME_LENGTH];
    int iFriesNeeded,iCheeseNeeded;
    int xPos,yPos;
    
    if(fp)
    {
        /*********READ IN THE WORLD NAME**************/
        readString(sName,fp,'|');
    
        /*********READ IN THE NUMBER OF LEVELS************/
        fscanf(fp,"%d",&iNumLevels);
    
        /*********READ IN THE LEVEL NAMES AND FILENAMES*************/
        if(levels)
        {
            for(int n=0 ; n<iNumLevels ; n++)
            {
                readString(levelName,fp,'|');
                readString(levelFile,fp,'|');
                readString(tilesetName,fp,'|');
                readString(objectsetName,fp,'|');
                readString(songName,fp,'|');
               /* textprintf_centre(screen,font,320,n*50,makecol(255,255,0),"%s",levelName);
                textprintf_centre(screen,font,320,n*50+10,makecol(255,255,0),"%s",levelFile);
                textprintf_centre(screen,font,320,n*50+20,makecol(255,255,0),"%s",tilesetName);
                textprintf_centre(screen,font,320,n*50+30,makecol(255,255,0),"%s",objectsetName);
               */ 
                fscanf(fp,"%d %d",&iFriesNeeded,&iCheeseNeeded);
                fscanf(fp,"%d %d",&xPos,&yPos);
               
                levels->create_level(levelFile,levelName,tilesetName,objectsetName,songName,0,iFriesNeeded,iCheeseNeeded,xPos,yPos);
                
 
            }
        }
        fclose(fp);
    }
    selected=0;
}

void CWorld::readString(char *into, FILE *from, char delim)
{    
    char c=1;
    int counter=0;
    
    strcpy(into,"");
    
    do 
    {
        c=fgetc(from);
        if(c!=delim && c>31)
        {
            into[counter]=c;
            counter++;
        }
    }while(c!=EOF && c!=delim && counter<NAME_LENGTH-1);
    
    into[counter]=0;
}

void CWorld::splashWorld(BITMAP *backgr, FONT *f, int y)
{
    textprintf_centre_ex(backgr,f,320,y,makecol(255,255,0),-1,"%s",sName);
    
    textprintf_centre_ex(backgr,font,320,y+40,makecol(255,255,0),-1,"%d",iNumLevels);
    
    for(int n=0 ; n<levels->retNumLevels() ; n++)
    {
        levels->splash_level(backgr,n,font,y+50+n*10);
    }
}

// class constructor
CWorld::CWorld(CLevels *l)
{
    iNumLevels=0;
    setLevels(l);
	// insert your code here
}

// class destructor
CWorld::~CWorld()
{
	// insert your code here
}

