#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CTileSet.h"


int CTileSet::ret_max_tiles(void)
{
    return next_tile;
}

void CTileSet::display_tile(BITMAP *backgr,int n, float x, float y)
{
    if(n<next_tile)
        {
        tile[n]->draw_tile(backgr,-x,-y);
        }
}

void CTileSet::load_tile_set(char *filename)
{
    FILE *fp=fopen(filename,"r");

    fscanf(fp,"%s ",dataname);

    data = load_datafile(dataname);

    fscanf(fp,"%d ",&next_tile);
    fscanf(fp,"%d ",&background);

    for(int n=0 ; n<next_tile ; n++)
    {
        tile[n]=new CTile;
        tile[n]->load_tile(fp,data);
    }
    fclose(fp);
}

void CTileSet::save_tile_set(char *filename)
{
    FILE *fp=fopen(filename,"w");

    fprintf(fp,"%d ",next_tile);
    for(int n=0 ; n<next_tile ; n++)
        tile[n]->save_tile(fp);
    fprintf(fp,"\n");

    fclose(fp);
}

void CTileSet::display_tiles(BITMAP *backgr)
{
    for(int n=0 ; n < next_tile ; n++)
         tile[n]->draw_tile(backgr,-300,5-n*(35));
}

CTile* CTileSet::return_tile(int num)
{
    if(num < next_tile && num!=-1)
         return tile[num];
    else
         return tile[0];
}

void CTileSet::init(void)
{
    next_tile=0;
    background=0;
}

void CTileSet::add_tile(CTile *_tile)
{
    tile[next_tile] = _tile;
    next_tile++;
}

void CTileSet::destroy_ts(void)
{
    //for(int n=0 ; n<max_tiles ; n++)
    //{
        if(data)
            unload_datafile(data);
    //}
    outtext(LOG,"Done Destorying tileset");
}
