#include "allegro.h"
#include "CObject.h"
//#include "CTileSet.h"
#include <stdio.h>
//#include

#ifndef CTile_def

#define CTile_def

/*********iStatus values***********/
#define     EMPTY   0
#define     NORMAL  1
#define     FROM_BELOW  2
#define     SPIKES  3
#define     ICE     4
#define     BACKGROUND  5
#define     SPECIAL 6   //a tile that is ignored by the cleanup tool acts like a normal tile otherwuse
#define     POSITIVE_SLOPE   7
#define     NEGATIVE_SLOPE  8

class CTileSet;

class CTile : public CObject
{
private:
    int iLayer;     //the type of tile (ground, scenery, etc)
    int iStatus;   //the walkability of the layer 0=empty 1=norm ground 2=come from below 3=spike 4=ice
    float fFriction;

public:
    int iPicNum;
    int iTNum;
    void init_tile(DATAFILE *data, int _iPicNum, int _iLayer, int _iStatus, int _iSpecialCollisionCondition);
    void init_tile(BITMAP *_pic, int _iPicNum, int _iLayer, int _iStatus, int _iSpecialCollisionCondition);

    void draw_tile(BITMAP *backgr, float s_x, float s_y);

    void load_tile (char *filename, DATAFILE *data);
    void save_tile (char *filename);

    void load_tile (FILE *fp, DATAFILE *data);
    void save_tile (FILE *fp);
    
    int ret_status(int _x, int _y);
    int ret_status(void);
    int ret_pic(void) {return iPicNum;}
    float retFriction(void) {return fFriction;}
    
    void set_picture(DATAFILE *data);

};

#endif


