#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CTile.h"


void CTile::set_picture(DATAFILE *data)
{
    pic = (BITMAP*)data[iPicNum].dat;
    iWidth=pic->w;
    iHeight=pic->h;
}

int CTile::ret_status(void)
{
    return iStatus;
}

int CTile::ret_status(int _x, int _y)
{
    int ret=-1;

    if(iTNum==4 || iTNum==5 || iTNum==6 || iTNum==7 || iTNum==17 || iTNum==18 || iTNum==21 || iTNum==22 || iStatus==POSITIVE_SLOPE || iStatus==NEGATIVE_SLOPE)     //not a full tile
    {
        //so we need to check the individual pixels
        int c=_getpixel16(pic,_x,_y);
        if( !(getr16(c)==255 && getb16(c)==255 && getg16(c)==0) )
            ret= iStatus;
    }

    else
    {
            ret=iStatus;
    }



    return ret;
}

void CTile::save_tile(char *filename)
{
    FILE *fp;
    fp = fopen(filename , "w");

    if(!fp)
        exit(0);

    fprintf(fp,"%d ",iTNum);
//    fprintf(fp,"%d ",iLayer);
    fprintf(fp,"%d ",iStatus);

    fclose(fp);
}

void CTile::save_tile(FILE *fp)
{
    /*FILE *fp;
    fp = fopen(filename , "w"); */

    if(!fp)
        exit(0);

    fprintf(fp,"%d ",iTNum);
//    fprintf(fp,"%d ",iLayer);
    fprintf(fp,"%d ",iStatus);

    //fclose(fp);
}

void CTile::load_tile(char *filename, DATAFILE *data)
{
    FILE *fp;
    fp = fopen(filename ,"r");

    if(!fp)
        exit(0);

    fscanf(fp,"%d ",&iTNum);
//    fscanf(fp,"%d ",&iLayer);
    fscanf(fp,"%d ",&iStatus);

    init_tile(data,iTNum,iLayer,iStatus,iSpecialCollisionCondition);

    fclose(fp);
}

void CTile::load_tile(FILE *fp, DATAFILE *data)
{
    /*FILE *fp;
    fp = fopen(filename ,"r");*/

    if(!fp)
        exit(0);

    fscanf(fp,"%d ",&iTNum);
//    fscanf(fp,"%d ",&iLayer);
    fscanf(fp,"%d ",&iStatus);
    fscanf(fp,"%f ",&fFriction);
    fscanf(fp,"%d ",&iSpecialCollisionCondition);

    init_tile(data,iTNum,iLayer,iStatus,iSpecialCollisionCondition);

    //fclose(fp);
}

void CTile::draw_tile(BITMAP *backgr, float s_x, float s_y)
{
    if(iTNum>0)
        draw(backgr,s_x,s_y,0);
  //  textprintf(backgr,font,(int)x-(int)s_x,(int)y-(int)s_y,makecol(255,0,0),"%d",iPicNum);
}

void CTile::init_tile(DATAFILE *data, int _iPicNum, int _iLayer, int _iStatus, int _iSpecialCollisionCondition)
{
    init( (BITMAP*)data[_iPicNum].dat );  //inits the CObject part
    iLayer = _iLayer;
    iStatus = _iStatus;
    iPicNum = _iPicNum;
    iTNum = iPicNum;
    iSpecialCollisionCondition=_iSpecialCollisionCondition;
    dir=RIGHT;
}

void CTile::init_tile(BITMAP *_pic, int _iPicNum, int _iLayer, int _iStatus, int _iSpecialCollisionCondition)
{
    init(_pic);
    iLayer = _iLayer;
    iStatus = _iStatus;
    iPicNum = _iPicNum;
    iTNum = iPicNum;
    iSpecialCollisionCondition=_iSpecialCollisionCondition;
    dir=RIGHT;
}
