#include "allegro.h"

#ifndef csavestate_def
#define csavestate_def

#include "CObject.h"
#include "CParts.h"
#include "CAnim.h"
#include "CTile.h"
#include "CTileSet.h"
#include "CObjectSet.h"
#include "CMapObject.h"
#include "CMapObjects.h"
#include "CMapObjects.h"
#include "CForeground.h"
#include "CMap.h"
#include "CProjectile.h"
#include "CProjectiles.h"
#include "CCharacter.h"
#include "CEnims.h"
#include "CLevel.h"
#include "CLevels.h"
#include "CSaveState.h"

typedef struct
{
    int best_fries_collected, fries_collected , total_fries;
    int best_cheeses_collected, cheeses_collected, total_cheeses;
} CLevelStruct;

class CSaveState
{
private:
    TSkills *skills,temp;

public:
    int score;
    CLevelStruct level[max_levels];
    int current_level;
    char name[20];

    void init(void);
    void set_item_count(CLevels *levels);
    void picked_up_fry(int level_num);
    void picked_up_cheese(int level_num);

    int ret_fries_collected(int level_num);
    int ret_total_fries(int level_num);
    int ret_best_fries_collected(int level_num);
    int count_fries_collected(void);

    int ret_cheeses_collected(int level_num);
    int ret_total_cheeses(int level_num);
    int ret_best_cheeses_collected(int level_num);
    int count_cheeses_collected(void);

    void save_game(char *filename);
    void load_game(char *filename, CLevels *levels);

    void write_info(BITMAP *backgr, float x, float y, FONT *f);
    void increase_score(int n);
    int return_score(void);
    void reset_level(int n);
    void setSkills(TSkills *_skills);

    void new_game(void);
    
    void count_items(CLevels *levels);
    //void select_level_screen(BITMAP *backgr, FONT *f);
};

//void CSaveState::select_level_screen(BITMAP *backgr, FONT *f);


#endif
