#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CProjectiles.h"

//will return the number of the proj that is colliding with the player
int CProjectiles::check_col_with_object(CMapObject *object)
{
    int ret=-1;
    if(object)
    {
        for(int n=0 ; n<max_projs ; n++)
        {
            if(proj[n].check_col_with_object(object)==1)
            {
                ret=n;
                break;
            }
        }
    
    }
    return ret;
}

int CProjectiles::return_type(int num)
{
    if(num>=0)
        return proj[num].return_type();
    else if(num==LATEST)
        {
        if(next_proj==0)
            return proj[max_projs-2].return_type();
        else
            return proj[next_proj-1].return_type();
        }
}

CProjectile* CProjectiles::return_current_shot(int type)
{
    //returns the lastest shot projectile of the given type

    int n=1;

    while(next_proj-n>0)
        {
        if(proj[next_proj-n].return_type()==type)
            {
            return &proj[next_proj-n];
            }
        else
            n++;
        }
}

void CProjectiles::draw_all(BITMAP *backgr, float s_x, float s_y)
{
    for(int n=0 ; n<max_projs ; n++)
        proj[n].draw_p(backgr,s_x,s_y);
}

Point CProjectiles::move_all(CMap *map)
{
    Point pTemp1, pTemp2={-1,-1};
    for(int n=0 ; n<max_projs ; n++)
        {
        pTemp1.x=-1;
        pTemp1.y=-1;
        pTemp1 = proj[n].move_p(map);

        if(pTemp1.x!=-1)
             pTemp2 = pTemp1;
        }
   return  pTemp2;
}

void CProjectiles::init_all(void)
{
    for(int n=0 ; n<max_projs ; n++)
        {
        proj[n].init_p();
        }
}

void CProjectiles::create_new(BITMAP *pic, float x, float y, float angle, ProjInfo _info)
{
    proj[next_proj].create_p(pic,x,y,angle,_info);

    if(next_proj<max_projs-1)
        next_proj++;
    else
        next_proj=0;

}
