#ifndef cprojectile_def
#define cprojectile_def

#include "CMapObject.h"

#include "CObject.h"
#include "CParts.h"
#include "CAnim.h"
#include "CTile.h"
#include "CTileSet.h"
#include "CObjectSet.h"
#include "CMapObject.h"
#include "CMap.h"

class CMap;

typedef struct
{
    bool grav;
    float speed;
    int type;
} ProjInfo;

class CProjectile : public CObject
{
private:
    float dx,dy;
    float odx,ody;
    float /*speed,*/angle;
    //int type;
    //bool grav;
    ProjInfo info;

public:
    void init_p(void);
    void create_p(BITMAP *pic, float _x, float _y, float _angle, ProjInfo _info);
    void draw_p(BITMAP *backgr, float s_x, float s_y);
    Point move_p(CMap *map);
    bool check_down(CMap *map);
    bool check_up(CMap *map);
    bool check_left(CMap *map);
    bool check_right(CMap *map);
    int return_type(void);
    int check_col_with_object(CMapObject *object);
    void not_exist(void);
};

#endif
