/*#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"*/

#include "CProjectile.h"

void CProjectile::not_exist(void)
{
    exist=false;
}

int CProjectile::check_col_with_object(CMapObject *object)
{
    int ret;

    if(object && object->pic && pic && exist==true)
    {
    ret=check_col_with_bitmap(iWidth,iHeight,object->iWidth,object->iHeight,x,y,object->x,object->y);
    
    if(ret==1)  //there was a collision
    {
        not_exist();
    }
    
    }
    return ret;
}

int CProjectile::return_type(void)
{
    return info.type;
}

Point CProjectile::move_p(CMap *map)
{
    //position where the projectile hit
    Point pTemp={-1,-1};

    if(exist==true)
    {

    int dirx=1,diry=1;  //the x and y directions of the projectile's motion
    //positive means down, or right, and negative means left or up
    
    //temp value for check collision with the map
    int iTemp=-1;

    //set the direction flags (if moving right, dirx is posivite, moving left, dirx is negative, etc)
    if(dx>0)
        dirx=1;
    else
        dirx=-1;

    if(dy>0)
        diry=1;
    else
        diry=-1;

    //value for moving along the trajectory of the projectile
    int tx=0,ty=0;
    
    //step along the length of the trajectory this loop
    while(tx!=(int)dx && ty!=(int)dy)
        {
        if(tx!=(int)dx)
            tx+=dirx;
        if(ty!=(int)dy)
            ty+=diry;


        //check to see if this position is touching the map
        if(x+tx>0 && y+ty>0)
            iTemp=map->return_tile_status(x+tx,y+ty);
        else
            {
            //if it is touching a tile
            not_exist();
            x-=dx-tx;
            y-=dy-ty;
            break;
            }

        if(iTemp==1 || iTemp==2)    //hitting a solid object
            {
            //if it is touching a tile
            not_exist();
            x-=dx-tx;
            y-=dy-ty;
            break;
            }
        }
        
    if(info.grav==true)
    {
        dy+=gravity;
    }

    //move the projectile
    x+=dx;
    y+=dy;
    

    if(iTemp==1 || iTemp==2)    //means it is touching a tile
        {
        //set the return position to tell the program where the projectile hit
        pTemp.x=x;
        pTemp.y=y;
        }

    if(x<=0 || y<=0)
        {
        not_exist();
        x=1;
        y=1;
        }

    if(iTemp==1 || iTemp==2)
        {
        pTemp.x=x;
        pTemp.y=y;
        }

    }

  return pTemp;
}

void CProjectile::draw_p(BITMAP *backgr, float s_x, float s_y)
{
    if(x>0 && y>0)
        {

        draw(backgr,s_x,s_y,1);

        if(x-s_x > 800  || x-s_x<-200 || y-s_y>600 || y-s_y<-150)
            exist=false;
        }
    else
        exist=false;


}

void CProjectile::create_p(BITMAP *pic, float _x, float _y, float _angle, ProjInfo _info)
{
    init_p();
    init(pic);

    //speed = _speed;
    angle = _angle;
    x = _x;
    y = _y;
    
    info=_info;

    dx = cos(angle) * info.speed;
    dy = -sin(angle)* info.speed;

    //type=_type;


    exist=1;
}

void CProjectile::init_p(void)
{
    init_blank();
    dx=0;
    dy=0;
    odx=0;
    ody=0;
    angle=0;
    info.speed=0;
    info.type=0;
    info.grav=false;
}










bool CProjectile::check_down(CMap *map)
{
    int hit=0,iTemp=-1,iNum=-1;
    ob obInfo;
    bool touching_ground=false;
    float touching_object=-1;

    for(float yy=0 ; yy < ceil(dy) ; yy++)
        {
        hit=0;
        for(int xx=1 ; xx < pic->w ; xx++)
            {
            if(iTemp==-1)   //if was not touching an object
                {
                iTemp=map->return_tile_status(x+xx,y+pic->h+yy);
                }

            //if the character is inside there ground, push him up onto
            //the top
            while(map->return_tile_status(x+xx,y+yy+pic->h-1)!=-1)
                y-=1;

            if(iTemp==1 || iTemp==2) //hitting ground
                {
                hit=1;
                break;
                }
            }

        if(hit==1)
            {
            dy=0;
            //ody=0;
            touching_ground=true;
            break;
            }
        else
            y++;
    }

    return touching_ground;
}

bool CProjectile::check_up(CMap *map)
{
    bool touching_ground=false;
    int hit=0,iTemp;
    for(int yy=0 ; yy > ceil(dy) ; yy--)
        {
        hit=0;
        for(int xx=1 ; xx < pic->w ; xx++)
            {
            iTemp=map->return_tile_status(x+xx,y+yy);
            if(iTemp==1) //hitting ground
                {
                hit=1;
                break;
                }
            }
        if(hit==1)
            {
            dy=0;
            ody=0;
            hit=1;
            touching_ground=true;
            break;
            }
        else
            y--;
        }
    return touching_ground;
}

bool CProjectile::check_right(CMap *map)
{
    int hit=0,iTemp;
    bool touching_ground=false;
    for(int xx=0 ; xx < ceil(dx) ; xx++)
        {
        hit=0;
        for(int yy=0 ; yy < pic->h ; yy++)
            {
            iTemp=map->return_tile_status(x+pic->w+xx,y+yy);

            if(iTemp==1) //hitting ground
                {
                hit=1;
                break;
                }
            }
        if(hit==1)
            {
            dx=0;

            odx=0;
            hit=1;
            touching_ground=true;
            break;
            }
        else
            x++;
        }
    return touching_ground;
}

bool CProjectile::check_left(CMap *map)
{
    int hit=0,iTemp;
    bool touching_ground=false;
    for(int xx=0 ; xx > ceil(dx)-1 ; xx--)
        {
        hit=0,iTemp;
        for(int yy=0 ; yy < pic->h ; yy++)
            {
            iTemp=map->return_tile_status(x+xx,y+yy);

            if(iTemp==1) //hitting ground
                {
                hit=1;
                break;
                }
            }
        if(hit==1)
            {
            dx=0;

            odx=0;
            hit=1;
            touching_ground=true;
            break;
            }
        else
            x--;
        }
    return touching_ground;
}
