#include "CDialog.h"
#include "CMapObject.h"
#include "CMap.h"
#include "CCharacter.h"
#include "CEnims.h"
#include "CLevels.h"
#include "CSaveState.h"

#ifndef cplayer_def
#define cplayer_def


#define LEVEL_LOCKED    0
#define LEVEL_UNPLAYED  1
#define LEVEL_PLAYED    2


class CPlayer
{
private:
    CCharacter character;
    BITMAP *health_bar_f,*health_bar_e,*health_bar_b;
    //int fries_left;
    //int current_level;
    CProjectile *web_shot;

    bool played_victory;
    int lives;

public:
    CLevels *levels;
    CSaveState *game;

    int fries_collected , total_fries;

    void init_player(void);

    //sets up the character for this player
    void create_character(ob _obInfo, DATAFILE *d, DATAFILE *sounds, float _x, float _y, int _life, CCinematic *_ingameCin);
    //sets up other junk for this player
    void create_player(CLevels *_levels, BITMAP *_health_bar_full, BITMAP *_health_bar_empty, BITMAP *_health_bar_bottle);
    void draw_player(BITMAP *backgr, float s_x, float s_y, FONT *f);
    void move_character(CMap *map,CMapObjects *objects, CParts *parts, float s_x, float s_y);
    CCharacter* return_character(void);
    int check_col_with_objects(CMapObjects *obs, CParts *parts,CDialog *dialog);
    void set_up_level(CMap *map, CMapObjects *obs ,CObjectSet *os, CTileSet *ts, DATAFILE *d, CTile *blank, CEnims *enims, CCinematic *ingameCin);
    void splash_current_level(BITMAP *bmp,FONT *f);
    void splash_level(int n, BITMAP *bmp, FONT *f);
    void display_level_info(BITMAP *backgr,int level_num,FONT *font1, FONT *font2, int y);
    void display_game_info(BITMAP *backgr,FONT *font1, FONT *font2, int y);

    int ret_cur_level(void);
    int ret_number_of_levels(void);
    void go_to_next_level(void);
    void go_to_level(int n);
    int onGround(void);
    int ret_fries_left(void);

    void save_game(char *filename);
    void load_game(char *filename);

    void set_game(CSaveState *g);

    void shoot_web(CProjectiles *projs,BITMAP *bmpPart);
    void adjust_web_length(int dir);;
    
    void display_fries(BITMAP *backgr, BITMAP *fry, FONT *text, int x, int y);
    void display_chesses(BITMAP *backgr, BITMAP *fry, FONT *text, int x, int y);
    void display_cheeses_and_fries(BITMAP *backgr, BITMAP *cheese, BITMAP *fry, FONT *text);
    void set_script(char *filename) {character.load_script(filename);}

    void draw_health(BITMAP *backgr, CParts *parts, FONT *text, int s_x, int s_y);

    int return_life(void) {return character.return_life();}
    
    int ret_level_state(int n);
    char* ret_cur_song_filename(void);
    
    void tellDead(void);
    int ret_lives_left(void) {return lives;}
    void reset_character_to_start(void);
    
};




#endif
