#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CPlayer.h"

void CPlayer::display_fries(BITMAP *backgr, BITMAP *fry, FONT *text, int x, int y)
{
/*
    BITMAP *temp = create_bitmap(100,60);
    rectfill(temp,0,0,100,60,makecol(255,0,255));

    draw_sprite(temp,fry,40,10);
    textprintf(temp,text,0,0,makecol(255,0,0),"%d",game->ret_fries_collected(game->current_level));

    draw_trans_sprite(backgr,temp,x,y);
    
    destroy_bitmap(temp);
*/

    draw_sprite(backgr,fry,40,10);
    textprintf_ex(backgr,text,0,0,makecol(255,0,0),-1,"%d",game->ret_fries_collected(game->current_level));

}

void CPlayer::display_chesses(BITMAP *backgr, BITMAP *cheese, FONT *text, int x, int y)
{
/*
    BITMAP *temp = create_bitmap(100,60);
    rectfill(temp,0,0,100,60,makecol(255,0,255));
    
    draw_sprite(temp,cheese,40,10);
    textprintf(temp,text,0,0,makecol(255,0,0),"%d",game->ret_cheeses_collected(game->current_level));

    textprintf_centre(backgr,text,320,40,makecol(200,0,0),"SCORE: %d",game->return_score());

    draw_trans_sprite(backgr,temp,x,y);
    
    destroy_bitmap(temp);
*/

    draw_sprite(backgr,cheese,40,10);
    textprintf_ex(backgr,text,0,0,makecol(255,0,0),-1,"%d",game->ret_cheeses_collected(game->current_level));

    textprintf_centre_ex(backgr,text,320,40,makecol(200,0,0),-1,"SCORE: %d",game->return_score());

}

void CPlayer::display_cheeses_and_fries(BITMAP *backgr, BITMAP *cheese, BITMAP *fry, FONT *text)
{
/*
    BITMAP *temp = create_bitmap(SCREEN_W,80);
    rectfill(temp,0,0,SCREEN_W,80,makecol(255,0,255));
    
    draw_sprite(temp,fry,40,30);
    textprintf(temp,text,0,30,makecol(255,0,0),"%d",game->ret_fries_collected(game->current_level));

    draw_sprite(temp,cheese,SCREEN_W-40,30);
    textprintf(temp,text,SCREEN_W-80,30,makecol(255,0,0),"%d",game->ret_cheeses_collected(game->current_level));

    textprintf_centre(temp,text,320,40,makecol(200,0,0),"SCORE %d",game->return_score());
    
    draw_trans_sprite(backgr,temp,0,0); 
    destroy_bitmap(temp);
*/

/*    draw_sprite(backgr,fry,5,30);
    textprintf(backgr,text,50,30,makecol(255,0,0),"%d/%d",game->ret_fries_collected(game->current_level),game->ret_total_fries(game->current_level));

    draw_sprite(backgr,cheese,SCREEN_W-140,30);
    textprintf(backgr,text,SCREEN_W-90,30,makecol(255,0,0),"%d/%d",game->ret_cheeses_collected(game->current_level),game->ret_total_cheeses(game->current_level));

    textprintf_centre(backgr,text,320,40,makecol(200,0,0),"SCORE %d",game->return_score()); */
    
    draw_sprite(backgr,fry,3,9);
    textprintf_ex(backgr,text,49,19,makecol(0,0,0),-1,"%d/%d",game->ret_fries_collected(game->current_level),game->ret_total_fries(game->current_level));
    textprintf_ex(backgr,text,50,20,makecol(200,100,35),-1,"%d/%d",game->ret_fries_collected(game->current_level),game->ret_total_fries(game->current_level));

    draw_sprite(backgr,cheese,SCREEN_W-136,9);
    textprintf_ex(backgr,text,SCREEN_W-91,19,makecol(0,0,0),-1,"%d/%d",game->ret_cheeses_collected(game->current_level),game->ret_total_cheeses(game->current_level));
    textprintf_ex(backgr,text,SCREEN_W-90,20,makecol(200,100,35),-1,"%d/%d",game->ret_cheeses_collected(game->current_level),game->ret_total_cheeses(game->current_level));

    textprintf_centre_ex(backgr,text,319,4,makecol(0,0,0),-1,"SCORE %d",game->return_score()); 
    textprintf_centre_ex(backgr,text,320,5,makecol(200,100,35),-1,"SCORE %d",game->return_score());        
}

void CPlayer::draw_health(BITMAP *backgr, CParts *parts, FONT *text, int s_x, int s_y)
{
    
    if(health_bar_f && health_bar_e && health_bar_b)
    {
        //for(int n=0 ; n<character.return_life() ; n++)
        //    draw_sprite(backgr,heart_pic,320 - character.return_life()*heart_pic->w/2 + n * heart_pic->w , 30);
        //draw_sprite(backgr,heart_pic

        
        float target = (float)character.return_life() / (float)character.return_max_life();
        target*=health_bar_e->w;
        

        
        static float current = target; 
        static float delta=0;
        
        static int counter=250;
        
        
        if(target > current+1)
        {
            if(delta<1)
               delta+=.05;
            
            current+=delta;
        }
        else if(target < current-1)
        {
            if(delta>-1)
                delta-=.05;
            
            current+=delta;
        }
        else
            delta=0;
            
        
        draw_sprite(backgr,health_bar_b,110,3);
        textprintf_ex(backgr,text,110+5+health_bar_b->w,23,makecol(150,15,15),-1,"x %d",lives);
        
        draw_sprite(backgr,health_bar_e,320-health_bar_e->w/2,35);
        masked_blit(health_bar_f,backgr,0,0,320-health_bar_f->w/2,35,(int)current,health_bar_f->h);
       /* rect(backgr,144,45,140+(int)current,45+9,makecol(0,0,0));
        rectfill(backgr,144,46,143+(int)current,46+7,makecol(175,40,40));
        rectfill(backgr,144,46,143+(int)current,46+1,makecol(200,40,40));
        draw_sprite(backgr,health_bar_f,143+(int)current-7,45);
        
        draw_sprite(backgr,health_bar_b,120,3);*/
        

        
        /**********THIS IS FOR THE DRIPPING ON THE HEALTH BAR****************/
        /*counter--;
        if(counter==0)
        {
            counter=250;
            
            //only drip if ketchup is standing still
            if(character.ret_dx()==0 && character.ret_dy()==0)
            {
                RGB col={200,45,45};
                parts->create_new((float)143+(int)current + s_x, (float)46+4 + s_y, col, 0,0, (float)0, 0, true, 3);
            }
        }*/
        
        
        //parts->create_new((float)123+dw, (float)36+4, col, (float)0, (float)0, (float)0, (float)0, true, 3);

        
    }
}    



void CPlayer::adjust_web_length(int dir)
{
    character.adjust_web_length(dir);
}


void CPlayer::shoot_web(CProjectiles *projs,BITMAP *bmpPart)
{
    //creates a projectile type that is not affected by gravity, moves at 40p/sec, and is of the type WEB
    ProjInfo webInfo={false,40,WEB};
  //  ProjInfo arrowInfo={true,12,5};

  /*  BITMAP *tArrow;
   // if(!tArrow)
   // {
        tArrow=create_bitmap(10,3);
        rectfill(tArrow,0,0,10,3,makecol(100,100,100));
   // }

    if(character.dir==RIGHT)
        projs->create_new(tArrow,character.swing_pos_x,character.swing_pos_y,M_PI/4,arrowInfo);

    else if(character.dir==LEFT)
        projs->create_new(tArrow,character.swing_pos_x,character.swing_pos_y, 3*M_PI/4,arrowInfo);

*/
    if(character.jumped>-1 && character.swinging==false && character.web_left>0) //jumped, but not swinging
        {

        //shoots the projectile based on what direction the plasyer is facing
        if(character.dir==RIGHT)
            projs->create_new(bmpPart,character.swing_pos_x,character.swing_pos_y,M_PI/4,webInfo);

        else if(character.dir==LEFT)
            projs->create_new(bmpPart,character.swing_pos_x,character.swing_pos_y, 3*M_PI/4,webInfo);


        web_shot = projs->return_current_shot(WEB);    //gives the most recentally shot projectile to the class

        character.web_left--;
        }
    else if(character.jumped>-1 && character.swinging==true) //in air and swinging
        {
            character.swinging=false;
        }

}

void CPlayer::set_game(CSaveState *g)
{
    game = g;
    game->setSkills(character.retSkills());
}

void CPlayer::load_game(char *filename)
{
    //FILE *fp=fopen(filename,"r");
    game->load_game(filename,levels);
    //fclose(fp);
}

void CPlayer::save_game(char *filename)
{
    //FILE *fp=fopen(filename,"w");
    game->save_game(filename);
    //fclose(fp);
}

void CPlayer::go_to_next_level(void)
{
    game->current_level++;
}

void CPlayer::go_to_level(int n)
{
    game->current_level=n;
}

int CPlayer::ret_cur_level(void)
{
    return game->current_level;
}

int CPlayer::ret_number_of_levels(void)
{
    return levels->next_level;
}

int CPlayer::ret_level_state(int n)
{
    int ret;
    
    if( game->count_fries_collected()< levels->level[n].retFriesNeeded()  ||
        game->count_cheeses_collected() < levels->level[n].retCheesesNeeded()  )
            ret = LEVEL_LOCKED;
    else if(game->ret_best_fries_collected(n)==0 && game->ret_best_cheeses_collected(n)==0)
            ret = LEVEL_UNPLAYED;
    else
            ret = LEVEL_PLAYED;
    
    //ret_best_fries_collected(int level_num);   

    return ret;
}    

void CPlayer::display_level_info(BITMAP *backgr,int level_num,FONT *font1, FONT *font2, int y)
{
    textprintf_centre_ex(backgr,font1,320,y+20,makecol(0,255,0),-1,"%s",levels->ret_name(level_num));
    textprintf_centre_ex(backgr,font,320,y,makecol(255,200,0),-1,"Level %d",level_num+1);

    textprintf_ex(backgr,font2,105,y+80,makecol(200,0,0),-1,"Fries: %d / %d",game->ret_fries_collected(level_num),game->ret_total_fries(level_num));
    textprintf_ex(backgr,font2,105,y+105,makecol(200,0,0),-1,"Best Fry Count: %d",game->ret_best_fries_collected(level_num));

    textprintf_ex(backgr,font2,105,y+130,makecol(200,0,0),-1,"Cheeses: %d / %d",game->ret_cheeses_collected(level_num),game->ret_total_cheeses(level_num));
    textprintf_ex(backgr,font2,105,y+155,makecol(200,0,0),-1,"Best Cheese Count: %d",game->ret_best_cheeses_collected(level_num));
}

int CPlayer::ret_fries_left(void)
{
    return game->ret_total_fries(game->current_level) - game->ret_fries_collected(game->current_level);
}

void CPlayer::display_game_info(BITMAP *backgr,FONT *font1, FONT *font2, int y)
{
    textprintf_centre_ex(backgr,font1,320,y+11,makecol(0,255,0),-1,"GAME INFO");

    textprintf_ex(backgr,font2,105,y+50,makecol(200,0,0),-1,"Total Fries: %d",game->count_fries_collected());
    textprintf_ex(backgr,font2,105,y+75,makecol(200,0,0),-1,"Total Cheeses: %d",game->count_cheeses_collected());
    textprintf_ex(backgr,font2,105,y+100,makecol(200,0,0),-1,"Total Score: %d",game->return_score());
}

void CPlayer::splash_level(int n, BITMAP *bmp, FONT *f)
{
    rectfill(bmp,0,0,640,480,0);
    textprintf_centre_ex(bmp,f,320,180,makecol(255,255,0),-1,"LEVEL %d",n+1);
    levels->splash_level(bmp,n,f,250);   
}    

void CPlayer::splash_current_level(BITMAP *bmp, FONT *f)
{
    rectfill(bmp,0,0,640,480,0);
    textprintf_centre_ex(bmp,f,320,180,makecol(255,255,0),-1,"LEVEL %d",game->current_level+1);
    levels->splash_level(bmp,game->current_level,f,250);
}


void CPlayer::set_up_level(CMap *map, CMapObjects *obs ,CObjectSet *os, CTileSet *ts, DATAFILE *d, CTile *blank, CEnims *enims, CCinematic *ingameCin)
{
    game->reset_level(game->current_level);
    levels->set_up_level(game->current_level,map,obs,os,ts,d,blank,enims,ingameCin);
    game->set_item_count(levels);   //count the items in the level for the saved game
    
    //character.restore_life();
    
    character.reset();
    
    character.x=map->retStartx();
    character.y=map->retStarty();
    character.startX=map->retStartx();
    character.startY=map->retStarty();
    
    played_victory=false;
    lives=3;        //reset the player's lives for this level
}

char* CPlayer::ret_cur_song_filename(void)
{
    return levels->ret_song_filename(game->current_level);   
}    

int CPlayer::onGround(void)
{
    return character.jumped;
}

int CPlayer::check_col_with_objects(CMapObjects *obs, CParts *parts, CDialog *dialog)
{
    int ret=-1;
    ret=character.check_col_with_objects(obs,parts,dialog);

    if(ret==1) //means a fry was picked up
    {
        //tells the current save state that a fry was picked up on the current level
        game->picked_up_fry(game->current_level);
        game->increase_score(200);
    }
    else if(ret==2) //means a cheese was picked up
    {
        //tells the player's save state that a cheese was picked up
        game->picked_up_cheese(game->current_level);
        game->increase_score(10);
    }
    else if(ret==8) //means that it a item for score
    {
        game->increase_score(100);
    }
      
    if(game->ret_fries_collected(game->current_level)>=game->ret_total_fries(game->current_level) &&
       game->ret_cheeses_collected(game->current_level) >= game->ret_total_cheeses(game->current_level) &&
       played_victory==false)
    {
//        play_sample(character.ret_sample(victory),255,125,1000,FALSE);
        played_victory=true;
    }
    
    if(character.has_script)
    {
        character.script.check_condition(&character,&character,parts,dialog,character.ingameCin);
    }
            
    return ret;

}

/*void CPlayer::create_player(CLevels *_levels, BITMAP *_heart_pic)
{
    levels = _levels;
    heart_pic = _heart_pic;
}*/

void CPlayer::create_player(CLevels *_levels, BITMAP *_health_bar_full, BITMAP *_health_bar_empty, BITMAP *_health_bar_bottle)
{
    levels = _levels;
    health_bar_f = _health_bar_full;
    health_bar_e = _health_bar_empty;
    health_bar_b = _health_bar_bottle;
}

CCharacter* CPlayer::return_character(void)
{
    return &character;
}

void CPlayer::move_character(CMap *map,CMapObjects *objects,CParts *parts, float s_x, float s_y)
{
    character.move(map,objects,parts,s_x,s_y);
}

void CPlayer::init_player(void)
{
    character.init_c();
    played_victory=false;
    lives=3;
}

void CPlayer::draw_player(BITMAP *backgr, float s_x, float s_y, FONT *f)
{
    if(web_shot)
    {
        if(web_shot->exist==true)
        {
            line(backgr,(int)(character.swing_pos_x-s_x),(int)(character.swing_pos_y-s_y),(int)(web_shot->x-s_x),(int)(web_shot->y-s_y),makecol(160,160,160));
        }
    }
        
    character.draw_p(backgr,(int)s_x,(int)s_y);
    
    //textprintf(backgr,font,100,100,makecol(255,0,0),"%d",character.return_life());


/*    if(character.web_left>0)
        {
        textprintf(backgr,font,200,5,makecol(255,0,0),"Web: %d",character.web_left);
        }*/

}

void CPlayer::create_character(ob _obInfo, DATAFILE *d, DATAFILE *sounds, float _x, float _y, int _life, CCinematic *_ingameCin)
{
    character.create_c(_obInfo,d,sounds,_x,_y,_life,_ingameCin);

    character.swinging=true;
    played_victory=false;
}

void CPlayer::tellDead(void)
{
    lives--;
}

void CPlayer::reset_character_to_start(void)
{
    character.reset_to_start();
}
