#ifndef cmenuitem_def
#define cmenuitem_def

#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#define MAXSTRING   30
#define MAXSUBITEMS 10

typedef struct
{
    FONT *f;
    RGB unselected , selected;
    RGB subunselected, subselected;
} itemInfo;

typedef struct
{
    char text[MAXSTRING];
} str;

class CMenuItem
{
private:
    bool exist;
    bool selected;
    bool is_sliderbar;
    float x,y;
    int slider_value;
    itemInfo info;
    char text[MAXSTRING];
    str subitem[MAXSUBITEMS];
    int number_of_subitems, selected_subitem; 

public:
    void init(void);
    void set_item_text(char *_text, itemInfo _info, float _x=0, float _y=0);
    void toggle_selected(void)  {selected=!selected;}
    void draw_item(BITMAP *backgr, float offsetx, float offsety);
    void add_subitem(char *_text);
    void change_subitem(int dir);
    int return_selected_subitem(void) {return selected_subitem;}

};


#endif
