#include "CMenuItem.h"

void CMenuItem::change_subitem(int dir)
{
    if(is_sliderbar==true)
    {
        if(slider_value<=96 && dir>0)
            slider_value+=4;
        else if(slider_value>=4 && dir<0)
            slider_value-=4;   
    }
    else
    {
        selected_subitem+=dir;  
        
        if(selected_subitem<0)
            selected_subitem=number_of_subitems-1;
        else if(selected_subitem>=number_of_subitems)
            selected_subitem=0;
    }
}


void CMenuItem::add_subitem(char *_text)
{
    if(strcmp(_text,"sliderbar")==0)
    {
        is_sliderbar=true;
    }
    else if(number_of_subitems<MAXSUBITEMS)
    {
        strcpy(subitem[number_of_subitems].text,_text);
        number_of_subitems++;
    }
}

void CMenuItem::draw_item(BITMAP *backgr, float offsetx, float offsety)
{
if(exist==true)
{
    if(selected==true)
    {
        textprintf_ex(backgr,info.f,(int)(x+offsetx),(int)(y+offsety),makecol(info.selected.r,info.selected.g,info.selected.b),-1,text);     
        
        if(is_sliderbar==true)
        {
            for(int n=0 ; n<slider_value ; n++)
                line(backgr,(int)(x+offsetx)+text_length(info.f,text)+30+n,(int)(y+offsety),(int)(x+offsetx)+text_length(info.f,text)+30+n,(int)(y+offsety)+20,makecol(info.subselected.r,info.subselected.g,info.subselected.b));
            rect(backgr,(int)(x+offsetx)+text_length(info.f,text)+30,(int)(y+offsety),(int)(x+offsetx)+text_length(info.f,text)+30+100,(int)(y+offsety)+20,makecol(info.subselected.r,info.subselected.g,info.subselected.b));
        }
        else if(number_of_subitems>0)
            textprintf_ex(backgr,info.f,(int)(x+offsetx)+text_length(info.f,text)+30,(int)(y+offsety),makecol(info.subselected.r,info.subselected.g,info.subselected.b),-1,subitem[selected_subitem].text);
    }
    else
    {
        textprintf_ex(backgr,info.f,(int)(x+offsetx),(int)(y+offsety),makecol(info.unselected.r,info.unselected.g,info.unselected.b),-1,text);
        if(is_sliderbar==true)
        {
            for(int n=0 ; n<slider_value ; n++)
                line(backgr,(int)(x+offsetx)+text_length(info.f,text)+30+n,(int)(y+offsety),(int)(x+offsetx)+text_length(info.f,text)+30+n,(int)(y+offsety)+20,makecol(info.subunselected.r,info.subunselected.g,info.subunselected.b));
            rect(backgr,(int)(x+offsetx)+text_length(info.f,text)+30,(int)(y+offsety),(int)(x+offsetx)+text_length(info.f,text)+30+100,(int)(y+offsety)+20,makecol(info.subunselected.r,info.subunselected.g,info.subunselected.b));
        }
        else if(number_of_subitems>0)
            textprintf_ex(backgr,info.f,(int)(x+offsetx)+text_length(info.f,text)+30,(int)(y+offsety),makecol(info.subunselected.r,info.subunselected.g,info.subunselected.b),-1,subitem[selected_subitem].text);
    }
}
}

void CMenuItem::set_item_text(char *_text, itemInfo _info, float _x, float _y)
{
    strcpy(text,_text);
    info=_info;
    x=_x;
    y=_y;
    exist=true;
}

void CMenuItem::init(void)
{
    exist=false;
    selected=false;
    x=0;
    y=0;
    number_of_subitems=0;
    selected_subitem=0;
    is_sliderbar=false;
    slider_value=48;
}

