#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CMap.h"

void CMap::copy(CMap *m)
{
    for(int x=0 ; x<mw-1 ; x++)
    {
        for(int y=0 ; y<mh-1 ; y++)
        {
            tile[x][y] = m->tile[x][y];
            layer2[x][y] = m->layer2[x][y];
            layer0[x][y] = m->layer0[x][y];
        }
    }
}

int CMap::return_tile_num(int x, int y, int layer)
{
    int ret=EMPTY;
    if(x>0 & y>0)
    {
        if(layer==1)
            ret = tile[x][y]->iTNum;
        else if(layer==2)
            ret = layer2[x][y]->iTNum;
        else if(layer==0)
            ret = layer0[x][y]->iTNum;
    }
    return ret;
}


void CMap::clean_up_box(DATAFILE *d, CTileSet *ts, float x1, float y1, float x2, float y2, int layer)
{
    float temp;

  /*  if(x2 < x1)
        {
        temp=x1;
        x1=x2;
        x2=temp;
        }
    if(y2 < y1)
        {
        temp=y1;
        y1=y2;
        y2=temp;
        }        */

    if (x1<x2 && y1<y2)
        {


    for(int x=(int)(x1/32) ; x <(int)(x2/32) ; x++)
        {
        for(int y=(int)(y1/32) ; y <(int)(y2/32) ; y++)
            {
            if(layer==1)
                clean_up_tile(x,y,d,ts);
            else if(layer==2)
                clean_up_tile_l2(x,y,d,ts);
            }
        }

    for(int x=(int)(x1/32) ; x <(int)(x2/32) ; x++)
        {
        for(int y=(int)(y1/32) ; y <(int)(y2/32) ; y++)
            {
            if(layer==1)
                clean_up2(x,y,d,ts);
            else if(layer==2)
                clean_up2_l2(x,y,d,ts);
            }
        }
        }
}

void CMap::clean_up_all(DATAFILE *d, CTileSet *ts, int layer)
{
    for(int x=0 ; x<mw-1 ; x++)
        {
        for(int y=0 ; y<mh-1 ; y++)
            {
            if(layer==1)
                clean_up_tile(x,y,d,ts);
            else if(layer==2)
                clean_up_tile_l2(x,y,d,ts);
            }
        }

    for(int x=0 ; x<mw-1 ; x++)
        {
        for(int y=0 ; y<mh-1 ; y++)
            {
            if(layer==1)
                clean_up2(x,y,d,ts);
            else if(layer==2)
                clean_up2_l2(x,y,d,ts);
            }
        }
}

void CMap::clean_up_tile(int xx, int yy,DATAFILE *d, CTileSet *ts)
{
    int temp;
    if(xx>0 && yy>0 && tile[xx][yy]->iPicNum!=-1 && tile[xx][yy]->iPicNum!=1 && tile[xx][yy]->iPicNum!=14 && tile[xx][yy]->iPicNum!=15)
        {
        tile[xx][yy]=ts->return_tile(3);

        if(yy>0) //cant be at the edge of the map
            {

            if(tile[xx][yy-1]->iPicNum==-1 && layer2[xx][yy-1]->iPicNum==-1)
                tile[xx][yy]=ts->return_tile(2);
            }

        if( tile[xx+1][yy]->iPicNum == -1 && layer2[xx+1][yy]->iPicNum==-1)
            {
            if(tile[xx][yy]->iPicNum==2)
                tile[xx][yy]=ts->return_tile(4);
            else
                tile[xx][yy]=ts->return_tile(6);
            }

        if(xx>0)
            {
            if(tile[xx-1][yy]->iPicNum==-1 && layer2[xx-1][yy]->iPicNum==-1)
                {
                if(tile[xx][yy]->iPicNum==2)
                    {
                    tile[xx][yy]=ts->return_tile(5);
                    }
                else
                    {
                    tile[xx][yy]=ts->return_tile(7);
                    }
                }
            }
        }
}

void CMap::clean_up2(int xx, int yy, DATAFILE *d, CTileSet *ts)
{
    if(xx>0 && yy>0 && tile[xx][yy]->iPicNum!=-1 && tile[xx][yy]->iPicNum!=1 && tile[xx][yy]->iPicNum!=14 && tile[xx][yy]->iPicNum!=15)
        {
        //the tile is not grass-topped
        if(tile[xx][yy]->iPicNum==3 || tile[xx][yy]->iPicNum==6 || tile[xx][yy]->iPicNum==7)
            {

            if(xx>0)
                {
                    if(tile[xx-1][yy]->iPicNum==1 || layer2[xx-1][yy]->iPicNum==1)  //there is a come-from below next to it
                        tile[xx][yy]=ts->return_tile(8);
                }
            if(tile[xx+1][yy]->iPicNum==1 || layer2[xx+1][yy]->iPicNum==1)
                tile[xx][yy]=ts->return_tile(9);

            }
        else if(tile[xx][yy]->iPicNum==2 || tile[xx][yy]->iPicNum==4 || tile[xx][yy]->iPicNum==5)
            {

             if(xx>0)
                {
                    if(tile[xx-1][yy]->iPicNum==1 || layer2[xx-1][yy]->iPicNum==1)  //there is a come-from below next to it
                        tile[xx][yy]=ts->return_tile(10);
                }
            if(tile[xx+1][yy]->iPicNum==1 || layer2[xx+1][yy]->iPicNum==1)
                tile[xx][yy]=ts->return_tile(11);
            }

        if(xx>0 && yy>0)
            {
            if( (tile[xx-1][yy]->iPicNum==2 || layer2[xx-1][yy]->iPicNum==2 || tile[xx-1][yy]->iPicNum==5 || layer2[xx-1][yy]->iPicNum==5) &&  (tile[xx][yy-1]->iPicNum==7 || layer2[xx][yy-1]->iPicNum==7 || tile[xx][yy-1]->iPicNum==5 || layer2[xx][yy-1]->iPicNum==5))
                tile[xx][yy] = ts->return_tile(12);
            }
        if((tile[xx+1][yy]->iPicNum==2 || layer2[xx+1][yy]->iPicNum==2 || tile[xx-1][yy]->iPicNum==4 || layer2[xx-1][yy]->iPicNum==4) && (tile[xx][yy-1]->iPicNum==6 || layer2[xx][yy-1]->iPicNum==6 || tile[xx][yy-1]->iPicNum==4 || layer2[xx][yy-1]->iPicNum==4))
            tile[xx][yy] = ts->return_tile(13);

        }
}

void CMap::clean_up_tile_l2(int xx, int yy,DATAFILE *d, CTileSet *ts)
{
    int temp;
    if(xx>0 && yy>0 && layer2[xx][yy]->iPicNum!=-1 && layer2[xx][yy]->iPicNum!=1)
        {
        layer2[xx][yy]=ts->return_tile(3);

        if(yy>0) //cant be at the edge of the map
            {
            //temp = yy-1;
            if(layer2[xx][yy-1]->iPicNum==-1)
                layer2[xx][yy]=ts->return_tile(2);
            }

        //temp=xx+1;

        if( layer2[xx+1][yy]->iPicNum == -1)
            {
            if(layer2[xx][yy]->iPicNum==2)
                layer2[xx][yy]=ts->return_tile(4);
            else
                layer2[xx][yy]=ts->return_tile(6);
            }

        if(xx>0)
            {
            if(layer2[xx-1][yy]->iPicNum==-1)
                {
                if(layer2[xx][yy]->iPicNum==2)
                    {
                    layer2[xx][yy]=ts->return_tile(5);
                    }
                else
                    {
                    layer2[xx][yy]=ts->return_tile(7);
                    }
                }
            }
       // tile[xx][yy]->set_picture(d,ts);
        //tile[xx][yy] = ts->return_tile(tile[xx][yy]->iPicNum);
        }

}

void CMap::clean_up2_l2(int xx, int yy, DATAFILE *d, CTileSet *ts)
{
    if(xx>0 && yy>0 && layer2[xx][yy]->iPicNum!=-1 && layer2[xx][yy]->iPicNum!=1)
        {
        //the tile is not grass-topped
        if(layer2[xx][yy]->iPicNum==3 || layer2[xx][yy]->iPicNum==6 || layer2[xx][yy]->iPicNum==7)
            {

            if(xx>0)
                {
                    if(layer2[xx-1][yy]->iPicNum==1)  //there is a come-from below next to it
                        layer2[xx][yy]=ts->return_tile(8);
                }
            if(layer2[xx+1][yy]->iPicNum==1)
                layer2[xx][yy]=ts->return_tile(9);

            }
        else if(layer2[xx][yy]->iPicNum==2 || layer2[xx][yy]->iPicNum==4 || layer2[xx][yy]->iPicNum==5)
            {

             if(xx>0)
                {
                    if(layer2[xx-1][yy]->iPicNum==1)  //there is a come-from below next to it
                        layer2[xx][yy]=ts->return_tile(10);
                }
            if(layer2[xx+1][yy]->iPicNum==1)
                layer2[xx][yy]=ts->return_tile(11);
            }

        if(xx>0 && yy>0)
            {
            if( (layer2[xx-1][yy]->iPicNum==2 || layer2[xx-1][yy]->iPicNum==5) &&  (layer2[xx][yy-1]->iPicNum==7 || layer2[xx][yy-1]->iPicNum==5))
                layer2[xx][yy] = ts->return_tile(12);
            }
        if((layer2[xx+1][yy]->iPicNum==2 || layer2[xx-1][yy]->iPicNum==4) && (layer2[xx][yy-1]->iPicNum==6 || layer2[xx][yy-1]->iPicNum==4))
            layer2[xx][yy] = ts->return_tile(13);

        }
}

void CMap::del_tile(CTile *tTemp, int x, int y, int layer)
{
    if(layer==1)
        tile[x][y]=tTemp;
    else if(layer==2)
        layer2[x][y]=tTemp;
    else if(layer==0)
        layer0[x][y]=tTemp;
}


void CMap::destroy_map(void)
{
   // for(int n=0 ; n<max_objects ; n++)
    //    object[n].destroy();
}

void CMap::save_map(char *filename, CMapObjects *objects)
{
    FILE *fp=fopen(filename,"w");

    fprintf(fp,"%d %d ",startX,startY);


    total_fries = objects->count_fries();
    total_cheeses = objects->count_cheeses();
    
    fprintf(fp,"%d %d ",total_fries,total_cheeses);
    
    objects->save_objects(fp);
  /*  fprintf(fp,"%d ",next_object);  //the total number of objects

    for(int n=0 ; n<next_object ; n++)
        {
        object[n].finalize_movement();
        fprintf(fp,"%d ",object[n].exist);
        fprintf(fp,"%d ",object[n].pic_num);
        if(object[n].pic_num==-1)
            fprintf(fp,"%s ",object[n].anim_file);
        fprintf(fp,"%d ",object[n].pickup_type);
        fprintf(fp,"%d ",object[n].type);
        fprintf(fp,"%f ",object[n].p1.x);
        fprintf(fp,"%f ",object[n].p1.y);
        fprintf(fp,"%f ",object[n].p2.x);
        fprintf(fp,"%f ",object[n].p2.y);
        }  */

    /*for(int x=0 ; x<mw ; x++)
        {
        for(int y=0 ; y<mh ; y++)
            {
            //tile[x][y]->save_tile(fp);
            fprintf(fp,"%d ",tile[x][y]->iPicNum);
            }
        }
*/
   /* for(int x=0 ; x<mw ; x++)
        {
        for(int y=0 ; y<mh ; y++)
            {
            //tile[x][y]->save_tile(fp);
            fprintf(fp,"%d ",layer2[x][y]->iPicNum);
            }
        }*/
    save_layer(fp,tile);
    save_layer(fp,layer2);    
    save_layer(fp,layer0);    
        
    fclose(fp);
}

void CMap::save_layer(FILE *fp, CTile *t[mw][mh])
{
    for(int x=0 ; x<mw ; x++)
    {
        for(int y=0 ; y<mh ; y++)
        {
            //tile[x][y]->save_tile(fp);
            fprintf(fp,"%d ",t[x][y]->iPicNum);
        }
    }
}

void CMap::load_layer(FILE *fp, CTile *t[mw][mh], CTileSet *ts, CTile *blank)
{
    int iTemp;
    for(int x=0 ; x<mw ; x++)
    {
        for(int y=0 ; y<mh ; y++)
        {
            //tile[x][y]=new tile
            //tile[x][y]->load_tile(fp,d);
            fscanf(fp,"%d ",&iTemp);
            if(iTemp!=EMPTY)   //a blank tile
            {
                t[x][y]=ts->return_tile(iTemp);
                t[x][y]->iPicNum=iTemp;
            }
            else
                t[x][y]=blank;
        }
    }
}

void CMap::load_map(char *filename, CTileSet *ts, CTile *blank, DATAFILE *d, CObjectSet *os, CMapObjects *objects, CCinematic *_ingameCin)
{
    int temp_exist,temp_pic_num;

    int iTemp;
    Point pTemp={0,0};

    strcpy(name,filename);
    
    FILE *fp=fopen(filename,"r");

    fscanf(fp,"%d %d ",&startX,&startY);
    fscanf(fp,"%d %d ",&total_fries,&total_cheeses);

    background = ts->ret_background();
    objects->load_objects(os, fp,d,_ingameCin);

    load_layer(fp,tile,ts,blank);
    load_layer(fp,layer2,ts,blank);
    load_layer(fp,layer0,ts,blank);

    fclose(fp);

    total_fries = objects->count_fries();
    total_cheeses = objects->count_cheeses();
}

bool CMap::isEmpty(int x, int y, int layer)
{
    int status=true;
    CTile *t;
    
    if(x>=0 && x<mw-1 && y>=0 && y<mh-1)
    {
        if(layer==1)
            t=tile[x][y];
        else if(layer==2)
            t=layer2[x][y];
        else if(layer==0)
            t=layer0[x][y];
          
        if(t->exist=true)
        {  
            if(t->ret_status()!=0)
                status=false;
        }    
    }
    return status;
}

float CMap::retFrictionAt(float x, float y)
{
    int tx,ty;
    float ret=1;
    
    tx=(int)(x/32);
    ty=(int)(y/32);
    
    if(tx>=0 && tx<mw && ty>=0 && ty<mh)
    {
        ret = tile[tx][ty]->retFriction();
    }
    
    return ret;
}

int CMap::return_tile_status(float x, float y, int layer)
{
    int status=EMPTY;
    int tx,ty,tx2,ty2;
    CTile *t;
    
    tx=(int)(x/32);
    ty=(int)(y/32);

    tx2=((int)x % 32);
    ty2=((int)y % 32);

    if(layer==1)
        t=tile[tx][ty];
    else if(layer==2)
        t=layer2[tx][ty];
    else if(layer==0)
        t=layer0[tx][ty];

    if(t->exist==true)
    {
        status = t->ret_status();
        /*if(t->iPicNum!=-1 && t->iPicNum!=0)    //must be a tile there
        {
            if(t->ret_status()==0 || t->ret_status()==5) //-1 tile or background tile
                status=EMPTY;
            else
                status=t->ret_status();
            else if((int)x%32 <t->pic->w && (int)y%32<t->pic->h)
                status=t->ret_status(tx2,ty2);
        }*/
    }

    return status;
}

void CMap::draw_grid(BITMAP *backgr, float s_x, float s_y)
{
    int tilex_min=0,tiley_min=0, tilex_max=0, tiley_max=0;
        
    tilex_min = (int)(s_x/32);
    tiley_min = (int)(s_y/32);

    if(tilex_min<0)
        tilex_min=0;
    if(tiley_min<0)
        tiley_min=0;

    tilex_max = tilex_min + 20;
    tiley_max = tiley_min + 15;

    if(tilex_max > mw)
        tilex_max=mw;
    if(tiley_max > mh)
        tiley_max=mh;

    RGB col={255,255,255};
    RGB Red={255,0,0};
    RGB Lgreen={200,255,200};
    RGB Blue={0,0,255};
    RGB White={255,255,255};
    RGB DPurple={150,0,150};
   // int col=1;

    for(int x=tilex_min ; x<tilex_max+1 ; x++)
        for(int y=tiley_min ; y<tiley_max+1 ; y++)
        {
            tile[x][y]->draw_tile(backgr,-(x*32)+s_x , -(y*32)+s_y);

            if(tile[x][y]->ret_status()==0) //-1
                 col=Lgreen;
            else if(tile[x][y]->ret_status()==1) //normal tile
                 col=Blue;
            else if(tile[x][y]->ret_status()==2) //jump thru from below
                 col=DPurple;
            else
                col=White;

            rect(backgr,(int)((x*32)-s_x) , (int)((y*32)-s_y),(int)((x*32)-s_x+32)-1 , (int)((y*32)-s_y+32)-1, makecol(col.r , col.g , col.b) );
        }

    //draws the rectangle for ketchup's start location
    rect(backgr,startX-(int)s_x,startY-(int)s_y,startX-(int)s_x+50,startY-(int)s_y+80,makecol(255,0,0));
    rect(backgr,startX-(int)s_x+1,startY-(int)s_y+1,startX-(int)s_x+49,startY-(int)s_y+79,makecol(255,0,0));
    textprintf_ex(backgr,font,startX-(int)s_x+4,startY-(int)s_y+4,makecol(0,255,0),-1,"Start");

}

void CMap::draw_background(BITMAP *backgr, float s_x, float s_y, int vert_slide)
{
    if(background==DESERT_BACKGROUND)
    {
        rectfill(backgr,0,0,S_W,S_H,makecol(200,150,0));
        circlefill(backgr,320-(int)(s_x/32),525+vert_slide,250,makecol(255,228,0));
    }
    else if(background==GRASS_BACKGROUND)
        rectfill(backgr,0,0,S_W,S_H,makecol(0,130,255));
    else if(background==DEATH_BACKGROUND)
        rectfill(backgr,0,0,S_W,S_H,/*makecol(60,0,0)*/makecol(55,55,55));
    else if(background==SNOW_BACKGROUND)
        rectfill(backgr,0,0,S_W,S_H,makecol(150,150,200));
    else if(background==CASTLE_BACKGROUND)
        rectfill(backgr,0,0,S_W,S_H,makecol(80,80,80));
    else if(background==WASTELAND_BACKGROUND)
        rectfill(backgr,0,0,S_W,S_H,makecol(47,45,55));
}

void CMap::draw_map(BITMAP *backgr, float s_x, float s_y)
{
    int tilex_min=0,tiley_min=0, tilex_max=0, tiley_max=0;

    tilex_min = (int)(s_x/32);
    tiley_min = (int)(s_y/32);

    if(tilex_min<0)
        tilex_min=0;
    if(tiley_min<0)
        tiley_min=0;

    tilex_max = tilex_min + S_W/32 +1;
    tiley_max = tiley_min + S_H/32 +1;

    if(tilex_max > mw)
        tilex_max=mw;
    if(tiley_max > mh)
        tiley_max=mh;

    int n=0;
    for(int x=tilex_min ; x<tilex_max+1 ; x++)
        for(int y=tiley_min ; y<tiley_max+1 ; y++)
        {
            tile[x][y]->draw_tile(backgr,-(x*32)+s_x , -(y*32)+s_y);
            n++;
        }
}

void CMap::draw_layer2(BITMAP *backgr, float s_x, float s_y)
{
    int tilex_min=0,tiley_min=0, tilex_max=0, tiley_max=0;

    tilex_min = (int)(s_x/32);
    tiley_min = (int)(s_y/32);

    if(tilex_min<0)
        tilex_min=0;
    if(tiley_min<0)
        tiley_min=0;

    tilex_max = tilex_min + /*20*/S_W/32 +1;
    tiley_max = tiley_min + /*15*/S_H/32 +1;

    if(tilex_max > mw)
        tilex_max=mw;
    if(tiley_max > mh)
        tiley_max=mh;


    for(int x=tilex_min ; x<tilex_max+1 ; x++)
        for(int y=tiley_min ; y<tiley_max+1 ; y++)
        {
            layer2[x][y]->draw_tile(backgr,-(x*32)+s_x , -(y*32)+s_y);
        }
}

void CMap::draw_layer0(BITMAP *backgr, float s_x, float s_y)
{
    int tilex_min=0,tiley_min=0, tilex_max=0, tiley_max=0;

    tilex_min = (int)(s_x/32);
    tiley_min = (int)(s_y/32);

    if(tilex_min<0)
        tilex_min=0;
    if(tiley_min<0)
        tiley_min=0;

    tilex_max = tilex_min + /*20*/S_W/32 +1;
    tiley_max = tiley_min + /*15*/S_H/32 +1;

    if(tilex_max > mw)
        tilex_max=mw;
    if(tiley_max > mh)
        tiley_max=mh;


    for(int x=tilex_min ; x<tilex_max+1 ; x++)
        for(int y=tiley_min ; y<tiley_max+1 ; y++)
        {
            layer0[x][y]->draw_tile(backgr,-(x*32)+s_x , -(y*32)+s_y);
        }
}

void CMap::add_tile(CTileSet *TileSet, int tile_num, int pos_x, int pos_y, int layer)
{
    if(pos_x < mw && pos_x >=0 && pos_y < mh && pos_y >=0)
    {
        if(layer==1)
            tile[pos_x][pos_y] = TileSet->return_tile(tile_num);
        else if(layer==2)
            layer2[pos_x][pos_y] = TileSet->return_tile(tile_num);
        else if(layer==0)
            layer0[pos_x][pos_y] = TileSet->return_tile(tile_num);
    }
}

void CMap::init(CTile *tTemp)
{
    //fills the tile array with -1 tiles.
    for(int n1=0; n1<mw ; n1++)
        for(int n2=0; n2<mw ; n2++)
        {
            tile[n1][n2] = tTemp;
            layer2[n1][n2] = tTemp;
            layer0[n1][n2]= tTemp;
        }
    startX=30;
    startY=30;
    strcpy(name,"");
    total_fries=0;
    total_cheeses=0;
}

void CMap::clean_up_layer(CTileSet *ts, int layer)
{
    for(int x=0 ; x<mw ; x++)
    {
        for(int y=0 ; y<mh ; y++)
        {
            clean_up_at(x,y,ts,layer);
        }
    } 
}

//cleans up tile at position x,y ie tile[x][y]
void CMap::clean_up_at(int x, int y, CTileSet *ts, int layer)
{
    CTile **map;
    int typeAbove=1, typeBelow=1, typeLeft=1, typeRight=1;
    int typeAboveLeft=1, typeAboveRight=1;
    int newTile=0;

    if(x>0 && y>0 && x<mw && y<mh)
    {
        
        //get the layer to work on
       /* if(layer==1)
            map = (CTile**)*tile;
        else if(layer==2)
            map = (CTile**)*layer2;
        else if(layer==0)
            map = (CTile**)*layer0;
*/
        /**********GET THE TYPES OF THE TILES ALL AROUND THE CURRENT TILE***/
        if(y>1)
        {
            typeAbove = tile[x][y-1]->ret_status();
            if(typeAbove==EMPTY)
                typeAbove = layer2[x][y-1]->ret_status();
        }
        if(x>1)
        {
            typeLeft = tile[x-1][y]->ret_status();
            if(typeLeft==EMPTY)
                typeLeft = layer2[x-1][y]->ret_status();
        }
        if(y<mh-2)
        {
            typeBelow = tile[x][y+1]->ret_status();
            if(typeBelow==EMPTY)
                typeBelow = layer2[x][y+1]->ret_status();
        }
        if(x<mw-2)
        {
            typeRight = tile[x+1][y]->ret_status();
            if(typeRight==EMPTY)
                typeRight = layer2[x+1][y]->ret_status();
        }
        if(y>1 && x>1)
        {
            typeAboveLeft = tile[x-1][y-1]->ret_status();
            if(typeAboveLeft==EMPTY)
                typeAboveLeft = layer2[x-1][y-1]->ret_status();
        }
        if(y>1 && x<mw-2)
        {
            typeAboveRight = tile[x+1][y-1]->ret_status();
            if(typeAboveRight==EMPTY)
                typeAboveRight = layer2[x+1][y-1]->ret_status();   
        }
        
        if(tile[x][y]->ret_status()==ICE)
        {
            newTile=15;
            if(typeLeft==NORMAL)
                newTile=19;
            else if(typeRight==NORMAL)
                newTile=20;
                
            if(typeLeft==EMPTY)
                newTile=21;
            else if(typeRight==EMPTY)
                newTile=22;
                
            tile[x][y] = ts->return_tile(newTile);
        }
        
        if(tile[x][y]->ret_status()==FROM_BELOW)
        {
            newTile=1;
            if(typeLeft==EMPTY)
                newTile=18;
            else if(typeRight==EMPTY)
                newTile=17;
                
            tile[x][y] = ts->return_tile(newTile);
        }   
           
        if(tile[x][y]->ret_status()==NORMAL || layer2[x][y]->ret_status()==NORMAL)
        {
            //CHANGE THE TILE BASED ON THE TYPES AROUND IT
            newTile=3;
            
            //there is a tile above this tile
            if(typeAbove!=EMPTY)
            {            
                //check on the dialognal to make sure the correct tile is selected when meeting with a wall
                if(typeAboveLeft==EMPTY && typeAbove!=NEGATIVE_SLOPE)
                    newTile=12;
                else if(typeAboveRight==EMPTY && typeAbove!=POSITIVE_SLOPE)
                    newTile=13;           
              
                //change it to a half square on either the left or the right if there is -1 space to the right or the left of this tile
                if(typeLeft==EMPTY)
                    newTile=7;
                else if(typeRight==EMPTY)
                    newTile=6;
                    

                //if the tile to the left or the right is a special 'come from below' tile, choose the right tile here
                if(typeLeft==FROM_BELOW)
                    newTile=8;
                else if(typeRight==FROM_BELOW)
                    newTile=9;  
                    
                if(typeAbove==POSITIVE_SLOPE && typeAboveLeft==EMPTY)
                    newTile=23;
                else if(typeAbove==NEGATIVE_SLOPE && typeAboveRight==EMPTY)
                    newTile=26;
            }


            if(typeAbove==EMPTY)
            {
                newTile=2;
                
                if(typeLeft==EMPTY)
                    newTile=5;
                else if(typeRight==EMPTY)
                    newTile=4;
                    
                if(typeLeft==FROM_BELOW)
                    newTile=10;
                else if(typeRight==FROM_BELOW)
                    newTile=11;
                    

            }
            
            if(tile[x][y]->ret_status()==NORMAL)
                tile[x][y] = ts->return_tile(newTile);
            if(layer2[x][y]->ret_status()==NORMAL && (tile[x][y]->ret_status()==EMPTY || tile[x][y]->ret_status()==NORMAL))
                layer2[x][y] = ts->return_tile(newTile);
        }
    }
}

void CMap::retTileAt(CObject *ret, float x, float y, int layer)
{
    int mx,my;  //the map index position for the tile
    //CTile *ret=0;
    //CObject *ret;
    
    mx = (int)(x/32);
    my = (int)(y/32);
    
    if(mx>=0 && mx<mw && my>=0 && my<=mh)
    {
        if(layer==1)
            //ret = tile[mx][my];
            ret->init(tile[mx][my]->retPic(),mx*32,my*32,tile[mx][my]->iSpecialCollisionCondition);
        else if(layer==0)
            ret->init(layer0[mx][my]->retPic(),mx*32,my*32,tile[mx][my]->iSpecialCollisionCondition);
        else if(layer==2)
            ret->init(layer2[mx][my]->retPic(),mx*32,my*32,tile[mx][my]->iSpecialCollisionCondition);
    
    }
}
